/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.logging.Logger;
import javax.measure.Prefix;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.math.Fraction;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.ConventionalUnit;
import org.apache.sis.measure.LinearConverter;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.UnitRegistry;
import org.apache.sis.measure.Units;
import org.apache.sis.util.Characters;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

abstract class AbstractUnit<Q extends Quantity<Q>>
implements Unit<Q>,
LenientComparable,
Serializable {
    private static final long serialVersionUID = -5559950920796714303L;
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.measure");
    static final char MULTIPLY = '\u22c5';
    static final char DIVIDE = '\u2215';
    private static final int MAX_OPERATIONS_IN_SYMBOL = 1;
    private final String symbol;
    final transient byte scope;
    final transient short epsg;

    AbstractUnit(String symbol, byte scope, short epsg) {
        this.symbol = symbol;
        this.scope = scope;
        this.epsg = epsg;
    }

    static boolean isPrefixable(Unit<?> unit) {
        return unit instanceof AbstractUnit && ((AbstractUnit)unit).isPrefixable();
    }

    final boolean isPrefixable() {
        return (this.scope & 1) != 0;
    }

    static boolean isSymbolChar(int c) {
        return Character.isLetter(c) || Characters.isSubScript(c) || "\u00b0'\u2032\u2019\"\u2033%\u2030\u2031-_".indexOf(c) >= 0;
    }

    private static boolean isValidSymbol(String symbol, boolean allowExponents, boolean allowMultiply) {
        return AbstractUnit.invalidCharForSymbol(symbol, allowMultiply ? 1 : 0, allowExponents) == -1;
    }

    static int invalidCharForSymbol(String symbol, int maxMultiply, boolean allowExponents) {
        int c;
        if (symbol == null || symbol.isEmpty()) {
            return -2;
        }
        for (int i = 0; i < symbol.length(); i += Character.charCount(c)) {
            c = symbol.codePointAt(i);
            if (AbstractUnit.isSymbolChar(c) || !(c == 8901 ? --maxMultiply < 0 : !allowExponents || !Characters.isSuperScript(c))) continue;
            return c;
        }
        return -1;
    }

    final String inferSymbol(char operation, Unit<?> other) {
        String ts = this.symbol;
        boolean inverse = false;
        boolean allowExponents = false;
        switch (operation) {
            case '\u2215': {
                inverse = ts != null && ts.isEmpty();
            }
            case '\u22c5': {
                allowExponents = true;
            }
        }
        if (inverse || AbstractUnit.isValidSymbol(ts, allowExponents, allowExponents)) {
            if (other != null) {
                String os = other.getSymbol();
                if (AbstractUnit.isValidSymbol(os, allowExponents, false)) {
                    if (inverse) {
                        ts = "1";
                    }
                    return (ts + operation + os).intern();
                }
            } else if (!allowExponents) {
                assert (Characters.isSuperScript(operation)) : operation;
                return (ts + operation).intern();
            }
        }
        return null;
    }

    final <R extends Quantity<R>> Unit<R> inferSymbol(Unit<R> result, char operation, Unit<?> other) {
        String symbol;
        if (result instanceof ConventionalUnit && result.getSymbol() == null && (symbol = this.inferSymbol(operation, other)) != null) {
            result = ((ConventionalUnit)result).forSymbol(symbol);
        }
        return result;
    }

    @Override
    public final String getSymbol() {
        return this.symbol;
    }

    @Override
    public final String getName() {
        if (this.symbol != null) {
            try {
                return UnitFormat.getBundle(Locale.getDefault()).getString(this.symbol);
            }
            catch (MissingResourceException e) {
                Logging.ignorableException(LOGGER, AbstractUnit.class, "getName", e);
            }
        }
        return null;
    }

    @Override
    public abstract SystemUnit<Q> getSystemUnit();

    @Override
    public abstract Map<SystemUnit<?>, Integer> getBaseUnits();

    abstract Map<SystemUnit<?>, Fraction> getBaseSystemUnits();

    @Override
    public final boolean isCompatible(Unit<?> that) {
        return this.getDimension().equals(that.getDimension());
    }

    @Override
    public final boolean isEquivalentTo(Unit<Q> that) {
        return this.getConverterTo(that).isIdentity();
    }

    final String incompatible(Unit<?> that) {
        return Errors.format((short)66, this, that);
    }

    @Override
    public final Unit<Q> prefix(Prefix prefix) {
        Number base = prefix.getValue();
        int exponent = prefix.getExponent();
        if (exponent == 1) {
            return this.multiply(base);
        }
        double value = AbstractConverter.doubleValue(base);
        value = value == 10.0 ? MathFunctions.pow10(exponent) : Math.pow(value, exponent);
        return this.multiply(value);
    }

    @Override
    public final Unit<Q> shift(Number offset) {
        if (offset instanceof Fraction) {
            Fraction f = (Fraction)offset;
            return this.transform(LinearConverter.offset(f.numerator, f.denominator));
        }
        return this.shift(AbstractConverter.doubleValue(offset));
    }

    @Override
    public final Unit<Q> multiply(Number multiplier) {
        if (multiplier instanceof Fraction) {
            Fraction f = (Fraction)multiplier;
            return this.transform(LinearConverter.scale(f.numerator, f.denominator));
        }
        return this.multiply(AbstractConverter.doubleValue(multiplier));
    }

    @Override
    public final Unit<Q> divide(Number divisor) {
        if (divisor instanceof Fraction) {
            Fraction f = (Fraction)divisor;
            return this.transform(LinearConverter.scale(f.denominator, f.numerator));
        }
        return this.divide(AbstractConverter.doubleValue(divisor));
    }

    @Override
    public final Unit<Q> shift(double offset) {
        if (offset == 0.0) {
            return this;
        }
        double divisor = 1.0;
        double m4 = 1.0;
        do {
            double r;
            double c;
            if (!(Math.abs((c = offset * m4) - (r = Math.rint(c))) <= Math.ulp(c))) continue;
            offset = r;
            divisor = m4;
            break;
        } while ((m4 *= 10.0) <= 1000000.0);
        return this.transform(LinearConverter.offset(offset, divisor));
    }

    @Override
    public final Unit<Q> multiply(double multiplier) {
        if (multiplier == 1.0) {
            return this;
        }
        double divisor = AbstractUnit.inverse(multiplier);
        if (divisor != 1.0) {
            multiplier = 1.0;
        } else {
            double m4 = 1.0;
            do {
                double r;
                double c;
                if (!(Math.abs((c = multiplier * m4) - (r = Math.rint(c))) <= Math.ulp(c))) continue;
                multiplier = r;
                divisor = m4;
                break;
            } while ((m4 *= 10.0) <= 1000000.0);
        }
        return this.transform(LinearConverter.scale(multiplier, divisor));
    }

    @Override
    public final Unit<Q> divide(double divisor) {
        if (divisor == 1.0) {
            return this;
        }
        double multiplier = AbstractUnit.inverse(divisor);
        if (multiplier != 1.0) {
            divisor = 1.0;
        }
        return this.transform(LinearConverter.scale(multiplier, divisor));
    }

    private static double inverse(double multiplier) {
        double r;
        double inverse;
        if (Math.abs(multiplier) < 1.0 && AbstractConverter.epsilonEquals(inverse = 1.0 / multiplier, r = Math.rint(inverse))) {
            return r;
        }
        return 1.0;
    }

    @Override
    public final Unit<?> inverse() {
        return this.pow(-1);
    }

    ConventionalUnit<Q>[] related() {
        return null;
    }

    @Override
    public final boolean equals(Object other) {
        return this.equals(other, ComparisonMode.STRICT);
    }

    @Override
    public boolean equals(Object other, ComparisonMode mode) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        if (mode.isIgnoringMetadata()) {
            return true;
        }
        AbstractUnit that = (AbstractUnit)other;
        return AbstractUnit.equals(this.epsg, that.epsg) && AbstractUnit.equals(this.scope, that.scope) && Objects.equals(this.symbol, that.symbol);
    }

    private static boolean equals(short a, short b) {
        return a == 0 || b == 0 || a == b;
    }

    public int hashCode() {
        return 31 * Objects.hashCode(this.symbol);
    }

    @Override
    public final String toString() {
        if (this.symbol != null) {
            return this.symbol;
        }
        return UnitFormat.INSTANCE.format(this);
    }

    final Object readResolve() throws ObjectStreamException {
        Object existing;
        if (this.symbol != null && Units.initialized && this.equals(existing = UnitRegistry.putIfAbsent(this.symbol, this))) {
            return (Unit)existing;
        }
        return this;
    }
}

