/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Set;
import org.apache.sis.geometry.CurveExtremum;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.WraparoundInEnvelope;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.util.CoordinateOperations;
import org.apache.sis.referencing.util.j2d.IntervalRectangle;
import org.apache.sis.referencing.util.j2d.ShapeUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public final class Shapes2D
extends Static {
    private Shapes2D() {
    }

    public static Point2D intersectionPoint(Line2D a, Line2D b) {
        return ShapeUtilities.intersectionPoint(a.getX1(), a.getY1(), a.getX2(), a.getY2(), b.getX1(), b.getY1(), b.getX2(), b.getY2());
    }

    public static Point2D nearestColinearPoint(Line2D segment, Point2D point) {
        return ShapeUtilities.nearestColinearPoint(segment.getX1(), segment.getY1(), segment.getX2(), segment.getY2(), point.getX(), point.getY());
    }

    public static Point2D colinearPoint(Line2D line, Point2D point, double distance) {
        return ShapeUtilities.colinearPoint(line.getX1(), line.getY1(), line.getX2(), line.getY2(), point.getX(), point.getY(), distance);
    }

    public static Ellipse2D circle(Point2D P1, Point2D P2, Point2D P3) {
        Point2D.Double center = ShapeUtilities.circleCentre(P1.getX(), P1.getY(), P2.getX(), P2.getY(), P3.getX(), P3.getY());
        double radius = center.distance(P2);
        return new Ellipse2D.Double(center.x - radius, center.y - radius, 2.0 * radius, 2.0 * radius);
    }

    public static void intersect(RectangularShape shape, Envelope envelope, int xdim, int ydim) {
        double xmin = Math.max(shape.getMinX(), envelope.getMinimum(xdim));
        double ymin = Math.max(shape.getMinY(), envelope.getMinimum(ydim));
        double xmax = Math.min(shape.getMaxX(), envelope.getMaximum(xdim));
        double ymax = Math.min(shape.getMaxY(), envelope.getMaximum(ydim));
        shape.setFrame(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    public static Rectangle2D transform(MathTransform2D transform, Rectangle2D envelope, Rectangle2D destination) throws TransformException {
        ArgumentChecks.ensureNonNull("transform", transform);
        if (transform instanceof AffineTransform) {
            return AffineTransforms2D.transform((AffineTransform)((Object)transform), envelope, destination);
        }
        return Shapes2D.transform(transform, envelope, destination, new double[2]);
    }

    private static Rectangle2D transform(MathTransform2D transform, Rectangle2D envelope, Rectangle2D destination, double[] point) throws TransformException {
        if (envelope == null) {
            return null;
        }
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        WraparoundInEnvelope.Controller wc = new WraparoundInEnvelope.Controller(transform);
        do {
            double x0 = 0.0;
            double y0 = 0.0;
            double \u03bb0 = 0.0;
            double \u03c60 = 0.0;
            double x1 = 0.0;
            double y1 = 0.0;
            double \u03bb1 = 0.0;
            double \u03c61 = 0.0;
            Matrix D02 = null;
            Matrix D12 = null;
            Matrix D22 = null;
            boolean isDerivativeSupported = true;
            CurveExtremum extremum = new CurveExtremum();
            for (int i = 0; i <= 8; ++i) {
                double \u03c62;
                double \u03bb2;
                switch (i) {
                    case 0: 
                    case 6: 
                    case 7: {
                        \u03bb2 = envelope.getMinX();
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 8: {
                        \u03bb2 = envelope.getCenterX();
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        \u03bb2 = envelope.getMaxX();
                        break;
                    }
                    default: {
                        throw new AssertionError(i);
                    }
                }
                switch (i) {
                    case 0: 
                    case 1: 
                    case 2: {
                        \u03c62 = envelope.getMinY();
                        break;
                    }
                    case 3: 
                    case 7: 
                    case 8: {
                        \u03c62 = envelope.getCenterY();
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        \u03c62 = envelope.getMaxY();
                        break;
                    }
                    default: {
                        throw new AssertionError(i);
                    }
                }
                point[0] = \u03bb2;
                point[1] = \u03c62;
                try {
                    D12 = D22;
                    D22 = Envelopes.derivativeAndTransform(wc.transform, point, point, 0, isDerivativeSupported && i != 8);
                }
                catch (TransformException e) {
                    if (!isDerivativeSupported) {
                        throw e;
                    }
                    isDerivativeSupported = false;
                    D22 = null;
                    point[0] = \u03bb2;
                    point[1] = \u03c62;
                    wc.transform.transform(point, 0, point, 0, 1);
                    Envelopes.recoverableException(Shapes2D.class, e);
                }
                double x2 = point[0];
                double y2 = point[1];
                if (x2 < xmin) {
                    xmin = x2;
                }
                if (x2 > xmax) {
                    xmax = x2;
                }
                if (y2 < ymin) {
                    ymin = y2;
                }
                if (y2 > ymax) {
                    ymax = y2;
                }
                switch (i) {
                    case 0: {
                        \u03bb0 = \u03bb2;
                        x0 = x2;
                        \u03c60 = \u03c62;
                        y0 = y2;
                        D02 = D22;
                        break;
                    }
                    case 8: {
                        \u03bb2 = \u03bb0;
                        x2 = x0;
                        \u03c62 = \u03c60;
                        y2 = y0;
                        D22 = D02;
                    }
                }
                if (D12 != null && D22 != null) {
                    double max;
                    double min2;
                    double s2;
                    double s1;
                    int srcDim;
                    switch (i) {
                        case 1: 
                        case 2: 
                        case 5: 
                        case 6: {
                            assert (\u03c62 == \u03c61);
                            srcDim = 0;
                            s1 = \u03bb1;
                            s2 = \u03bb2;
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 7: 
                        case 8: {
                            assert (\u03bb2 == \u03bb1);
                            srcDim = 1;
                            s1 = \u03c61;
                            s2 = \u03c62;
                            break;
                        }
                        default: {
                            throw new AssertionError(i);
                        }
                    }
                    if (s1 < s2) {
                        min2 = s1;
                        max = s2;
                    } else {
                        min2 = s2;
                        max = s1;
                    }
                    int tgtDim = 0;
                    do {
                        extremum.resolve(s1, tgtDim == 0 ? x1 : y1, D12.getElement(tgtDim, srcDim), s2, tgtDim == 0 ? x2 : y2, D22.getElement(tgtDim, srcDim));
                        boolean isP2 = false;
                        do {
                            double te;
                            double se;
                            double d = se = isP2 ? extremum.ex2 : extremum.ex1;
                            if (!(se > min2) || !(se < max)) continue;
                            double d2 = te = isP2 ? extremum.ey2 : extremum.ey1;
                            if (!(tgtDim == 0 ? te < xmin || te > xmax : te < ymin || te > ymax)) continue;
                            double oldX = point[0];
                            double oldY = point[1];
                            if (srcDim == 0) {
                                point[0] = se;
                                point[1] = \u03c61;
                            } else {
                                point[0] = \u03bb1;
                                point[1] = se;
                            }
                            wc.transform.transform(point, 0, point, 0, 1);
                            double x = point[0];
                            double y = point[1];
                            if (x < xmin) {
                                xmin = x;
                            }
                            if (x > xmax) {
                                xmax = x;
                            }
                            if (y < ymin) {
                                ymin = y;
                            }
                            if (y > ymax) {
                                ymax = y;
                            }
                            point[0] = oldX;
                            point[1] = oldY;
                        } while (isP2 = !isP2);
                    } while (++tgtDim == 1);
                }
                \u03bb1 = \u03bb2;
                x1 = x2;
                \u03c61 = \u03c62;
                y1 = y2;
                D12 = D22;
            }
        } while (wc.translate());
        if (destination != null) {
            destination.setRect(xmin, ymin, xmax - xmin, ymax - ymin);
        } else {
            destination = new IntervalRectangle(xmin, ymin, xmax, ymax);
        }
        return destination;
    }

    public static Rectangle2D transform(CoordinateOperation operation, Rectangle2D envelope, Rectangle2D destination) throws TransformException {
        CoordinateReferenceSystem targetCRS;
        CoordinateSystem cs;
        ArgumentChecks.ensureNonNull("operation", operation);
        if (envelope == null) {
            return null;
        }
        MathTransform2D mt = MathTransforms.bidimensional(operation.getMathTransform());
        double[] center = new double[2];
        destination = Shapes2D.transform(mt, envelope, destination, center);
        CoordinateReferenceSystem sourceCRS = operation.getSourceCRS();
        if (sourceCRS != null && (cs = sourceCRS.getCoordinateSystem()) != null && cs.getDimension() == 2) {
            CoordinateSystemAxis axis = cs.getAxis(0);
            double min2 = envelope.getMinX();
            double max = envelope.getMaxX();
            Point2D.Double pt = null;
            for (int i = 0; i < 4; ++i) {
                double v;
                if (i == 2) {
                    axis = cs.getAxis(1);
                    min2 = envelope.getMinY();
                    max = envelope.getMaxY();
                }
                double d = v = (i & 1) == 0 ? axis.getMinimumValue() : axis.getMaximumValue();
                if (!(v > min2) || !(v < max)) continue;
                if (pt == null) {
                    pt = new Point2D.Double();
                }
                if ((i & 2) == 0) {
                    pt.x = v;
                    pt.y = envelope.getCenterY();
                } else {
                    pt.x = envelope.getCenterX();
                    pt.y = v;
                }
                destination.add(mt.transform(pt, pt));
            }
        }
        if ((targetCRS = operation.getTargetCRS()) == null) {
            return destination;
        }
        CoordinateSystem targetCS = targetCRS.getCoordinateSystem();
        if (targetCS == null || targetCS.getDimension() != 2) {
            return destination;
        }
        MathTransform2D inverse = null;
        TransformException warning = null;
        Point2D sourcePt = null;
        Point2D targetPt = null;
        Point2D revertPt = null;
        int includedBoundsValue = 0;
        for (int border = 0; border < 4; ++border) {
            double extremum;
            int dimension = border >>> 1;
            CoordinateSystemAxis axis = targetCS.getAxis(dimension);
            if (axis == null) continue;
            double d = extremum = (border & 1) == 0 ? axis.getMinimumValue() : axis.getMaximumValue();
            if (!Double.isFinite(extremum)) continue;
            if (inverse == null) {
                try {
                    inverse = mt.inverse();
                }
                catch (NoninvertibleTransformException exception) {
                    Envelopes.recoverableException(Shapes2D.class, exception);
                    return destination;
                }
                targetPt = new Point2D.Double();
            }
            switch (dimension) {
                case 0: {
                    targetPt.setLocation(extremum, center[1]);
                    break;
                }
                case 1: {
                    targetPt.setLocation(center[0], extremum);
                    break;
                }
                default: {
                    throw new AssertionError(border);
                }
            }
            try {
                sourcePt = inverse.transform(targetPt, sourcePt);
                if (CoordinateOperations.isWrapAround(axis)) {
                    revertPt = mt.transform(sourcePt, revertPt);
                    double delta = Math.abs((dimension == 0 ? revertPt.getX() : revertPt.getY()) - extremum);
                    if (!(delta < 0.25 * (axis.getMaximumValue() - axis.getMinimumValue()))) continue;
                }
                if (!envelope.contains(sourcePt)) continue;
                destination.add(targetPt);
                includedBoundsValue |= 1 << border;
                continue;
            }
            catch (TransformException exception) {
                if (warning == null) {
                    warning = exception;
                    continue;
                }
                warning.addSuppressed(exception);
            }
        }
        if (includedBoundsValue != 0) {
            int toTest = (includedBoundsValue & 1) << 3 | (includedBoundsValue & 4) >>> 1 | (includedBoundsValue & 2) << 6 | (includedBoundsValue & 8) << 2;
            toTest |= toTest >>> 1;
            if (((toTest &= ~(includedBoundsValue | includedBoundsValue << 4)) & 0x33333333) != 0 && !CoordinateOperations.isWrapAround(targetCS.getAxis(0))) {
                toTest &= 0xCCCCCCCC;
            }
            if ((toTest & 0xCCCCCCCC) != 0 && !CoordinateOperations.isWrapAround(targetCS.getAxis(1))) {
                toTest &= 0x33333333;
            }
            while (toTest != 0) {
                double y;
                int border = Integer.numberOfTrailingZeros(toTest);
                int bitMask = 1 << border;
                toTest &= ~bitMask;
                int dimensionToAdd = border >>> 1 & 1;
                CoordinateSystemAxis toAdd = targetCS.getAxis(dimensionToAdd);
                CoordinateSystemAxis added = targetCS.getAxis(dimensionToAdd ^ 1);
                double x = (border & 1) == 0 ? toAdd.getMinimumValue() : toAdd.getMaximumValue();
                double d = y = (border & 4) == 0 ? added.getMinimumValue() : added.getMaximumValue();
                if (dimensionToAdd == 0) {
                    targetPt.setLocation(x, y);
                } else {
                    targetPt.setLocation(y, x);
                }
                try {
                    if (!envelope.contains(sourcePt = inverse.transform(targetPt, sourcePt))) continue;
                    destination.add(targetPt);
                }
                catch (TransformException exception) {
                    if (warning == null) {
                        warning = exception;
                        continue;
                    }
                    warning.addSuppressed(exception);
                }
            }
        }
        Set<Integer> wrapAroundChanges = operation instanceof AbstractCoordinateOperation ? ((AbstractCoordinateOperation)operation).getWrapAroundChanges() : CoordinateOperations.wrapAroundChanges(sourceCRS, targetCS);
        for (int dim : wrapAroundChanges) {
            double o2;
            double o1;
            CoordinateSystemAxis axis = targetCS.getAxis(dim);
            double minimum = axis.getMinimumValue();
            double maximum = axis.getMaximumValue();
            if (dim == 0) {
                o1 = destination.getMinX();
                o2 = destination.getMaxX();
            } else {
                o1 = destination.getMinY();
                o2 = destination.getMaxY();
            }
            if (!(o1 < minimum) && !(o2 > maximum)) continue;
            double span = maximum - minimum;
            if (dim == 0) {
                destination.setRect(minimum, destination.getY(), span, destination.getHeight());
                continue;
            }
            destination.setRect(destination.getX(), minimum, destination.getWidth(), span);
        }
        if (warning != null) {
            Envelopes.recoverableException(Shapes2D.class, warning);
        }
        return destination;
    }
}

