/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.Function;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.MismatchedCoverageRangeException;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.SliceGeometry;
import org.apache.sis.coverage.grid.j2d.ColorModelBuilder;
import org.apache.sis.coverage.grid.j2d.DeferredProperty;
import org.apache.sis.coverage.grid.j2d.ObservableImage;
import org.apache.sis.coverage.grid.j2d.RasterFactory;
import org.apache.sis.coverage.grid.j2d.TiledImage;
import org.apache.sis.coverage.grid.j2d.WritableTiledImage;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.DataType;
import org.apache.sis.math.Vector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

public class ImageRenderer {
    private final GridGeometry geometry;
    private final GridExtent sliceExtent;
    private final int[] gridDimensions;
    private GridGeometry imageGeometry;
    private final long offsetZ;
    private final long offsetX;
    private final long offsetY;
    private final int imageX;
    private final int imageY;
    private final int width;
    private final int height;
    private final int pixelStride;
    private final int scanlineStride;
    private int strideFactor;
    private final SampleDimension[] bands;
    private int[] bandOffsets;
    private int[] bankIndices;
    private int visibleBand;
    private DataBuffer buffer;
    private Function<Category, Color[]> colors;
    private Hashtable<String, Object> properties;
    private static final MathTransformFactory mtFactory = null;

    public ImageRenderer(GridCoverage coverage, GridExtent sliceExtent) {
        ArgumentChecks.ensureNonNull("coverage", coverage);
        this.bands = (SampleDimension[])coverage.getSampleDimensions().toArray(SampleDimension[]::new);
        this.geometry = coverage.getGridGeometry();
        GridExtent source = this.geometry.getExtent();
        int dimension = source.getDimension();
        this.sliceExtent = sliceExtent;
        if (sliceExtent != null) {
            if (sliceExtent.getDimension() != dimension) {
                throw new MismatchedDimensionException(Errors.format((short)81, "sliceExtent", dimension, sliceExtent.getDimension()));
            }
        } else {
            sliceExtent = source;
        }
        this.gridDimensions = sliceExtent.getSubspaceDimensions(2);
        int xd = this.gridDimensions[0];
        int yd = this.gridDimensions[1];
        long xcov = source.getLow(xd);
        long ycov = source.getLow(yd);
        long xreq = sliceExtent.getLow(xd);
        long yreq = sliceExtent.getLow(yd);
        long xmin = Math.max(xreq, xcov);
        long ymin = Math.max(yreq, ycov);
        long xmax = Math.min(sliceExtent.getHigh(xd), source.getHigh(xd));
        long ymax = Math.min(sliceExtent.getHigh(yd), source.getHigh(yd));
        if (xmax < xmin || ymax < ymin) {
            int d = xmax < xmin ? xd : yd;
            throw new DisjointExtentException(source, sliceExtent, d);
        }
        this.width = Math.incrementExact(Math.toIntExact(xmax - xmin));
        this.height = Math.incrementExact(Math.toIntExact(ymax - ymin));
        this.imageX = Math.toIntExact(Math.subtractExact(xmin, xreq));
        this.imageY = Math.toIntExact(Math.subtractExact(ymin, yreq));
        this.offsetX = Math.subtractExact(xmin, xcov);
        this.offsetY = Math.subtractExact(ymin, ycov);
        long stride = 1L;
        long pixelStride = 0L;
        long scanlineStride = 0L;
        long offsetZ = 0L;
        for (int i = 0; i < dimension; ++i) {
            if (i == xd) {
                pixelStride = stride;
            } else if (i == yd) {
                scanlineStride = stride;
            } else {
                long min2 = source.getLow(i);
                long c = sliceExtent.getLow(i);
                if (c > min2) {
                    offsetZ = Math.addExact(offsetZ, Math.multiplyExact(stride, c - min2));
                }
            }
            stride = Math.multiplyExact(stride, source.getSize(i));
        }
        this.pixelStride = Math.toIntExact(pixelStride);
        this.scanlineStride = Math.toIntExact(scanlineStride);
        this.offsetZ = offsetZ;
        this.colors = ColorModelBuilder.GRAYSCALE;
    }

    public final int getNumBands() {
        return this.bands.length;
    }

    private void ensureExpectedBandCount(int n, boolean acceptOne) {
        int e;
        if (!(n == 1 & acceptOne) && n != (e = this.getNumBands())) {
            throw new MismatchedCoverageRangeException(Resources.format((short)67, e, n));
        }
    }

    public final Rectangle getBounds() {
        return new Rectangle(this.imageX, this.imageY, this.width, this.height);
    }

    public final int[] getXYDimensions() {
        return (int[])this.gridDimensions.clone();
    }

    public GridGeometry getImageGeometry(int dimCRS) {
        GridGeometry ig = this.imageGeometry;
        if (ig == null || dimCRS != 2) {
            if (this.imageUseSameGeometry(dimCRS)) {
                ig = this.geometry;
            } else {
                try {
                    ig = new SliceGeometry(this.geometry, this.sliceExtent, this.gridDimensions, mtFactory).reduce(new GridExtent(this.imageX, this.imageY, this.width, this.height), dimCRS);
                }
                catch (FactoryException e) {
                    throw SliceGeometry.canNotCompute(e);
                }
            }
            if (dimCRS == 2) {
                this.imageGeometry = ig;
            }
        }
        return ig;
    }

    public Object getProperty(String key) {
        switch (key) {
            case "org.apache.sis.GridGeometry": {
                return this.getImageGeometry(2);
            }
            case "org.apache.sis.SampleDimensions": {
                return this.bands.clone();
            }
        }
        return this.properties != null ? this.properties.get(key) : null;
    }

    public void addProperty(String key, Object value) {
        ArgumentChecks.ensureNonNull("key", key);
        ArgumentChecks.ensureNonNull("value", value);
        if (!"org.apache.sis.GridGeometry".equals(key) && !"org.apache.sis.SampleDimensions".equals(key)) {
            if (this.properties == null) {
                this.properties = new Hashtable();
            }
            if (this.properties.putIfAbsent(key, value) == null) {
                return;
            }
        }
        throw new IllegalArgumentException(Errors.format((short)27, key));
    }

    private boolean imageUseSameGeometry(int dimCRS) {
        int tgtDim = this.geometry.getTargetDimension();
        ArgumentChecks.ensureBetween("dimCRS", 2, tgtDim, dimCRS);
        if (tgtDim == dimCRS && this.geometry.getDimension() == this.gridDimensions.length) {
            GridExtent extent = this.geometry.extent;
            if (this.sliceExtent == null) {
                return extent == null || extent.startsAtZero();
            }
            if (this.sliceExtent.equals(extent, ComparisonMode.IGNORE_METADATA)) {
                return this.sliceExtent.startsAtZero();
            }
        }
        return false;
    }

    public void setData(DataBuffer data) {
        ArgumentChecks.ensureNonNull("data", data);
        this.ensureExpectedBandCount(data.getNumBanks(), true);
        this.buffer = data;
    }

    public void setData(DataType dataType, Buffer ... data) {
        ArgumentChecks.ensureNonNull("dataType", (Object)dataType);
        ArgumentChecks.ensureNonNull("data", data);
        this.ensureExpectedBandCount(data.length, true);
        this.setData(RasterFactory.wrap(dataType, data));
    }

    public void setData(Vector ... data) {
        ArgumentChecks.ensureNonNull("data", data);
        this.ensureExpectedBandCount(data.length, true);
        Buffer[] buffers = new Buffer[data.length];
        DataType dataType = null;
        for (int i = 0; i < data.length; ++i) {
            Vector v = data[i];
            ArgumentChecks.ensureNonNullElement("data", i, v);
            DataType t2 = DataType.forPrimitiveType(v.getElementType(), v.isUnsigned());
            if (dataType == null) {
                dataType = t2;
            } else if (dataType != t2) {
                throw new RasterFormatException(Resources.format((short)42));
            }
            buffers[i] = v.buffer().orElseThrow(UnsupportedOperationException::new);
        }
        this.setData(dataType, buffers);
    }

    public void setInterleavedPixelOffsets(int pixelStride, int[] bandOffsets) {
        ArgumentChecks.ensureStrictlyPositive("pixelStride", pixelStride);
        ArgumentChecks.ensureNonNull("bandOffsets", bandOffsets);
        this.ensureExpectedBandCount(bandOffsets.length, false);
        this.strideFactor = pixelStride;
        this.bandOffsets = (int[])bandOffsets.clone();
    }

    public void setVisibleBand(int band) {
        ArgumentChecks.ensureBetween("band", 0, this.getNumBands() - 1, band);
        this.visibleBand = band;
    }

    public void setCategoryColors(Function<Category, Color[]> colors) {
        ArgumentChecks.ensureNonNull("colors", colors);
        this.colors = colors;
    }

    public Raster createRaster() {
        boolean isInterleaved;
        if (this.buffer == null) {
            throw new IllegalStateException(Resources.format((short)74));
        }
        boolean bl = isInterleaved = this.buffer.getNumBanks() == 1;
        if (this.bandOffsets == null) {
            this.strideFactor = isInterleaved ? this.getNumBands() : 1;
        }
        int ls = Math.multiplyExact(this.scanlineStride, this.strideFactor);
        int ps = this.pixelStride * this.strideFactor;
        int[] offsets = new int[this.getNumBands()];
        Arrays.fill(offsets, Math.toIntExact(Math.addExact(Math.addExact(Math.multiplyExact(this.offsetX, ps), Math.multiplyExact(this.offsetY, ls)), this.offsetZ)));
        if (this.bandOffsets != null || isInterleaved) {
            for (int i = 0; i < offsets.length; ++i) {
                offsets[i] = Math.addExact(offsets[i], this.bandOffsets != null ? this.bandOffsets[i] : i);
            }
        }
        Point location = new Point(this.imageX, this.imageY);
        return RasterFactory.createRaster(this.buffer, this.width, this.height, ps, ls, this.bankIndices, offsets, location);
    }

    public RenderedImage createImage() {
        WritableRaster wr;
        ColorModelBuilder colorizer = new ColorModelBuilder(this.colors, null, false);
        Raster raster = this.createRaster();
        SampleModel sm = raster.getSampleModel();
        ColorModel colors = colorizer.initialize(sm, this.bands[this.visibleBand]) || colorizer.initialize(sm, this.visibleBand) ? colorizer.createColorModel(this.buffer.getDataType(), this.bands.length, this.visibleBand) : ColorModelBuilder.NULL_COLOR_MODEL;
        SliceGeometry supplier = null;
        if (this.imageGeometry == null) {
            if (this.imageUseSameGeometry(2)) {
                this.imageGeometry = this.geometry;
            } else {
                supplier = new SliceGeometry(this.geometry, this.sliceExtent, this.gridDimensions, mtFactory);
            }
        }
        WritableRaster writableRaster = wr = raster instanceof WritableRaster ? (WritableRaster)raster : null;
        if (wr != null && colors != null && (this.imageX | this.imageY) == 0) {
            return new Untiled(colors, wr, this.properties, this.imageGeometry, supplier, this.bands);
        }
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.putIfAbsent("org.apache.sis.GridGeometry", supplier != null ? new DeferredProperty(supplier) : this.imageGeometry);
        this.properties.putIfAbsent("org.apache.sis.SampleDimensions", this.bands);
        if (wr != null) {
            return new WritableTiledImage((Map<String, Object>)this.properties, colors, this.width, this.height, 0, 0, wr);
        }
        return new TiledImage(this.properties, colors, this.width, this.height, 0, 0, raster);
    }

    private static final class Untiled
    extends ObservableImage {
        private GridGeometry geometry;
        private SliceGeometry supplier;
        private final SampleDimension[] bands;

        Untiled(ColorModel colors, WritableRaster raster, Hashtable<?, ?> properties, GridGeometry geometry, SliceGeometry supplier, SampleDimension[] bands) {
            super(colors, raster, false, properties);
            this.geometry = geometry;
            this.supplier = supplier;
            this.bands = bands;
        }

        @Override
        public String[] getPropertyNames() {
            return ArraysExt.concatenate(super.getPropertyNames(), {"org.apache.sis.GridGeometry", "org.apache.sis.SampleDimensions"});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getProperty(String key) {
            switch (key) {
                default: {
                    return super.getProperty(key);
                }
                case "org.apache.sis.SampleDimensions": {
                    return this.bands.clone();
                }
                case "org.apache.sis.GridGeometry": 
            }
            Untiled untiled = this;
            synchronized (untiled) {
                SliceGeometry s2;
                if (this.geometry == null && (s2 = this.supplier) != null) {
                    this.supplier = null;
                    this.geometry = s2.apply(this);
                }
                return this.geometry;
            }
        }
    }
}

