/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import java.util.regex.Pattern;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.projection.ProjectionVariant;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;

public class Mollweide
extends NormalizedProjection {
    private static final long serialVersionUID = 712275000459795291L;

    private static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> enumMap = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        enumMap.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.internal.referencing.provider.Mollweide.CENTRAL_MERIDIAN);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.internal.referencing.provider.Mollweide.FALSE_EASTING);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.internal.referencing.provider.Mollweide.FALSE_NORTHING);
        return new Initializer(operationMethod, parameters, enumMap, Variant.SPHERICAL);
    }

    public Mollweide(OperationMethod operationMethod, Parameters parameters) {
        super(Mollweide.initializer(operationMethod, parameters), null);
        MatrixSIS matrixSIS = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        MatrixSIS matrixSIS2 = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        matrixSIS.convertAfter(0, 2.8284271247461903, null);
        matrixSIS2.convertBefore(0, 0.3183098861837907, null);
        matrixSIS2.convertBefore(1, 1.4142135623730951, null);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d;
        double d2 = dArray[n];
        double d3 = dArray[n + 1];
        double d4 = Math.sin(d3);
        double d5 = 2.0 * Math.asin(d3 * 0.6366197723675814);
        if (Math.abs(d4) != 1.0) {
            double d6;
            d = Math.PI * d4;
            int n3 = 18;
            do {
                if (--n3 < 0) {
                    throw new ProjectionException(Resources.format((short)46));
                }
                d6 = (d5 + Math.sin(d5) - d) / (1.0 + Math.cos(d5));
                d5 -= d6;
            } while (Math.abs(d6) > 7.853353365705227E-10);
        }
        d = d5 * 0.5;
        double d7 = Math.cos(d) * d2;
        double d8 = Math.sin(d);
        if (dArray2 != null) {
            dArray2[n2] = d7;
            dArray2[n2 + 1] = d8;
        }
        if (!bl) {
            return null;
        }
        try {
            return Matrices.inverse(Mollweide.inverseDerivate(d7, d8, d5, d4));
        }
        catch (NoninvertibleMatrixException noninvertibleMatrixException) {
            throw new ProjectionException(noninvertibleMatrixException);
        }
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = Math.asin(d2);
        double d4 = 2.0 * d3;
        double d5 = Math.asin((d4 + Math.sin(d4)) * 0.3183098861837907);
        double d6 = d / Math.cos(d3);
        if (Math.abs(d6) > 8.885765876316732) {
            d6 = Double.NaN;
        }
        dArray2[n2] = d6;
        dArray2[n2 + 1] = d5;
    }

    private static Matrix inverseDerivate(double d, double d2, double d3, double d4) {
        double d5 = Math.sqrt(1.0 - d4 * d4);
        double d6 = 1.0 - d2 * d2;
        double d7 = 1.0 / Math.sqrt(d6);
        double d8 = d * d2 * d7 / d6;
        double d9 = 2.0 * d7 * (1.0 + Math.cos(d3)) / (Math.PI * d5);
        return new Matrix2(d7, d8, 0.0, d9);
    }

    private static enum Variant implements ProjectionVariant
    {
        SPHERICAL;


        @Override
        public Pattern getOperationNamePattern() {
            return null;
        }

        @Override
        public String getIdentifier() {
            return null;
        }

        @Override
        public boolean useAuthalicRadius() {
            return true;
        }
    }
}

