/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import java.time.temporal.Temporal;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.gco.GO_Temporal;
import org.apache.sis.internal.jaxb.metadata.MD_Scope;
import org.apache.sis.metadata.iso.quality.DefaultConformanceResult;
import org.apache.sis.metadata.iso.quality.DefaultCoverageResult;
import org.apache.sis.metadata.iso.quality.DefaultDescriptiveResult;
import org.apache.sis.metadata.iso.quality.DefaultQuantitativeResult;
import org.apache.sis.metadata.iso.quality.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.quality.ConformanceResult;
import org.opengis.metadata.quality.CoverageResult;
import org.opengis.metadata.quality.QuantitativeResult;
import org.opengis.metadata.quality.Result;
import org.opengis.metadata.quality.Scope;

@XmlType(name="AbstractDQ_Result_Type", propOrder={"resultScope", "dateTime"})
@XmlRootElement(name="AbstractDQ_Result")
@XmlSeeAlso(value={DefaultConformanceResult.class, DefaultQuantitativeResult.class, DefaultDescriptiveResult.class, DefaultCoverageResult.class})
public class AbstractResult
extends ISOMetadata
implements Result {
    private static final long serialVersionUID = 3510023908820052467L;
    private Scope resultScope;
    private Temporal dateTime;

    public AbstractResult() {
    }

    public AbstractResult(Result result) {
        super(result);
        if (result instanceof AbstractResult) {
            AbstractResult abstractResult = (AbstractResult)result;
            this.resultScope = abstractResult.getResultScope();
            this.dateTime = abstractResult.getDateTime();
        }
    }

    public static AbstractResult castOrCopy(Result result) {
        if (result instanceof QuantitativeResult) {
            return DefaultQuantitativeResult.castOrCopy((QuantitativeResult)result);
        }
        if (result instanceof ConformanceResult) {
            return DefaultConformanceResult.castOrCopy((ConformanceResult)result);
        }
        if (result instanceof CoverageResult) {
            return DefaultCoverageResult.castOrCopy((CoverageResult)result);
        }
        if (result == null || result instanceof AbstractResult) {
            return (AbstractResult)result;
        }
        return new AbstractResult(result);
    }

    @XmlElement(name="resultScope")
    @XmlJavaTypeAdapter(value=MD_Scope.Since2014.class)
    @UML(identifier="resultScope", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public Scope getResultScope() {
        return this.resultScope;
    }

    public void setResultScope(Scope scope) {
        this.resultScope = scope;
    }

    @XmlElement(name="dateTime")
    @XmlJavaTypeAdapter(value=GO_Temporal.Since2014.class)
    @UML(identifier="dateTime", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public Temporal getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(Temporal temporal) {
        this.dateTime = temporal;
    }
}

