/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.quantity.Time;
import org.apache.sis.internal.metadata.TransformationAccuracy;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.EllipsoidalHeightCombiner;
import org.apache.sis.internal.referencing.Legacy;
import org.apache.sis.internal.referencing.ReferencingFactoryContainer;
import org.apache.sis.internal.referencing.ServicesForMetadata;
import org.apache.sis.internal.referencing.VerticalDatumTypes;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Element;
import org.apache.sis.io.wkt.MathTransformParser;
import org.apache.sis.io.wkt.StoredTree;
import org.apache.sis.io.wkt.Symbols;
import org.apache.sis.io.wkt.Transliterator;
import org.apache.sis.io.wkt.UnparsableObjectException;
import org.apache.sis.io.wkt.VerticalInfo;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultGeographicDescription;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.crs.DefaultDerivedCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ObjectFactory;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

class GeodeticObjectParser
extends MathTransformParser
implements Comparator<CoordinateSystemAxis> {
    private static final String[] ToWGS84 = new String[]{"dx", "dy", "dz", "ex", "ey", "ez", "ppm"};
    private final boolean usesCommonUnits;
    private final boolean ignoreAxes;
    private final Transliterator transliterator;
    private final Map<String, Object> properties = new HashMap<String, Object>(4);
    private final Map<CoordinateSystemAxis, Integer> axisOrder = new IdentityHashMap<CoordinateSystemAxis, Integer>(4);
    private transient VerticalCRS verticalCRS;
    private transient VerticalInfo verticalElements;

    public GeodeticObjectParser(Map<String, ?> map, ObjectFactory objectFactory, MathTransformFactory mathTransformFactory) {
        super(Symbols.getDefault(), Collections.emptyMap(), null, null, null, new ReferencingFactoryContainer(map, (CRSFactory)objectFactory, (CSFactory)objectFactory, (DatumFactory)objectFactory, null, mathTransformFactory), (Locale)map.get("locale"));
        this.transliterator = Transliterator.DEFAULT;
        this.usesCommonUnits = false;
        this.ignoreAxes = false;
    }

    GeodeticObjectParser(Symbols symbols, Map<String, StoredTree> map, NumberFormat numberFormat, DateFormat dateFormat, UnitFormat unitFormat, Convention convention, Transliterator transliterator, Locale locale, ReferencingFactoryContainer referencingFactoryContainer) {
        super(symbols, map, numberFormat, dateFormat, unitFormat, referencingFactoryContainer, locale);
        this.transliterator = transliterator;
        this.usesCommonUnits = convention.usesCommonUnits;
        this.ignoreAxes = convention == Convention.WKT1_IGNORE_AXES;
    }

    @Override
    String getPublicFacade() {
        return "org.apache.sis.referencing.factory.GeodeticObjectFactory";
    }

    void completeRoot(Map<String, Object> map) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final Object createFromWKT(String string, ParsePosition parsePosition) throws ParseException {
        Object object;
        block10: {
            try {
                object = super.createFromWKT(string, parsePosition);
                if (this.verticalElements == null) break block10;
                Exception exception = null;
                try {
                    this.verticalElements = this.verticalElements.resolve(CommonCRS.Vertical.MEAN_SEA_LEVEL.crs());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    exception = unsupportedOperationException;
                }
                if (this.verticalElements != null) {
                    try {
                        this.verticalElements = this.verticalElements.complete(this.factories.getCRSFactory(), this.factories.getCSFactory());
                    }
                    catch (FactoryException factoryException) {
                        if (exception == null) {
                            exception = factoryException;
                        }
                        exception.addSuppressed(factoryException);
                    }
                }
                if (this.verticalElements != null) {
                    this.warning(null, (String)null, Errors.formatInternational((short)3, "VerticalExtent", this.verticalElements.unit), exception);
                }
            }
            finally {
                this.verticalElements = null;
                this.verticalCRS = null;
                this.axisOrder.clear();
                this.properties.clear();
            }
        }
        return object;
    }

    @Override
    final Object buildFromTree(Element element) throws ParseException {
        Object object = this.parseCoordinateReferenceSystem(element, false);
        if (object != null) {
            return object;
        }
        object = this.parseMathTransform(element, false);
        if (object != null) {
            return object;
        }
        Object object2 = this.parseAxis(0, element, null, Units.METRE);
        if (object2 == null && (object2 = this.parsePrimeMeridian(0, element, false, Units.DEGREE)) == null && (object2 = this.parseDatum(0, element, null)) == null && (object2 = this.parseEllipsoid(0, element)) == null && (object2 = this.parseToWGS84(0, element)) == null && (object2 = this.parseVerticalDatum(0, element, false)) == null && (object2 = this.parseTimeDatum(0, element)) == null && (object2 = this.parseParametricDatum(0, element)) == null && (object2 = this.parseEngineeringDatum(0, element, false)) == null && (object2 = this.parseImageDatum(0, element)) == null && (object2 = this.parseOperation(0, element)) == null && (object2 = this.parseGeogTranslation(0, element)) == null) {
            throw element.missingOrUnknownComponent("GeodeticCRS");
        }
        return object2;
    }

    private CoordinateReferenceSystem parseCoordinateReferenceSystem(Element element, boolean bl) throws ParseException {
        CoordinateReferenceSystem coordinateReferenceSystem = this.parseGeodeticCRS(0, element, 2, null);
        if (coordinateReferenceSystem == null && (coordinateReferenceSystem = this.parseProjectedCRS(0, element, false)) == null && (coordinateReferenceSystem = this.parseVerticalCRS(0, element, false)) == null && (coordinateReferenceSystem = this.parseTimeCRS(0, element, false)) == null && (coordinateReferenceSystem = this.parseParametricCRS(0, element, false)) == null && (coordinateReferenceSystem = this.parseEngineeringCRS(0, element, false)) == null && (coordinateReferenceSystem = this.parseImageCRS(0, element)) == null && (coordinateReferenceSystem = this.parseCompoundCRS(0, element)) == null && (coordinateReferenceSystem = this.parseFittedCS(0, element)) == null && bl) {
            throw element.missingOrUnknownComponent("GeodeticCRS");
        }
        return coordinateReferenceSystem;
    }

    private CoordinateReferenceSystem parseCoordinateReferenceSystem(Element element, int n, String string) throws ParseException {
        Element element2 = element.pullElement(n, string);
        if (element2 == null) {
            return null;
        }
        CoordinateReferenceSystem coordinateReferenceSystem = this.parseCoordinateReferenceSystem(element2, true);
        element2.close(this.ignoredElements);
        return coordinateReferenceSystem;
    }

    private static Identifier toIdentifier(Object object) {
        return object instanceof Identifier[] ? ((Identifier[])object)[0] : (Identifier)object;
    }

    private Map<String, Object> parseMetadataAndClose(Element element, String string, IdentifiedObject identifiedObject) throws ParseException {
        Object object;
        String string2;
        Object object2;
        Element element2;
        this.properties.clear();
        this.properties.put("name", string.isEmpty() && identifiedObject != null ? identifiedObject.getName() : string);
        while ((element2 = element.pullElement(1, ID_KEYWORDS)) != null) {
            ReferenceIdentifier[] referenceIdentifierArray;
            String string3;
            object2 = element2.pullString("codeSpace");
            string2 = element2.pullObject("code").toString();
            object = element2.pullOptional(Object.class);
            Element element3 = element2.pullElement(1, "Citation");
            if (element3 != null) {
                string3 = element3.pullString("authority");
                element3.close(this.ignoredElements);
            } else {
                string3 = object2;
            }
            Element element4 = element2.pullElement(1, "URI");
            if (element4 != null) {
                element4.pullString("URI");
                element4.close(this.ignoredElements);
            }
            element2.close(this.ignoredElements);
            ImmutableIdentifier immutableIdentifier = new ImmutableIdentifier(Citations.fromName(string3), (String)object2, string2, object != null ? object.toString() : null, null);
            Object object3 = this.properties.put("identifiers", immutableIdentifier);
            if (object3 == null) continue;
            if (object3 instanceof ReferenceIdentifier) {
                referenceIdentifierArray = new ReferenceIdentifier[]{(ReferenceIdentifier)object3, immutableIdentifier};
            } else {
                referenceIdentifierArray = (ReferenceIdentifier[])object3;
                int n = referenceIdentifierArray.length;
                referenceIdentifierArray = Arrays.copyOf(referenceIdentifierArray, n + 1);
                referenceIdentifierArray[n] = immutableIdentifier;
            }
            this.properties.put("identifiers", referenceIdentifierArray);
        }
        if (!element.isEmpty()) {
            element2 = element.pullElement(1, "Scope");
            if (element2 != null) {
                this.properties.put("scope", element2.pullString("scope"));
                element2.close(this.ignoredElements);
            }
            object2 = null;
            while ((element2 = element.pullElement(1, "Area")) != null) {
                string2 = element2.pullString("area");
                element2.close(this.ignoredElements);
                if (object2 == null) {
                    object2 = new DefaultExtent(string2, null, null, null);
                    continue;
                }
                ((DefaultExtent)object2).getGeographicElements().add(new DefaultGeographicDescription(string2));
            }
            while ((element2 = element.pullElement(1, "BBox")) != null) {
                double d = element2.pullDouble("southBoundLatitude");
                double d2 = element2.pullDouble("westBoundLongitude");
                double d3 = element2.pullDouble("northBoundLatitude");
                double d4 = element2.pullDouble("eastBoundLongitude");
                element2.close(this.ignoredElements);
                if (object2 == null) {
                    object2 = new DefaultExtent();
                }
                ((DefaultExtent)object2).getGeographicElements().add(new DefaultGeographicBoundingBox(d2, d4, d, d3));
            }
            while ((element2 = element.pullElement(1, "VerticalExtent")) != null) {
                double d = element2.pullDouble("minimum");
                double d5 = element2.pullDouble("maximum");
                Unit<Length> unit = this.parseScaledUnit(element2, "LengthUnit", Units.METRE);
                element2.close(this.ignoredElements);
                if (unit == null) {
                    unit = Units.METRE;
                }
                if (object2 == null) {
                    object2 = new DefaultExtent();
                }
                this.verticalElements = new VerticalInfo(this.verticalElements, (DefaultExtent)object2, d, d5, unit).resolve(this.verticalCRS);
            }
            while ((element2 = element.pullElement(1, "TimeExtent")) != null) {
                if (element2.peekValue() instanceof String) {
                    element2.pullString("startTime");
                    element2.pullString("endTime");
                    element2.close(this.ignoredElements);
                    this.warning(element, element2, Errors.formatInternational((short)163, (Object)"TimeExtent[String,String]"), null);
                    continue;
                }
                Date date = element2.pullDate("startTime");
                object = element2.pullDate("endTime");
                element2.close(this.ignoredElements);
                DefaultTemporalExtent defaultTemporalExtent = new DefaultTemporalExtent();
                defaultTemporalExtent.setBounds(date, (Date)object);
                if (object2 == null) {
                    object2 = new DefaultExtent();
                }
                ((DefaultExtent)object2).getTemporalElements().add(defaultTemporalExtent);
            }
            if (object2 != null) {
                this.properties.put("domainOfValidity", object2);
            }
            if ((element2 = element.pullElement(1, "Remark")) != null) {
                this.properties.put("remarks", element2.pullString("remarks"));
                element2.close(this.ignoredElements);
            }
        }
        element.close(this.ignoredElements);
        if (element.isRoot) {
            this.completeRoot(this.properties);
        }
        return this.properties;
    }

    private Map<String, Object> parseAnchorAndClose(Element element, String string) throws ParseException {
        Element element2 = element.pullElement(1, "Anchor");
        Map<String, Object> map = this.parseMetadataAndClose(element, string, null);
        if (element2 != null) {
            map.put("anchorPoint", element2.pullString("anchorDefinition"));
            element2.close(this.ignoredElements);
        }
        return map;
    }

    private <Q extends Quantity<Q>> Unit<Q> parseScaledUnit(Element element, String string, Unit<Q> unit) throws ParseException {
        Element element2 = element.pullElement(1, string, "Unit");
        if (element2 == null) {
            return null;
        }
        String string2 = element2.pullString("name");
        double d = element2.pullDouble("factor");
        Unit<?> unit2 = unit.multiply(GeodeticObjectParser.completeUnitFactor(unit, d));
        Unit<?> unit3 = this.parseUnitID(element2);
        element2.close(this.ignoredElements);
        if (unit3 != null) {
            if (!unit.getSystemUnit().equals(unit3.getSystemUnit())) {
                this.warning(element, element2, Errors.formatInternational((short)70, unit3), null);
            } else {
                Unit<?> unit4;
                Unit<?> unit5 = unit2;
                unit2 = unit3;
                if (Math.abs(unit5.getConverterTo(unit4).convert(1.0) - 1.0) > 1.0E-13) {
                    this.warning(element, element2, Errors.formatInternational((short)142, unit3, d), null);
                } else {
                    unit3 = null;
                }
            }
        }
        if (unit3 == null) {
            try {
                unit3 = this.parseUnit(string2);
            }
            catch (ParserException parserException) {
                this.log(new LogRecord(Level.FINE, parserException.toString()));
            }
            if (unit3 != null) {
                try {
                    if (Math.abs(unit3.getConverterToAny(unit2).convert(1.0) - 1.0) > 1.0E-13) {
                        this.warning(element, element2, Errors.formatInternational((short)142, unit3, d), null);
                    }
                }
                catch (IncommensurableException incommensurableException) {
                    throw new UnparsableObjectException(this.errorLocale, 70, new Object[]{unit3}, element2.offset).initCause(incommensurableException);
                }
            }
        }
        return unit2;
    }

    private CoordinateSystem parseCoordinateSystem(Element element, String string, int n, boolean bl, Unit<?> unit, Datum datum) throws ParseException, FactoryException {
        CharSequence charSequence;
        String string2;
        Object object;
        Object object2;
        CoordinateSystemAxis[] coordinateSystemAxisArray;
        this.axisOrder.clear();
        boolean bl2 = n >= 3;
        Map<String, Object> map = null;
        if (!bl && (coordinateSystemAxisArray = element.pullElement(1, "CS")) != null) {
            object2 = string;
            string = coordinateSystemAxisArray.pullVoidElement((String)"type").keyword;
            n = coordinateSystemAxisArray.pullInteger("dimension");
            map = new HashMap<String, Object>(this.parseMetadataAndClose((Element)coordinateSystemAxisArray, "CS", null));
            if (object2 != null && !((String)object2).equalsIgnoreCase(string)) {
                throw new UnparsableObjectException(this.errorLocale, 144, new String[]{"CS", string}, coordinateSystemAxisArray.offset);
            }
            if (n <= 0 || n >= Short.MAX_VALUE) {
                Object[] objectArray;
                short s;
                if (n <= 0) {
                    s = 165;
                    objectArray = new Object[]{"dimension", n};
                } else {
                    s = 37;
                    objectArray = new Object[]{n};
                }
                throw new UnparsableObjectException(this.errorLocale, s, objectArray, coordinateSystemAxisArray.offset);
            }
            string = string.equalsIgnoreCase("Cartesian") ? "Cartesian" : string.toLowerCase(this.symbols.getLocale());
        }
        coordinateSystemAxisArray = null;
        object2 = this.parseAxis(string == null ? 2 : 1, element, string, unit);
        if (object2 != null) {
            object = new ArrayList(n + 2);
            do {
                object.add(object2);
            } while ((object2 = this.parseAxis(object.size() < n ? 2 : 1, element, string, unit)) != null);
            if (!bl || !this.ignoreAxes) {
                coordinateSystemAxisArray = object.toArray(new CoordinateSystemAxis[object.size()]);
                Arrays.sort(coordinateSystemAxisArray, this);
            }
        }
        object = this.factories.getCSFactory();
        if (coordinateSystemAxisArray == null) {
            if (string == null) {
                throw element.missingComponent("Axis");
            }
            string2 = null;
            charSequence = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            AxisDirection axisDirection = AxisDirection.EAST;
            AxisDirection axisDirection2 = AxisDirection.NORTH;
            AxisDirection axisDirection3 = null;
            Unit<Object> unit2 = unit;
            switch (string) {
                case "Cartesian": {
                    if (datum != null && !(datum instanceof GeodeticDatum)) {
                        throw element.missingComponent("Axis");
                    }
                    if (unit == null) {
                        throw element.missingComponent("LengthUnit");
                    }
                    if (bl2) {
                        return Legacy.standard(unit);
                    }
                    string2 = "Easting";
                    charSequence = "E";
                    string3 = "Northing";
                    string4 = "N";
                    if (n < 3) break;
                    string6 = "h";
                    string5 = "Ellipsoidal height";
                    unit2 = Units.METRE;
                    break;
                }
                case "ellipsoidal": {
                    if (unit == null) {
                        throw element.missingComponent("AngleUnit");
                    }
                    if (bl) {
                        string2 = "Geodetic longitude";
                        charSequence = "\u03bb";
                        string3 = "Geodetic latitude";
                        string4 = "\u03c6";
                    } else {
                        string2 = "Geodetic latitude";
                        charSequence = "\u03c6";
                        axisDirection = AxisDirection.NORTH;
                        string3 = "Geodetic longitude";
                        string4 = "\u03bb";
                        axisDirection2 = AxisDirection.EAST;
                    }
                    if (n < 3) break;
                    axisDirection3 = AxisDirection.UP;
                    string6 = "h";
                    string5 = "Ellipsoidal height";
                    unit2 = Units.METRE;
                    break;
                }
                case "vertical": {
                    if (unit == null) {
                        throw element.missingComponent("Unit");
                    }
                    string6 = "h";
                    string5 = "Height";
                    axisDirection3 = AxisDirection.UP;
                    if (!(datum instanceof VerticalDatum)) break;
                    VerticalDatumType verticalDatumType = ((VerticalDatum)datum).getVerticalDatumType();
                    if (verticalDatumType == VerticalDatumType.GEOIDAL) {
                        string5 = "Gravity-related height";
                        string6 = "H";
                        break;
                    }
                    if (verticalDatumType == VerticalDatumType.DEPTH) {
                        axisDirection3 = AxisDirection.DOWN;
                        string5 = "Depth";
                        string6 = "D";
                        break;
                    }
                    if (verticalDatumType != VerticalDatumTypes.ELLIPSOIDAL) break;
                    string5 = "Ellipsoidal height";
                    break;
                }
                case "temporal": {
                    if (unit == null) {
                        throw element.missingComponent("TimeUnit");
                    }
                    axisDirection3 = AxisDirection.FUTURE;
                    string5 = "Time";
                    string6 = "t";
                    break;
                }
                case "parametric": {
                    if (unit == null) {
                        throw element.missingComponent("ParametricUnit");
                    }
                    axisDirection3 = AxisDirection.OTHER;
                    string5 = "Parametric";
                    string6 = "p";
                    break;
                }
                default: {
                    throw element.missingComponent("Axis");
                }
            }
            int n2 = 0;
            coordinateSystemAxisArray = new CoordinateSystemAxis[n];
            if (charSequence != null && n2 < n) {
                coordinateSystemAxisArray[n2++] = object.createCoordinateSystemAxis(Collections.singletonMap("name", string2), (String)charSequence, axisDirection, unit);
            }
            if (string4 != null && n2 < n) {
                coordinateSystemAxisArray[n2++] = object.createCoordinateSystemAxis(Collections.singletonMap("name", string3), string4, axisDirection2, unit);
            }
            if (string6 != null && n2 < n) {
                coordinateSystemAxisArray[n2++] = object.createCoordinateSystemAxis(Collections.singletonMap("name", string5), string6, axisDirection3, unit2);
            }
        }
        charSequence = new StringBuilder();
        if (string != null && !string.isEmpty()) {
            int n3 = string.codePointAt(0);
            ((StringBuilder)charSequence).appendCodePoint(Character.toUpperCase(n3)).append(string, Character.charCount(n3), string.length()).append(' ');
        }
        string2 = AxisDirections.appendTo(((StringBuilder)charSequence).append("CS"), coordinateSystemAxisArray);
        if (map == null) {
            map = Collections.singletonMap("name", string2);
        } else {
            map.put("name", string2);
        }
        if (string == null) {
            return new AbstractCS(map, coordinateSystemAxisArray);
        }
        switch (string) {
            case "ellipsoidal": {
                switch (coordinateSystemAxisArray.length) {
                    case 2: {
                        return object.createEllipsoidalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                    }
                    case 3: {
                        return object.createEllipsoidalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                    }
                }
                n = coordinateSystemAxisArray.length < 2 ? 2 : 3;
                break;
            }
            case "Cartesian": {
                switch (coordinateSystemAxisArray.length) {
                    case 2: {
                        return object.createCartesianCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                    }
                    case 3: {
                        return object.createCartesianCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                    }
                }
                n = coordinateSystemAxisArray.length < 2 ? 2 : 3;
                break;
            }
            case "affine": {
                switch (coordinateSystemAxisArray.length) {
                    case 2: {
                        return object.createAffineCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                    }
                    case 3: {
                        return object.createAffineCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                    }
                }
                n = coordinateSystemAxisArray.length < 2 ? 2 : 3;
                break;
            }
            case "vertical": {
                n = 1;
                if (coordinateSystemAxisArray.length != 1) break;
                return object.createVerticalCS(map, coordinateSystemAxisArray[0]);
            }
            case "temporal": {
                n = 1;
                if (coordinateSystemAxisArray.length != 1) break;
                return object.createTimeCS(map, coordinateSystemAxisArray[0]);
            }
            case "linear": {
                n = 1;
                if (coordinateSystemAxisArray.length != 1) break;
                return object.createLinearCS(map, coordinateSystemAxisArray[0]);
            }
            case "polar": {
                n = 2;
                if (coordinateSystemAxisArray.length != 2) break;
                return object.createPolarCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
            }
            case "cylindrical": {
                n = 3;
                if (coordinateSystemAxisArray.length != 3) break;
                return object.createCylindricalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
            }
            case "spherical": {
                n = 3;
                if (coordinateSystemAxisArray.length != 3) break;
                return object.createSphericalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
            }
            case "parametric": {
                n = 1;
                if (coordinateSystemAxisArray.length != 1) break;
                return ServicesForMetadata.createParametricCS(map, coordinateSystemAxisArray[0], (CSFactory)object);
            }
            default: {
                this.warning(element, "CS", Errors.formatInternational((short)149, (Object)string), null);
                return new AbstractCS(map, coordinateSystemAxisArray);
            }
        }
        throw new UnparsableObjectException(this.errorLocale, coordinateSystemAxisArray.length > n ? (short)130 : 128, new Object[]{n, "Axis"}, element.offset);
    }

    private CoordinateSystemAxis parseAxis(int n, Element element, String string, Unit<?> unit) throws ParseException {
        CoordinateSystemAxis coordinateSystemAxis;
        String string2;
        int n2;
        int n3;
        Element element2 = element.pullElement(n, "Axis");
        if (element2 == null) {
            return null;
        }
        String string3 = element2.pullString("name");
        Element element3 = element2.pullVoidElement("orientation");
        Unit<?> unit2 = this.parseUnit(element2);
        if (unit2 == null) {
            if (unit == null) {
                throw element2.missingComponent("Unit");
            }
            unit2 = unit;
        }
        AxisDirection axisDirection = Types.forCodeName(AxisDirection.class, element3.keyword, true);
        Element element4 = element2.pullElement(1, "Meridian");
        if (element4 != null) {
            double d = element4.pullDouble("meridian");
            Unit<Angle> unit3 = this.parseScaledUnit(element4, "AngleUnit", Units.RADIAN);
            element4.close(this.ignoredElements);
            if (unit3 != null) {
                d = unit3.getConverterTo(Units.DEGREE).convert(d);
            }
            axisDirection = CoordinateSystems.directionAlongMeridian(axisDirection, d);
        }
        if ((n3 = string3.length() - 1) > 1 && string3.charAt(n3) == ')' && (n2 = string3.lastIndexOf(40, n3 - 1)) >= 0) {
            int n4 = n3;
            while (--n4 >= 0 && string3.charAt(n4) == ')') {
                int n5 = string3.lastIndexOf(40, n2 - 1);
                if (n5 < 0) {
                    this.warning(element, element2, Errors.formatInternational((short)101, Character.valueOf('('), string3), null);
                    break;
                }
                n2 = n5;
            }
            string2 = CharSequences.trimWhitespaces(string3.substring(n2 + 1, n3));
            if ((string3 = CharSequences.trimWhitespaces(string3.substring(0, n2))).isEmpty()) {
                string3 = string2;
            }
        } else {
            string2 = AxisDirections.suggestAbbreviation(string3, axisDirection, unit2);
        }
        string3 = this.transliterator.toLongAxisName(string, axisDirection, string3);
        string2 = this.transliterator.toUnicodeAbbreviation(string, axisDirection, string2);
        Element element5 = element2.pullElement(1, "Order");
        Integer n6 = null;
        if (element5 != null) {
            n6 = element5.pullInteger("order");
            element5.close(this.ignoredElements);
        }
        CSFactory cSFactory = this.factories.getCSFactory();
        try {
            coordinateSystemAxis = cSFactory.createCoordinateSystemAxis(this.parseMetadataAndClose(element2, string3, null), string2, axisDirection, unit2);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
        if (this.axisOrder.put(coordinateSystemAxis, n6) != null) {
            throw new UnparsableObjectException(this.errorLocale, 24, new Object[]{Strings.bracket("Axis", (Object)string3)}, element2.offset);
        }
        return coordinateSystemAxis;
    }

    @Override
    public final int compare(CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) {
        Integer n = this.axisOrder.get(coordinateSystemAxis);
        Integer n2 = this.axisOrder.get(coordinateSystemAxis2);
        if (n != null) {
            if (n2 != null) {
                return n - n2;
            }
            return -1;
        }
        if (n2 != null) {
            return 1;
        }
        return 0;
    }

    private PrimeMeridian parsePrimeMeridian(int n, Element element, boolean bl, Unit<Angle> unit) throws ParseException {
        Element element2;
        if (bl && this.usesCommonUnits) {
            unit = Units.DEGREE;
        }
        if ((element2 = element.pullElement(n, "PrimeMeridian", "PrimeM")) == null) {
            return null;
        }
        String string = element2.pullString("name");
        double d = element2.pullDouble("longitude");
        Unit<Angle> unit2 = this.parseScaledUnit(element2, "AngleUnit", Units.RADIAN);
        if (unit2 != null) {
            unit = unit2;
        } else if (unit == null) {
            throw element.missingComponent("AngleUnit");
        }
        DatumFactory datumFactory = this.factories.getDatumFactory();
        try {
            return datumFactory.createPrimeMeridian(this.parseMetadataAndClose(element2, string, null), d, unit);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private Object parseToWGS84(int n, Element element) throws ParseException {
        Element element2 = element.pullElement(n, "ToWGS84");
        if (element2 == null) {
            return null;
        }
        double[] dArray = new double[ToWGS84.length];
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = element2.pullDouble(ToWGS84[n2]);
            if (++n2 % 3 != 0 || !element2.isEmpty()) continue;
        }
        element2.close(this.ignoredElements);
        BursaWolfParameters bursaWolfParameters = new BursaWolfParameters(CommonCRS.WGS84.datum(), null);
        bursaWolfParameters.setValues(dArray);
        return bursaWolfParameters;
    }

    private Ellipsoid parseEllipsoid(int n, Element element) throws ParseException {
        Element element2 = element.pullElement(n, "Ellipsoid", "Spheroid");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        double d = element2.pullDouble("semiMajorAxis");
        double d2 = element2.pullDouble("inverseFlattening");
        Unit<Length> unit = this.parseScaledUnit(element2, "LengthUnit", Units.METRE);
        if (unit == null) {
            unit = Units.METRE;
        }
        Map<String, Object> map = this.parseMetadataAndClose(element2, string, null);
        DatumFactory datumFactory = this.factories.getDatumFactory();
        try {
            if (d2 == 0.0) {
                return datumFactory.createEllipsoid(map, d, d, unit);
            }
            return datumFactory.createFlattenedSphere(map, d, d2, unit);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private SingleCRS parseBaseCRS(int n, Element element, OperationMethod operationMethod) throws ParseException {
        int n2 = 2;
        String string = "ellipsoidal";
        if (operationMethod != null) {
            Integer n3 = operationMethod.getSourceDimensions();
            if (n3 != null) {
                n2 = n3;
            }
            if (operationMethod instanceof AbstractProvider && (string = WKTUtilities.toType(CoordinateSystem.class, ((AbstractProvider)operationMethod).sourceCSType)) == null) {
                string = "ellipsoidal";
            }
        }
        return this.parseGeodeticCRS(n, element, n2, string);
    }

    private OperationMethod parseMethod(Element element, String ... stringArray) throws ParseException {
        Element element2 = element.pullElement(2, stringArray);
        String string = element2.pullString("method");
        Map<String, Object> map = this.parseMetadataAndClose(element2, string, null);
        Identifier identifier = GeodeticObjectParser.toIdentifier(map.remove("identifiers"));
        FactoryException factoryException = null;
        DefaultCoordinateOperationFactory defaultCoordinateOperationFactory = this.factories.getCoordinateOperationFactory();
        MathTransformFactory mathTransformFactory = this.factories.getMathTransformFactory();
        if (identifier instanceof ReferenceIdentifier) {
            try {
                return ServicesForMetadata.getOperationMethod(defaultCoordinateOperationFactory, mathTransformFactory, ((ReferenceIdentifier)identifier).getCodeSpace() + ':' + identifier.getCode());
            }
            catch (FactoryException factoryException2) {
                factoryException = factoryException2;
            }
        }
        try {
            return ServicesForMetadata.getOperationMethod(defaultCoordinateOperationFactory, mathTransformFactory, string);
        }
        catch (FactoryException factoryException3) {
            if (factoryException != null) {
                factoryException3.addSuppressed(factoryException);
            }
            throw element2.parseFailed(factoryException3);
        }
    }

    private Conversion parseDerivingConversion(int n, Element element, String string, Unit<?> unit, Unit<Angle> unit2) throws ParseException {
        String string2;
        if (string == null) {
            string2 = null;
        } else {
            if ((element = element.pullElement(n, string)) == null) {
                return null;
            }
            string2 = element.pullString("name");
        }
        OperationMethod operationMethod = this.parseMethod(element, "Method", "Projection");
        Map<String, Object> map = this.properties;
        ParameterValueGroup parameterValueGroup = operationMethod.getParameters().createValue();
        this.parseParameters(element, parameterValueGroup, unit, unit2);
        if (string != null) {
            map = this.parseMetadataAndClose(element, string2, operationMethod);
        }
        DefaultCoordinateOperationFactory defaultCoordinateOperationFactory = this.factories.getCoordinateOperationFactory();
        try {
            return defaultCoordinateOperationFactory.createDefiningConversion(map, operationMethod, parameterValueGroup);
        }
        catch (FactoryException factoryException) {
            throw element.parseFailed(factoryException);
        }
    }

    private GeodeticDatum parseDatum(int n, Element element, PrimeMeridian primeMeridian) throws ParseException {
        Element element2 = element.pullElement(n, "Datum", "GeodeticDatum");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        Ellipsoid ellipsoid = this.parseEllipsoid(2, element2);
        Object object = this.parseToWGS84(1, element2);
        Map<String, Object> map = this.parseAnchorAndClose(element2, string);
        if (primeMeridian == null) {
            primeMeridian = CommonCRS.WGS84.primeMeridian();
        }
        if (object != null) {
            map.put("bursaWolf", object);
        }
        DatumFactory datumFactory = this.factories.getDatumFactory();
        try {
            return datumFactory.createGeodeticDatum(map, ellipsoid, primeMeridian);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private VerticalDatum parseVerticalDatum(int n, Element element, boolean bl) throws ParseException {
        Element element2 = element.pullElement(n, "VerticalDatum", "VDatum", "Vert_Datum");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        VerticalDatumType verticalDatumType = null;
        if (bl) {
            verticalDatumType = VerticalDatumTypes.fromLegacy(element2.pullInteger("datum"));
        }
        if (verticalDatumType == null) {
            verticalDatumType = VerticalDatumTypes.guess(string, null, null);
        }
        DatumFactory datumFactory = this.factories.getDatumFactory();
        try {
            return datumFactory.createVerticalDatum(this.parseAnchorAndClose(element2, string), verticalDatumType);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private TemporalDatum parseTimeDatum(int n, Element element) throws ParseException {
        Element element2 = element.pullElement(n, "TimeDatum", "TDatum");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        Element element3 = element2.pullElement(2, "TimeOrigin");
        Date date = element3.pullDate("origin");
        element3.close(this.ignoredElements);
        DatumFactory datumFactory = this.factories.getDatumFactory();
        try {
            return datumFactory.createTemporalDatum(this.parseAnchorAndClose(element2, string), date);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private Datum parseParametricDatum(int n, Element element) throws ParseException {
        Element element2 = element.pullElement(n, "ParametricDatum", "PDatum");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        DatumFactory datumFactory = this.factories.getDatumFactory();
        try {
            return ServicesForMetadata.createParametricDatum(this.parseAnchorAndClose(element2, string), datumFactory);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private EngineeringDatum parseEngineeringDatum(int n, Element element, boolean bl) throws ParseException {
        Element element2 = element.pullElement(n, "EngineeringDatum", "EDatum", "Local_Datum");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        if (bl) {
            element2.pullInteger("datum");
        }
        DatumFactory datumFactory = this.factories.getDatumFactory();
        try {
            return datumFactory.createEngineeringDatum(this.parseAnchorAndClose(element2, string));
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private ImageDatum parseImageDatum(int n, Element element) throws ParseException {
        Element element2 = element.pullElement(n, "ImageDatum", "IDatum");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        PixelInCell pixelInCell = Types.forCodeName(PixelInCell.class, element2.pullVoidElement((String)"pixelInCell").keyword, true);
        DatumFactory datumFactory = this.factories.getDatumFactory();
        try {
            return datumFactory.createImageDatum(this.parseAnchorAndClose(element2, string), pixelInCell);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private SingleCRS parseEngineeringCRS(int n, Element element, boolean bl) throws ParseException {
        String[] stringArray;
        if (bl) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "BaseEngCRS";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "EngineeringCRS";
            stringArray3[1] = "EngCRS";
            stringArray = stringArray3;
            stringArray3[2] = "Local_CS";
        }
        Element element2 = element.pullElement(n, stringArray);
        if (element2 == null) {
            return null;
        }
        boolean bl2 = element2.getKeywordIndex() == 2;
        String string = element2.pullString("name");
        Unit<?> unit = this.parseUnit(element2);
        EngineeringDatum engineeringDatum = null;
        SingleCRS singleCRS = null;
        Conversion conversion = null;
        if (!bl2 && !bl && (conversion = this.parseDerivingConversion(1, element2, "DerivingConversion", unit, null)) != null && (singleCRS = this.parseEngineeringCRS(1, element2, true)) == null && (singleCRS = this.parseBaseCRS(1, element2, conversion.getMethod())) == null) {
            singleCRS = this.parseProjectedCRS(2, element2, true);
        }
        if (singleCRS == null) {
            engineeringDatum = this.parseEngineeringDatum(2, element2, bl2);
        }
        CRSFactory cRSFactory = this.factories.getCRSFactory();
        try {
            CoordinateSystem coordinateSystem = this.parseCoordinateSystem(element2, null, 1, bl2, unit, engineeringDatum);
            Map<String, Object> map = this.parseMetadataAndClose(element2, string, engineeringDatum);
            if (singleCRS != null) {
                return cRSFactory.createDerivedCRS(map, singleCRS, conversion, coordinateSystem);
            }
            return cRSFactory.createEngineeringCRS(map, engineeringDatum, coordinateSystem);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private ImageCRS parseImageCRS(int n, Element element) throws ParseException {
        CoordinateSystem coordinateSystem;
        Element element2 = element.pullElement(n, "ImageCRS");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        ImageDatum imageDatum = this.parseImageDatum(2, element2);
        Unit<?> unit = this.parseUnit(element2);
        try {
            coordinateSystem = this.parseCoordinateSystem(element2, "Cartesian", 2, false, unit, imageDatum);
            Map<String, Object> map = this.parseMetadataAndClose(element2, string, imageDatum);
            if (coordinateSystem instanceof AffineCS) {
                return this.factories.getCRSFactory().createImageCRS(map, imageDatum, (AffineCS)coordinateSystem);
            }
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
        throw element2.illegalCS(coordinateSystem);
    }

    private SingleCRS parseGeodeticCRS(int n, Element element, int n2, String string) throws ParseException {
        CoordinateSystem coordinateSystem;
        Unit<Angle> unit;
        Unit<Object> unit2;
        boolean bl;
        String[] stringArray;
        if (string != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "BaseGeodCRS";
            stringArray = stringArray2;
            stringArray2[1] = "GeogCS";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "GeodeticCRS";
            stringArray3[1] = "GeogCS";
            stringArray3[2] = "GeodCRS";
            stringArray = stringArray3;
            stringArray3[3] = "GeocCS";
        }
        Element element2 = element.pullElement(n, stringArray);
        if (element2 == null) {
            return null;
        }
        switch (element2.getKeywordIndex()) {
            default: {
                bl = false;
                unit2 = this.parseUnit(element2);
                if (Units.isAngular(unit2)) {
                    unit = unit2.asType(Angle.class);
                    break;
                }
                unit = Units.DEGREE;
                if (unit2 != null || string == null) break;
                switch (string) {
                    case "ellipsoidal": {
                        unit2 = Units.DEGREE;
                        break;
                    }
                    case "Cartesian": {
                        unit2 = Units.METRE;
                    }
                }
                break;
            }
            case 1: {
                bl = true;
                string = "ellipsoidal";
                unit = this.parseScaledUnit(element2, "AngleUnit", Units.RADIAN);
                unit2 = unit;
                n2 = 2;
                break;
            }
            case 3: {
                bl = true;
                string = "Cartesian";
                unit = Units.DEGREE;
                unit2 = this.parseScaledUnit(element2, "LengthUnit", Units.METRE);
                n2 = 3;
            }
        }
        String string2 = element2.pullString("name");
        SingleCRS singleCRS = null;
        Conversion conversion = null;
        if (!bl && string == null && (conversion = this.parseDerivingConversion(1, element2, "DerivingConversion", unit2, unit)) != null) {
            singleCRS = this.parseBaseCRS(2, element2, conversion.getMethod());
        }
        CRSFactory cRSFactory = this.factories.getCRSFactory();
        try {
            coordinateSystem = this.parseCoordinateSystem(element2, string, n2, bl, unit2, null);
            if (singleCRS != null) {
                Map<String, Object> map = this.parseMetadataAndClose(element2, string2, null);
                return cRSFactory.createDerivedCRS(map, singleCRS, conversion, coordinateSystem);
            }
            Unit<Angle> unit3 = AxisDirections.getAngularUnit(coordinateSystem, unit);
            if (unit != null && !unit.equals(unit3)) {
                this.warning(element2, "AngleUnit", Errors.formatInternational((short)70, unit), null);
            }
            PrimeMeridian primeMeridian = this.parsePrimeMeridian(1, element2, bl, unit3);
            GeodeticDatum geodeticDatum = this.parseDatum(2, element2, primeMeridian);
            Map<String, Object> map = this.parseMetadataAndClose(element2, string2, geodeticDatum);
            if (coordinateSystem instanceof EllipsoidalCS) {
                return cRSFactory.createGeographicCRS(map, geodeticDatum, (EllipsoidalCS)coordinateSystem);
            }
            if (coordinateSystem instanceof CartesianCS) {
                return cRSFactory.createGeocentricCRS(map, geodeticDatum, Legacy.forGeocentricCRS((CartesianCS)coordinateSystem, false));
            }
            if (coordinateSystem instanceof SphericalCS) {
                return cRSFactory.createGeocentricCRS(map, geodeticDatum, (SphericalCS)coordinateSystem);
            }
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
        throw element2.illegalCS(coordinateSystem);
    }

    private SingleCRS parseVerticalCRS(int n, Element element, boolean bl) throws ParseException {
        CoordinateSystem coordinateSystem;
        String[] stringArray;
        if (bl) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "BaseVertCRS";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "VerticalCRS";
            stringArray3[1] = "VertCRS";
            stringArray = stringArray3;
            stringArray3[2] = "Vert_CS";
        }
        Element element2 = element.pullElement(n, stringArray);
        if (element2 == null) {
            return null;
        }
        boolean bl2 = element2.getKeywordIndex() == 2;
        String string = element2.pullString("name");
        Unit<?> unit = this.parseUnit(element2);
        VerticalDatum verticalDatum = null;
        SingleCRS singleCRS = null;
        Conversion conversion = null;
        if (!bl2 && !bl && (conversion = this.parseDerivingConversion(1, element2, "DerivingConversion", unit, null)) != null) {
            singleCRS = this.parseVerticalCRS(2, element2, true);
        }
        if (singleCRS == null) {
            verticalDatum = this.parseVerticalDatum(2, element2, bl2);
        }
        try {
            coordinateSystem = this.parseCoordinateSystem(element2, "vertical", 1, bl2, unit, verticalDatum);
            Map<String, Object> map = this.parseMetadataAndClose(element2, string, verticalDatum);
            if (coordinateSystem instanceof VerticalCS) {
                VerticalDatumType verticalDatumType;
                CRSFactory cRSFactory = this.factories.getCRSFactory();
                if (singleCRS != null) {
                    return cRSFactory.createDerivedCRS(map, singleCRS, conversion, coordinateSystem);
                }
                if (VerticalDatumType.OTHER_SURFACE.equals(verticalDatum.getVerticalDatumType()) && !VerticalDatumType.OTHER_SURFACE.equals(verticalDatumType = VerticalDatumTypes.guess(verticalDatum.getName().getCode(), verticalDatum.getAlias(), coordinateSystem.getAxis(0)))) {
                    DatumFactory datumFactory = this.factories.getDatumFactory();
                    verticalDatum = datumFactory.createVerticalDatum(IdentifiedObjects.getProperties(verticalDatum, new String[0]), verticalDatumType);
                }
                this.verticalCRS = cRSFactory.createVerticalCRS(map, verticalDatum, (VerticalCS)coordinateSystem);
                if (this.verticalElements != null) {
                    this.verticalElements = this.verticalElements.resolve(this.verticalCRS);
                }
                return this.verticalCRS;
            }
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
        throw element2.illegalCS(coordinateSystem);
    }

    private SingleCRS parseTimeCRS(int n, Element element, boolean bl) throws ParseException {
        CoordinateSystem coordinateSystem;
        Element element2 = element.pullElement(n, bl ? "BaseTimeCRS" : "TimeCRS");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        Unit<Time> unit = this.parseScaledUnit(element2, "TimeUnit", Units.SECOND);
        TemporalDatum temporalDatum = null;
        SingleCRS singleCRS = null;
        Conversion conversion = null;
        if (!bl && (conversion = this.parseDerivingConversion(1, element2, "DerivingConversion", unit, null)) != null) {
            singleCRS = this.parseTimeCRS(2, element2, true);
        }
        if (singleCRS == null) {
            temporalDatum = this.parseTimeDatum(2, element2);
        }
        try {
            coordinateSystem = this.parseCoordinateSystem(element2, "temporal", 1, false, unit, temporalDatum);
            Map<String, Object> map = this.parseMetadataAndClose(element2, string, temporalDatum);
            if (coordinateSystem instanceof TimeCS) {
                CRSFactory cRSFactory = this.factories.getCRSFactory();
                if (singleCRS != null) {
                    return cRSFactory.createDerivedCRS(map, singleCRS, conversion, coordinateSystem);
                }
                return cRSFactory.createTemporalCRS(map, temporalDatum, (TimeCS)coordinateSystem);
            }
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
        throw element2.illegalCS(coordinateSystem);
    }

    private SingleCRS parseParametricCRS(int n, Element element, boolean bl) throws ParseException {
        CoordinateSystem coordinateSystem;
        Element element2 = element.pullElement(n, bl ? "BaseParamCRS" : "ParametricCRS");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        Unit<?> unit = this.parseUnit(element2);
        Datum datum = null;
        SingleCRS singleCRS = null;
        Conversion conversion = null;
        if (!bl && (conversion = this.parseDerivingConversion(1, element2, "DerivingConversion", unit, null)) != null) {
            singleCRS = this.parseParametricCRS(2, element2, true);
        }
        if (singleCRS == null) {
            datum = this.parseParametricDatum(2, element2);
        }
        try {
            coordinateSystem = this.parseCoordinateSystem(element2, "parametric", 1, false, unit, datum);
            Map<String, Object> map = this.parseMetadataAndClose(element2, string, datum);
            if (coordinateSystem != null) {
                CRSFactory cRSFactory = this.factories.getCRSFactory();
                if (singleCRS != null) {
                    return cRSFactory.createDerivedCRS(map, singleCRS, conversion, coordinateSystem);
                }
                return ServicesForMetadata.createParametricCRS(map, datum, coordinateSystem, cRSFactory);
            }
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
        throw element2.illegalCS(coordinateSystem);
    }

    private ProjectedCRS parseProjectedCRS(int n, Element element, boolean bl) throws ParseException {
        CoordinateSystem coordinateSystem;
        Unit<Angle> unit;
        Unit<Length> unit2;
        String[] stringArray;
        if (bl) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "BaseProjCRS";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "ProjectedCRS";
            stringArray3[1] = "ProjCRS";
            stringArray = stringArray3;
            stringArray3[2] = "ProjCS";
        }
        Element element2 = element.pullElement(n, stringArray);
        if (element2 == null) {
            return null;
        }
        boolean bl2 = element2.getKeywordIndex() == 2;
        String string = element2.pullString("name");
        SingleCRS singleCRS = this.parseGeodeticCRS(2, element2, 2, "ellipsoidal");
        if (!(singleCRS instanceof GeographicCRS)) {
            throw new UnparsableObjectException(this.errorLocale, 47, new Object[]{singleCRS.getClass()}, element2.offset);
        }
        Unit<Length> unit3 = this.parseScaledUnit(element2, "LengthUnit", Units.METRE);
        if (bl2 && this.usesCommonUnits) {
            unit2 = Units.METRE;
            unit = Units.DEGREE;
        } else {
            unit2 = unit3;
            unit = AxisDirections.getAngularUnit(singleCRS.getCoordinateSystem(), Units.DEGREE);
        }
        Conversion conversion = this.parseDerivingConversion(2, element2, bl2 ? null : "Conversion", unit2, unit);
        if (unit3 == null && bl) {
            unit3 = Units.METRE;
        }
        try {
            coordinateSystem = this.parseCoordinateSystem(element2, "Cartesian", 2, bl2, unit3, singleCRS.getDatum());
            Map<String, Object> map = this.parseMetadataAndClose(element2, string, conversion);
            if (coordinateSystem instanceof CartesianCS) {
                CRSFactory cRSFactory = this.factories.getCRSFactory();
                return cRSFactory.createProjectedCRS(map, (GeographicCRS)singleCRS, conversion, (CartesianCS)coordinateSystem);
            }
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
        throw element2.illegalCS(coordinateSystem);
    }

    private CoordinateReferenceSystem parseCompoundCRS(int n, Element element) throws ParseException {
        CoordinateReferenceSystem coordinateReferenceSystem;
        Element element2 = element.pullElement(n, "CompoundCRS", "Compd_CS");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        ArrayList<CoordinateReferenceSystem> arrayList = new ArrayList<CoordinateReferenceSystem>(4);
        while ((coordinateReferenceSystem = this.parseCoordinateReferenceSystem(element2, arrayList.size() < 2)) != null) {
            arrayList.add(coordinateReferenceSystem);
        }
        try {
            return new EllipsoidalHeightCombiner(this.factories).createCompoundCRS(this.parseMetadataAndClose(element2, string, null), arrayList.toArray(new CoordinateReferenceSystem[arrayList.size()]));
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private DerivedCRS parseFittedCS(int n, Element element) throws ParseException {
        Element element2 = element.pullElement(n, "Fitted_CS");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        MathTransform mathTransform = this.parseMathTransform(element2, true);
        OperationMethod operationMethod = this.getOperationMethod();
        CoordinateReferenceSystem coordinateReferenceSystem = this.parseCoordinateReferenceSystem(element2, true);
        if (!(coordinateReferenceSystem instanceof SingleCRS)) {
            throw new UnparsableObjectException(this.errorLocale, 144, new Object[]{"Fitted_CS", coordinateReferenceSystem.getClass()}, element2.offset);
        }
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[mathTransform.getSourceDimensions()];
        StringBuilder stringBuilder = new StringBuilder(string).append(" axis ");
        int n2 = stringBuilder.length();
        CSFactory cSFactory = this.factories.getCSFactory();
        try {
            Object object;
            for (int i = 0; i < coordinateSystemAxisArray.length; ++i) {
                object = String.valueOf(i);
                stringBuilder.setLength(n2);
                stringBuilder.append((String)object);
                coordinateSystemAxisArray[i] = cSFactory.createCoordinateSystemAxis(Collections.singletonMap("name", stringBuilder.toString()), (String)object, AxisDirection.OTHER, Units.UNITY);
            }
            Map<String, Object> map = this.parseMetadataAndClose(element2, string, coordinateReferenceSystem);
            object = new AbstractCS(Collections.singletonMap("name", AxisDirections.appendTo(new StringBuilder("CS"), coordinateSystemAxisArray)), coordinateSystemAxisArray);
            map.put("conversion.name", string);
            return DefaultDerivedCRS.create(map, (SingleCRS)coordinateReferenceSystem, null, operationMethod, mathTransform.inverse(), (CoordinateSystem)object);
        }
        catch (NoninvertibleTransformException | FactoryException exception) {
            throw element2.parseFailed(exception);
        }
    }

    private CoordinateOperation parseGeogTranslation(int n, Element element) throws ParseException {
        Element element2 = element.pullElement(n, "GeogTran");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        SingleCRS singleCRS = this.parseGeodeticCRS(2, element2, 2, null);
        SingleCRS singleCRS2 = this.parseGeodeticCRS(2, element2, 2, null);
        OperationMethod operationMethod = this.parseMethod(element2, "Method");
        Map<String, Object> map = this.parseParametersAndClose(element2, string, operationMethod);
        try {
            DefaultCoordinateOperationFactory defaultCoordinateOperationFactory = this.getOperationFactory();
            return defaultCoordinateOperationFactory.createSingleOperation(map, singleCRS, singleCRS2, null, operationMethod, null);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private CoordinateOperation parseOperation(int n, Element element) throws ParseException {
        Element element2 = element.pullElement(n, "CoordinateOperation");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        CoordinateReferenceSystem coordinateReferenceSystem = this.parseCoordinateReferenceSystem(element2, 2, "SourceCRS");
        CoordinateReferenceSystem coordinateReferenceSystem2 = this.parseCoordinateReferenceSystem(element2, 2, "TargetCRS");
        CoordinateReferenceSystem coordinateReferenceSystem3 = this.parseCoordinateReferenceSystem(element2, 1, "InterpolationCRS");
        OperationMethod operationMethod = this.parseMethod(element2, "Method");
        Element element3 = element2.pullElement(1, "OperationAccuracy");
        Map<String, Object> map = this.parseParametersAndClose(element2, string, operationMethod);
        if (element3 != null) {
            map.put("coordinateOperationAccuracy", TransformationAccuracy.create(element3.pullDouble("accuracy")));
            element3.close(this.ignoredElements);
        }
        try {
            DefaultCoordinateOperationFactory defaultCoordinateOperationFactory = this.getOperationFactory();
            return defaultCoordinateOperationFactory.createSingleOperation(map, coordinateReferenceSystem, coordinateReferenceSystem2, coordinateReferenceSystem3, operationMethod, null);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private Map<String, Object> parseParametersAndClose(Element element, String string, OperationMethod operationMethod) throws ParseException {
        ParameterValueGroup parameterValueGroup = operationMethod.getParameters().createValue();
        this.parseParameters(element, parameterValueGroup, null, null);
        Map<String, Object> map = this.parseMetadataAndClose(element, string, operationMethod);
        map.put("parameters", parameterValueGroup);
        return map;
    }

    private DefaultCoordinateOperationFactory getOperationFactory() {
        DefaultCoordinateOperationFactory defaultCoordinateOperationFactory = this.factories.getCoordinateOperationFactory();
        if (defaultCoordinateOperationFactory instanceof DefaultCoordinateOperationFactory) {
            return defaultCoordinateOperationFactory;
        }
        return CoordinateOperations.factory();
    }
}

