/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.esri;

import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.image.DataType;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.internal.storage.PRJDataStore;
import org.apache.sis.internal.storage.RangeArgument;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.esri.RasterStore;
import org.apache.sis.internal.storage.esri.RawRasterLayout;
import org.apache.sis.internal.storage.esri.RawRasterReader;
import org.apache.sis.internal.storage.esri.RawRasterStoreProvider;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.Statistics;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.datum.PixelInCell;

final class RawRasterStore
extends RasterStore {
    private static final String NBANDS = "NBANDS";
    private static final String NBITS = "NBITS";
    private static final String PIXELTYPE = "PIXELTYPE";
    private static final String BYTEORDER = "BYTEORDER";
    private static final String LAYOUT = "LAYOUT";
    private static final String SKIPBYTES = "SKIPBYTES";
    private static final String BANDROWBYTES = "BANDROWBYTES";
    private static final String TOTALROWBYTES = "TOTALROWBYTES";
    private static final String BANDGAPBYTES = "BANDGAPBYTES";
    private static final String ULXMAP = "ULXMAP";
    private static final String ULYMAP = "ULYMAP";
    static final String XDIM = "XDIM";
    static final String YDIM = "YDIM";
    private static final String NODATA = "NODATA";
    private static final PixelInCell CELL_ANCHOR = PixelInCell.CELL_CENTER;
    private ChannelDataInput input;
    private RawRasterReader reader;

    RawRasterStore(RawRasterStoreProvider rawRasterStoreProvider, StorageConnector storageConnector) throws DataStoreException {
        super(rawRasterStoreProvider, storageConnector);
        this.input = storageConnector.commit(ChannelDataInput.class, "BIL/BIP/BSQ");
    }

    @Override
    public Path[] getComponentFiles() throws DataStoreException {
        return this.listComponentFiles("hdr", "prj", "stx", "clr");
    }

    @Override
    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            this.getSampleDimensions();
            this.createMetadata("BIL/BIP/BSQ", "RAWGRD");
        }
        return this.metadata;
    }

    @Override
    public synchronized GridGeometry getGridGeometry() throws DataStoreException {
        if (this.reader == null) {
            try {
                this.readHeader();
            }
            catch (IOException iOException) {
                throw new DataStoreException(this.canNotRead(), iOException);
            }
            catch (RuntimeException runtimeException) {
                throw new DataStoreContentException(this.canNotRead(), runtimeException);
            }
        }
        return this.reader.gridGeometry;
    }

    @Override
    public synchronized List<SampleDimension> getSampleDimensions() throws DataStoreException {
        List<SampleDimension> list = super.getSampleDimensions();
        if (list == null) {
            try {
                if (this.reader == null) {
                    this.readHeader();
                }
                this.loadBandDescriptions(this.input.filename, this.reader.layout, new Statistics[0]);
                list = super.getSampleDimensions();
            }
            catch (IOException iOException) {
                throw new DataStoreException(this.canNotRead(), iOException);
            }
            catch (RuntimeException runtimeException) {
                throw new DataStoreContentException(this.canNotRead(), runtimeException);
            }
        }
        return list;
    }

    private Errors errors() {
        return Errors.getResources(this.getLocale());
    }

    private DataStoreContentException missingProperty(PRJDataStore.AuxiliaryContent auxiliaryContent, String string) {
        return new DataStoreContentException(this.errors().getString((short)197, auxiliaryContent.getFilename(), string));
    }

    private void ignoredProperty(String string, int n) {
        if (n != 0) {
            this.listeners.warning(Messages.getResources(this.getLocale()).getString((short)35, string));
        }
    }

    private int indexOf(String string, String string2, String ... stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.equalsIgnoreCase(stringArray[i])) continue;
            return i;
        }
        this.listeners.warning(this.errors().getString((short)198, string, string2));
        return -1;
    }

    private int parseStrictlyPositive(String string, String string2) throws DataStoreContentException {
        int n = Integer.parseInt(string2);
        if (n > 0) {
            return n;
        }
        throw new DataStoreContentException(this.errors().getString((short)165, string, string2));
    }

    /*
     * WARNING - void declaration
     */
    private void readHeader() throws IOException, DataStoreException {
        void var26_31;
        int n;
        int n2;
        int n3;
        assert (Thread.holdsLock(this));
        if (this.input == null) {
            throw new DataStoreClosedException(this.canNotRead());
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        int n7 = 8;
        boolean bl = false;
        long l = 0L;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        double d4 = 1.0;
        int n11 = 0;
        RawRasterLayout rawRasterLayout = RawRasterLayout.BIL;
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        PRJDataStore.AuxiliaryContent auxiliaryContent = this.readAuxiliaryFile("hdr");
        if (auxiliaryContent == null) {
            throw new DataStoreException(Resources.forLocale(this.getLocale()).getString((short)66, "hdr"));
        }
        for (CharSequence object2 : CharSequences.splitOnEOL(auxiliaryContent)) {
            int n12;
            n3 = object2.length();
            n2 = CharSequences.skipLeadingWhitespaces(object2, 0, n3);
            int n13 = CharSequences.indexOf(object2, 32, n2, n3);
            if (n2 < 0 || (n = CharSequences.indexOf(object2, 32, n12 = CharSequences.skipLeadingWhitespaces(object2, n13, n3), n3)) < 0 && (n = CharSequences.skipTrailingWhitespaces(object2, n12, n3)) <= n12) continue;
            String string = object2.subSequence(n2, n13).toString();
            String string2 = object2.subSequence(n12, n).toString();
            try {
                block19 : switch (string.toUpperCase(Locale.US)) {
                    case "NROWS": {
                        n4 = this.parseStrictlyPositive(string, string2);
                        break;
                    }
                    case "NCOLS": {
                        n5 = this.parseStrictlyPositive(string, string2);
                        break;
                    }
                    case "NBANDS": {
                        n6 = this.parseStrictlyPositive(string, string2);
                        break;
                    }
                    case "NBITS": {
                        n7 = this.parseStrictlyPositive(string, string2);
                        break;
                    }
                    case "BANDROWBYTES": {
                        n8 = this.parseStrictlyPositive(string, string2);
                        break;
                    }
                    case "TOTALROWBYTES": {
                        n9 = this.parseStrictlyPositive(string, string2);
                        break;
                    }
                    case "BANDGAPBYTES": {
                        n10 = Integer.parseInt(string2);
                        break;
                    }
                    case "SKIPBYTES": {
                        l = Long.parseLong(string2);
                        break;
                    }
                    case "ULXMAP": {
                        d = Double.parseDouble(string2);
                        n11 |= 1;
                        break;
                    }
                    case "ULYMAP": {
                        d2 = Double.parseDouble(string2);
                        n11 |= 2;
                        break;
                    }
                    case "XDIM": {
                        d3 = Double.parseDouble(string2);
                        n11 |= 4;
                        break;
                    }
                    case "YDIM": {
                        d4 = Double.parseDouble(string2);
                        n11 |= 8;
                        break;
                    }
                    case "NODATA": {
                        this.nodataValue = Double.parseDouble(string2);
                        break;
                    }
                    case "PIXELTYPE": {
                        bl = this.indexOf(string, string2, "SIGNED", "SIGNEDINT") >= 0;
                        break;
                    }
                    case "LAYOUT": {
                        rawRasterLayout = RawRasterLayout.valueOf(string2.toUpperCase(Locale.US));
                        break;
                    }
                    case "BYTEORDER": {
                        switch (this.indexOf(string, string2, "I", "M")) {
                            case 0: {
                                byteOrder = ByteOrder.LITTLE_ENDIAN;
                                break block19;
                            }
                            case 1: {
                                byteOrder = ByteOrder.BIG_ENDIAN;
                                break block19;
                            }
                        }
                        throw new DataStoreContentException(this.errors().getString((short)198, string, string2));
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DataStoreContentException(this.errors().getString((short)198, string, string2), illegalArgumentException);
            }
        }
        this.input.buffer.order(byteOrder);
        if (n4 == 0 || n5 == 0) {
            throw this.missingProperty(auxiliaryContent, n4 == 0 ? "NROWS" : "NCOLS");
        }
        int n14 = DataType.forNumberOfBits(n7, false, bl).toDataBufferType();
        int n15 = DataBuffer.getDataTypeSize(n14) / 8;
        switch (n11) {
            case 0: {
                d2 = n5 - 1;
                break;
            }
            case 3: {
                break;
            }
            case 15: {
                break;
            }
            default: {
                String string;
                switch (Integer.lowestOneBit(~n11)) {
                    case 1: {
                        string = ULXMAP;
                        break;
                    }
                    case 2: {
                        string = ULYMAP;
                        break;
                    }
                    case 4: {
                        string = XDIM;
                        break;
                    }
                    case 8: {
                        string = YDIM;
                        break;
                    }
                    default: {
                        string = "?";
                    }
                }
                throw this.missingProperty(auxiliaryContent, string);
            }
        }
        this.readPRJ();
        GridGeometry gridGeometry = new GridGeometry(new GridExtent((long)n5, n4), CELL_ANCHOR, new AffineTransform2D(d3, 0.0, 0.0, -d4, d, d2), this.crs);
        Object var26_25 = null;
        switch (rawRasterLayout) {
            case BIL: {
                this.ignoredProperty(BANDGAPBYTES, n10);
                if (n8 == 0) {
                    n8 = Numerics.ceilDiv(Math.multiplyExact(n5, n7), 8);
                }
                if (n9 == 0) {
                    n9 = Math.multiplyExact(n6, n8);
                }
                if (n15 == 0) break;
                n3 = Numerics.wholeDiv(n8, n15);
                n2 = Numerics.wholeDiv(n9, n15);
                int[] nArray = new int[n6];
                int[] nArray2 = new int[n6];
                for (n = 1; n < n6; ++n) {
                    nArray2[n] = Math.multiplyExact(n3, n);
                }
                ComponentSampleModel componentSampleModel = new ComponentSampleModel(n14, n5, n4, 1, n2, nArray, nArray2);
                break;
            }
            case BIP: {
                this.ignoredProperty(BANDGAPBYTES, n10);
                this.ignoredProperty(BANDROWBYTES, n8);
                if (n9 == 0) {
                    n9 = Numerics.ceilDiv(Math.multiplyExact(Math.multiplyExact(n5, n6), n7), 8);
                }
                if (n15 == 0) break;
                n3 = Numerics.wholeDiv(n9, n15);
                int[] nArray = ArraysExt.range(0, n6);
                PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(n14, n5, n4, n6, n3, nArray);
                break;
            }
            case BSQ: {
                this.ignoredProperty(BANDROWBYTES, n8);
                if (n9 == 0) {
                    n9 = n5;
                }
                if (n15 == 0) break;
                n3 = Numerics.wholeDiv(n9, n15);
                int[] nArray = ArraysExt.range(0, n6);
                int[] nArray3 = new int[n6];
                BandedSampleModel bandedSampleModel = new BandedSampleModel(n14, n5, n4, n3, nArray, nArray3);
                break;
            }
            default: {
                throw new AssertionError((Object)rawRasterLayout);
            }
        }
        if (n15 == 0) {
            if (n6 != 1) {
                throw new DataStoreContentException(this.errors().getString((short)67, n7, NBITS));
            }
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(n14, n5, n4, n7, n9, 0);
        }
        this.reader = new RawRasterReader(gridGeometry, (SampleModel)var26_31, n10, this.input);
        this.reader.setOrigin(l);
    }

    @Override
    public synchronized GridCoverage read(GridGeometry gridGeometry, int ... nArray) throws DataStoreException {
        try {
            this.getSampleDimensions();
            RangeArgument rangeArgument = RangeArgument.validate(this.reader.layout.getNumBands(), nArray, this.listeners);
            WritableRaster writableRaster = this.reader.read(gridGeometry, rangeArgument);
            return this.createCoverage(this.reader.getEffectiveDomain(), rangeArgument, writableRaster, null);
        }
        catch (IOException iOException) {
            throw new DataStoreException(this.canNotRead(), iOException);
        }
        catch (RuntimeException runtimeException) {
            throw new DataStoreContentException(this.canNotRead(), runtimeException);
        }
    }

    private String canNotRead() {
        return Resources.forLocale(this.getLocale()).getString((short)1, "BIL/BIP/BSQ", this.getDisplayName());
    }

    @Override
    public synchronized void close() throws DataStoreException {
        this.listeners.close();
        ChannelDataInput channelDataInput = this.input;
        this.input = null;
        this.reader = null;
        super.close();
        if (channelDataInput != null) {
            try {
                channelDataInput.channel.close();
            }
            catch (IOException iOException) {
                throw new DataStoreException(iOException);
            }
        }
    }
}

