/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.GeocentricToTopocentric;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class GeographicToTopocentric
extends AbstractProvider {
    private static final long serialVersionUID = -3829993731324133815L;
    static final ParameterDescriptor<Double> ORIGIN_X;
    static final ParameterDescriptor<Double> ORIGIN_Y;
    static final ParameterDescriptor<Double> ORIGIN_Z;
    private static final ParameterDescriptorGroup PARAMETERS;

    public GeographicToTopocentric() {
        super(Conversion.class, PARAMETERS, EllipsoidalCS.class, 3, true, CartesianCS.class, 3, false);
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws FactoryException {
        try {
            return GeocentricToTopocentric.create(mathTransformFactory, Parameters.castOrWrap(parameterValueGroup), true);
        }
        catch (TransformException transformException) {
            throw new FactoryException(transformException);
        }
    }

    static {
        ParameterBuilder parameterBuilder = GeographicToTopocentric.builder();
        ORIGIN_X = GeographicToTopocentric.createLongitude((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8835")).addName("Longitude of topocentric origin"));
        ORIGIN_Y = GeographicToTopocentric.createLatitude((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8834")).addName("Latitude of topocentric origin"), true);
        ORIGIN_Z = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8836")).addName("Ellipsoidal height of topocentric origin")).create(0.0, Units.METRE);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("9837")).addName("Geographic/topocentric conversions")).createGroupForMapProjection(ORIGIN_Y, ORIGIN_X, ORIGIN_Z);
    }
}

