/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.GridCacheValue;
import org.apache.sis.internal.netcdf.Node;
import org.apache.sis.internal.netcdf.Resources;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.builder.LocalizationGridBuilder;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.util.ArraysExt;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

public final class Linearizer {
    private static final int SOURCE_DIMENSION = 2;
    private final CommonCRS datum;
    final Type type;
    private SingleCRS targetCRS;
    private boolean axisSwap;
    private float longitudeSpan;

    public Linearizer(CommonCRS commonCRS, Type type) {
        this.datum = commonCRS;
        this.type = type;
    }

    final String name() {
        return this.type.name();
    }

    final SingleCRS getTargetCRS() {
        return this.targetCRS;
    }

    final boolean axisSwap() {
        return this.axisSwap;
    }

    final InternationalString getPotentialCause(Node node) {
        if (this.longitudeSpan >= 174.0f) {
            String string = IdentifiedObjects.getDisplayName(this.targetCRS, node.getLocale());
            return org.apache.sis.internal.referencing.Resources.formatInternational((short)102, Float.valueOf(this.longitudeSpan), string != null ? string : this.type);
        }
        return null;
    }

    public String toString() {
        return Strings.toString(this.getClass(), new Object[]{"type", this.type, "targetCRS", IdentifiedObjects.getName(this.targetCRS, null)});
    }

    private MathTransform gridToTargetCRS(LocalizationGridBuilder localizationGridBuilder, int n, int n2) throws TransformException {
        double d;
        double d2;
        double d3;
        double d4;
        switch (this.type) {
            default: {
                throw new AssertionError((Object)this.type);
            }
            case UNIVERSAL: 
        }
        Object object = localizationGridBuilder.getSourceEnvelope(false);
        Object[] objectArray = localizationGridBuilder.getControlPoint((int)Math.round(object.getMedian(0)), (int)Math.round(object.getMedian(1)));
        double d5 = d4 = (d3 = objectArray[n]);
        double d6 = d2 = (d = objectArray[n2]);
        objectArray = new int[2];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 2; ++j) {
                objectArray[j] = (int)Math.round((i & 1 << j) == 0 ? object.getMinimum(j) : object.getMaximum(j));
            }
            double[] dArray = localizationGridBuilder.getControlPoint((int)objectArray[0], (int)objectArray[1]);
            double d7 = dArray[n];
            if (d7 < d5) {
                d5 = d7;
            }
            if (d7 > d4) {
                d4 = d7;
            }
            if ((d7 = dArray[n2]) < d6) {
                d6 = d7;
            }
            if (!(d7 > d2)) continue;
            d2 = d7;
        }
        this.longitudeSpan = (float)(d4 - d5);
        if (d6 >= 60.0) {
            d = d2;
        } else if (d2 <= -60.0) {
            d = d6;
        }
        ProjectedCRS projectedCRS = this.datum.universal(d, d3);
        assert (ReferencingUtilities.startsWithNorthEast(projectedCRS.getBaseCRS().getCoordinateSystem()));
        MathTransform mathTransform = projectedCRS.getConversionFromBase().getMathTransform();
        this.targetCRS = projectedCRS;
        boolean bl = this.axisSwap = n2 < n;
        if (!this.axisSwap) {
            object = new Matrix3();
            ((Matrix3)object).m11 = 0.0;
            ((Matrix3)object).m00 = 0.0;
            ((Matrix3)object).m10 = 1.0;
            ((Matrix3)object).m01 = 1.0;
            mathTransform = MathTransforms.concatenate(MathTransforms.linear((Matrix)object), mathTransform);
        }
        return mathTransform;
    }

    static void setCandidatesOnGrid(Axis[] axisArray, Set<Linearizer> set, LocalizationGridBuilder localizationGridBuilder) throws TransformException {
        int n = -1;
        int n2 = -1;
        int n3 = axisArray.length;
        while (--n3 >= 0) {
            switch (axisArray[n3].abbreviation) {
                case '\u03bb': {
                    n = n3;
                    break;
                }
                case '\u03c6': {
                    n2 = n3;
                }
            }
        }
        if ((n | n2) >= 0) {
            HashMap<String, MathTransform> hashMap = new HashMap<String, MathTransform>();
            for (Linearizer linearizer : set) {
                MathTransform mathTransform = linearizer.gridToTargetCRS(localizationGridBuilder, n, n2);
                hashMap.put(linearizer.name(), mathTransform);
            }
            localizationGridBuilder.addLinearizers(hashMap, false, Math.min(n, n2), Math.max(n, n2));
        }
    }

    static void replaceInCompoundCRS(SingleCRS[] singleCRSArray, List<GridCacheValue> list, Matrix matrix) throws DataStoreReferencingException {
        Matrix matrix2 = null;
        block0: for (GridCacheValue gridCacheValue : list) {
            SingleCRS singleCRS = gridCacheValue.linearizationTarget;
            CoordinateSystem coordinateSystem = singleCRS.getCoordinateSystem();
            int n = 0;
            for (int i = 0; i < singleCRSArray.length; ++i) {
                SingleCRS singleCRS2 = singleCRSArray[i];
                int[] nArray = AxisDirections.indicesOfLenientMapping(singleCRS2.getCoordinateSystem(), coordinateSystem);
                if (nArray != null) {
                    singleCRSArray[i] = singleCRS;
                    if (gridCacheValue.axisSwap) {
                        ArraysExt.swap(nArray, 0, 1);
                    }
                    for (int j = 0; j < nArray.length; ++j) {
                        if (nArray[j] == j) continue;
                        int n2 = nArray[j] + n;
                        int n3 = j + n;
                        if (matrix2 == null) {
                            matrix2 = matrix.clone();
                        }
                        int n4 = matrix2.getNumCol();
                        while (--n4 >= 0) {
                            matrix.setElement(n3, n4, matrix2.getElement(n2, n4));
                        }
                    }
                    continue block0;
                }
                n += singleCRS2.getCoordinateSystem().getDimension();
            }
            throw new DataStoreReferencingException(Resources.format((short)26, IdentifiedObjects.getName(singleCRS, null)));
        }
    }

    public static enum Type {
        UNIVERSAL;

        static final int POLAR_THRESHOLD = 60;
    }
}

