/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Set;
import org.apache.sis.image.SourceAlignedImage;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;

final class BandSelectImage
extends SourceAlignedImage {
    private static final Set<String> INHERITED_PROPERTIES = JDK9.setOf("org.apache.sis.GridGeometry", "org.apache.sis.PositionalAccuracy", "org.apache.sis.SampleResolution", "org.apache.sis.Statistics");
    private final int[] bands;

    private BandSelectImage(RenderedImage renderedImage, ColorModel colorModel, int[] nArray) {
        super(renderedImage, colorModel, renderedImage.getSampleModel().createSubsetSampleModel(nArray));
        this.bands = nArray;
    }

    static RenderedImage create(RenderedImage renderedImage, int[] nArray) {
        int n = ImageUtilities.getNumBands(renderedImage);
        if (nArray.length == n && ArraysExt.isRange(0, nArray)) {
            return renderedImage;
        }
        ArgumentChecks.ensureNonEmpty("bands", nArray, 0, n - 1, false);
        ColorModel colorModel = ColorModelFactory.createSubset(renderedImage.getColorModel(), nArray).orElse(null);
        if (colorModel != null && renderedImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)renderedImage;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>(8);
            for (String string : INHERITED_PROPERTIES) {
                Object object = BandSelectImage.getProperty(bufferedImage, string, nArray);
                if (object == Image.UndefinedProperty) continue;
                hashtable.put(string, object);
            }
            return new BufferedImage(colorModel, bufferedImage.getRaster().createWritableChild(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), 0, 0, nArray), bufferedImage.isAlphaPremultiplied(), hashtable);
        }
        return new BandSelectImage(renderedImage, colorModel, (int[])nArray.clone());
    }

    @Override
    public String[] getPropertyNames() {
        return BandSelectImage.filterPropertyNames(this.getSource().getPropertyNames(), INHERITED_PROPERTIES, null);
    }

    @Override
    public Object getProperty(String string) {
        if (INHERITED_PROPERTIES.contains(string)) {
            return BandSelectImage.getProperty(this.getSource(), string, this.bands);
        }
        return super.getProperty(string);
    }

    private static Object getProperty(RenderedImage renderedImage, String string, int[] nArray) {
        Class<?> clazz;
        Object object = renderedImage.getProperty(string);
        if (object != null && (string.equals("org.apache.sis.SampleResolution") || string.equals("org.apache.sis.Statistics")) && (clazz = object.getClass().getComponentType()) != null) {
            Object object2 = Array.newInstance(clazz, nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                Array.set(object2, i, Array.get(object, nArray[i]));
            }
            return object2;
        }
        return object;
    }

    @Override
    protected Raster computeTile(int n, int n2, WritableRaster writableRaster) {
        Raster raster = this.getSource().getTile(n, n2);
        int n3 = raster.getMinX();
        int n4 = raster.getMinY();
        return raster.createChild(n3, n4, raster.getWidth(), raster.getHeight(), n3, n4, this.bands);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 97 * Arrays.hashCode(this.bands);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            BandSelectImage bandSelectImage = (BandSelectImage)object;
            return Arrays.equals(this.bands, bandSelectImage.bands);
        }
        return false;
    }
}

