/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import java.util.Collections;
import org.apache.sis.feature.AbstractAssociation;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureType;
import org.apache.sis.metadata.iso.quality.AbstractElement;
import org.apache.sis.metadata.iso.quality.DefaultConformanceResult;
import org.apache.sis.metadata.iso.quality.DefaultDataQuality;
import org.apache.sis.metadata.iso.quality.DefaultDomainConsistency;
import org.apache.sis.metadata.iso.quality.DefaultScope;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

final class Validator {
    final DefaultDataQuality quality = new DefaultDataQuality();

    Validator(ScopeCode scopeCode) {
        if (scopeCode != null) {
            this.quality.setScope(new DefaultScope(scopeCode));
        }
    }

    private AbstractElement addViolationReport(AbstractElement abstractElement, AbstractIdentifiedType abstractIdentifiedType, InternationalString internationalString) {
        if (abstractElement == null) {
            GenericName genericName = abstractIdentifiedType.getName();
            abstractElement = new DefaultDomainConsistency();
            abstractElement.setMeasureIdentification(genericName instanceof Identifier ? (Identifier)((Object)genericName) : new NamedIdentifier(genericName));
            abstractElement.setEvaluationMethodType(EvaluationMethodType.DIRECT_INTERNAL);
            this.quality.getReports().add(abstractElement);
        }
        abstractElement.getResults().add(new DefaultConformanceResult(null, internationalString, false));
        return abstractElement;
    }

    private static Collection<?> asList(Object object, int n) {
        if (n <= 1) {
            return object != null ? Collections.singletonList(object) : Collections.emptyList();
        }
        return (Collection)object;
    }

    void validate(FeatureType featureType, AbstractFeature abstractFeature) {
        for (AbstractIdentifiedType abstractIdentifiedType : featureType.getProperties(true)) {
            DataQuality dataQuality;
            Object object = abstractFeature.getProperty(abstractIdentifiedType.getName().toString());
            if (object instanceof AbstractAttribute) {
                dataQuality = ((AbstractAttribute)object).quality();
            } else if (object instanceof AbstractAssociation) {
                dataQuality = ((AbstractAssociation)object).quality();
            } else {
                if (object instanceof AbstractAttribute) {
                    this.validate(((AbstractAttribute)object).getType(), ((AbstractAttribute)object).getValues());
                    continue;
                }
                if (!(object instanceof AbstractAssociation)) continue;
                this.validate(((AbstractAssociation)object).getRole(), ((AbstractAssociation)object).getValues());
                continue;
            }
            if (dataQuality == null) continue;
            this.quality.getReports().addAll(dataQuality.getReports());
        }
    }

    void validateAny(AbstractIdentifiedType abstractIdentifiedType, Object object) {
        if (abstractIdentifiedType instanceof DefaultAttributeType) {
            this.validate((DefaultAttributeType)abstractIdentifiedType, Validator.asList(object, ((DefaultAttributeType)abstractIdentifiedType).getMaximumOccurs()));
        }
        if (abstractIdentifiedType instanceof DefaultAssociationRole) {
            this.validate((DefaultAssociationRole)abstractIdentifiedType, Validator.asList(object, ((DefaultAssociationRole)abstractIdentifiedType).getMaximumOccurs()));
        }
    }

    void validate(DefaultAttributeType<?> defaultAttributeType, Collection<?> collection) {
        AbstractElement abstractElement = null;
        for (Object obj : collection) {
            Class<?> clazz = defaultAttributeType.getValueClass();
            if (clazz.isInstance(obj)) continue;
            abstractElement = this.addViolationReport(abstractElement, defaultAttributeType, Errors.formatInternational((short)59, defaultAttributeType.getName(), clazz, obj.getClass()));
            break;
        }
        this.verifyCardinality(abstractElement, defaultAttributeType, defaultAttributeType.getMinimumOccurs(), defaultAttributeType.getMaximumOccurs(), collection.size());
    }

    void validate(DefaultAssociationRole defaultAssociationRole, Collection<?> collection) {
        AbstractElement abstractElement = null;
        for (Object obj : collection) {
            DefaultFeatureType defaultFeatureType = ((AbstractFeature)obj).getType();
            DefaultFeatureType defaultFeatureType2 = defaultAssociationRole.getValueType();
            if (defaultFeatureType2.isAssignableFrom(defaultFeatureType)) continue;
            abstractElement = this.addViolationReport(abstractElement, defaultAssociationRole, Errors.formatInternational((short)59, defaultAssociationRole.getName(), defaultFeatureType2.getName(), defaultFeatureType.getName()));
            break;
        }
        this.verifyCardinality(abstractElement, defaultAssociationRole, defaultAssociationRole.getMinimumOccurs(), defaultAssociationRole.getMaximumOccurs(), collection.size());
    }

    private void verifyCardinality(AbstractElement abstractElement, AbstractIdentifiedType abstractIdentifiedType, int n, int n2, int n3) {
        if (n3 < n) {
            InternationalString internationalString = n3 == 0 ? Errors.formatInternational((short)89, (Object)abstractIdentifiedType.getName()) : Errors.formatInternational((short)128, n, abstractIdentifiedType.getName());
            this.addViolationReport(abstractElement, abstractIdentifiedType, internationalString);
        } else if (n3 > n2) {
            InternationalString internationalString = n2 == 0 ? Errors.formatInternational((short)41, (Object)abstractIdentifiedType.getName()) : Errors.formatInternational((short)130, n2, abstractIdentifiedType.getName());
            this.addViolationReport(abstractElement, abstractIdentifiedType, internationalString);
        }
    }
}

