/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.cfg;

import com.mchange.v1.lang.BooleanUtils;
import com.mchange.v2.beans.BeansUtils;
import com.mchange.v2.c3p0.C3P0Registry;
import com.mchange.v2.c3p0.cfg.C3P0ConfigFinder;
import com.mchange.v2.c3p0.cfg.C3P0ConfigUtils;
import com.mchange.v2.c3p0.cfg.DefaultC3P0ConfigFinder;
import com.mchange.v2.c3p0.cfg.InvalidConfigException;
import com.mchange.v2.c3p0.cfg.NamedScope;
import com.mchange.v2.c3p0.cfg.Validator;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.cfg.MConfig;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class C3P0Config {
    static final String PROP_STYLE_NAMED_CFG_PFX = "c3p0.named-configs";
    static final int PROP_STYLE_NAMED_CFG_PFX_LEN = "c3p0.named-configs".length();
    static final String PROP_STYLE_USER_OVERRIDES_PART = "user-overrides";
    static final String PROP_STYLE_USER_OVERRIDES_PFX = "c3p0.user-overrides";
    static final int PROP_STYLE_USER_OVERRIDES_PFX_LEN = "c3p0.user-overrides".length();
    static final String PROP_STYLE_EXTENSIONS_PART = "extensions";
    static final String PROP_STYLE_EXTENSIONS_PFX = "c3p0.extensions";
    static final int PROP_STYLE_EXTENSIONS_PFX_LEN = "c3p0.extensions".length();
    public static final String CFG_FINDER_CLASSNAME_KEY = "com.mchange.v2.c3p0.cfg.finder";
    public static final String DEFAULT_CONFIG_NAME = "default";
    public static final String PROPS_FILE_RSRC_PATH = "/c3p0.properties";
    static final MLogger logger = MLog.getLogger(C3P0Config.class);
    private static MultiPropertiesConfig _MPCONFIG;
    private static C3P0Config _MAIN;
    static final Class[] SUOAS_ARGS;
    static final Collection SKIP_BIND_PROPS;
    NamedScope defaultConfig;
    HashMap configNamesToNamedScopes;

    private static synchronized MultiPropertiesConfig MPCONFIG() {
        return _MPCONFIG;
    }

    private static synchronized C3P0Config MAIN() {
        return _MAIN;
    }

    private static synchronized void setLibraryMultiPropertiesConfig(MultiPropertiesConfig multiPropertiesConfig) {
        _MPCONFIG = multiPropertiesConfig;
    }

    public static Properties allCurrentProperties() {
        return C3P0Config.MPCONFIG().getPropertiesByPrefix("");
    }

    public static synchronized void setMainConfig(C3P0Config c3P0Config) {
        _MAIN = c3P0Config;
    }

    public static synchronized void refreshMainConfig() {
        C3P0Config.refreshMainConfig(null, null);
    }

    public static synchronized void refreshMainConfig(MultiPropertiesConfig[] multiPropertiesConfigArray, String string) {
        MultiPropertiesConfig multiPropertiesConfig = C3P0Config.findLibraryMultiPropertiesConfig();
        if (multiPropertiesConfigArray != null) {
            int n = multiPropertiesConfigArray.length;
            MultiPropertiesConfig[] multiPropertiesConfigArray2 = new MultiPropertiesConfig[n + 1];
            multiPropertiesConfigArray2[0] = multiPropertiesConfig;
            for (int i = 0; i < n; ++i) {
                multiPropertiesConfigArray2[i + 1] = multiPropertiesConfigArray[i];
            }
            MultiPropertiesConfig multiPropertiesConfig2 = MConfig.combine(multiPropertiesConfigArray2);
            C3P0Config.setLibraryMultiPropertiesConfig(multiPropertiesConfig2);
            C3P0Config.setMainConfig(C3P0Config.findLibraryC3P0Config(true));
            if (logger.isLoggable(MLevel.INFO)) {
                logger.log(MLevel.INFO, "c3p0 main configuration was refreshed, with overrides specified" + (string == null ? "." : " - " + string));
            }
        } else {
            C3P0Config.setLibraryMultiPropertiesConfig(multiPropertiesConfig);
            C3P0Config.setMainConfig(C3P0Config.findLibraryC3P0Config(false));
            if (logger.isLoggable(MLevel.INFO)) {
                logger.log(MLevel.INFO, "c3p0 main configuration was refreshed, with no overrides specified (and any previous overrides removed).");
            }
        }
        C3P0Registry.markConfigRefreshed();
    }

    private static MultiPropertiesConfig findLibraryMultiPropertiesConfig() {
        String[] stringArray = new String[]{"/mchange-commons.properties", "/mchange-log.properties"};
        String[] stringArray2 = new String[]{"hocon:/reference,/application,/c3p0,/", PROPS_FILE_RSRC_PATH, "/"};
        return MConfig.readVmConfig(stringArray, stringArray2);
    }

    private static C3P0Config findLibraryC3P0Config(boolean bl) {
        NamedScope namedScope;
        Object object2;
        HashMap hashMap;
        C3P0Config c3P0Config;
        C3P0ConfigFinder c3P0ConfigFinder;
        block14: {
            String string = C3P0Config.MPCONFIG().getProperty(CFG_FINDER_CLASSNAME_KEY);
            c3P0ConfigFinder = null;
            try {
                if (string != null) {
                    c3P0ConfigFinder = (C3P0ConfigFinder)Class.forName(string).newInstance();
                }
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) break block14;
                logger.log(MLevel.WARNING, "Could not load specified C3P0ConfigFinder class'" + string + "'.", exception);
            }
        }
        try {
            if (c3P0ConfigFinder == null) {
                Class.forName("org.w3c.dom.Node");
                Class.forName("com.mchange.v2.c3p0.cfg.C3P0ConfigXmlUtils");
                c3P0ConfigFinder = new DefaultC3P0ConfigFinder(bl);
            }
            c3P0Config = c3P0ConfigFinder.findConfig();
        }
        catch (Exception exception) {
            if (exception instanceof ClassNotFoundException) {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "XML configuration disabled! Verify that standard XML libs are available.", exception);
                }
            } else if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "An error occurred while trying to parse the XML configuration!");
                logger.log(MLevel.SEVERE, "XML CONFIGURATION IGNORED!", exception);
            }
            hashMap = C3P0ConfigUtils.extractHardcodedC3P0Defaults();
            hashMap.putAll(C3P0ConfigUtils.extractC3P0PropertiesResources());
            c3P0Config = C3P0ConfigUtils.configFromFlatDefaults(hashMap);
        }
        HashMap hashMap2 = C3P0Config.findPropStyleNamedScopes();
        hashMap = c3P0Config.configNamesToNamedScopes;
        HashMap<Object, NamedScope> hashMap3 = new HashMap<Object, NamedScope>();
        HashSet hashSet = new HashSet(hashMap.keySet());
        hashSet.addAll(hashMap2.keySet());
        for (Object object2 : hashSet) {
            namedScope = (NamedScope)hashMap.get(object2);
            NamedScope namedScope2 = (NamedScope)hashMap2.get(object2);
            if (namedScope != null && namedScope2 != null) {
                hashMap3.put(object2, namedScope.mergedOver(namedScope2));
                continue;
            }
            if (namedScope != null && namedScope2 == null) {
                hashMap3.put(object2, namedScope);
                continue;
            }
            if (namedScope == null && namedScope2 != null) {
                hashMap3.put(object2, namedScope2);
                continue;
            }
            throw new AssertionError((Object)"Huh? allConfigNames is the union, every name should be in one of the two maps.");
        }
        HashMap hashMap4 = C3P0Config.findPropStyleUserOverridesDefaultConfig();
        object2 = C3P0Config.findPropStyleExtensionsDefaultConfig();
        namedScope = new NamedScope(c3P0Config.defaultConfig.props, NamedScope.mergeUserNamesToOverrides(c3P0Config.defaultConfig.userNamesToOverrides, hashMap4), NamedScope.mergeExtensions(c3P0Config.defaultConfig.extensions, (HashMap)object2));
        return new C3P0Config(namedScope, hashMap3);
    }

    private static void warnOnUnknownProperties(C3P0Config c3P0Config) {
        C3P0Config.warnOnUnknownProperties(c3P0Config.defaultConfig);
        Iterator iterator = c3P0Config.configNamesToNamedScopes.values().iterator();
        while (iterator.hasNext()) {
            C3P0Config.warnOnUnknownProperties((NamedScope)iterator.next());
        }
    }

    private static void warnOnUnknownProperties(NamedScope namedScope) {
        C3P0Config.warnOnUnknownProperties(namedScope.props);
        Iterator iterator = namedScope.userNamesToOverrides.values().iterator();
        while (iterator.hasNext()) {
            C3P0Config.warnOnUnknownProperties((Map)iterator.next());
        }
    }

    private static void warnOnUnknownProperties(Map map) {
        for (String string : map.keySet()) {
            if (C3P0Defaults.isKnownProperty(string) || !logger.isLoggable(MLevel.WARNING)) continue;
            logger.log(MLevel.WARNING, "Unknown c3p0-config property: " + string);
        }
    }

    public static String getPropsFileConfigProperty(String string) {
        return C3P0Config.MPCONFIG().getProperty(string);
    }

    static Properties findResourceProperties() {
        return C3P0Config.MPCONFIG().getPropertiesByResourcePath(PROPS_FILE_RSRC_PATH);
    }

    static Properties findAllOneLevelC3P0Properties() {
        Properties properties = C3P0Config.MPCONFIG().getPropertiesByPrefix("c3p0");
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            if (((String)iterator.next()).lastIndexOf(46) <= 4) continue;
            iterator.remove();
        }
        return properties;
    }

    static HashMap findPropStyleUserOverridesDefaultConfig() {
        HashMap<String, HashMap<String, Object>> hashMap = new HashMap<String, HashMap<String, Object>>();
        Properties properties = C3P0Config.MPCONFIG().getPropertiesByPrefix(PROP_STYLE_USER_OVERRIDES_PFX);
        for (String string : properties.keySet()) {
            String string2 = string.substring(PROP_STYLE_USER_OVERRIDES_PFX_LEN + 1);
            int n = string2.indexOf(46);
            if (n < 0) {
                if (!logger.isLoggable(MLevel.WARNING)) continue;
                logger.log(MLevel.WARNING, "Bad specification of user-override property '" + string + "', propfile key should look like '" + PROP_STYLE_USER_OVERRIDES_PFX + ".<user>.<property>'. Ignoring.");
                continue;
            }
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            HashMap<String, Object> hashMap2 = (HashMap<String, Object>)hashMap.get(string3);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, Object>();
                hashMap.put(string3, hashMap2);
            }
            hashMap2.put(string4, properties.get(string));
        }
        return hashMap;
    }

    static HashMap findPropStyleExtensionsDefaultConfig() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Properties properties = C3P0Config.MPCONFIG().getPropertiesByPrefix(PROP_STYLE_EXTENSIONS_PFX);
        for (String string : properties.keySet()) {
            String string2 = string.substring(PROP_STYLE_EXTENSIONS_PFX_LEN + 1);
            hashMap.put(string2, properties.get(string));
        }
        return hashMap;
    }

    static HashMap findPropStyleNamedScopes() {
        HashMap<String, NamedScope> hashMap = new HashMap<String, NamedScope>();
        Properties properties = C3P0Config.MPCONFIG().getPropertiesByPrefix(PROP_STYLE_NAMED_CFG_PFX);
        for (String string : properties.keySet()) {
            int n;
            String string2 = string.substring(PROP_STYLE_NAMED_CFG_PFX_LEN + 1);
            int n2 = string2.indexOf(46);
            if (n2 < 0) {
                if (!logger.isLoggable(MLevel.WARNING)) continue;
                logger.log(MLevel.WARNING, "Bad specification of named config property '" + string + "', propfile key should look like '" + PROP_STYLE_NAMED_CFG_PFX + ".<cfgname>.<property>' or '" + PROP_STYLE_NAMED_CFG_PFX + ".<cfgname>.user-overrides.<user>.<property>'. Ignoring.");
                continue;
            }
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            NamedScope namedScope = (NamedScope)hashMap.get(string3);
            if (namedScope == null) {
                namedScope = new NamedScope();
                hashMap.put(string3, namedScope);
            }
            if ((n = string4.indexOf(46)) >= 0) {
                if (string4.startsWith(PROP_STYLE_USER_OVERRIDES_PART)) {
                    int n3 = string4.substring(n + 1).indexOf(46);
                    if (n3 < 0 && logger.isLoggable(MLevel.WARNING)) {
                        logger.log(MLevel.WARNING, "Misformatted user-override property; missing user or property name: " + string4);
                    }
                    String string5 = string4.substring(n + 1, n3);
                    String string6 = string4.substring(n3 + 1);
                    HashMap<String, Object> hashMap2 = (HashMap<String, Object>)namedScope.userNamesToOverrides.get(string5);
                    if (hashMap2 == null) {
                        hashMap2 = new HashMap<String, Object>();
                        namedScope.userNamesToOverrides.put(string5, hashMap2);
                    }
                    hashMap2.put(string6, properties.get(string));
                    continue;
                }
                if (string4.startsWith(PROP_STYLE_EXTENSIONS_PART)) {
                    String string7 = string4.substring(n + 1);
                    namedScope.extensions.put(string7, properties.get(string));
                    continue;
                }
                if (!logger.isLoggable(MLevel.WARNING)) continue;
                logger.log(MLevel.WARNING, "Unexpected compound property, ignored: " + string4);
                continue;
            }
            namedScope.props.put(string4, properties.get(string));
        }
        return hashMap;
    }

    public static String getUnspecifiedUserProperty(String string, String string2) {
        String string3 = null;
        if (string2 == null) {
            string3 = (String)C3P0Config.MAIN().defaultConfig.props.get(string);
        } else {
            NamedScope namedScope = (NamedScope)C3P0Config.MAIN().configNamesToNamedScopes.get(string2);
            if (namedScope != null) {
                string3 = (String)namedScope.props.get(string);
            } else {
                logger.warning("named-config with name '" + string2 + "' does not exist. Using default-config for property '" + string + "'.");
            }
            if (string3 == null) {
                string3 = (String)C3P0Config.MAIN().defaultConfig.props.get(string);
            }
        }
        return string3;
    }

    public static Map getExtensions(String string) {
        HashMap hashMap = C3P0Config.MAIN().defaultConfig.extensions;
        if (string != null) {
            NamedScope namedScope = (NamedScope)C3P0Config.MAIN().configNamesToNamedScopes.get(string);
            if (namedScope != null) {
                hashMap = namedScope.extensions;
            } else {
                logger.warning("named-config with name '" + string + "' does not exist. Using default-config extensions.");
            }
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public static Map getUnspecifiedUserProperties(String string) {
        HashMap hashMap = new HashMap();
        hashMap.putAll(C3P0Config.MAIN().defaultConfig.props);
        if (string != null) {
            NamedScope namedScope = (NamedScope)C3P0Config.MAIN().configNamesToNamedScopes.get(string);
            if (namedScope != null) {
                hashMap.putAll(namedScope.props);
            } else {
                logger.warning("named-config with name '" + string + "' does not exist. Using default-config.");
            }
        }
        return hashMap;
    }

    public static Map getUserOverrides(String string) {
        HashMap hashMap = new HashMap();
        NamedScope namedScope = null;
        if (string != null) {
            namedScope = (NamedScope)C3P0Config.MAIN().configNamesToNamedScopes.get(string);
        }
        hashMap.putAll(C3P0Config.MAIN().defaultConfig.userNamesToOverrides);
        if (namedScope != null) {
            hashMap.putAll(namedScope.userNamesToOverrides);
        }
        return hashMap.isEmpty() ? null : hashMap;
    }

    public static String getUserOverridesAsString(String string) throws IOException {
        Map map = C3P0Config.getUserOverrides(string);
        if (map == null) {
            return null;
        }
        return C3P0ImplUtils.createUserOverridesAsString(map).intern();
    }

    public static void bindUserOverridesAsString(Object object, String string) throws Exception {
        Method method = object.getClass().getMethod("setUserOverridesAsString", SUOAS_ARGS);
        method.invoke(object, string);
    }

    public static void bindUserOverridesToBean(Object object, String string) throws Exception {
        C3P0Config.bindUserOverridesAsString(object, C3P0Config.getUserOverridesAsString(string));
    }

    public static void bindNamedConfigToBean(Object object, String string, boolean bl) throws IntrospectionException {
        block4: {
            Map map = C3P0Config.getUnspecifiedUserProperties(string);
            Map map2 = C3P0Config.getExtensions(string);
            HashMap<String, Map> hashMap = new HashMap<String, Map>();
            hashMap.putAll(map);
            hashMap.put(PROP_STYLE_EXTENSIONS_PART, map2);
            BeansUtils.overwriteAccessiblePropertiesFromMap(hashMap, object, false, SKIP_BIND_PROPS, true, MLevel.FINEST, MLevel.WARNING, false);
            try {
                if (bl) {
                    C3P0Config.bindUserOverridesToBean(object, string);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) break block4;
                logger.log(MLevel.WARNING, "An exception occurred while trying to bind user overrides for named config '" + string + "'. Only default user configs will be used.", exception);
            }
        }
    }

    public static String initializeUserOverridesAsString() {
        try {
            return C3P0Config.getUserOverridesAsString(null);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Error initializing default user overrides. User overrides may be ignored.", exception);
            }
            return null;
        }
    }

    public static Map initializeExtensions() {
        return C3P0Config.getExtensions(null);
    }

    public static String initializeStringPropertyVar(String string, String string2, Validator<String> validator) {
        String string3 = C3P0Config.getUnspecifiedUserProperty(string, null);
        try {
            if (string3 == null) {
                string3 = string2;
            } else if (validator != null) {
                string3 = validator.validate(string3);
            }
            return string3;
        }
        catch (InvalidConfigException invalidConfigException) {
            logger.log(MLevel.WARNING, "'" + string3 + "' is not a legal value for property '" + string + "'. Using default value: " + string2, invalidConfigException);
            return string2;
        }
    }

    public static String initializeStringPropertyVar(String string, String string2) {
        return C3P0Config.initializeStringPropertyVar(string, string2, null);
    }

    public static int initializeIntPropertyVar(String string, int n) {
        boolean bl = false;
        int n2 = -1;
        String string2 = C3P0Config.getUnspecifiedUserProperty(string, null);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(MLevel.WARNING, "'" + string2 + "' is not a legal value for property '" + string + "'. Using default value: " + n, numberFormatException);
            }
        }
        if (!bl) {
            n2 = n;
        }
        return n2;
    }

    public static boolean initializeBooleanPropertyVar(String string, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = C3P0Config.getUnspecifiedUserProperty(string, null);
        if (string2 != null) {
            try {
                bl3 = BooleanUtils.parseBoolean(string2.trim());
                bl2 = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.log(MLevel.WARNING, "'" + string2 + "' is not a legal value for property '" + string + "'. Using default value: " + bl, illegalArgumentException);
            }
        }
        if (!bl2) {
            bl3 = bl;
        }
        return bl3;
    }

    public static MultiPropertiesConfig getMultiPropertiesConfig() {
        return C3P0Config.MPCONFIG();
    }

    C3P0Config(NamedScope namedScope, HashMap hashMap) {
        this.defaultConfig = namedScope;
        this.configNamesToNamedScopes = hashMap;
    }

    static {
        C3P0Config.setLibraryMultiPropertiesConfig(C3P0Config.findLibraryMultiPropertiesConfig());
        C3P0Config.setMainConfig(C3P0Config.findLibraryC3P0Config(false));
        C3P0Config.warnOnUnknownProperties(C3P0Config.MAIN());
        SUOAS_ARGS = new Class[]{String.class};
        SKIP_BIND_PROPS = Arrays.asList("loginTimeout", "properties");
    }
}

