/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.validator;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.cert.jcajce.JcaCertStoreBuilder;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.mail.smime.validator.SignedMailValidatorException;
import org.bouncycastle.pkix.jcajce.CertPathReviewerException;
import org.bouncycastle.pkix.jcajce.PKIXCertPathReviewer;
import org.bouncycastle.pkix.util.ErrorBundle;
import org.bouncycastle.pkix.util.filter.TrustedInput;
import org.bouncycastle.pkix.util.filter.UntrustedInput;
import org.bouncycastle.util.Integers;

public class SignedMailValidator {
    private static final String RESOURCE_NAME = "org.bouncycastle.mail.smime.validator.SignedMailValidatorMessages";
    private static final Class DEFAULT_CERT_PATH_REVIEWER = PKIXCertPathReviewer.class;
    private static final String EXT_KEY_USAGE = Extension.extendedKeyUsage.getId();
    private static final String SUBJECT_ALTERNATIVE_NAME = Extension.subjectAlternativeName.getId();
    private static final int shortKeyLength = 512;
    private static final long THIRTY_YEARS_IN_MILLI_SEC = 946728000000L;
    private static final JcaX509CertSelectorConverter selectorConverter = new JcaX509CertSelectorConverter();
    private CertStore certs;
    private SignerInformationStore signers;
    private Map results;
    private String[] fromAddresses;
    private Class certPathReviewerClass;

    public SignedMailValidator(MimeMessage mimeMessage, PKIXParameters pKIXParameters) throws SignedMailValidatorException {
        this(mimeMessage, pKIXParameters, DEFAULT_CERT_PATH_REVIEWER);
    }

    public SignedMailValidator(MimeMessage mimeMessage, PKIXParameters pKIXParameters, Class clazz) throws SignedMailValidatorException {
        this.certPathReviewerClass = clazz;
        boolean bl = DEFAULT_CERT_PATH_REVIEWER.isAssignableFrom(clazz);
        if (!bl) {
            throw new IllegalArgumentException("certPathReviewerClass is not a subclass of " + DEFAULT_CERT_PATH_REVIEWER.getName());
        }
        try {
            SMIMESigned sMIMESigned;
            Address[] addressArray;
            if (mimeMessage.isMimeType("multipart/signed")) {
                addressArray = (Address[])mimeMessage.getContent();
                sMIMESigned = new SMIMESigned((MimeMultipart)addressArray);
            } else if (mimeMessage.isMimeType("application/pkcs7-mime") || mimeMessage.isMimeType("application/x-pkcs7-mime")) {
                sMIMESigned = new SMIMESigned((Part)mimeMessage);
            } else {
                ErrorBundle errorBundle = SignedMailValidator.createErrorBundle("SignedMailValidator.noSignedMessage");
                throw new SignedMailValidatorException(errorBundle);
            }
            this.certs = new JcaCertStoreBuilder().addCertificates(sMIMESigned.getCertificates()).addCRLs(sMIMESigned.getCRLs()).setProvider("BC").build();
            this.signers = sMIMESigned.getSignerInfos();
            addressArray = mimeMessage.getFrom();
            InternetAddress internetAddress = null;
            try {
                if (mimeMessage.getHeader("Sender") != null) {
                    internetAddress = new InternetAddress(mimeMessage.getHeader("Sender")[0]);
                }
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
            int n = addressArray != null ? addressArray.length : 0;
            this.fromAddresses = new String[n + (internetAddress != null ? 1 : 0)];
            for (int i = 0; i < n; ++i) {
                InternetAddress internetAddress2 = (InternetAddress)addressArray[i];
                this.fromAddresses[i] = internetAddress2.getAddress();
            }
            if (internetAddress != null) {
                this.fromAddresses[n] = internetAddress.getAddress();
            }
            this.results = new HashMap();
        }
        catch (Exception exception) {
            if (exception instanceof SignedMailValidatorException) {
                throw (SignedMailValidatorException)exception;
            }
            ErrorBundle errorBundle = SignedMailValidator.createErrorBundle("SignedMailValidator.exceptionReadingMessage", new Object[]{exception.getMessage(), exception, exception.getClass().getName()});
            throw new SignedMailValidatorException(errorBundle, (Throwable)exception);
        }
        this.validateSignatures(pKIXParameters);
    }

    protected void validateSignatures(PKIXParameters pKIXParameters) {
        PKIXParameters pKIXParameters2 = (PKIXParameters)pKIXParameters.clone();
        pKIXParameters2.addCertStore(this.certs);
        Collection<SignerInformation> collection = this.signers.getSigners();
        Iterator<SignerInformation> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<ErrorBundle> arrayList2 = new ArrayList<ErrorBundle>();
            SignerInformation signerInformation = iterator.next();
            X509Certificate x509Certificate = null;
            try {
                object2 = SignedMailValidator.findCerts(pKIXParameters2.getCertStores(), selectorConverter.getCertSelector(signerInformation.getSID()));
                object = object2.iterator();
                if (object.hasNext()) {
                    x509Certificate = (X509Certificate)object.next();
                }
            }
            catch (CertStoreException certStoreException) {
                object = SignedMailValidator.createErrorBundle("SignedMailValidator.exceptionRetrievingSignerCert", new Object[]{certStoreException.getMessage(), certStoreException, certStoreException.getClass().getName()});
                arrayList.add(object);
            }
            if (x509Certificate != null) {
                Object object3;
                Object object4;
                Object object5;
                boolean bl = false;
                try {
                    bl = signerInformation.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(x509Certificate.getPublicKey()));
                    if (!bl) {
                        object = SignedMailValidator.createErrorBundle("SignedMailValidator.signatureNotVerified");
                        arrayList.add(object);
                    }
                }
                catch (Exception exception) {
                    object5 = SignedMailValidator.createErrorBundle("SignedMailValidator.exceptionVerifyingSignature", new Object[]{exception.getMessage(), exception, exception.getClass().getName()});
                    arrayList.add(object5);
                }
                this.checkSignerCert(x509Certificate, arrayList, arrayList2);
                object = signerInformation.getSignedAttributes();
                if (object != null && (object5 = ((AttributeTable)object).get(PKCSObjectIdentifiers.id_aa_receiptRequest)) != null) {
                    object4 = SignedMailValidator.createErrorBundle("SignedMailValidator.signedReceiptRequest");
                    arrayList2.add((ErrorBundle)object4);
                }
                if ((object5 = SignedMailValidator.getSignatureTime(signerInformation)) == null) {
                    object4 = SignedMailValidator.createErrorBundle("SignedMailValidator.noSigningTime");
                    arrayList2.add((ErrorBundle)object4);
                    object5 = pKIXParameters.getDate();
                    if (object5 == null) {
                        object5 = new Date();
                    }
                } else {
                    try {
                        x509Certificate.checkValidity((Date)object5);
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        object3 = SignedMailValidator.createErrorBundle("SignedMailValidator.certExpired", new Object[]{new TrustedInput(object5), new TrustedInput(x509Certificate.getNotAfter())});
                        arrayList.add(object3);
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        object3 = SignedMailValidator.createErrorBundle("SignedMailValidator.certNotYetValid", new Object[]{new TrustedInput(object5), new TrustedInput(x509Certificate.getNotBefore())});
                        arrayList.add(object3);
                    }
                }
                pKIXParameters2.setDate((Date)object5);
                try {
                    PKIXCertPathReviewer pKIXCertPathReviewer;
                    ArrayList<CertStore> arrayList3 = new ArrayList<CertStore>();
                    arrayList3.add(this.certs);
                    Object[] objectArray = SignedMailValidator.createCertPath(x509Certificate, pKIXParameters2.getTrustAnchors(), pKIXParameters.getCertStores(), arrayList3);
                    object4 = (CertPath)objectArray[0];
                    object3 = (List)objectArray[1];
                    try {
                        pKIXCertPathReviewer = (PKIXCertPathReviewer)this.certPathReviewerClass.newInstance();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new IllegalArgumentException("Cannot instantiate object of type " + this.certPathReviewerClass.getName() + ": " + illegalAccessException.getMessage());
                    }
                    catch (InstantiationException instantiationException) {
                        throw new IllegalArgumentException("Cannot instantiate object of type " + this.certPathReviewerClass.getName() + ": " + instantiationException.getMessage());
                    }
                    pKIXCertPathReviewer.init((CertPath)object4, pKIXParameters2);
                    if (!pKIXCertPathReviewer.isValidCertPath()) {
                        ErrorBundle errorBundle = SignedMailValidator.createErrorBundle("SignedMailValidator.certPathInvalid");
                        arrayList.add(errorBundle);
                    }
                    this.results.put(signerInformation, new ValidationResult(pKIXCertPathReviewer, bl, arrayList, arrayList2, (List)object3));
                }
                catch (GeneralSecurityException generalSecurityException) {
                    object3 = SignedMailValidator.createErrorBundle("SignedMailValidator.exceptionCreateCertPath", new Object[]{generalSecurityException.getMessage(), generalSecurityException, generalSecurityException.getClass().getName()});
                    arrayList.add(object3);
                    this.results.put(signerInformation, new ValidationResult(null, bl, arrayList, arrayList2, null));
                }
                catch (CertPathReviewerException certPathReviewerException) {
                    arrayList.add(certPathReviewerException.getErrorMessage());
                    this.results.put(signerInformation, new ValidationResult(null, bl, arrayList, arrayList2, null));
                }
                continue;
            }
            object2 = SignedMailValidator.createErrorBundle("SignedMailValidator.noSignerCert");
            arrayList.add(object2);
            this.results.put(signerInformation, new ValidationResult(null, false, arrayList, arrayList2, null));
        }
    }

    public static Set getEmailAddresses(X509Certificate x509Certificate) throws IOException, CertificateEncodingException {
        Object object;
        int n;
        Object object2;
        HashSet<Object> hashSet = new HashSet<Object>();
        TBSCertificate tBSCertificate = SignedMailValidator.getTBSCert(x509Certificate);
        RDN[] rDNArray = tBSCertificate.getSubject().getRDNs(PKCSObjectIdentifiers.pkcs_9_at_emailAddress);
        for (int i = 0; i < rDNArray.length; ++i) {
            object2 = rDNArray[i].getTypesAndValues();
            for (n = 0; n != ((AttributeTypeAndValue[])object2).length; ++n) {
                if (!object2[n].getType().equals(PKCSObjectIdentifiers.pkcs_9_at_emailAddress)) continue;
                object = ((ASN1String)((Object)((AttributeTypeAndValue)object2[n]).getValue())).getString().toLowerCase();
                hashSet.add(object);
            }
        }
        byte[] byArray = x509Certificate.getExtensionValue(SUBJECT_ALTERNATIVE_NAME);
        if (byArray != null) {
            object2 = ASN1Sequence.getInstance(SignedMailValidator.getObject(byArray));
            for (n = 0; n < ((ASN1Sequence)object2).size(); ++n) {
                object = (ASN1TaggedObject)((ASN1Sequence)object2).getObjectAt(n);
                if (((ASN1TaggedObject)object).getTagNo() != 1) continue;
                String string = ASN1IA5String.getInstance((ASN1TaggedObject)object, false).getString().toLowerCase();
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private static ASN1Primitive getObject(byte[] byArray) throws IOException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(aSN1InputStream.readObject());
        return ASN1Primitive.fromByteArray(aSN1OctetString.getOctets());
    }

    protected void checkSignerCert(X509Certificate x509Certificate, List list, List list2) {
        Object object;
        Object object2;
        Object object3;
        long l;
        PublicKey publicKey = x509Certificate.getPublicKey();
        int n = -1;
        if (publicKey instanceof RSAPublicKey) {
            n = ((RSAPublicKey)publicKey).getModulus().bitLength();
        } else if (publicKey instanceof DSAPublicKey) {
            n = ((DSAPublicKey)publicKey).getParams().getP().bitLength();
        }
        if (n != -1 && n <= 512) {
            ErrorBundle errorBundle = SignedMailValidator.createErrorBundle("SignedMailValidator.shortSigningKey", new Object[]{Integers.valueOf(n)});
            list2.add(errorBundle);
        }
        if ((l = x509Certificate.getNotAfter().getTime() - x509Certificate.getNotBefore().getTime()) > 946728000000L) {
            object3 = SignedMailValidator.createErrorBundle("SignedMailValidator.longValidity", new Object[]{new TrustedInput(x509Certificate.getNotBefore()), new TrustedInput(x509Certificate.getNotAfter())});
            list2.add(object3);
        }
        if ((object3 = x509Certificate.getKeyUsage()) != null && !object3[0] && !object3[1]) {
            object2 = SignedMailValidator.createErrorBundle("SignedMailValidator.signingNotPermitted");
            list.add(object2);
        }
        try {
            object2 = x509Certificate.getExtensionValue(EXT_KEY_USAGE);
            if (object2 != null && !((ExtendedKeyUsage)(object = ExtendedKeyUsage.getInstance(SignedMailValidator.getObject((byte[])object2)))).hasKeyPurposeId(KeyPurposeId.anyExtendedKeyUsage) && !((ExtendedKeyUsage)object).hasKeyPurposeId(KeyPurposeId.id_kp_emailProtection)) {
                ErrorBundle errorBundle = SignedMailValidator.createErrorBundle("SignedMailValidator.extKeyUsageNotPermitted");
                list.add(errorBundle);
            }
        }
        catch (Exception exception) {
            object = SignedMailValidator.createErrorBundle("SignedMailValidator.extKeyUsageError", new Object[]{exception.getMessage(), exception, exception.getClass().getName()});
            list.add(object);
        }
        try {
            object2 = SignedMailValidator.getEmailAddresses(x509Certificate);
            if (object2.isEmpty()) {
                object = SignedMailValidator.createErrorBundle("SignedMailValidator.noEmailInCert");
                list.add(object);
            } else {
                boolean bl = false;
                for (int i = 0; i < this.fromAddresses.length; ++i) {
                    if (!object2.contains(this.fromAddresses[i].toLowerCase())) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    ErrorBundle errorBundle = SignedMailValidator.createErrorBundle("SignedMailValidator.emailFromCertMismatch", new Object[]{new UntrustedInput(SignedMailValidator.addressesToString(this.fromAddresses)), new UntrustedInput(object2)});
                    list.add(errorBundle);
                }
            }
        }
        catch (Exception exception) {
            object = SignedMailValidator.createErrorBundle("SignedMailValidator.certGetEmailError", new Object[]{exception.getMessage(), exception, exception.getClass().getName()});
            list.add(object);
        }
    }

    static String addressesToString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        for (int i = 0; i != objectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(String.valueOf(objectArray[i]));
        }
        return stringBuffer.append(']').toString();
    }

    public static Date getSignatureTime(SignerInformation signerInformation) {
        Attribute attribute;
        AttributeTable attributeTable = signerInformation.getSignedAttributes();
        Date date = null;
        if (attributeTable != null && (attribute = attributeTable.get(CMSAttributes.signingTime)) != null) {
            Time time = Time.getInstance(attribute.getAttrValues().getObjectAt(0).toASN1Primitive());
            date = time.getDate();
        }
        return date;
    }

    private static List findCerts(List list, X509CertSelector x509CertSelector) throws CertStoreException {
        ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>();
        for (CertStore certStore : list) {
            Collection<? extends Certificate> collection = certStore.getCertificates(x509CertSelector);
            if (collection.isEmpty() && x509CertSelector.getSubjectKeyIdentifier() != null) {
                X509CertSelector x509CertSelector2 = (X509CertSelector)x509CertSelector.clone();
                x509CertSelector2.setSubjectKeyIdentifier(null);
                collection = certStore.getCertificates(x509CertSelector2);
            }
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    private static X509Certificate findNextCert(List list, X509CertSelector x509CertSelector, Set set) throws CertStoreException {
        Iterator iterator = SignedMailValidator.findCerts(list, x509CertSelector).iterator();
        boolean bl = false;
        X509Certificate x509Certificate = null;
        while (iterator.hasNext()) {
            x509Certificate = (X509Certificate)iterator.next();
            if (set.contains(x509Certificate)) continue;
            bl = true;
            break;
        }
        return bl ? x509Certificate : null;
    }

    public static CertPath createCertPath(X509Certificate x509Certificate, Set set, List list) throws GeneralSecurityException {
        Object[] objectArray = SignedMailValidator.createCertPath(x509Certificate, set, list, null);
        return (CertPath)objectArray[0];
    }

    public static Object[] createCertPath(X509Certificate x509Certificate, Set set, List list, List list2) throws GeneralSecurityException {
        Object object;
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        X509Certificate x509Certificate2 = x509Certificate;
        linkedHashSet.add(x509Certificate2);
        arrayList.add(new Boolean(true));
        boolean bl = false;
        Object object2 = null;
        while (x509Certificate2 != null && !bl) {
            Object object3;
            Object object42;
            for (Object object42 : set) {
                object3 = ((TrustAnchor)object42).getTrustedCert();
                if (object3 != null) {
                    if (!((X509Certificate)object3).getSubjectX500Principal().equals(x509Certificate2.getIssuerX500Principal())) continue;
                    try {
                        x509Certificate2.verify(((Certificate)object3).getPublicKey(), "BC");
                        bl = true;
                        object2 = object3;
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (!((TrustAnchor)object42).getCAName().equals(x509Certificate2.getIssuerX500Principal().getName())) continue;
                try {
                    x509Certificate2.verify(((TrustAnchor)object42).getCAPublicKey(), "BC");
                    bl = true;
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (bl) continue;
            object42 = new X509CertSelector();
            try {
                ((X509CertSelector)object42).setSubject(x509Certificate2.getIssuerX500Principal().getEncoded());
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException.toString());
            }
            object3 = x509Certificate2.getExtensionValue(Extension.authorityKeyIdentifier.getId());
            if (object3 != null) {
                try {
                    AuthorityKeyIdentifier authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance(SignedMailValidator.getObject((byte[])object3));
                    if (authorityKeyIdentifier.getKeyIdentifier() != null) {
                        ((X509CertSelector)object42).setSubjectKeyIdentifier(new DEROctetString(authorityKeyIdentifier.getKeyIdentifier()).getEncoded("DER"));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            boolean bl2 = false;
            x509Certificate2 = SignedMailValidator.findNextCert(list, (X509CertSelector)object42, linkedHashSet);
            if (x509Certificate2 == null && list2 != null) {
                bl2 = true;
                x509Certificate2 = SignedMailValidator.findNextCert(list2, (X509CertSelector)object42, linkedHashSet);
            }
            if (x509Certificate2 == null) continue;
            linkedHashSet.add(x509Certificate2);
            arrayList.add(new Boolean(bl2));
        }
        if (bl) {
            if (object2 != null && ((X509Certificate)object2).getSubjectX500Principal().equals(((X509Certificate)object2).getIssuerX500Principal())) {
                linkedHashSet.add(object2);
                arrayList.add(new Boolean(false));
            } else {
                object = new X509CertSelector();
                try {
                    ((X509CertSelector)object).setSubject(x509Certificate2.getIssuerX500Principal().getEncoded());
                    ((X509CertSelector)object).setIssuer(x509Certificate2.getIssuerX500Principal().getEncoded());
                }
                catch (IOException iOException) {
                    throw new IllegalStateException(iOException.toString());
                }
                boolean bl3 = false;
                object2 = SignedMailValidator.findNextCert(list, (X509CertSelector)object, linkedHashSet);
                if (object2 == null && list2 != null) {
                    bl3 = true;
                    object2 = SignedMailValidator.findNextCert(list2, (X509CertSelector)object, linkedHashSet);
                }
                if (object2 != null) {
                    try {
                        x509Certificate2.verify(((Certificate)object2).getPublicKey(), "BC");
                        linkedHashSet.add(object2);
                        arrayList.add(new Boolean(bl3));
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        // empty catch block
                    }
                }
            }
        }
        object = CertificateFactory.getInstance("X.509", "BC").generateCertPath(new ArrayList(linkedHashSet));
        return new Object[]{object, arrayList};
    }

    public CertStore getCertsAndCRLs() {
        return this.certs;
    }

    public SignerInformationStore getSignerInformationStore() {
        return this.signers;
    }

    public ValidationResult getValidationResult(SignerInformation signerInformation) throws SignedMailValidatorException {
        if (this.signers.getSigners(signerInformation.getSID()).isEmpty()) {
            ErrorBundle errorBundle = SignedMailValidator.createErrorBundle("SignedMailValidator.wrongSigner");
            throw new SignedMailValidatorException(errorBundle);
        }
        return (ValidationResult)this.results.get(signerInformation);
    }

    private static TBSCertificate getTBSCert(X509Certificate x509Certificate) throws CertificateEncodingException {
        return TBSCertificate.getInstance(x509Certificate.getTBSCertificate());
    }

    private static ErrorBundle createErrorBundle(String string) {
        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, string);
        errorBundle.setClassLoader(SignedMailValidator.class.getClassLoader());
        return errorBundle;
    }

    private static ErrorBundle createErrorBundle(String string, Object[] objectArray) {
        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, string, objectArray);
        errorBundle.setClassLoader(SignedMailValidator.class.getClassLoader());
        return errorBundle;
    }

    public static class ValidationResult {
        private PKIXCertPathReviewer review;
        private List errors;
        private List notifications;
        private List userProvidedCerts;
        private boolean signVerified;

        ValidationResult(PKIXCertPathReviewer pKIXCertPathReviewer, boolean bl, List list, List list2, List list3) {
            this.review = pKIXCertPathReviewer;
            this.errors = list;
            this.notifications = list2;
            this.signVerified = bl;
            this.userProvidedCerts = list3;
        }

        public List getErrors() {
            return this.errors;
        }

        public List getNotifications() {
            return this.notifications;
        }

        public PKIXCertPathReviewer getCertPathReview() {
            return this.review;
        }

        public CertPath getCertPath() {
            return this.review != null ? this.review.getCertPath() : null;
        }

        public List getUserProvidedCerts() {
            return this.userProvidedCerts;
        }

        public boolean isVerifiedSignature() {
            return this.signVerified;
        }

        public boolean isValidSignature() {
            if (this.review != null) {
                return this.signVerified && this.review.isValidCertPath() && this.errors.isEmpty();
            }
            return false;
        }
    }
}

