/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.pdfparser.COSParser;

class PDFEncodedStringDecoder {
    private static final String[] PDF_ENCODING_BOMS = new String[]{"\\376\\377", "\\377\\376", "\\357\\273\\277"};

    PDFEncodedStringDecoder() {
    }

    static boolean shouldDecode(String s) {
        if (s == null || s.length() < 8) {
            return false;
        }
        for (String BOM2 : PDF_ENCODING_BOMS) {
            if (!s.startsWith(BOM2)) continue;
            return true;
        }
        return false;
    }

    String decode(String value) {
        try {
            byte[] bytes = new String("(" + value + ")").getBytes(StandardCharsets.ISO_8859_1);
            UnsynchronizedByteArrayInputStream is = new UnsynchronizedByteArrayInputStream(bytes);
            COSStringParser p = new COSStringParser(new RandomAccessBuffer(is));
            String parsed = p.myParseCOSString();
            if (parsed != null) {
                return parsed;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }

    static class COSStringParser
    extends COSParser {
        COSStringParser(RandomAccessRead buffer) throws IOException {
            super(buffer);
        }

        String myParseCOSString() {
            try {
                COSString cosString = this.parseCOSString();
                if (cosString != null) {
                    return cosString.getString();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }
}

