/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.poi.hdgf.extractor.VisioTextExtractor;
import org.apache.poi.hpbf.extractor.PublisherTextExtractor;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.poifs.macros.VBAMacroReader;
import org.apache.poi.util.LocaleUtil;
import org.apache.tika.detect.microsoft.POIFSContainerDetector;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.microsoft.AbstractOfficeParser;
import org.apache.tika.parser.microsoft.ExcelExtractor;
import org.apache.tika.parser.microsoft.HSLFExtractor;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.parser.microsoft.OutlookExtractor;
import org.apache.tika.parser.microsoft.SummaryExtractor;
import org.apache.tika.parser.microsoft.WordExtractor;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OfficeParser
extends AbstractOfficeParser {
    private static final long serialVersionUID = 7393462244028653479L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(POIFSDocumentType.access$000(POIFSDocumentType.WORKBOOK), POIFSDocumentType.access$000(POIFSDocumentType.OLE10_NATIVE), POIFSDocumentType.access$000(POIFSDocumentType.WORDDOCUMENT), POIFSDocumentType.access$000(POIFSDocumentType.UNKNOWN), POIFSDocumentType.access$000(POIFSDocumentType.ENCRYPTED), POIFSDocumentType.access$000(POIFSDocumentType.DRMENCRYPTED), POIFSDocumentType.access$000(POIFSDocumentType.POWERPOINT), POIFSDocumentType.access$000(POIFSDocumentType.PUBLISHER), POIFSDocumentType.access$000(POIFSDocumentType.PROJECT), POIFSDocumentType.access$000(POIFSDocumentType.VISIO), POIFSDocumentType.access$000(POIFSDocumentType.XLR), POIFSDocumentType.access$000(POIFSDocumentType.OUTLOOK), POIFSDocumentType.access$000(POIFSDocumentType.SOLIDWORKS_PART), POIFSDocumentType.access$000(POIFSDocumentType.SOLIDWORKS_ASSEMBLY), POIFSDocumentType.access$000(POIFSDocumentType.SOLIDWORKS_DRAWING))));

    public static void extractMacros(POIFSFileSystem fs, ContentHandler xhtml, EmbeddedDocumentExtractor embeddedDocumentExtractor) throws IOException, SAXException {
        Map<String, String> macros = null;
        try {
            VBAMacroReader reader = new VBAMacroReader(fs);
            macros = reader.readMacros();
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            Metadata m = new Metadata();
            m.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.MACRO.toString());
            m.set("Content-Type", "text/x-vbasic");
            EmbeddedDocumentUtil.recordException(e, m);
            if (embeddedDocumentExtractor.shouldParseEmbedded(m)) {
                embeddedDocumentExtractor.parseEmbedded(UnsynchronizedByteArrayInputStream.builder().setByteArray(new byte[]{32}).get(), xhtml, m, true);
            }
            return;
        }
        for (Map.Entry<String, String> e : macros.entrySet()) {
            Metadata m = new Metadata();
            m.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.MACRO.toString());
            m.set("Content-Type", "text/x-vbasic");
            if (!StringUtils.isBlank(e.getKey())) {
                m.set("resourceName", e.getKey());
            }
            if (!embeddedDocumentExtractor.shouldParseEmbedded(m)) continue;
            embeddedDocumentExtractor.parseEmbedded(UnsynchronizedByteArrayInputStream.builder().setByteArray(e.getValue().getBytes(StandardCharsets.UTF_8)).get(), xhtml, m, true);
        }
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        this.configure(context);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        TikaInputStream tstream = TikaInputStream.cast(stream);
        POIFSFileSystem mustCloseFs = null;
        boolean isDirectoryNode = false;
        try {
            DirectoryNode root;
            if (tstream == null) {
                mustCloseFs = new POIFSFileSystem(CloseShieldInputStream.wrap(stream));
                root = mustCloseFs.getRoot();
            } else {
                Object container = tstream.getOpenContainer();
                if (container instanceof POIFSFileSystem) {
                    root = ((POIFSFileSystem)container).getRoot();
                } else if (container instanceof DirectoryNode) {
                    root = (DirectoryNode)container;
                    isDirectoryNode = true;
                } else {
                    POIFSFileSystem fs = null;
                    fs = tstream.hasFile() ? new POIFSFileSystem(tstream.getFile(), true) : new POIFSFileSystem(CloseShieldInputStream.wrap(tstream));
                    tstream.setOpenContainer(fs);
                    root = fs.getRoot();
                }
            }
            this.parse(root, context, metadata, xhtml);
            OfficeParserConfig officeParserConfig = context.get(OfficeParserConfig.class);
            if (officeParserConfig.isExtractMacros() && !isDirectoryNode) {
                OfficeParser.extractMacros(root.getFileSystem(), xhtml, EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(context));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(mustCloseFs);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)mustCloseFs);
        xhtml.endDocument();
    }

    /*
     * Unable to fully structure code
     */
    protected void parse(DirectoryNode root, ParseContext context, Metadata metadata, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        new SummaryExtractor(metadata).parseSummaries(root);
        type = POIFSDocumentType.detectType(root);
        if (type != POIFSDocumentType.UNKNOWN) {
            this.setType(metadata, type.getType());
        }
        switch (1.$SwitchMap$org$apache$tika$parser$microsoft$OfficeParser$POIFSDocumentType[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                publisherTextExtractor = new PublisherTextExtractor(root);
                xhtml.element("p", publisherTextExtractor.getText());
                break;
            }
            case 5: {
                new WordExtractor(context, metadata).parse(root, xhtml);
                break;
            }
            case 6: {
                new HSLFExtractor(context, metadata).parse(root, xhtml);
                break;
            }
            case 7: 
            case 8: {
                locale = context.get(Locale.class, LocaleUtil.getUserLocale());
                new ExcelExtractor(context, metadata).parse(root, xhtml, locale);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                visioTextExtractor = new VisioTextExtractor(root);
                for (String text : visioTextExtractor.getAllText()) {
                    xhtml.element("p", text);
                }
                break;
            }
            case 11: {
                extractor = new OutlookExtractor(root, metadata, context);
                extractor.parse(xhtml);
                break;
            }
            case 12: {
                try {
                    info = new EncryptionInfo(root);
                    d = Decryptor.getInstance(info);
                    password = "VelvetSweatshop";
                    passwordProvider = context.get(PasswordProvider.class);
                    if (passwordProvider != null && (suppliedPassword = passwordProvider.getPassword(metadata)) != null) {
                        password = suppliedPassword;
                    }
                    if (!d.verifyPassword(password)) {
                        throw new EncryptedDocumentException();
                    }
                    parser = new OOXMLParser();
                    tis = TikaInputStream.get(d.getDataStream(root));
                    var16_22 = null;
                    parser.parse(tis, new EmbeddedContentHandler(new BodyContentHandler(xhtml)), metadata, context);
                    if (tis == null) break;
                    if (var16_22 == null) ** GOTO lbl57
                    try {
                        tis.close();
                    }
                    catch (Throwable var17_23) {
                        var16_22.addSuppressed(var17_23);
                    }
                    break;
lbl57:
                    // 1 sources

                    tis.close();
                    ** break;
                    catch (Throwable var17_24) {
                        try {
                            var16_22 = var17_24;
                            throw var17_24;
                        }
                        catch (Throwable var18_25) {
                            if (tis != null) {
                                if (var16_22 != null) {
                                    try {
                                        tis.close();
                                    }
                                    catch (Throwable var19_26) {
                                        var16_22.addSuppressed(var19_26);
                                    }
                                } else {
                                    tis.close();
                                }
                            }
                            throw var18_25;
lbl74:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (GeneralSecurityException ex) {
                    throw new EncryptedDocumentException(ex);
                }
                catch (FileNotFoundException ex) {
                    throw new EncryptedDocumentException(ex);
                }
            }
            case 13: {
                throw new EncryptedDocumentException("DRM encrypted document is not yet supported by Apache POI");
            }
            default: {
                if (!root.hasEntry("EncryptedPackage")) break;
                throw new EncryptedDocumentException("OLE2 file with an unrecognized EncryptedPackage entry");
            }
        }
    }

    private void setType(Metadata metadata, MediaType type) {
        metadata.set("Content-Type", type.toString());
    }

    public static Entry getUCEntry(DirectoryEntry root, String ucTarget) {
        Iterator<Entry> it = root.getEntries();
        while (it.hasNext()) {
            Entry e = it.next();
            if (!e.getName().toUpperCase(Locale.US).equals(ucTarget)) continue;
            return e;
        }
        return null;
    }

    public static enum POIFSDocumentType {
        WORKBOOK("xls", MediaType.application("vnd.ms-excel")),
        OLE10_NATIVE("ole", POIFSContainerDetector.OLE10_NATIVE),
        COMP_OBJ("ole", POIFSContainerDetector.COMP_OBJ),
        WORDDOCUMENT("doc", MediaType.application("msword")),
        UNKNOWN("unknown", MediaType.application("x-tika-msoffice")),
        DRMENCRYPTED("ole", MediaType.application("x-tika-ole-drm-encrypted")),
        ENCRYPTED("ole", MediaType.application("x-tika-ooxml-protected")),
        POWERPOINT("ppt", MediaType.application("vnd.ms-powerpoint")),
        PUBLISHER("pub", MediaType.application("x-mspublisher")),
        PROJECT("mpp", MediaType.application("vnd.ms-project")),
        VISIO("vsd", MediaType.application("vnd.visio")),
        WORKS("wps", MediaType.application("vnd.ms-works")),
        XLR("xlr", MediaType.application("x-tika-msworks-spreadsheet")),
        OUTLOOK("msg", MediaType.application("vnd.ms-outlook")),
        SOLIDWORKS_PART("sldprt", MediaType.application("sldworks")),
        SOLIDWORKS_ASSEMBLY("sldasm", MediaType.application("sldworks")),
        SOLIDWORKS_DRAWING("slddrw", MediaType.application("sldworks")),
        GRAPH("", MediaType.application("vnd.ms-graph"));

        static Map<MediaType, POIFSDocumentType> TYPE_MAP;
        private final String extension;
        private final MediaType type;

        private POIFSDocumentType(String extension, MediaType type) {
            this.extension = extension;
            this.type = type;
        }

        public static POIFSDocumentType detectType(POIFSFileSystem fs) {
            return POIFSDocumentType.detectType(fs.getRoot());
        }

        public static POIFSDocumentType detectType(DirectoryEntry node) {
            HashSet<String> names = new HashSet<String>();
            for (Entry entry : node) {
                names.add(entry.getName());
            }
            MediaType type = POIFSContainerDetector.detect(names, node);
            if (TYPE_MAP.containsKey(type)) {
                return TYPE_MAP.get(type);
            }
            return UNKNOWN;
        }

        public String getExtension() {
            return this.extension;
        }

        public MediaType getType() {
            return this.type;
        }

        static /* synthetic */ MediaType access$000(POIFSDocumentType x0) {
            return x0.type;
        }

        static {
            TYPE_MAP = new HashMap<MediaType, POIFSDocumentType>();
            for (POIFSDocumentType t : POIFSDocumentType.values()) {
                TYPE_MAP.put(t.type, t);
            }
        }
    }
}

