/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class GZipSpecializationDetector
implements Detector {
    public static MediaType GZ = MediaType.application("gzip");
    public static MediaType WARC_GZ = MediaType.application("warc+gz");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        input.mark(2);
        byte[] firstTwo = new byte[2];
        try {
            IOUtils.readFully(input, firstTwo);
        }
        finally {
            input.reset();
        }
        int magic = (firstTwo[1] & 0xFF) << 8 | firstTwo[0] & 0xFF;
        if (35615 != magic) {
            return MediaType.OCTET_STREAM;
        }
        return this.detectSpecialization(input, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaType detectSpecialization(InputStream input, Metadata metadata) throws IOException {
        int buffSize = 1024;
        UnsynchronizedByteArrayOutputStream gzippedBytes = UnsynchronizedByteArrayOutputStream.builder().get();
        try {
            org.apache.commons.io.IOUtils.copyLarge(input, gzippedBytes, 0L, (long)buffSize);
        }
        catch (IOException iOException) {
        }
        finally {
            input.reset();
        }
        UnsynchronizedByteArrayOutputStream bytes = UnsynchronizedByteArrayOutputStream.builder().get();
        try (GzipCompressorInputStream is2 = new GzipCompressorInputStream(UnsynchronizedByteArrayInputStream.builder().setByteArray(gzippedBytes.toByteArray()).get());){
            int c = ((InputStream)is2).read();
            while (c > -1) {
                bytes.write(c);
                c = ((InputStream)is2).read();
            }
        }
        catch (IOException is2) {
            // empty catch block
        }
        String s = new String(bytes.toByteArray(), StandardCharsets.UTF_8);
        if (s.startsWith("WARC/")) {
            return WARC_GZ;
        }
        return GZ;
    }
}

