/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.noaa;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayScalar;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.unidata.io.RandomAccessFile;

public class StructureDataRegexp
extends StructureData {
    protected Matcher matcher;

    public StructureDataRegexp(StructureMembers members, Matcher m4) {
        super(members);
        this.matcher = m4;
    }

    protected Object parse(DataType dt, VinfoField vinfo) throws NumberFormatException {
        return this.parse(dt, vinfo, vinfo.fldno);
    }

    protected Object parse(DataType dt, VinfoField vinfo, int fldno) throws NumberFormatException {
        String svalue = fldno <= this.matcher.groupCount() ? this.matcher.group(fldno) : " ";
        if (dt == DataType.STRING) {
            return svalue.trim();
        }
        if (dt == DataType.CHAR) {
            return svalue;
        }
        try {
            boolean isBlank;
            svalue = svalue.trim();
            boolean bl = isBlank = svalue.length() == 0;
            if (dt == DataType.DOUBLE) {
                return isBlank ? 0.0 : new Double(svalue);
            }
            if (dt == DataType.FLOAT) {
                float result = isBlank ? 0.0f : new Float(svalue).floatValue();
                return Float.valueOf(vinfo.hasScale ? result * vinfo.scale : result);
            }
            if (dt == DataType.INT) {
                return isBlank ? 0 : new Integer(svalue);
            }
            if (dt == DataType.LONG) {
                return isBlank ? 0L : new Long(svalue);
            }
        }
        catch (NumberFormatException e) {
            System.out.printf("  %d = <%s> %n", fldno, svalue);
            throw e;
        }
        return null;
    }

    @Override
    public Array getArray(StructureMembers.Member m4) {
        VinfoField f = (VinfoField)m4.getDataObject();
        if (m4.getDataType() == DataType.STRING) {
            String result = this.matcher.group(f.fldno);
            return new ArrayObject(String.class, new int[0], new Object[]{result.trim()});
        }
        if (m4.getDataType() == DataType.SEQUENCE) {
            return this.getArraySequence(m4);
        }
        if (!m4.isScalar()) {
            if (m4.getDataType() == DataType.FLOAT) {
                float[] ja = this.getJavaArrayFloat(m4);
                return Array.factory(DataType.FLOAT, m4.getShape(), (Object)ja);
            }
            if (m4.getDataType() == DataType.CHAR) {
                char[] ja = this.getJavaArrayChar(m4);
                return Array.factory(DataType.CHAR, m4.getShape(), (Object)ja);
            }
            if (m4.getDataType() == DataType.BYTE) {
                byte[] ja = this.getJavaArrayByte(m4);
                return Array.factory(DataType.BYTE, m4.getShape(), (Object)ja);
            }
        }
        Object result = this.parse(m4.getDataType(), f);
        if (m4.getDataType() == DataType.CHAR) {
            return new ArrayChar((String)result);
        }
        return new ArrayScalar(result);
    }

    @Override
    public float convertScalarFloat(StructureMembers.Member m4) {
        VinfoField f = (VinfoField)m4.getDataObject();
        return ((Number)this.parse(m4.getDataType(), f)).floatValue();
    }

    @Override
    public double convertScalarDouble(StructureMembers.Member m4) {
        VinfoField f = (VinfoField)m4.getDataObject();
        return ((Number)this.parse(m4.getDataType(), f)).doubleValue();
    }

    @Override
    public int convertScalarInt(StructureMembers.Member m4) {
        VinfoField f = (VinfoField)m4.getDataObject();
        return ((Number)this.parse(m4.getDataType(), f)).intValue();
    }

    @Override
    public long convertScalarLong(StructureMembers.Member m4) {
        VinfoField f = (VinfoField)m4.getDataObject();
        return ((Number)this.parse(m4.getDataType(), f)).longValue();
    }

    @Override
    public double getScalarDouble(StructureMembers.Member m4) {
        VinfoField f = (VinfoField)m4.getDataObject();
        return (Double)this.parse(m4.getDataType(), f);
    }

    @Override
    public double[] getJavaArrayDouble(StructureMembers.Member m4) {
        return new double[0];
    }

    @Override
    public float getScalarFloat(StructureMembers.Member m4) {
        VinfoField f = (VinfoField)m4.getDataObject();
        Object result = this.parse(m4.getDataType(), f);
        return result instanceof Float ? ((Float)result).floatValue() : ((Double)result).floatValue();
    }

    @Override
    public float[] getJavaArrayFloat(StructureMembers.Member m4) {
        int n = m4.getSize();
        float[] result = new float[n];
        VinfoField f = (VinfoField)m4.getDataObject();
        for (int i = 0; i < n; ++i) {
            result[i] = ((Float)this.parse(m4.getDataType(), f, f.fldno + f.stride * i)).floatValue();
        }
        return result;
    }

    @Override
    public byte getScalarByte(StructureMembers.Member m4) {
        VinfoField f = (VinfoField)m4.getDataObject();
        return (Byte)this.parse(m4.getDataType(), f);
    }

    @Override
    public byte[] getJavaArrayByte(StructureMembers.Member m4) {
        int n = m4.getSize();
        byte[] result = new byte[n];
        VinfoField f = (VinfoField)m4.getDataObject();
        for (int i = 0; i < n; ++i) {
            String s2 = (String)this.parse(m4.getDataType(), f, f.fldno + f.stride * i);
            result[i] = (byte)s2.charAt(0);
        }
        return result;
    }

    @Override
    public int getScalarInt(StructureMembers.Member m4) {
        VinfoField f = (VinfoField)m4.getDataObject();
        return (Integer)this.parse(m4.getDataType(), f);
    }

    @Override
    public int[] getJavaArrayInt(StructureMembers.Member m4) {
        return new int[0];
    }

    @Override
    public short getScalarShort(StructureMembers.Member m4) {
        VinfoField f = (VinfoField)m4.getDataObject();
        return (Short)this.parse(m4.getDataType(), f);
    }

    @Override
    public short[] getJavaArrayShort(StructureMembers.Member m4) {
        return new short[0];
    }

    @Override
    public long getScalarLong(StructureMembers.Member m4) {
        VinfoField f = (VinfoField)m4.getDataObject();
        return (Long)this.parse(m4.getDataType(), f);
    }

    @Override
    public long[] getJavaArrayLong(StructureMembers.Member m4) {
        return new long[0];
    }

    @Override
    public char getScalarChar(StructureMembers.Member m4) {
        VinfoField f = (VinfoField)m4.getDataObject();
        String result = (String)this.parse(m4.getDataType(), f);
        return result.charAt(0);
    }

    @Override
    public char[] getJavaArrayChar(StructureMembers.Member m4) {
        int n = m4.getSize();
        char[] result = new char[n];
        VinfoField f = (VinfoField)m4.getDataObject();
        for (int i = 0; i < n; ++i) {
            String s2 = (String)this.parse(m4.getDataType(), f, f.fldno + f.stride * i);
            result[i] = s2.charAt(0);
        }
        return result;
    }

    @Override
    public String getScalarString(StructureMembers.Member m4) {
        VinfoField f = (VinfoField)m4.getDataObject();
        return (String)this.parse(m4.getDataType(), f);
    }

    @Override
    public String[] getJavaArrayString(StructureMembers.Member m4) {
        return new String[]{this.getScalarString(m4)};
    }

    @Override
    public StructureData getScalarStructure(StructureMembers.Member m4) {
        return null;
    }

    @Override
    public ArrayStructure getArrayStructure(StructureMembers.Member m4) {
        return null;
    }

    @Override
    public ArraySequence getArraySequence(StructureMembers.Member m4) {
        return null;
    }

    public static class VinfoField {
        int fldno;
        int stride = 4;
        float scale;
        boolean hasScale;

        public VinfoField(int fldno) {
            this.fldno = fldno;
        }
    }

    public static class Vinfo {
        RandomAccessFile rafile;
        StructureMembers sm;
        Pattern p;
        int nelems = -1;

        public Vinfo(RandomAccessFile raff, StructureMembers sm, Pattern p) {
            this.sm = sm;
            this.rafile = raff;
            this.p = p;
        }
    }
}

