/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import net.jcip.annotations.Immutable;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateBuilderImpl;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.util.Indent;

@Immutable
public class CoordinateRuntime
implements Coordinate {
    final List<CalendarDate> runtimeSorted;
    final CalendarDate firstDate;
    CalendarPeriod timeUnit = CalendarPeriod.Hour;
    String name = "reftime";
    String periodName;

    public CoordinateRuntime(List<CalendarDate> runtimeSorted, CalendarPeriod timeUnit) {
        this.runtimeSorted = Collections.unmodifiableList(runtimeSorted);
        this.firstDate = runtimeSorted.get(0);
        this.timeUnit = timeUnit == null ? CalendarPeriod.Hour : timeUnit;
        CalendarPeriod.Field cf = this.timeUnit.getField();
        this.periodName = cf == CalendarPeriod.Field.Month || cf == CalendarPeriod.Field.Year ? "calendar " + cf.toString() : cf.toString();
    }

    public CalendarPeriod getTimeUnits() {
        return this.timeUnit;
    }

    public List<CalendarDate> getRuntimesSorted() {
        return this.runtimeSorted;
    }

    public List<Double> getOffsetsInTimeUnits() {
        ArrayList<Double> result = new ArrayList<Double>(this.runtimeSorted.size());
        for (CalendarDate cd2 : this.runtimeSorted) {
            double msecs = cd2.getDifferenceInMsecs(this.firstDate);
            result.add(msecs / this.timeUnit.getValueInMillisecs());
        }
        return result;
    }

    @Override
    public int getSize() {
        return this.runtimeSorted.size();
    }

    @Override
    public Coordinate.Type getType() {
        return Coordinate.Type.runtime;
    }

    @Override
    public String getUnit() {
        return this.periodName + " since " + this.firstDate.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getCode() {
        return 0;
    }

    public CalendarDate getFirstDate() {
        return this.firstDate;
    }

    public CalendarDate getLastDate() {
        return this.runtimeSorted.get(this.getSize() - 1);
    }

    public CalendarDate getDate(int idx) {
        return this.runtimeSorted.get(idx);
    }

    @Override
    public List<? extends Object> getValues() {
        return this.runtimeSorted;
    }

    @Override
    public int getIndex(Object val) {
        return Collections.binarySearch(this.runtimeSorted, (CalendarDate)val);
    }

    @Override
    public Object getValue(int idx) {
        return this.runtimeSorted.get(idx);
    }

    @Override
    public void showInfo(Formatter info, Indent indent) {
        info.format("%s%s:", new Object[]{indent, this.getType()});
        for (CalendarDate cd2 : this.runtimeSorted) {
            info.format(" %s,", cd2);
        }
        info.format(" (%d) %n", this.runtimeSorted.size());
    }

    @Override
    public void showCoords(Formatter info) {
        info.format("Run Times: %s (%s)%n", this.getName(), this.getUnit());
        List<Double> udunits = this.getOffsetsInTimeUnits();
        int count = 0;
        for (CalendarDate cd2 : this.runtimeSorted) {
            info.format("   %s (%f)%n", cd2, udunits.get(count++));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateRuntime that = (CoordinateRuntime)o;
        return this.runtimeSorted.equals(that.runtimeSorted);
    }

    public int hashCode() {
        return this.runtimeSorted.hashCode();
    }

    public static class Builder1
    extends CoordinateBuilderImpl<Grib1Record> {
        CalendarPeriod timeUnit;

        public Builder1(CalendarPeriod timeUnit) {
            this.timeUnit = timeUnit;
        }

        @Override
        public Object extract(Grib1Record gr) {
            return gr.getReferenceDate();
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            ArrayList<CalendarDate> runtimeSorted = new ArrayList<CalendarDate>(values.size());
            for (Object val : values) {
                runtimeSorted.add((CalendarDate)val);
            }
            Collections.sort(runtimeSorted);
            return new CoordinateRuntime(runtimeSorted, this.timeUnit);
        }
    }

    public static class Builder2
    extends CoordinateBuilderImpl<Grib2Record> {
        CalendarPeriod timeUnit;

        public Builder2(CalendarPeriod timeUnit) {
            this.timeUnit = timeUnit;
        }

        @Override
        public Object extract(Grib2Record gr) {
            return gr.getReferenceDate();
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            ArrayList<CalendarDate> runtimeSorted = new ArrayList<CalendarDate>(values.size());
            for (Object val : values) {
                runtimeSorted.add((CalendarDate)val);
            }
            Collections.sort(runtimeSorted);
            return new CoordinateRuntime(runtimeSorted, this.timeUnit);
        }
    }
}

