/*
 * Decompiled with CFR 0.152.
 */
package ucar.atd.dorade;

import java.io.RandomAccessFile;
import ucar.atd.dorade.DoradeDescriptor;
import ucar.atd.dorade.DoradeRADD;
import ucar.atd.dorade.DoradeRDAT;
import ucar.nc2.constants.CDM;

public class DoradePARM
extends DoradeDescriptor {
    public static final float BAD_VALUE = Float.MAX_VALUE;
    private String paramName;
    private String paramDescription;
    private String unitName;
    private short usedPRTs;
    private short usedFrequencies;
    private float rcvrBandwidth;
    private short pulseWidth;
    private short polarization;
    private short nSamples;
    private short binaryFormat;
    public static final int FORMAT_8BIT_INT = 1;
    public static final int FORMAT_16BIT_INT = 2;
    public static final int FORMAT_32BIT_INT = 3;
    public static final int FORMAT_32BIT_FLOAT = 4;
    public static final int FORMAT_16BIT_FLOAT = 5;
    private String thresholdParamName;
    private float thresholdValue;
    private float scale;
    private float bias;
    private int badDataFlag;
    private DoradeRADD myRADD;

    public DoradePARM(RandomAccessFile file, boolean littleEndianData, DoradeRADD radd) throws DoradeDescriptor.DescriptorException {
        byte[] data = this.readDescriptor(file, littleEndianData, "PARM");
        this.myRADD = radd;
        this.paramName = new String(data, 8, 8, CDM.utf8Charset).trim();
        this.paramDescription = new String(data, 16, 40, CDM.utf8Charset).trim();
        this.unitName = new String(data, 56, 8, CDM.utf8Charset).trim();
        this.usedPRTs = this.grabShort(data, 64);
        this.usedFrequencies = this.grabShort(data, 66);
        this.rcvrBandwidth = this.grabFloat(data, 68);
        this.pulseWidth = this.grabShort(data, 72);
        this.polarization = this.grabShort(data, 74);
        this.nSamples = this.grabShort(data, 76);
        this.binaryFormat = this.grabShort(data, 78);
        this.thresholdParamName = new String(data, 80, 8, CDM.utf8Charset).trim();
        this.thresholdValue = this.grabFloat(data, 88);
        this.scale = this.grabFloat(data, 92);
        this.bias = this.grabFloat(data, 96);
        this.badDataFlag = this.grabInt(data, 100);
        if (this.verbose) {
            System.out.println(this);
        }
    }

    public String toString() {
        String s2 = "PARM\n";
        s2 = s2 + "  param name: " + this.paramName + "\n";
        s2 = s2 + "  param description: " + this.paramDescription + "\n";
        s2 = s2 + "  unit name: " + this.unitName + "\n";
        s2 = s2 + "  used PRTs: " + this.usedPRTs + "\n";
        s2 = s2 + "  used frequencies: " + this.usedFrequencies + "\n";
        s2 = s2 + "  receiver bandwidth: " + this.rcvrBandwidth + "\n";
        s2 = s2 + "  pulse width: " + this.pulseWidth + "\n";
        s2 = s2 + "  polarization: " + this.polarization + "\n";
        s2 = s2 + "  number of samples: " + this.nSamples + "\n";
        s2 = s2 + "  binary format: " + this.binaryFormat + "\n";
        s2 = s2 + "  threshold parameter: " + this.thresholdParamName + "\n";
        s2 = s2 + "  threshold value: " + this.thresholdValue + "\n";
        s2 = s2 + "  scale: " + this.scale + "\n";
        s2 = s2 + "  bias: " + this.bias + "\n";
        s2 = s2 + "  bad data flag: " + this.badDataFlag;
        return s2;
    }

    public String getName() {
        return this.paramName;
    }

    public int getBadDataFlag() {
        return this.badDataFlag;
    }

    public float getThresholdValue() {
        return this.thresholdValue;
    }

    public int getPolarization() {
        return this.polarization;
    }

    public float getScale() {
        return this.scale;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public int getusedPRTs() {
        return this.usedPRTs;
    }

    public int getusedFrequencies() {
        return this.usedFrequencies;
    }

    public int getnSamples() {
        return this.nSamples;
    }

    public String getthresholdParamName() {
        return this.thresholdParamName;
    }

    public String getUnits() {
        return this.unitName;
    }

    public String getDescription() {
        return this.paramDescription;
    }

    public int getBinaryFormat() {
        return this.binaryFormat;
    }

    public int getNCells() {
        return this.myRADD.getNCells();
    }

    public float getCellSpacing() throws DoradeDescriptor.DescriptorException {
        return this.myRADD.getCellSpacing();
    }

    public float[] getParamValues(DoradeRDAT rdat) throws DoradeDescriptor.DescriptorException {
        return this.getParamValues(rdat, null);
    }

    public float[] getParamValues(DoradeRDAT rdat, float[] workingArray) throws DoradeDescriptor.DescriptorException {
        if (!this.paramName.equals(rdat.getParamName())) {
            throw new DoradeDescriptor.DescriptorException("parameter name mismatch");
        }
        byte[] paramData = rdat.getRawData();
        int nCells = this.myRADD.getNCells();
        float[] values = workingArray != null && workingArray.length == nCells ? workingArray : new float[nCells];
        short[] svalues = null;
        if (this.myRADD.getCompressionScheme() == 1) {
            if (this.binaryFormat != 2) {
                throw new DoradeDescriptor.DescriptorException("Cannot unpack compressed data with binary format " + this.binaryFormat);
            }
            svalues = this.uncompressHRD(paramData, nCells);
        }
        block7: for (int cell = 0; cell < nCells; ++cell) {
            switch (this.binaryFormat) {
                case 1: {
                    byte bval = paramData[cell];
                    values[cell] = bval == this.badDataFlag ? Float.MAX_VALUE : ((float)bval - this.bias) / this.scale;
                    continue block7;
                }
                case 2: {
                    short sval = svalues != null ? svalues[cell] : this.grabShort(paramData, 2 * cell);
                    values[cell] = sval == this.badDataFlag ? Float.MAX_VALUE : ((float)sval - this.bias) / this.scale;
                    continue block7;
                }
                case 3: {
                    int ival = this.grabInt(paramData, 4 * cell);
                    values[cell] = ival == this.badDataFlag ? Float.MAX_VALUE : ((float)ival - this.bias) / this.scale;
                    continue block7;
                }
                case 4: {
                    float fval = this.grabFloat(paramData, 4 * cell);
                    values[cell] = fval == (float)this.badDataFlag ? Float.MAX_VALUE : (fval - this.bias) / this.scale;
                    continue block7;
                }
                case 5: {
                    throw new DoradeDescriptor.DescriptorException("can't unpack 16-bit float data yet");
                }
                default: {
                    throw new DoradeDescriptor.DescriptorException("bad binary format (" + this.binaryFormat + ")");
                }
            }
        }
        return values;
    }

    private short[] uncompressHRD(byte[] compressedData, int nCells) throws DoradeDescriptor.DescriptorException {
        short[] svalues = new short[nCells];
        int cPos = 0;
        int nextCell = 0;
        while (true) {
            short runDescriptor = this.grabShort(compressedData, cPos);
            cPos += 2;
            boolean runHasGoodValues = (runDescriptor & 0x8000) != 0;
            int runLength = runDescriptor & Short.MAX_VALUE;
            if (runLength == 1) break;
            if (nextCell + runLength > nCells) {
                throw new DoradeDescriptor.DescriptorException("attempt to unpack too many cells");
            }
            for (int cell = nextCell; cell < nextCell + runLength; ++cell) {
                if (runHasGoodValues) {
                    svalues[cell] = this.grabShort(compressedData, cPos);
                    cPos += 2;
                    continue;
                }
                svalues[cell] = (short)this.badDataFlag;
            }
            nextCell += runLength;
        }
        for (int cell = nextCell; cell < nCells; ++cell) {
            svalues[cell] = (short)this.badDataFlag;
        }
        return svalues;
    }
}

