/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.hdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;

public class HDFParser
extends AbstractParser {
    private static final long serialVersionUID = 1091208208003437549L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"x-hdf"));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        UnsynchronizedByteArrayOutputStream os = UnsynchronizedByteArrayOutputStream.builder().get();
        IOUtils.copy(stream, (OutputStream)os);
        String name = metadata.get("resourceName");
        if (name == null) {
            name = "";
        }
        try {
            NetcdfFile ncFile = NetcdfFile.openInMemory(name, os.toByteArray());
            this.unravelStringMet(ncFile, null, metadata);
        }
        catch (IOException e) {
            throw new TikaException("HDF parse error", (Throwable)e);
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.endDocument();
    }

    protected void unravelStringMet(NetcdfFile ncFile, Group group, Metadata met) {
        if (group == null) {
            group = ncFile.getRootGroup();
        }
        met.set("File-Type-Description", ncFile.getFileTypeDescription());
        for (Attribute attribute : group.getAttributes()) {
            if (attribute.isString()) {
                met.add(attribute.getFullName(), attribute.getStringValue());
                continue;
            }
            met.add(attribute.getFullName(), String.valueOf(attribute.getNumericValue()));
        }
        for (Group g2 : group.getGroups()) {
            this.unravelStringMet(ncFile, g2, met);
        }
    }
}

