/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.geoinfo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.util.CheckedArrayList;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.iso.DefaultMetadataScope;
import org.apache.sis.metadata.iso.constraint.DefaultLegalConstraints;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultGeographicDescription;
import org.apache.sis.metadata.iso.identification.DefaultDataIdentification;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.util.collection.CodeListSet;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.DateUtils;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.metadata.distribution.DigitalTransferOptions;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.distribution.Distributor;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.Progress;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.util.InternationalString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class GeographicInformationParser
extends AbstractParser {
    public static final String geoInfoType = "text/iso19139+xml";
    private static final Logger LOG = LoggerFactory.getLogger(GeographicInformationParser.class);
    private final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.text((String)"iso19139+xml"));

    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return this.SUPPORTED_TYPES;
    }

    public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        metadata.set("Content-Type", geoInfoType);
        XHTMLContentHandler xhtmlContentHandler = new XHTMLContentHandler(contentHandler, metadata);
        TemporaryResources tmp = TikaInputStream.isTikaInputStream((InputStream)inputStream) ? null : new TemporaryResources();
        try (TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)inputStream, (TemporaryResources)tmp, (Metadata)metadata);){
            File file = tikaInputStream.getFile();
            try (DataStore dataStore = DataStores.open(file);){
                DefaultMetadata defaultMetadata = new DefaultMetadata(dataStore.getMetadata());
                this.extract(xhtmlContentHandler, metadata, defaultMetadata);
            }
        }
        catch (UnsupportedStorageException e) {
            throw new TikaException("UnsupportedStorageException", (Throwable)e);
        }
        catch (DataStoreException e) {
            throw new TikaException("DataStoreException", (Throwable)e);
        }
        finally {
            if (tmp != null) {
                tmp.dispose();
            }
        }
    }

    private void extract(XHTMLContentHandler xhtmlContentHandler, Metadata metadata, DefaultMetadata defaultMetadata) throws SAXException {
        this.getMetaDataCharacterSet(metadata, defaultMetadata);
        this.getMetaDataContact(metadata, defaultMetadata);
        this.getMetaDataIdentificationInfo(metadata, defaultMetadata);
        this.getMetaDataDistributionInfo(metadata, defaultMetadata);
        this.getMetaDataDateInfo(metadata, defaultMetadata);
        this.getMetaDataResourceScope(metadata, defaultMetadata);
        this.getMetaDataParentMetaDataTitle(metadata, defaultMetadata);
        this.getMetaDataIdetifierCode(metadata, defaultMetadata);
        this.getMetaDataStandard(metadata, defaultMetadata);
        this.extractContent(xhtmlContentHandler, defaultMetadata);
    }

    private void extractContent(XHTMLContentHandler xhtmlContentHandler, DefaultMetadata defaultMetadata) throws SAXException {
        xhtmlContentHandler.startDocument();
        xhtmlContentHandler.newline();
        xhtmlContentHandler.newline();
        ArrayList identifications = (ArrayList)defaultMetadata.getIdentificationInfo();
        for (Identification i : identifications) {
            xhtmlContentHandler.startElement("h1");
            xhtmlContentHandler.characters(i.getCitation().getTitle().toString());
            xhtmlContentHandler.endElement("h1");
            xhtmlContentHandler.newline();
            ArrayList responsiblePartyArrayList = (ArrayList)i.getCitation().getCitedResponsibleParties();
            for (ResponsibleParty r : responsiblePartyArrayList) {
                xhtmlContentHandler.startElement("h3");
                xhtmlContentHandler.newline();
                xhtmlContentHandler.characters("CitedResponsiblePartyRole " + r.getRole().toString());
                xhtmlContentHandler.characters("CitedResponsiblePartyName " + r.getIndividualName());
                xhtmlContentHandler.endElement("h3");
                xhtmlContentHandler.newline();
            }
            xhtmlContentHandler.startElement("p");
            xhtmlContentHandler.newline();
            xhtmlContentHandler.characters("IdentificationInfoAbstract " + i.getAbstract().toString());
            xhtmlContentHandler.endElement("p");
            xhtmlContentHandler.newline();
            Collection<Extent> extentList = ((DefaultDataIdentification)i).getExtents();
            for (Extent e : extentList) {
                ArrayList geoElements = (ArrayList)e.getGeographicElements();
                for (GeographicExtent g2 : geoElements) {
                    if (!(g2 instanceof DefaultGeographicBoundingBox)) continue;
                    xhtmlContentHandler.startElement("tr");
                    xhtmlContentHandler.startElement("td");
                    xhtmlContentHandler.characters("GeographicElementWestBoundLatitude");
                    xhtmlContentHandler.endElement("td");
                    xhtmlContentHandler.startElement("td");
                    xhtmlContentHandler.characters(String.valueOf(((DefaultGeographicBoundingBox)g2).getWestBoundLongitude()));
                    xhtmlContentHandler.endElement("td");
                    xhtmlContentHandler.endElement("tr");
                    xhtmlContentHandler.startElement("tr");
                    xhtmlContentHandler.startElement("td");
                    xhtmlContentHandler.characters("GeographicElementEastBoundLatitude");
                    xhtmlContentHandler.endElement("td");
                    xhtmlContentHandler.startElement("td");
                    xhtmlContentHandler.characters(String.valueOf(((DefaultGeographicBoundingBox)g2).getEastBoundLongitude()));
                    xhtmlContentHandler.endElement("td");
                    xhtmlContentHandler.endElement("tr");
                    xhtmlContentHandler.startElement("tr");
                    xhtmlContentHandler.startElement("td");
                    xhtmlContentHandler.characters("GeographicElementNorthBoundLatitude");
                    xhtmlContentHandler.endElement("td");
                    xhtmlContentHandler.startElement("td");
                    xhtmlContentHandler.characters(String.valueOf(((DefaultGeographicBoundingBox)g2).getNorthBoundLatitude()));
                    xhtmlContentHandler.endElement("td");
                    xhtmlContentHandler.endElement("tr");
                    xhtmlContentHandler.startElement("tr");
                    xhtmlContentHandler.startElement("td");
                    xhtmlContentHandler.characters("GeographicElementSouthBoundLatitude");
                    xhtmlContentHandler.endElement("td");
                    xhtmlContentHandler.startElement("td");
                    xhtmlContentHandler.characters(String.valueOf(((DefaultGeographicBoundingBox)g2).getSouthBoundLatitude()));
                    xhtmlContentHandler.endElement("td");
                    xhtmlContentHandler.endElement("tr");
                }
            }
        }
        xhtmlContentHandler.newline();
        xhtmlContentHandler.endDocument();
    }

    private void getMetaDataCharacterSet(Metadata metadata, DefaultMetadata defaultMetaData) {
        Map<Locale, Charset> charsetMap = defaultMetaData.getLocalesAndCharsets();
        for (Charset c : charsetMap.values()) {
            metadata.add("CharacterSet", c.name());
        }
    }

    private void getMetaDataContact(Metadata metadata, DefaultMetadata defaultMetaData) {
        CheckedArrayList contactSet = (CheckedArrayList)defaultMetaData.getContacts();
        for (ResponsibleParty rparty : contactSet) {
            if (rparty.getRole() != null) {
                metadata.add("ContactRole", rparty.getRole().name());
            }
            if (rparty.getOrganisationName() == null) continue;
            metadata.add("ContactPartyName-", rparty.getOrganisationName().toString());
        }
    }

    private void getMetaDataIdentificationInfo(Metadata metadata, DefaultMetadata defaultMetaData) {
        ArrayList identifications = (ArrayList)defaultMetaData.getIdentificationInfo();
        for (Identification i : identifications) {
            Object k22;
            Object f22;
            Object d22;
            DefaultDataIdentification defaultDataIdentification = (DefaultDataIdentification)i;
            if (i.getCitation() != null && i.getCitation().getTitle() != null) {
                metadata.add("IdentificationInfoCitationTitle ", i.getCitation().getTitle().toString());
            }
            ArrayList dateArrayList = (ArrayList)i.getCitation().getDates();
            for (Object d22 : dateArrayList) {
                if (d22.getDateType() == null) continue;
                String date = DateUtils.formatDate((Date)d22.getDate());
                metadata.add("CitationDate ", d22.getDateType().name() + "-->" + date);
            }
            ArrayList responsiblePartyArrayList = (ArrayList)i.getCitation().getCitedResponsibleParties();
            for (ResponsibleParty r : responsiblePartyArrayList) {
                if (r.getRole() != null) {
                    metadata.add("CitedResponsiblePartyRole ", r.getRole().toString());
                }
                if (r.getIndividualName() != null) {
                    metadata.add("CitedResponsiblePartyName ", r.getIndividualName());
                }
                if (r.getOrganisationName() != null) {
                    metadata.add("CitedResponsiblePartyOrganizationName ", r.getOrganisationName().toString());
                }
                if (r.getPositionName() != null) {
                    metadata.add("CitedResponsiblePartyPositionName ", r.getPositionName().toString());
                }
                if (r.getContactInfo() == null) continue;
                for (String s2 : r.getContactInfo().getAddress().getElectronicMailAddresses()) {
                    metadata.add("CitedResponsiblePartyEMail ", s2);
                }
            }
            if (i.getAbstract() != null) {
                metadata.add("IdentificationInfoAbstract ", i.getAbstract().toString());
            }
            d22 = i.getStatus().iterator();
            while (d22.hasNext()) {
                Progress p = d22.next();
                metadata.add("IdentificationInfoStatus ", p.name());
            }
            ArrayList formatArrayList = (ArrayList)i.getResourceFormats();
            for (Object f22 : formatArrayList) {
                if (f22.getName() == null) continue;
                metadata.add("ResourceFormatSpecificationAlternativeTitle ", f22.getName().toString());
            }
            Map<Locale, Charset> localeCharsetMap = defaultDataIdentification.getLocalesAndCharsets();
            f22 = localeCharsetMap.keySet().iterator();
            while (f22.hasNext()) {
                Locale l = (Locale)f22.next();
                metadata.add("IdentificationInfoLanguage-->", l.getDisplayLanguage(Locale.ENGLISH));
            }
            CodeListSet categoryList = (CodeListSet)defaultDataIdentification.getTopicCategories();
            for (TopicCategory t2 : categoryList) {
                metadata.add("IdentificationInfoTopicCategory-->", t2.name());
            }
            ArrayList keywordList = (ArrayList)i.getDescriptiveKeywords();
            int j = 1;
            for (Object k22 : keywordList) {
                ++j;
                ArrayList stringList = (ArrayList)k22.getKeywords();
                for (InternationalString internationalString : stringList) {
                    metadata.add("Keywords " + j, internationalString.toString());
                }
                if (k22.getType() != null) {
                    metadata.add("KeywordsType " + j, k22.getType().name());
                }
                if (k22.getThesaurusName() != null && k22.getThesaurusName().getTitle() != null) {
                    metadata.add("ThesaurusNameTitle " + j, k22.getThesaurusName().getTitle().toString());
                }
                if (k22.getThesaurusName() != null && k22.getThesaurusName().getAlternateTitles() != null) {
                    metadata.add("ThesaurusNameAlternativeTitle " + j, k22.getThesaurusName().getAlternateTitles().toString());
                }
                Iterator<Restriction> citationDates = (ArrayList)k22.getThesaurusName().getDates();
                Iterator iterator = ((ArrayList)((Object)citationDates)).iterator();
                while (iterator.hasNext()) {
                    CitationDate cd2 = (CitationDate)iterator.next();
                    if (cd2.getDateType() == null) continue;
                    String date = DateUtils.formatDate((Date)cd2.getDate());
                    metadata.add("ThesaurusNameDate ", cd2.getDateType().name() + "-->" + date);
                }
            }
            ArrayList constraintList = (ArrayList)i.getResourceConstraints();
            k22 = constraintList.iterator();
            while (k22.hasNext()) {
                DefaultLegalConstraints c = (DefaultLegalConstraints)k22.next();
                for (Restriction restriction : c.getAccessConstraints()) {
                    metadata.add("AccessContraints ", restriction.name());
                }
                for (InternationalString internationalString : c.getOtherConstraints()) {
                    metadata.add("OtherConstraints ", internationalString.toString());
                }
                for (Restriction restriction : c.getUseConstraints()) {
                    metadata.add("UserConstraints ", restriction.name());
                }
            }
            Collection<Extent> extentList = ((DefaultDataIdentification)i).getExtents();
            for (Extent e : extentList) {
                ArrayList arrayList = (ArrayList)e.getGeographicElements();
                for (GeographicExtent g2 : arrayList) {
                    if (!(g2 instanceof DefaultGeographicDescription)) continue;
                    if (((DefaultGeographicDescription)g2).getGeographicIdentifier() != null && ((DefaultGeographicDescription)g2).getGeographicIdentifier().getCode() != null) {
                        metadata.add("GeographicIdentifierCode ", ((DefaultGeographicDescription)g2).getGeographicIdentifier().getCode());
                    }
                    if (((DefaultGeographicDescription)g2).getGeographicIdentifier() != null && ((DefaultGeographicDescription)g2).getGeographicIdentifier().getAuthority() != null && ((DefaultGeographicDescription)g2).getGeographicIdentifier().getAuthority().getTitle() != null) {
                        metadata.add("GeographicIdentifierAuthorityTitle ", ((DefaultGeographicDescription)g2).getGeographicIdentifier().getAuthority().getTitle().toString());
                    }
                    for (InternationalString internationalString : ((DefaultGeographicDescription)g2).getGeographicIdentifier().getAuthority().getAlternateTitles()) {
                        metadata.add("GeographicIdentifierAuthorityAlternativeTitle ", internationalString.toString());
                    }
                    for (CitationDate citationDate : ((DefaultGeographicDescription)g2).getGeographicIdentifier().getAuthority().getDates()) {
                        if (citationDate.getDateType() == null || citationDate.getDate() == null) continue;
                        String date = DateUtils.formatDate((Date)citationDate.getDate());
                        metadata.add("GeographicIdentifierAuthorityDate ", citationDate.getDateType().name() + " " + date);
                    }
                }
            }
        }
    }

    private void getMetaDataDistributionInfo(Metadata metadata, DefaultMetadata defaultMetaData) {
        Distribution distribution = defaultMetaData.getDistributionInfo();
        ArrayList distributionFormat = (ArrayList)distribution.getDistributionFormats();
        for (Object f : distributionFormat) {
            if (f.getName() == null) continue;
            metadata.add("DistributionFormatSpecificationAlternativeTitle ", f.getName().toString());
        }
        ArrayList distributorList = (ArrayList)distribution.getDistributors();
        for (Distributor d : distributorList) {
            if (d != null && d.getDistributorContact() != null && d.getDistributorContact().getRole() != null) {
                metadata.add("Distributor Contact ", d.getDistributorContact().getRole().name());
            }
            if (d == null || d.getDistributorContact() == null || d.getDistributorContact().getOrganisationName() == null) continue;
            metadata.add("Distributor Organization Name ", d.getDistributorContact().getOrganisationName().toString());
        }
        ArrayList transferOptionsList = (ArrayList)distribution.getTransferOptions();
        for (DigitalTransferOptions d : transferOptionsList) {
            ArrayList onlineResourceList = (ArrayList)d.getOnLines();
            for (OnlineResource or : onlineResourceList) {
                if (or.getLinkage() != null) {
                    metadata.add("TransferOptionsOnlineLinkage ", or.getLinkage().toString());
                }
                if (or.getProtocol() != null) {
                    metadata.add("TransferOptionsOnlineProtocol ", or.getProtocol());
                }
                if (or.getApplicationProfile() != null) {
                    metadata.add("TransferOptionsOnlineProfile ", or.getApplicationProfile());
                }
                if (or.getName() != null) {
                    metadata.add("TransferOptionsOnlineName ", or.getName());
                }
                if (or.getDescription() != null) {
                    metadata.add("TransferOptionsOnlineDescription ", or.getDescription().toString());
                }
                if (or.getFunction() == null) continue;
                metadata.add("TransferOptionsOnlineFunction ", or.getFunction().name());
            }
        }
    }

    private void getMetaDataDateInfo(Metadata metadata, DefaultMetadata defaultMetaData) {
        ArrayList citationDateList = (ArrayList)defaultMetaData.getDateInfo();
        for (CitationDate c : citationDateList) {
            if (c.getDateType() == null) continue;
            String date = DateUtils.formatDate((Date)c.getDate());
            metadata.add("DateInfo ", c.getDateType().name() + " " + date);
        }
    }

    private void getMetaDataResourceScope(Metadata metadata, DefaultMetadata defaultMetaData) {
        ArrayList scopeList = (ArrayList)defaultMetaData.getMetadataScopes();
        for (DefaultMetadataScope d : scopeList) {
            if (d.getResourceScope() == null) continue;
            metadata.add("MetaDataResourceScope ", d.getResourceScope().name());
        }
    }

    private void getMetaDataParentMetaDataTitle(Metadata metadata, DefaultMetadata defaultMetaData) {
        Citation parentMetaData = defaultMetaData.getParentMetadata();
        if (parentMetaData != null && parentMetaData.getTitle() != null) {
            metadata.add("ParentMetaDataTitle", parentMetaData.getTitle().toString());
        }
    }

    private void getMetaDataIdetifierCode(Metadata metadata, DefaultMetadata defaultMetaData) {
        Identifier identifier = defaultMetaData.getMetadataIdentifier();
        if (identifier != null) {
            metadata.add("MetaDataIdentifierCode", identifier.getCode());
        }
    }

    private void getMetaDataStandard(Metadata metadata, DefaultMetadata defaultMetaData) {
        ArrayList citationList = (ArrayList)defaultMetaData.getMetadataStandards();
        for (Citation c : citationList) {
            if (c.getTitle() != null) {
                metadata.add("MetaDataStandardTitle ", c.getTitle().toString());
            }
            if (c.getEdition() == null) continue;
            metadata.add("MetaDataStandardEdition ", c.getEdition().toString());
        }
    }
}

