/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.resources;

import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.KeyConstants;
import org.apache.sis.util.resources.ResourceInternationalString;
import org.opengis.util.InternationalString;

public final class Vocabulary
extends IndexedResourceBundle {
    Vocabulary(URL uRL) {
        super(uRL);
    }

    @Override
    protected KeyConstants getKeyConstants() {
        return Keys.INSTANCE;
    }

    public static Vocabulary getResources(Locale locale) throws MissingResourceException {
        return Vocabulary.getBundle(Vocabulary.class, locale);
    }

    public static Vocabulary getResources(Map<?, ?> map) throws MissingResourceException {
        return Vocabulary.getResources(Vocabulary.getLocale(map));
    }

    public static String format(short s2) throws MissingResourceException {
        return Vocabulary.getResources((Locale)null).getString(s2);
    }

    public static InternationalString formatInternational(short s2) {
        return new International(s2);
    }

    public static InternationalString formatInternational(short s2, Object object) {
        return new International(s2, object);
    }

    public static InternationalString formatInternational(short s2, Object ... objectArray) {
        return new International(s2, objectArray);
    }

    public static final class Keys
    extends KeyConstants {
        static final Keys INSTANCE = new Keys();
        public static final short Abstract = 1;
        public static final short Accuracy = 2;
        public static final short Administrator = 3;
        public static final short Aliases = 4;
        public static final short AlternativeIdentifiers = 5;
        public static final short Angle = 6;
        public static final short AngularDegrees = 7;
        public static final short AngularMinutes = 8;
        public static final short AngularSeconds = 9;
        public static final short Attributes = 10;
        public static final short Automatic = 11;
        public static final short AxisChanges = 12;
        public static final short Axis_1 = 269;
        public static final short Azimuth = 13;
        public static final short Background = 14;
        public static final short Band_1 = 15;
        public static final short BarometricAltitude = 16;
        public static final short Bilinear = 230;
        public static final short Black = 17;
        public static final short Blue = 18;
        public static final short CRSs = 19;
        public static final short Cardinality = 20;
        public static final short Categories = 248;
        public static final short CausedBy_1 = 21;
        public static final short CellCount_1 = 22;
        public static final short CellGeometry = 23;
        public static final short Cells = 24;
        public static final short CharacterEncoding = 25;
        public static final short Characteristics = 26;
        public static final short Class = 240;
        public static final short Classpath = 27;
        public static final short Code = 28;
        public static final short Code_1 = 29;
        public static final short Color = 251;
        public static final short ColorIndex = 30;
        public static final short Colors = 228;
        public static final short Commands = 31;
        public static final short Configuration = 246;
        public static final short ConstantPressureSurface = 32;
        public static final short Constants = 233;
        public static final short Container = 33;
        public static final short Controls = 262;
        public static final short Conversion = 34;
        public static final short Coordinate = 35;
        public static final short CoordinateRefSys = 36;
        public static final short Correlation = 37;
        public static final short Coverage = 38;
        public static final short CoverageDomain = 39;
        public static final short Create = 40;
        public static final short CreationDate = 41;
        public static final short Credit = 42;
        public static final short CurrentDateTime = 43;
        public static final short CurrentDirectory = 44;
        public static final short Cyan = 45;
        public static final short CycleOmitted = 46;
        public static final short Data = 47;
        public static final short DataBase = 48;
        public static final short DataDirectory = 49;
        public static final short DataFormats = 50;
        public static final short DataType = 51;
        public static final short Date = 52;
        public static final short DateAndTime = 243;
        public static final short Datum = 53;
        public static final short DatumShift = 54;
        public static final short DaylightTime = 55;
        public static final short DefaultValue = 56;
        public static final short Deprecated = 57;
        public static final short DerivedFrom_1 = 58;
        public static final short Description = 59;
        public static final short Designation = 60;
        public static final short Destination = 61;
        public static final short Details = 62;
        public static final short DigitalElevationModel = 63;
        public static final short Dimension_1 = 64;
        public static final short Dimensions = 65;
        public static final short Directory = 66;
        public static final short Display = 67;
        public static final short DittoMark = 68;
        public static final short Domain = 69;
        public static final short DublinJulian = 70;
        public static final short EastBound = 71;
        public static final short Ellipsoid = 72;
        public static final short EllipsoidChange = 73;
        public static final short EllipsoidalHeight = 74;
        public static final short EndDate = 75;
        public static final short EndPoint = 76;
        public static final short Engineering = 77;
        public static final short EntryCount_1 = 78;
        public static final short Envelope = 79;
        public static final short Errors = 80;
        public static final short Extent = 81;
        public static final short False = 264;
        public static final short File = 82;
        public static final short FillValue = 83;
        public static final short Filter = 84;
        public static final short Format = 85;
        public static final short Geocentric = 86;
        public static final short GeocentricConversion = 87;
        public static final short GeocentricRadius = 88;
        public static final short GeodesicDistance = 89;
        public static final short Geodetic = 90;
        public static final short GeodeticDataset = 91;
        public static final short Geographic = 92;
        public static final short GeographicExtent = 93;
        public static final short GeographicIdentifier = 94;
        public static final short Gray = 95;
        public static final short Grayscale = 250;
        public static final short Green = 96;
        public static final short GridExtent = 97;
        public static final short Height = 98;
        public static final short Identifier = 99;
        public static final short Identifiers = 100;
        public static final short Identity = 101;
        public static final short Image = 102;
        public static final short ImageLayout = 103;
        public static final short ImageSize = 234;
        public static final short Image_1 = 261;
        public static final short Implementation = 104;
        public static final short InBetweenWords = 105;
        public static final short Index = 106;
        public static final short Information = 247;
        public static final short Interpolation = 231;
        public static final short Interval = 253;
        public static final short Invalid = 107;
        public static final short InverseOperation = 108;
        public static final short Isolines = 252;
        public static final short JavaExtensions = 109;
        public static final short JavaHome = 110;
        public static final short Julian = 111;
        public static final short Latitude = 112;
        public static final short Layout = 235;
        public static final short Legend = 113;
        public static final short Level = 114;
        public static final short Libraries = 115;
        public static final short LinearTransformation = 116;
        public static final short LocalConfiguration = 117;
        public static final short Locale = 118;
        public static final short Localization = 119;
        public static final short LocationType = 120;
        public static final short Logger = 241;
        public static final short Logging = 121;
        public static final short Logs = 244;
        public static final short Longitude = 122;
        public static final short LowerBound = 123;
        public static final short Magenta = 124;
        public static final short Mandatory = 125;
        public static final short Mapping = 126;
        public static final short Maximum = 127;
        public static final short MaximumValue = 128;
        public static final short MeanValue = 129;
        public static final short Measures = 130;
        public static final short Message = 239;
        public static final short Metadata = 131;
        public static final short Method = 242;
        public static final short Methods = 132;
        public static final short Minimum = 133;
        public static final short MinimumValue = 134;
        public static final short MissingValue = 135;
        public static final short ModifiedJulian = 136;
        public static final short More_1 = 137;
        public static final short Multiplicity = 138;
        public static final short Name = 139;
        public static final short NearestNeighbor = 232;
        public static final short Nodata = 140;
        public static final short None = 141;
        public static final short NorthBound = 142;
        public static final short Note = 143;
        public static final short NumberOfDimensions = 144;
        public static final short NumberOfNaN = 145;
        public static final short NumberOfTiles = 236;
        public static final short NumberOfValues = 146;
        public static final short Obligation = 147;
        public static final short Of_3 = 148;
        public static final short Offset = 149;
        public static final short OperatingSystem = 150;
        public static final short Operations = 151;
        public static final short Optional = 152;
        public static final short Options = 153;
        public static final short Origin = 154;
        public static final short OriginInCellCenter = 155;
        public static final short OtherSurface = 156;
        public static final short Others = 157;
        public static final short Page_1 = 254;
        public static final short Page_2 = 255;
        public static final short Panchromatic = 258;
        public static final short Parenthesis_2 = 158;
        public static final short Paths = 159;
        public static final short Plugins = 160;
        public static final short Preprocessing = 161;
        public static final short Projected = 162;
        public static final short Properties = 237;
        public static final short Property = 238;
        public static final short PublicationDate = 163;
        public static final short Purpose = 164;
        public static final short Quoted_1 = 165;
        public static final short Radiance = 256;
        public static final short Read = 166;
        public static final short Red = 167;
        public static final short ReferenceSystem = 168;
        public static final short Reflectance = 257;
        public static final short Reflective = 259;
        public static final short Remarks = 169;
        public static final short RemoteConfiguration = 170;
        public static final short RepresentativeValue = 171;
        public static final short Resolution = 172;
        public static final short ResourceIdentification = 173;
        public static final short Resources = 263;
        public static final short Result = 174;
        public static final short Retry = 175;
        public static final short Root = 176;
        public static final short RootMeanSquare = 177;
        public static final short SampleDimensions = 178;
        public static final short Scale = 179;
        public static final short Simplified = 180;
        public static final short SlashSeparatedList_2 = 181;
        public static final short Slower = 268;
        public static final short Slowness = 267;
        public static final short Source = 182;
        public static final short SouthBound = 183;
        public static final short SpatialRepresentation = 184;
        public static final short Sphere = 271;
        public static final short StandardDeviation = 185;
        public static final short StartDate = 186;
        public static final short StartPoint = 187;
        public static final short Stretching = 229;
        public static final short SubsetOf_1 = 188;
        public static final short Summary = 189;
        public static final short SupersededBy_1 = 190;
        public static final short Temporal = 191;
        public static final short TemporalExtent = 192;
        public static final short TemporaryFiles = 193;
        public static final short Thermal = 260;
        public static final short TileSize = 194;
        public static final short Time = 195;
        public static final short Time_1 = 196;
        public static final short Timezone = 197;
        public static final short Title = 270;
        public static final short TopicCategory = 198;
        public static final short Trace = 245;
        public static final short Transformation = 199;
        public static final short TransformationAccuracy = 200;
        public static final short Transparency = 201;
        public static final short Transparent = 249;
        public static final short True = 265;
        public static final short TruncatedJulian = 202;
        public static final short Type = 203;
        public static final short TypeOfResource = 204;
        public static final short UnavailableContent = 205;
        public static final short Units = 206;
        public static final short Unknown = 207;
        public static final short Unnamed = 208;
        public static final short Unnamed_1 = 266;
        public static final short Unspecified = 209;
        public static final short Untitled = 210;
        public static final short UpperBound = 211;
        public static final short UserHome = 212;
        public static final short Value = 213;
        public static final short ValueDomain = 214;
        public static final short ValueRange = 215;
        public static final short Values = 216;
        public static final short Variables = 217;
        public static final short Version_2 = 218;
        public static final short Versions = 219;
        public static final short Vertical = 220;
        public static final short Visual = 221;
        public static final short Warnings = 222;
        public static final short WestBound = 223;
        public static final short Width = 224;
        public static final short World = 225;
        public static final short Write = 226;
        public static final short Yellow = 227;

        private Keys() {
        }
    }

    private static final class International
    extends ResourceInternationalString {
        private static final long serialVersionUID = -5423999784169092823L;

        International(short s2) {
            super(s2);
        }

        International(short s2, Object object) {
            super(s2, object);
        }

        @Override
        protected KeyConstants getKeyConstants() {
            return Keys.INSTANCE;
        }

        @Override
        protected IndexedResourceBundle getBundle(Locale locale) {
            return Vocabulary.getResources(locale);
        }
    }
}

