/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.referencing.operation.matrix.GeneralMatrix;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.MismatchedMatrixSizeException;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.referencing.operation.matrix.Solver;
import org.opengis.referencing.operation.Matrix;

final class NonSquareMatrix
extends GeneralMatrix {
    private static final long serialVersionUID = 5481206711680231697L;

    NonSquareMatrix(int n, int n2, boolean bl, int n3) {
        super(n, n2, bl, n3);
    }

    NonSquareMatrix(int n, int n2, double[] dArray) {
        super(n, n2, dArray);
    }

    NonSquareMatrix(Matrix matrix) {
        super(matrix);
    }

    private NonSquareMatrix(GeneralMatrix generalMatrix) {
        super(generalMatrix);
    }

    @Override
    public void transpose() {
        int n = this.numRow;
        int n2 = this.numCol;
        int n3 = NonSquareMatrix.indexOfErrors(n, n2, this.elements);
        double[] dArray = (double[])this.elements.clone();
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n5 = j * n + i;
                this.elements[n5] = dArray[n4];
                if (n3 != 0) {
                    this.elements[n5 + n3] = dArray[n4 + n3];
                }
                ++n4;
            }
        }
        this.numRow = n2;
        this.numCol = (short)n;
    }

    @Override
    public MatrixSIS solve(Matrix matrix) throws MismatchedMatrixSizeException, NoninvertibleMatrixException {
        MatrixSIS matrixSIS = this.inverse();
        if (!matrix.isIdentity()) {
            matrixSIS = matrixSIS.multiply(matrix);
        }
        return matrixSIS;
    }

    @Override
    public MatrixSIS inverse() throws NoninvertibleMatrixException {
        if (this.numRow < this.numCol) {
            return this.inverseDimensionReduction();
        }
        return this.inverseDimensionIncrease();
    }

    private MatrixSIS inverseDimensionReduction() throws NoninvertibleMatrixException {
        short s2 = this.numRow;
        int n = this.numCol;
        int n2 = s2 * n;
        int n3 = n;
        int n4 = n - s2;
        int[] nArray = new int[n4];
        block0: do {
            if (--n3 < 0) {
                throw this.nonInvertible();
            }
            int n5 = n2 + n3;
            while ((n5 -= n) >= 0) {
                if (this.elements[n5] == 0.0) continue;
                continue block0;
            }
            nArray[--n4] = n3;
        } while (n4 != 0);
        GeneralMatrix generalMatrix = new GeneralMatrix(s2, s2, false, 2);
        int n6 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            if (n4 != nArray.length && n3 == nArray[n4]) {
                ++n4;
                continue;
            }
            NonSquareMatrix.copyColumn(this, n3, generalMatrix, n6++);
        }
        if (NonSquareMatrix.indexOfErrors(s2, n, this.elements) == 0) {
            NonSquareMatrix.inferErrors(generalMatrix.elements);
        }
        generalMatrix = (GeneralMatrix)Solver.inverse(generalMatrix, false);
        NonSquareMatrix nonSquareMatrix = new NonSquareMatrix(n, s2, false, 2);
        n4 = 0;
        n6 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            if (n4 != nArray.length && n3 == nArray[n4]) {
                nonSquareMatrix.setElement(n3, s2 - 1, Double.NaN);
                ++n4;
                continue;
            }
            NonSquareMatrix.copyRow(generalMatrix, n6++, nonSquareMatrix, n3);
        }
        return nonSquareMatrix;
    }

    private MatrixSIS inverseDimensionIncrease() throws NoninvertibleMatrixException {
        int n;
        int n2 = this.numRow;
        short s2 = this.numCol;
        int n3 = n2;
        int n4 = n2 - s2;
        int[] nArray = new int[n4];
        boolean bl = this.isAffine(false);
        if (bl) {
            --n3;
        }
        block0: do {
            if (--n3 < 0) {
                throw this.nonInvertible();
            }
            int n5 = n3 * s2;
            n = n5 + s2;
            if (bl) {
                --n;
            }
            while (--n >= n5) {
                double d = this.elements[n];
                if (d == 0.0 || Double.isNaN(d)) continue;
                continue block0;
            }
            nArray[--n4] = n3;
        } while (n4 != 0);
        GeneralMatrix generalMatrix = new GeneralMatrix(s2, s2, false, 2);
        n = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            if (n4 != nArray.length && n3 == nArray[n4]) {
                ++n4;
                continue;
            }
            NonSquareMatrix.copyRow(this, n3, generalMatrix, n++);
        }
        if (NonSquareMatrix.indexOfErrors(n2, s2, this.elements) == 0) {
            NonSquareMatrix.inferErrors(generalMatrix.elements);
        }
        generalMatrix = (GeneralMatrix)Solver.inverse(generalMatrix, false);
        NonSquareMatrix nonSquareMatrix = new NonSquareMatrix(s2, n2, false, 2);
        n4 = 0;
        n = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            if (n4 != nArray.length && n3 == nArray[n4]) {
                ++n4;
                continue;
            }
            NonSquareMatrix.copyColumn(generalMatrix, n++, nonSquareMatrix, n3);
        }
        return nonSquareMatrix;
    }

    private static void copyColumn(GeneralMatrix generalMatrix, int n, GeneralMatrix generalMatrix2, int n2) {
        assert (generalMatrix2.numRow == generalMatrix.numRow);
        while (n < generalMatrix.elements.length) {
            generalMatrix2.elements[n2] = generalMatrix.elements[n];
            n += generalMatrix.numCol;
            n2 += generalMatrix2.numCol;
        }
    }

    private static void copyRow(GeneralMatrix generalMatrix, int n, GeneralMatrix generalMatrix2, int n2) {
        short s2 = generalMatrix2.numCol;
        assert (s2 == generalMatrix.numCol);
        System.arraycopy(generalMatrix.elements, n *= s2, generalMatrix2.elements, n2 *= s2, s2);
        if ((n += s2 * generalMatrix.numRow) < generalMatrix.elements.length) {
            System.arraycopy(generalMatrix.elements, n, generalMatrix2.elements, n2 += s2 * generalMatrix2.numRow, s2);
        }
    }

    private NoninvertibleMatrixException nonInvertible() {
        return new NoninvertibleMatrixException(Resources.format((short)51, this.numRow, this.numCol));
    }

    @Override
    public MatrixSIS clone() {
        return new NonSquareMatrix(this);
    }
}

