/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.referencing.GeodeticCalculator;
import org.apache.sis.referencing.GeodeticException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.Ellipsoid;

class GeodesicsOnEllipsoid
extends GeodeticCalculator {
    static final boolean STORE_LOCAL_VARIABLES = false;
    static final double ITERATION_TOLERANCE = 7.853353365705227E-11;
    private static final double NEARLY_ANTIPODAL_\u0394\u03bb = 0.004363323129985824;
    final double eccentricitySquared;
    final double secondEccentricitySquared;
    final double thirdFlattening;
    final double axisRatio;
    private double sin\u03b10;
    private double cos\u03b10;
    private double \u03bb1E;
    private double I1_\u03c31;
    private double \u03b5;
    private double A1;
    private double A2;
    private double A3;
    private double C31;
    private double C32;
    private double C33;
    private double C34;
    private double C35;
    private final double R0;
    private final double R2;
    private final double R4;
    private final double R6;

    private double semiMinorAxis() {
        return this.semiMajorAxis * this.axisRatio;
    }

    GeodesicsOnEllipsoid(CoordinateReferenceSystem coordinateReferenceSystem, Ellipsoid ellipsoid) {
        super(coordinateReferenceSystem, ellipsoid);
        double d = this.semiMajorAxis;
        double d2 = ellipsoid.getSemiMinorAxis();
        double d3 = d * d - d2 * d2;
        this.eccentricitySquared = d3 / (d * d);
        this.secondEccentricitySquared = d3 / (d2 * d2);
        this.thirdFlattening = (d - d2) / (d + d2);
        this.axisRatio = d2 / d;
        this.R0 = 1.0 - this.eccentricitySquared * (0.25 + this.eccentricitySquared * (0.046875 + this.eccentricitySquared * 0.01953125));
        double d4 = this.eccentricitySquared;
        this.R2 = d4 * (-0.375 - this.eccentricitySquared * (0.09375 + this.eccentricitySquared * 0.032552083333333336));
        this.R4 = (d4 *= this.eccentricitySquared) * (0.1171875 + this.eccentricitySquared * 0.087890625);
        this.R6 = d4 * this.eccentricitySquared * -0.045572916666666664;
    }

    private double computeSeriesExpansionCoefficients() {
        assert (Math.abs(this.sin\u03b10 * this.sin\u03b10 + this.cos\u03b10 * this.cos\u03b10 - 1.0) <= 1.0E-10);
        double d = this.secondEccentricitySquared * (this.cos\u03b10 * this.cos\u03b10);
        double d2 = Math.sqrt(1.0 + d);
        this.\u03b5 = (d2 - 1.0) / (d2 + 1.0);
        double d3 = this.\u03b5 * this.\u03b5;
        this.A1 = (((0.00390625 * d3 + 0.015625) * d3 + 0.25) * d3 + 1.0) / (1.0 - this.\u03b5);
        this.A2 = (((0.09765625 * d3 + 0.140625) * d3 + 0.25) * d3 + 1.0) * (1.0 - this.\u03b5);
        double d4 = this.thirdFlattening;
        this.A3 = 1.0 - this.\u03b5 * (0.5 - d4 * 0.5 + this.\u03b5 * (0.25 + d4 * (0.125 - d4 * 0.375) + this.\u03b5 * (0.0625 + d4 * (0.1875 + d4 * 0.0625) + this.\u03b5 * (0.046875 + d4 * 0.03125 + this.\u03b5 * 0.0234375))));
        double d5 = this.\u03b5;
        this.C31 = d5 * (0.25 - d4 * 0.25 + this.\u03b5 * (0.125 - d4 * (d4 * 0.125) + this.\u03b5 * (0.020833333333333332 + d4 * (0.09375 - d4 * 0.041666666666666664) + this.\u03b5 * (0.015625 + d4 * 0.041666666666666664 + this.\u03b5 * 0.01796875))));
        this.C32 = (d5 *= this.\u03b5) * (0.125 - d4 * (0.1875 - d4 * 0.0625) + this.\u03b5 * (0.09375 - d4 * (0.0625 + d4 * 0.09375) + this.\u03b5 * (-0.0078125 + d4 * 0.125 + this.\u03b5 * -0.015625)));
        this.C33 = (d5 *= this.\u03b5) * (0.10416666666666667 - d4 * (0.1875 - d4 * 0.10416666666666667) + this.\u03b5 * (0.09375 - d4 * 0.10416666666666667 + this.\u03b5 * -0.04375));
        this.C34 = (d5 *= this.\u03b5) * (0.109375 - d4 * 0.21875 + this.\u03b5 * 0.109375);
        this.C35 = d5 * this.\u03b5 * 0.13125;
        return d;
    }

    private double sphericalToEllipsoidalAngle(double d, boolean bl) {
        double d2 = this.\u03b5 * this.\u03b5;
        double d3 = this.\u03b5 * d2;
        double d4 = d2 * d2;
        double d5 = d2 * d3;
        double d6 = d3 * d3;
        double d7 = d * 2.0;
        double d8 = Math.sin(d7);
        double d9 = Math.cos(d7);
        double d10 = this.A1 * (d + d8 * (-0.0484375 * d5 + 0.20833333333333334 * d3 + -0.5 * this.\u03b5 + d9 * (-0.052734375 * d6 + 0.1015625 * d4 + -0.125 * d2 + d9 * (0.1125 * d5 + -0.08333333333333333 * d3 + d9 * (0.15625 * d6 + -0.078125 * d4 + d9 * (-0.0875 * d5 + d9 * (-0.109375 * d6)))))));
        if (bl) {
            d10 -= this.A2 * (d + d8 * (0.0609375 * d5 + -0.041666666666666664 * d3 + 0.5 * this.\u03b5 + d9 * (0.205078125 * d6 + -0.2109375 * d4 + 0.375 * d2 + d9 * (-0.5125 * d5 + 0.4166666666666667 * d3 + d9 * (-1.09375 * d6 + 0.546875 * d4 + d9 * (0.7875 * d5 + d9 * (1.203125 * d6)))))));
        }
        return d10;
    }

    private double ellipsoidalToSphericalAngle(double d) {
        assert (!this.isInvalid(64));
        double d2 = this.\u03b5 * this.\u03b5;
        double d3 = this.\u03b5 * d2;
        double d4 = d2 * d2;
        double d5 = d2 * d3;
        double d6 = d3 * d3;
        double d7 = d * 2.0;
        double d8 = Math.cos(d7);
        return d + Math.sin(d7) * (1.1708333333333334 * d5 + -0.5833333333333334 * d3 + 0.5 * this.\u03b5 + d8 * (8.106640625 * d6 + -2.1744791666666665 * d4 + 0.625 * d2 + d8 * (-7.7609375 * d5 + 1.2083333333333333 * d3 + d8 * (-27.305729166666666 * d6 + 2.8072916666666665 * d4 + d8 * (7.222916666666666 * d5 + d8 * (19.833854166666665 * d6))))));
    }

    private double sphericalToGeodeticLongitude(double d, double d2) {
        double d3 = d2 * 2.0;
        double d4 = Math.cos(d3);
        double d5 = this.A3 * (Math.sin(d3) * (this.C31 + d4 * (this.C32 + d4 * (this.C33 + d4 * (this.C34 + d4 * this.C35)))) + d2);
        return d - this.sin\u03b10 * d5 * (1.0 - this.axisRatio);
    }

    private void \u03b10(double d, double d2, double d3, double d4) {
        this.sin\u03b10 = d * d4;
        this.cos\u03b10 = Math.hypot(d2, d * d3);
    }

    @Override
    final void computeEndPoint() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        this.canComputeEndPoint();
        if (this.isInvalid(64)) {
            d8 = Math.hypot(this.msin\u03b11, this.mcos\u03b11);
            d7 = this.msin\u03b11 / d8;
            d6 = this.mcos\u03b11 / d8;
            d5 = this.axisRatio * Math.tan(this.\u03c61);
            d4 = 1.0 / Math.sqrt(1.0 + d5 * d5);
            d3 = d5 * d4;
            this.\u03b10(d7, d6, d3, d4);
            d2 = d6 * d4;
            d = Math.atan2(d3, d2);
            double d9 = Math.atan2(d3 * this.sin\u03b10, d2);
            double d10 = this.computeSeriesExpansionCoefficients();
            this.\u03bb1E = this.sphericalToGeodeticLongitude(d9, d);
            this.I1_\u03c31 = this.sphericalToEllipsoidalAngle(d, false);
            this.setValid(64);
        }
        d8 = this.I1_\u03c31 + this.geodesicDistance / this.semiMinorAxis();
        d7 = this.ellipsoidalToSphericalAngle(d8 / this.A1);
        d6 = Math.sin(d7);
        d5 = Math.cos(d7);
        this.msin\u03b12 = this.sin\u03b10;
        this.mcos\u03b12 = this.cos\u03b10 * d5;
        d4 = this.cos\u03b10 * d6;
        d3 = Math.hypot(this.msin\u03b12, this.mcos\u03b12);
        d2 = Math.atan2(this.sin\u03b10 * d6, d5);
        d = this.sphericalToGeodeticLongitude(d2, d7);
        this.\u03bb2 = Math.IEEEremainder(d - this.\u03bb1E + this.\u03bb1, Math.PI * 2);
        this.\u03c62 = Math.atan(d4 / (d3 * this.axisRatio));
        this.setValid(10);
    }

    @Override
    final void computeDistance() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        boolean bl;
        boolean bl2;
        boolean bl3;
        this.canComputeDistance();
        double d10 = this.\u03c61;
        double d11 = this.\u03c62;
        double d12 = Math.IEEEremainder(this.\u03bb2 - this.\u03bb1, Math.PI * 2);
        boolean bl4 = bl3 = Math.abs(d11) > Math.abs(d10);
        if (bl3) {
            d10 = this.\u03c62;
            d11 = this.\u03c61;
            d12 = -d12;
        }
        boolean bl5 = bl2 = d10 > 0.0;
        if (bl2) {
            d10 = -d10;
            d11 = -d11;
        }
        boolean bl6 = bl = d12 < 0.0;
        if (bl) {
            d12 = -d12;
        }
        if (d10 > -1.5706706731410454E-10) {
            if (d12 > this.axisRatio * Math.PI) {
                throw new GeodeticException("Cannot compute geodesics for antipodal points on equator.");
            }
            super.computeDistance();
            return;
        }
        double d13 = this.axisRatio * Math.tan(d10);
        double d14 = this.axisRatio * Math.tan(d11);
        double d15 = 1.0 / Math.sqrt(1.0 + d13 * d13);
        double d16 = 1.0 / Math.sqrt(1.0 + d14 * d14);
        double d17 = d13 * d15;
        double d18 = d14 * d16;
        if (d12 >= 3.137229330459807 && Math.abs(d10 + d11) <= 0.004363323129985824) {
            d9 = Math.atan2(d17, d15);
            d8 = Math.atan2(d18, d16);
            d7 = (1.0 - this.axisRatio) * Math.PI * d15;
            d6 = (d8 + d9) / (d7 * d15);
            d5 = (Math.PI - d12) / d7;
            d4 = d5 * d5;
            double d19 = d6 * d6;
            if (d19 < 1.0E-12) {
                d3 = d4 > 1.0 ? 1.5707963267948966 : Math.atan(d5 / Math.sqrt(1.0 - d4));
            } else {
                double d20 = GeodesicsOnEllipsoid.\u03bc(d4, d19);
                d3 = Math.atan2(d5 * d20, d6 * (1.0 + d20));
            }
        } else {
            d9 = (d15 + d16) / 2.0;
            d9 = Math.sqrt(1.0 - this.eccentricitySquared * (d9 * d9));
            d8 = d12 / d9;
            d7 = Math.cos(d8);
            d6 = Math.sin(d8);
            d5 = d15 * d18 - d17 * d16 * d7;
            d4 = d16 * d6;
            d3 = Math.atan2(d4, d5);
        }
        int n = 18;
        do {
            double d21;
            double d22;
            this.msin\u03b11 = Math.sin(d3);
            this.mcos\u03b11 = Math.cos(d3);
            this.\u03b10(this.msin\u03b11, this.mcos\u03b11, d17, d15);
            d2 = this.computeSeriesExpansionCoefficients();
            d = this.mcos\u03b11 * d15;
            double d23 = Math.sqrt(d * d + (d15 <= 0.7071067811865475 ? (d16 - d15) * (d16 + d15) : (d17 - d18) * (d17 + d18)));
            this.msin\u03b12 = this.sin\u03b10;
            this.mcos\u03b12 = d23;
            d9 = Math.atan2(d17, d);
            d8 = Math.atan2(d18, d23);
            double d24 = Math.atan2(d17 * this.sin\u03b10, d);
            double d25 = Math.atan2(d18 * this.sin\u03b10, d23);
            this.\u03bb1E = this.sphericalToGeodeticLongitude(d24, d9);
            double d26 = this.sphericalToGeodeticLongitude(d25, d8);
            double d27 = Math.IEEEremainder(d26 - this.\u03bb1E - d12, Math.PI * 2);
            if (Math.abs(d27) <= 7.853353365705227E-11) {
                n = 0;
            } else if (--n == 0) {
                throw new GeodeticException(Resources.format((short)46));
            }
            if (Math.abs(this.mcos\u03b11) < 1.5706706731410454E-10 && -d13 - Math.abs(d14) < (1.0 + Math.abs(d13 * d14)) * 1.5706706731410454E-10) {
                d22 = -2.0 * Math.sqrt(1.0 - this.eccentricitySquared * (d15 * d15)) / d17;
            } else {
                d21 = Math.hypot(d17, d);
                double d28 = Math.hypot(d18, d23);
                double d29 = d17 / d21;
                double d30 = d18 / d28;
                double d31 = d / d21;
                double d32 = d23 / d28;
                double d33 = this.sphericalToEllipsoidalAngle(d8, true);
                double d34 = this.sphericalToEllipsoidalAngle(d9, true);
                double d35 = Math.sqrt(1.0 + d2 * (d30 * d30)) * d31 * d30 - Math.sqrt(1.0 + d2 * (d29 * d29)) * d29 * d32 - d31 * d32 * (d33 - d34);
                d22 = d35 * this.axisRatio / d23;
            }
            d21 = d27 / d22;
            if (d3 != (d3 -= d21)) continue;
            n = 0;
        } while (n != 0);
        this.I1_\u03c31 = this.sphericalToEllipsoidalAngle(d9, false);
        d2 = this.sphericalToEllipsoidalAngle(d8, false);
        this.geodesicDistance = (d2 - this.I1_\u03c31) * this.semiMinorAxis();
        if (bl3) {
            d = this.msin\u03b11;
            this.msin\u03b11 = this.msin\u03b12;
            this.msin\u03b12 = d;
            d = this.mcos\u03b11;
            this.mcos\u03b11 = this.mcos\u03b12;
            this.mcos\u03b12 = d;
        }
        if (bl ^ bl3) {
            this.msin\u03b11 = -this.msin\u03b11;
            this.msin\u03b12 = -this.msin\u03b12;
        }
        if (bl2 ^ bl3) {
            this.mcos\u03b11 = -this.mcos\u03b11;
            this.mcos\u03b12 = -this.mcos\u03b12;
        }
        this.setValid(28);
        if (!(bl3 | bl | bl2)) {
            this.setValid(64);
        }
    }

    private static double \u03bc(double d, double d2) {
        double d3;
        double d4 = d * d2 / 4.0;
        double d5 = (d + d2 - 1.0) / 6.0;
        double d6 = d5 * d5 * d5;
        double d7 = d4 * (d4 + 2.0 * d6);
        double d8 = d7 < 0.0 ? d5 * (1.0 + 2.0 * Math.cos(Math.atan2(Math.sqrt(-d7), -(d4 + d6)) / 3.0)) : ((d3 = Math.cbrt(d4 + d6 + Math.copySign(Math.sqrt(d7), d4 + d6))) == 0.0 ? 0.0 : d5 + d3 + d5 * d5 / d3);
        d3 = Math.sqrt(d8 * d8 + d2);
        double d9 = (d3 + d8 - d2) / (2.0 * d3);
        return (d3 + d8) / (Math.sqrt(d3 + d8 + d9 * d9) + d9);
    }

    @Override
    double d\u03c6_dy(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        return d3 / (1.0 - this.eccentricitySquared * (d3 * d3) / (1.0 - this.eccentricitySquared * (d2 * d2)));
    }

    final void snapshot() {
        this.store("\u03b5", this.\u03b5);
        this.store("A\u2081", this.A1);
        this.store("A\u2082", this.A2);
        this.store("A\u2083", this.A3);
        this.store("\u03b1\u2080", Math.atan2(this.sin\u03b10, this.cos\u03b10));
        this.store("I\u2081(\u03c3\u2081)", this.I1_\u03c31);
        this.store("s\u2081", this.I1_\u03c31 * this.semiMinorAxis());
        this.store("\u03bb\u2081", this.\u03bb1E);
    }

    void store(String string, double d) {
    }

    double computedToGiven(double d) {
        return d;
    }

    @Override
    final void computeRhumbLine() {
        double d;
        this.canComputeDistance();
        double d2 = Math.sqrt(this.eccentricitySquared);
        double d3 = Math.sin(this.\u03c61);
        double d4 = Math.sin(this.\u03c62);
        double d5 = d2 * (d3 - d4);
        double d6 = 1.0 - this.eccentricitySquared * (d3 * d4);
        double d7 = Math.log(Math.tan(0.7853981633974483 + this.\u03c62 / 2.0) / Math.tan(0.7853981633974483 + this.\u03c61 / 2.0) * Math.pow((d6 + d5) / (d6 - d5), d2 / 2.0));
        double d8 = Math.IEEEremainder(this.\u03bb2 - this.\u03bb1, Math.PI * 2);
        double d9 = Math.hypot(d8, d7);
        if (Math.abs(this.\u03c61 - this.\u03c62) < 1.5706706731410454E-10) {
            double d10 = (this.\u03c61 + this.\u03c62) / 2.0;
            double d11 = Math.sin(d10);
            d = Math.cos(d10) / Math.sqrt(1.0 - this.eccentricitySquared * (d11 * d11));
        } else {
            double d12 = this.m(this.\u03c61, d3);
            double d13 = this.m(this.\u03c62, d4);
            d = (d13 - d12) / d7;
        }
        this.rhumblineLength = d * d9 * this.semiMajorAxis;
        this.rhumblineAzimuth = Math.atan2(d8, d7);
    }

    private double m(double d, double d2) {
        double d3 = Math.cos(d);
        double d4 = 2.0 * d2 * d3;
        double d5 = (d3 + d2) * (d3 - d2);
        return this.R0 * d + d4 * (this.R2 + d5 * (this.R4 + d5 * this.R6));
    }

    @Override
    final String getProjectionMethod() {
        return "Modified Azimuthal Equidistant";
    }
}

