/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.WKTKeywords;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.io.wkt.StoredTree;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.factory.FactoryDataException;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.collection.FrequencySortedSet;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public class WKTDictionary
extends GeodeticAuthorityFactory {
    private volatile Citation authority;
    private final Set<String> authorities;
    private final Set<String> codespaces;
    private final Map<Class<?>, Set<String>> codeCaches;
    protected final WKTFormat parser;
    private final ReadWriteLock lock;
    private final Map<String, Object> definitions = new HashMap<String, Object>();

    public WKTDictionary(Citation citation) {
        this.codeCaches = new HashMap();
        this.codespaces = new FrequencySortedSet<String>(true);
        this.parser = new WKTFormat(null, null);
        this.lock = new ReentrantReadWriteLock();
        this.authorities = citation != null ? null : new FrequencySortedSet(true);
        this.authority = citation;
    }

    private void updateAuthority() {
        this.codeCaches.clear();
        if (this.authorities != null) {
            String string = CollectionsExt.first(this.authorities);
            if (string == null) {
                string = CollectionsExt.first(this.codespaces);
            }
            this.authority = Citations.fromName(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(BufferedReader bufferedReader) throws FactoryException {
        ArgumentChecks.ensureNonNull("source", bufferedReader);
        this.lock.writeLock().lock();
        try {
            Loader loader = new Loader(bufferedReader);
            try {
                loader.read();
            }
            catch (IOException iOException) {
                throw new FactoryException(loader.canNotRead(null, iOException), iOException);
            }
            catch (IllegalArgumentException | ParseException exception) {
                throw new FactoryDataException(loader.canNotRead(null, exception), exception);
            }
            finally {
                loader.restore();
                this.updateAuthority();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void addDefinition(StoredTree storedTree) throws FactoryDataException {
        String string;
        Object[] objectArray = new Object[this.authorities == null ? 4 : 3];
        storedTree.peekIdentifiers(objectArray);
        String string2 = WKTDictionary.trimOrNull(objectArray[1]);
        if (string2 == null) {
            throw new FactoryDataException(this.resources().getString((short)37, storedTree));
        }
        String string3 = WKTDictionary.trimOrNull(objectArray[0]);
        this.definitions.merge(string2, storedTree, (object, object2) -> new Disambiguation(string3, WKTDictionary.trimOrNull(objectArray[2]), string2, object, object2));
        this.codespaces.add(string3);
        if (objectArray.length >= 4 && (string = WKTDictionary.trimOrNull(objectArray[3])) != null) {
            this.authorities.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefinitions(Stream<String> stream) throws FactoryException {
        ArgumentChecks.ensureNonNull("objects", stream);
        Iterator iterator = stream.iterator();
        ParsePosition parsePosition = new ParsePosition(0);
        this.lock.writeLock().lock();
        try {
            int n = 1;
            try {
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    StoredTree storedTree = this.parser.textToTree(string, parsePosition, null);
                    int n2 = parsePosition.getIndex();
                    if (n2 < CharSequences.skipTrailingWhitespaces(string, 0, string.length())) {
                        throw new FactoryDataException(this.unexpectedText(n, string, n2));
                    }
                    this.addDefinition(storedTree);
                    parsePosition.setIndex(0);
                    ++n;
                }
                this.parser.logWarnings(WKTDictionary.class, "addDefinitions");
            }
            catch (IllegalArgumentException | ParseException exception) {
                throw new FactoryDataException(this.resources().getString((short)96, n, exception.getLocalizedMessage()));
            }
            finally {
                this.parser.clear();
                this.updateAuthority();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * Loose catch block
     */
    private IdentifiedObject parseAndAdd(String string, String string2, String string3, String string5, DefaultIdentifier defaultIdentifier) throws FactoryException {
        ArgumentChecks.ensureNonEmpty("code", string3);
        ArgumentChecks.ensureNonEmpty("wkt", string5);
        this.lock.writeLock().lock();
        try {
            try {
                this.parser.setDefaultIdentifier(defaultIdentifier);
                Object t2 = this.parser.parseObject(string5);
                if (!(t2 instanceof IdentifiedObject)) {
                    throw new FactoryDataException(this.parser.errors().getString((short)143, string3, IdentifiedObject.class, t2.getClass()));
                }
                Disambiguation disambiguation = (Disambiguation)this.definitions.compute(string3, (string4, object2) -> new Disambiguation(string, string2, string3, object2, t2));
                this.codespaces.add(disambiguation.codespace);
                IdentifiedObject identifiedObject = (IdentifiedObject)t2;
                return identifiedObject;
            }
            catch (IllegalArgumentException | ParseException exception) {
                throw new FactoryDataException(exception.getLocalizedMessage());
            }
            finally {
                this.parser.setDefaultIdentifier(null);
                this.parser.clear();
                this.updateAuthority();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected String fetchDefinition(DefaultIdentifier defaultIdentifier) throws FactoryException {
        return null;
    }

    private String unexpectedText(int n, String string, int n2) {
        return this.resources().getString((short)98, n, CharSequences.token(string, n2));
    }

    private Resources resources() {
        return Resources.forLocale(this.parser.getErrorLocale());
    }

    private static String trimOrNull(Object object) {
        return object != null ? Strings.trimOrNull(object.toString()) : null;
    }

    final void forEachValue(Consumer<Object> consumer) {
        for (Object object : this.definitions.values()) {
            if (object instanceof Disambiguation) {
                Disambiguation disambiguation = (Disambiguation)object;
                do {
                    consumer.accept(disambiguation.value);
                } while ((disambiguation = disambiguation.previous) != null);
                continue;
            }
            consumer.accept(object);
        }
    }

    @Override
    public Citation getAuthority() {
        return this.authority;
    }

    @Override
    public Set<String> getCodeSpaces() {
        this.lock.readLock().lock();
        try {
            Set<String> set = JDK9.copyOf(this.codespaces);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        Set<String> object2;
        ArgumentChecks.ensureNonNull("type", clazz);
        if (!clazz.isInterface()) {
            clazz = ReferencingUtilities.getInterface(IdentifiedObject.class, clazz);
        }
        this.lock.readLock().lock();
        try {
            object2 = this.codeCaches.get(clazz);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (object2 == null) {
            String[] stringArray = WKTKeywords.forType(clazz);
            Class<? extends IdentifiedObject> clazz2 = clazz;
            Predicate<Object> predicate = object -> {
                if (object instanceof StoredTree) {
                    return stringArray == null || ArraysExt.containsIgnoreCase(stringArray, ((StoredTree)object).keyword());
                }
                return clazz2.isInstance(object);
            };
            this.lock.writeLock().lock();
            try {
                object2 = this.codeCaches.get(clazz);
                if (object2 == null) {
                    object2 = new HashSet<String>();
                    for (Map.Entry<String, Object> object3 : this.definitions.entrySet()) {
                        String string = object3.getKey();
                        Object object4 = object3.getValue();
                        if (object4 instanceof Disambiguation) {
                            Disambiguation.list((Disambiguation)object4, string, predicate, object2);
                            continue;
                        }
                        if (!predicate.test(object4)) continue;
                        object2.add(string);
                    }
                    boolean bl = false;
                    for (Set<String> set : this.codeCaches.values()) {
                        if (!object2.equals(set)) continue;
                        object2 = set;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        object2 = CollectionsExt.unmodifiableOrCopy(object2);
                    }
                    this.codeCaches.put(clazz, object2);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return object2;
    }

    @Override
    public InternationalString getDescriptionText(String string) throws FactoryException {
        String string2;
        Object object = this.getOrCreate(string, false);
        if (object instanceof IdentifiedObject) {
            string2 = ((IdentifiedObject)object).getName().getCode();
        } else {
            string2 = String.valueOf(object);
            if (!(object instanceof StoredTree)) {
                throw new FactoryException(string2);
            }
        }
        return new SimpleInternationalString(string2);
    }

    @Override
    public IdentifiedObject createObject(String string) throws FactoryException {
        Object object = this.getOrCreate(string, true);
        if (object instanceof IdentifiedObject) {
            return (IdentifiedObject)object;
        }
        throw new FactoryException(String.valueOf(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getOrCreate(String string, boolean bl) throws FactoryException {
        Object object;
        block20: {
            Object object2;
            String string2 = null;
            String string3 = null;
            String string4 = string;
            int n = string.indexOf(58);
            int n2 = CharSequences.skipTrailingWhitespaces(string, 0, n);
            int n3 = CharSequences.skipLeadingWhitespaces(string, 0, n2);
            if (n3 < n2) {
                string2 = string.substring(n3, n2);
                int n4 = string.indexOf(58, ++n);
                n3 = CharSequences.skipLeadingWhitespaces(string, n, n4);
                if (n3 < (n2 = CharSequences.skipTrailingWhitespaces(string, n3, n4++))) {
                    string3 = string.substring(n3, n2);
                }
                n3 = Math.max(n, n4);
                n2 = string.length();
                string4 = CharSequences.trimWhitespaces(string, n3, n2).toString();
            }
            Disambiguation disambiguation = null;
            object = null;
            this.lock.readLock().lock();
            try {
                boolean bl2;
                boolean bl3 = bl2 = string2 == null || string2.isEmpty() || this.codespaces.contains(string2);
                if (!bl2) {
                    String string5;
                    object2 = this.codespaces.iterator();
                    while (object2.hasNext() && !(bl2 = (string5 = object2.next()).equalsIgnoreCase(string2))) {
                    }
                }
                if (bl2 && (object = this.definitions.get(string4)) instanceof Disambiguation) {
                    disambiguation = Disambiguation.find((Disambiguation)object, string2, string3, string4);
                    object = disambiguation != null ? disambiguation.value : null;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            if (object == null) {
                DefaultIdentifier defaultIdentifier = new DefaultIdentifier(string2, string4, string3);
                object2 = this.fetchDefinition(defaultIdentifier);
                if (object2 != null) {
                    return this.parseAndAdd(string2, string3, string4, (String)object2, defaultIdentifier);
                }
                throw new NoSuchAuthorityCodeException(this.parser.errors().getString((short)95, string), string2, string4, string);
            }
            if (bl && object instanceof StoredTree) {
                this.lock.writeLock().lock();
                try {
                    ParseException parseException;
                    block21: {
                        object = disambiguation != null ? disambiguation.value : this.definitions.get(string4);
                        if (!(object instanceof StoredTree)) break block20;
                        parseException = null;
                        try {
                            object = this.parser.buildFromTree((StoredTree)object);
                            this.parser.logWarnings(WKTDictionary.class, "createObject");
                        }
                        catch (ParseException parseException2) {
                            parseException = parseException2;
                            object = parseException2.getLocalizedMessage();
                            if (object != null) break block21;
                            object = parseException2.getClass().getSimpleName();
                        }
                    }
                    if (disambiguation != null) {
                        disambiguation.value = object;
                    } else {
                        this.definitions.put(string4, object);
                    }
                    this.codeCaches.clear();
                    if (parseException != null) {
                        throw new FactoryException(this.resources().getString((short)5, string), parseException);
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }
        return object;
    }

    private final class Loader {
        private static final String SET = "SET";
        private final BufferedReader source;
        private final StringBuilder buffer;
        private String aliasKey;
        private final ParsePosition pos;
        private int lineNumber;
        private final Set<String> aliases;

        Loader(BufferedReader bufferedReader) {
            this.source = bufferedReader;
            this.buffer = new StringBuilder(500);
            this.pos = new ParsePosition(0);
            this.aliases = new HashSet<String>(WKTDictionary.this.parser.getFragmentNames());
        }

        final void restore() {
            WKTDictionary.this.parser.getFragmentNames().retainAll(this.aliases);
            WKTDictionary.this.parser.clear();
        }

        final String canNotRead(String string, Exception exception) {
            Locale locale = WKTDictionary.this.parser.getErrorLocale();
            if (string == null) {
                string = Exceptions.getLocalizedMessage(exception, locale);
            }
            return Resources.forLocale(locale).getString((short)96, this.getLineNumber(), string);
        }

        private int getLineNumber() {
            if (this.source instanceof LineNumberReader) {
                this.lineNumber = ((LineNumberReader)this.source).getLineNumber();
            }
            return this.lineNumber;
        }

        final void read() throws IOException, ParseException, FactoryDataException {
            String string;
            String string2 = System.lineSeparator();
            int n = 0;
            while ((string = this.source.readLine()) != null) {
                int n2;
                ++this.lineNumber;
                int n3 = string.length();
                int n4 = CharSequences.skipLeadingWhitespaces(string, 0, n3);
                if (n4 < n3 && string.charAt(n4) == '#') continue;
                if (n4 > n) {
                    n4 = n;
                } else {
                    this.addAliasOrDefinition();
                    n = n4;
                    if (string.regionMatches(true, n4, SET, 0, SET.length()) && (n2 = CharSequences.skipLeadingWhitespaces(string, n4 + SET.length(), n3)) > n4) {
                        n4 = string.indexOf(61, n2);
                        if (n4 <= n2) {
                            throw new FactoryDataException(WKTDictionary.this.resources().getString((short)97, this.getLineNumber()));
                        }
                        int n5 = CharSequences.skipTrailingWhitespaces(string, n2, n4);
                        n4 = CharSequences.skipLeadingWhitespaces(string, n4 + 1, n3);
                        String string3 = string.substring(n2, n5);
                        if (!CharSequences.isUnicodeIdentifier(string3)) {
                            String string4 = WKTDictionary.this.parser.errors().getString((short)112, string3);
                            throw new FactoryDataException(this.canNotRead(string4, null));
                        }
                        this.aliasKey = string3;
                    }
                }
                if (n4 >= (n2 = CharSequences.skipTrailingWhitespaces(string, n4, n3))) continue;
                if (this.buffer.length() != 0) {
                    this.buffer.append(string2);
                }
                this.buffer.append(string, n4, n2);
            }
            this.addAliasOrDefinition();
            WKTDictionary.this.parser.logWarnings(WKTDictionary.class, "load");
        }

        private void addAliasOrDefinition() throws ParseException, FactoryDataException {
            if (this.buffer.length() != 0) {
                this.pos.setIndex(0);
                String string = this.buffer.toString();
                StoredTree storedTree = WKTDictionary.this.parser.textToTree(string, this.pos, this.aliasKey);
                int n = this.pos.getIndex();
                if (n < string.length()) {
                    throw new FactoryDataException(WKTDictionary.this.unexpectedText(this.getLineNumber(), string, n));
                }
                if (this.aliasKey != null) {
                    WKTDictionary.this.parser.addFragment(this.aliasKey, storedTree);
                    this.aliasKey = null;
                } else {
                    WKTDictionary.this.addDefinition(storedTree);
                }
                this.buffer.setLength(0);
            }
        }
    }

    private static final class Disambiguation {
        private final Disambiguation previous;
        private final String codespace;
        private final String version;
        Object value;

        private Disambiguation(IdentifiedObject identifiedObject) {
            ReferenceIdentifier referenceIdentifier = CollectionsExt.first(identifiedObject.getIdentifiers());
            this.codespace = referenceIdentifier.getCodeSpace();
            this.version = referenceIdentifier.getVersion();
            this.value = identifiedObject;
            this.previous = null;
        }

        private Disambiguation(StoredTree storedTree) {
            Object[] objectArray = new Object[3];
            storedTree.peekIdentifiers(objectArray);
            this.codespace = WKTDictionary.trimOrNull(objectArray[0]);
            this.version = WKTDictionary.trimOrNull(objectArray[2]);
            this.value = storedTree;
            this.previous = null;
        }

        Disambiguation(String string, String string2, String string3, Object object, Object object2) {
            this.codespace = string;
            this.version = string2;
            this.value = object2;
            if (object instanceof Disambiguation) {
                this.previous = (Disambiguation)object;
            } else if (object instanceof StoredTree) {
                this.previous = new Disambiguation((StoredTree)object);
            } else if (object instanceof IdentifiedObject) {
                this.previous = new Disambiguation((IdentifiedObject)object);
            } else {
                this.previous = null;
                return;
            }
            Disambiguation disambiguation = this.previous;
            do {
                if (!Strings.equalsIgnoreCase(string, disambiguation.codespace) || !Strings.equalsIgnoreCase(string2, disambiguation.version)) continue;
                throw new IllegalArgumentException(Errors.format((short)25, this.identifier(string3)));
            } while ((disambiguation = disambiguation.previous) != null);
        }

        static Disambiguation find(Disambiguation disambiguation, String string, String string2, String string3) throws NoSuchAuthorityCodeException {
            Disambiguation disambiguation2 = null;
            boolean bl = false;
            while (disambiguation != null) {
                block5: {
                    block7: {
                        block6: {
                            if (string != null && !string.equalsIgnoreCase(disambiguation.codespace)) break block5;
                            if (!Strings.equalsIgnoreCase(string2, disambiguation.version)) break block6;
                            if (bl) break block7;
                            bl = true;
                            disambiguation2 = disambiguation;
                            break block5;
                        }
                        if (bl) break block5;
                    }
                    if (bl && disambiguation2 != null) {
                        String string4 = Disambiguation.identifier(string, string2, string3);
                        throw new NoSuchAuthorityCodeException(Errors.format((short)1, disambiguation.identifier(string3), disambiguation2.identifier(string3), string4), string, string3, string4);
                    }
                    disambiguation2 = disambiguation;
                }
                disambiguation = disambiguation.previous;
            }
            return disambiguation2;
        }

        static void list(Disambiguation disambiguation, String string, Predicate<Object> predicate, Set<String> set) {
            do {
                if (!predicate.test(disambiguation.value)) continue;
                set.add(disambiguation.identifier(string));
            } while ((disambiguation = disambiguation.previous) != null);
        }

        private String identifier(String string) {
            return Disambiguation.identifier(this.codespace, this.version, string);
        }

        private static String identifier(String string, String string2, String string3) {
            return Strings.orEmpty(string) + ':' + Strings.orEmpty(string2) + ':' + Strings.orEmpty(string3);
        }
    }
}

