/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.lang.reflect.Array;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.logging.Level;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.DatumShiftGridLoader;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.transform.InterpolatedTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

abstract class DatumShiftGridFile<C extends Quantity<C>, T extends Quantity<T>>
extends DatumShiftGrid<C, T> {
    private static final long serialVersionUID = -5801692909082130314L;
    static final Cache<Object, DatumShiftGridFile<?, ?>> CACHE = new Cache<Object, DatumShiftGridFile<?, ?>>(4, 32768L, true){

        @Override
        protected int cost(DatumShiftGridFile<?, ?> datumShiftGridFile) {
            int n = 1;
            for (Object object : datumShiftGridFile.getData()) {
                if (object instanceof DatumShiftGridFile) {
                    n += this.cost((DatumShiftGridFile)object);
                    continue;
                }
                n *= Array.getLength(object);
            }
            return n;
        }
    };
    private final ParameterDescriptorGroup descriptor;
    private final Path[] files;
    protected final int scanlineStride;
    private final double periodX;
    double accuracy;
    protected DatumShiftGridFile<C, T>[] subgrids;

    DatumShiftGridFile(Unit<C> unit, Unit<T> unit2, boolean bl, double d, double d2, double d3, double d4, int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup, Path ... pathArray) throws NoninvertibleTransformException {
        super(unit, new AffineTransform2D(d3, 0.0, 0.0, d4, d, d2).inverse(), new int[]{n, n2}, bl, unit2);
        this.descriptor = parameterDescriptorGroup;
        this.files = pathArray;
        this.scanlineStride = n;
        this.periodX = Units.isAngular(unit) ? Math.rint(360.0 / Math.abs(d3)) : 0.0;
    }

    protected DatumShiftGridFile(DatumShiftGridFile<C, T> datumShiftGridFile) {
        super(datumShiftGridFile);
        this.descriptor = datumShiftGridFile.descriptor;
        this.files = datumShiftGridFile.files;
        this.scanlineStride = datumShiftGridFile.scanlineStride;
        this.accuracy = datumShiftGridFile.accuracy;
        this.subgrids = datumShiftGridFile.subgrids;
        this.periodX = datumShiftGridFile.periodX;
    }

    DatumShiftGridFile(DatumShiftGridFile<C, T> datumShiftGridFile, AffineTransform2D affineTransform2D, int n, int n2) throws NoninvertibleTransformException {
        super(datumShiftGridFile.getCoordinateUnit(), affineTransform2D.inverse(), new int[]{n, n2}, datumShiftGridFile.isCellValueRatio(), datumShiftGridFile.getTranslationUnit());
        this.scanlineStride = n;
        this.descriptor = datumShiftGridFile.descriptor;
        this.files = datumShiftGridFile.files;
        this.periodX = datumShiftGridFile.periodX == 0.0 ? 0.0 : Math.rint(360.0 / AffineTransforms2D.getScaleX0(affineTransform2D));
    }

    final void setSubGrids(Collection<DatumShiftGridFile<C, T>> collection) {
        if (this.subgrids != null) {
            throw new IllegalStateException();
        }
        this.subgrids = collection.toArray(new DatumShiftGridFile[collection.size()]);
    }

    private int getGridCount() {
        int n = 1;
        if (this.subgrids != null) {
            for (DatumShiftGridFile<C, T> datumShiftGridFile : this.subgrids) {
                n += super.getGridCount();
            }
        }
        return n;
    }

    @Override
    public final String toString() {
        if (this.subgrids == null) {
            return super.toString();
        }
        DefaultTreeTable defaultTreeTable = new DefaultTreeTable(TableColumn.NAME);
        this.toTree(defaultTreeTable.getRoot());
        return ((Object)defaultTreeTable).toString();
    }

    private void toTree(TreeTable.Node node) {
        String string = super.toString();
        if (this.subgrids != null) {
            string = string + " (" + this.getGridCount() + " grids)";
            for (DatumShiftGridFile<C, T> datumShiftGridFile : this.subgrids) {
                super.toTree(node.newChild());
            }
        }
        node.setValue(TableColumn.NAME, string);
    }

    final <NC extends Quantity<NC>, NT extends Quantity<NT>> DatumShiftGridFile<NC, NT> castTo(Class<NC> clazz, Class<NT> clazz2) {
        super.getCoordinateUnit().asType(clazz);
        super.getTranslationUnit().asType(clazz2);
        return this;
    }

    protected final DatumShiftGridFile<C, T> useSharedData() {
        Object[] objectArray = this.getData();
        for (DatumShiftGridFile datumShiftGridFile : CACHE.values()) {
            Object[] objectArray2 = datumShiftGridFile.getData();
            if (!Arrays.deepEquals(objectArray, objectArray2)) continue;
            return this.setData(objectArray2);
        }
        return this;
    }

    protected abstract DatumShiftGridFile<C, T> setData(Object[] var1);

    protected abstract Object[] getData();

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            DatumShiftGridFile datumShiftGridFile = (DatumShiftGridFile)object;
            return Arrays.equals(this.files, datumShiftGridFile.files) && Arrays.deepEquals(this.getData(), datumShiftGridFile.getData());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.files);
    }

    @Override
    public double getCellPrecision() {
        return this.accuracy / 10.0;
    }

    @Override
    protected void replaceOutsideGridCoordinates(double[] dArray) {
        if (this.periodX != 0.0) {
            dArray[0] = Math.IEEEremainder(dArray[0], this.periodX);
        }
    }

    @Override
    public final ParameterDescriptorGroup getParameterDescriptors() {
        return this.descriptor;
    }

    @Override
    public final void getParameterValues(Parameters parameters) {
        int n = 0;
        for (GeneralParameterDescriptor generalParameterDescriptor : this.descriptor.descriptors()) {
            ParameterDescriptor parameterDescriptor;
            if (!(generalParameterDescriptor instanceof ParameterDescriptor) || !Path.class.isAssignableFrom((parameterDescriptor = (ParameterDescriptor)generalParameterDescriptor).getValueClass())) continue;
            if (n >= this.files.length) break;
            parameters.getOrCreate(parameterDescriptor).setValue(this.files[n++]);
        }
    }

    public static MathTransform createGeodeticTransformation(Class<? extends AbstractProvider> clazz, MathTransformFactory mathTransformFactory, DatumShiftGridFile<Angle, Angle> datumShiftGridFile) throws FactoryException {
        MathTransform mathTransform = InterpolatedTransform.createGeodeticTransformation(mathTransformFactory, datumShiftGridFile);
        DatumShiftGridFile<C, T>[] datumShiftGridFileArray = datumShiftGridFile.subgrids;
        if (datumShiftGridFileArray == null) {
            return mathTransform;
        }
        LinkedHashMap<Envelope, MathTransform> linkedHashMap = new LinkedHashMap<Envelope, MathTransform>(Containers.hashMapCapacity(datumShiftGridFileArray.length));
        for (DatumShiftGridFile<Angle, Angle> datumShiftGridFile2 : datumShiftGridFileArray) {
            try {
                Envelope envelope = datumShiftGridFile2.getDomainOfValidity(Units.DEGREE);
                MathTransform mathTransform2 = DatumShiftGridFile.createGeodeticTransformation(clazz, mathTransformFactory, datumShiftGridFile2);
                if (linkedHashMap.putIfAbsent(envelope, mathTransform2) == null) continue;
                DatumShiftGridLoader.log(clazz, Errors.getResources((Locale)null).getLogRecord(Level.FINE, (short)24, envelope));
            }
            catch (TransformException transformException) {
                throw new FactoryException(transformException);
            }
        }
        return MathTransforms.specialize(mathTransform, linkedHashMap);
    }

    static final class Double<C extends Quantity<C>, T extends Quantity<T>>
    extends DatumShiftGridFile<C, T> {
        private static final long serialVersionUID = 3999271636016362364L;
        final double[][] offsets;

        Double(int n, Unit<C> unit, Unit<T> unit2, boolean bl, double d, double d2, double d3, double d4, int n2, int n3, ParameterDescriptorGroup parameterDescriptorGroup, Path ... pathArray) throws NoninvertibleTransformException {
            super(unit, unit2, bl, d, d2, d3, d4, n2, n3, parameterDescriptorGroup, pathArray);
            this.offsets = new double[n][Math.multiplyExact(n2, n3)];
        }

        private Double(DatumShiftGridFile<C, T> datumShiftGridFile, double[][] dArray) {
            super(datumShiftGridFile);
            this.offsets = dArray;
        }

        @Override
        protected final DatumShiftGridFile<C, T> setData(Object[] objectArray) {
            return new Double<C, T>(this, (double[][])objectArray);
        }

        @Override
        protected final Object[] getData() {
            return this.offsets;
        }

        @Override
        public final int getTranslationDimensions() {
            return this.offsets.length;
        }

        @Override
        public final double getCellValue(int n, int n2, int n3) {
            return this.offsets[n][n2 + n3 * this.scanlineStride];
        }
    }

    static final class Float<C extends Quantity<C>, T extends Quantity<T>>
    extends DatumShiftGridFile<C, T> {
        private static final long serialVersionUID = -9221609983475286496L;
        final float[][] offsets;

        Float(int n, Unit<C> unit, Unit<T> unit2, boolean bl, double d, double d2, double d3, double d4, int n2, int n3, ParameterDescriptorGroup parameterDescriptorGroup, Path ... pathArray) throws NoninvertibleTransformException {
            super(unit, unit2, bl, d, d2, d3, d4, n2, n3, parameterDescriptorGroup, pathArray);
            this.offsets = new float[n][Math.multiplyExact(n2, n3)];
        }

        private Float(DatumShiftGridFile<C, T> datumShiftGridFile, float[][] fArray) {
            super(datumShiftGridFile);
            this.offsets = fArray;
        }

        @Override
        protected final DatumShiftGridFile<C, T> setData(Object[] objectArray) {
            return new Float<C, T>(this, (float[][])objectArray);
        }

        @Override
        protected final Object[] getData() {
            return this.offsets;
        }

        @Override
        public final int getTranslationDimensions() {
            return this.offsets.length;
        }

        @Override
        public final double getCellValue(int n, int n2, int n3) {
            return DecimalFunctions.floatToDouble(this.offsets[n][n2 + n3 * this.scanlineStride]);
        }

        @Override
        public double getCellMean(int n) {
            float[] fArray = this.offsets[n];
            double d = 0.0;
            for (float f : fArray) {
                d += (double)f;
            }
            return d / (double)fArray.length;
        }
    }
}

