/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.processing.isoline;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.sis.internal.processing.isoline.PolylineBuffer;
import org.apache.sis.internal.util.Numerics;

final class Fragments
extends ArrayList<double[]> {
    private Point firstPoint;
    private Point lastPoint;

    Fragments(PolylineBuffer polylineBuffer, PolylineBuffer polylineBuffer2) {
        PolylineBuffer polylineBuffer3;
        int n = 0;
        do {
            int n2;
            PolylineBuffer polylineBuffer4 = polylineBuffer3 = (n & 2) == 0 ? polylineBuffer : polylineBuffer2;
            if (n % 3 == 0 && polylineBuffer3 != null) {
                polylineBuffer3 = polylineBuffer3.opposite;
            }
            if (polylineBuffer3 != null && (n2 = polylineBuffer3.size) != 0) {
                boolean bl;
                double d;
                double d2;
                double[] dArray = polylineBuffer3.coordinates;
                if ((n & 1) == 0) {
                    d2 = dArray[--n2];
                    d = dArray[--n2];
                } else {
                    d = dArray[0];
                    d2 = dArray[1];
                }
                boolean bl2 = bl = n >= 6;
                if (Double.isFinite(d) && Double.isFinite(d2)) {
                    Point point = new Point((int)d, (int)d2);
                    if (!Numerics.isInteger(d)) {
                        point.x ^= 0xFFFFFFFF;
                    }
                    if (!Numerics.isInteger(d2)) {
                        point.y ^= 0xFFFFFFFF;
                    }
                    if (bl) {
                        this.lastPoint = point;
                        break;
                    }
                    this.firstPoint = point;
                } else if (bl) {
                    if (this.firstPoint != null) break;
                    return;
                }
                n = 6;
                continue;
            }
            if (++n != 4) continue;
            return;
        } while (n <= 9);
        this.take(polylineBuffer.opposite);
        this.take(polylineBuffer);
        if (polylineBuffer2 != null) {
            polylineBuffer3 = polylineBuffer2.opposite;
            this.take(polylineBuffer2);
            this.take(polylineBuffer3);
        }
    }

    private void take(PolylineBuffer polylineBuffer) {
        if (polylineBuffer != null && polylineBuffer.size != 0) {
            this.add(Arrays.copyOf(polylineBuffer.coordinates, polylineBuffer.size));
            polylineBuffer.clear();
        } else {
            this.add(null);
        }
    }

    final boolean isExtremity(Point point) {
        return point.equals(this.firstPoint) || point.equals(this.lastPoint);
    }

    final boolean addOrMerge(Map<Point, Fragments> map) {
        Fragments fragments = map.remove(this.firstPoint);
        Fragments fragments2 = map.remove(this.lastPoint);
        if (fragments != null) {
            map.remove(this.addAll(fragments, true));
        }
        if (fragments2 != null) {
            map.remove(this.addAll(fragments2, false));
        }
        if (this.firstPoint != null && this.firstPoint.equals(this.lastPoint)) {
            map.remove(this.firstPoint);
            map.remove(this.lastPoint);
            return true;
        }
        if (this.firstPoint != null) {
            map.put(this.firstPoint, this);
        }
        if (this.lastPoint != null) {
            map.put(this.lastPoint, this);
        }
        return this.firstPoint == null && this.lastPoint == null;
    }

    private Point addAll(Fragments fragments, boolean bl) {
        int n;
        assert (((this.size() | fragments.size()) & 1) == 0);
        if (this.lastPoint != null && this.lastPoint.equals(fragments.firstPoint)) {
            n = 0;
        } else if (this.firstPoint != null && this.firstPoint.equals(fragments.firstPoint)) {
            n = 1;
        } else if (this.lastPoint != null && this.lastPoint.equals(fragments.lastPoint)) {
            n = 2;
        } else if (this.firstPoint != null && this.firstPoint.equals(fragments.lastPoint)) {
            n = 3;
        } else {
            throw new AssertionError();
        }
        if (bl) {
            n ^= 3;
        }
        if ((n & 1) != 0) {
            this.reverse();
        }
        if ((n & 2) != 0) {
            fragments.reverse();
        }
        if (bl) {
            this.addAll(0, fragments);
            this.firstPoint = fragments.firstPoint;
            return fragments.lastPoint;
        }
        this.addAll(fragments);
        this.lastPoint = fragments.lastPoint;
        return fragments.firstPoint;
    }

    private void reverse() {
        Collections.reverse(this);
        Point point = this.firstPoint;
        this.firstPoint = this.lastPoint;
        this.lastPoint = point;
    }

    final PolylineBuffer[] toPolylines() {
        PolylineBuffer[] polylineBufferArray = new PolylineBuffer[this.size()];
        for (int i = 0; i < polylineBufferArray.length; ++i) {
            double[] dArray = (double[])this.get(i);
            if (dArray == null) continue;
            polylineBufferArray[i] = new PolylineBuffer(dArray);
        }
        return polylineBufferArray;
    }
}

