/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import javax.measure.Quantity;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.image.AnnotatedImage;
import org.apache.sis.image.BandSelectImage;
import org.apache.sis.image.BandedSampleConverter;
import org.apache.sis.image.DataType;
import org.apache.sis.image.ErrorHandler;
import org.apache.sis.image.ImageAdapter;
import org.apache.sis.image.Interpolation;
import org.apache.sis.image.MaskedImage;
import org.apache.sis.image.PrefetchedImage;
import org.apache.sis.image.RecoloredImage;
import org.apache.sis.image.ResampledImage;
import org.apache.sis.image.StatisticsCalculator;
import org.apache.sis.image.Visualization;
import org.apache.sis.internal.coverage.j2d.ImageLayout;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.TiledImage;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.processing.isoline.Isolines;
import org.apache.sis.math.Statistics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class ImageProcessor
implements Cloneable {
    private static final WeakHashSet<RenderedImage> CACHE = new WeakHashSet<RenderedImage>(RenderedImage.class);
    private ImageLayout layout = ImageLayout.DEFAULT;
    private Interpolation interpolation;
    private Number[] fillValues;
    private Function<Category, Color[]> colors;
    private Quantity<?>[] positionalAccuracyHints;
    private Mode executionMode = Mode.DEFAULT;
    private ErrorHandler errorHandler = ErrorHandler.THROW;

    static RenderedImage unique(RenderedImage renderedImage) {
        return CACHE.unique(renderedImage);
    }

    public ImageProcessor() {
        this.interpolation = Interpolation.BILINEAR;
    }

    final synchronized ImageLayout getImageLayout() {
        return this.layout;
    }

    final synchronized void setImageLayout(ImageLayout imageLayout) {
        ArgumentChecks.ensureNonNull("layout", imageLayout);
        this.layout = imageLayout;
    }

    public synchronized Interpolation getInterpolation() {
        return this.interpolation;
    }

    public synchronized void setInterpolation(Interpolation interpolation) {
        ArgumentChecks.ensureNonNull("method", interpolation);
        this.interpolation = interpolation;
    }

    public synchronized Number[] getFillValues() {
        return this.fillValues != null ? (Number[])this.fillValues.clone() : null;
    }

    public synchronized void setFillValues(Number ... numberArray) {
        this.fillValues = numberArray != null ? (Number[])numberArray.clone() : null;
    }

    public synchronized Function<Category, Color[]> getCategoryColors() {
        return this.colors;
    }

    public synchronized void setCategoryColors(Function<Category, Color[]> function) {
        this.colors = function;
    }

    public synchronized Resizing getImageResizingPolicy() {
        return this.layout.isBoundsAdjustmentAllowed ? Resizing.EXPAND : Resizing.NONE;
    }

    public synchronized void setImageResizingPolicy(Resizing resizing) {
        ArgumentChecks.ensureNonNull("policy", (Object)resizing);
        this.layout = resizing == Resizing.EXPAND ? ImageLayout.SIZE_ADJUST : ImageLayout.DEFAULT;
    }

    public synchronized Quantity<?>[] getPositionalAccuracyHints() {
        return this.positionalAccuracyHints != null ? (Quantity[])this.positionalAccuracyHints.clone() : new Quantity[]{};
    }

    public synchronized void setPositionalAccuracyHints(Quantity<?> ... quantityArray) {
        if (quantityArray != null) {
            Quantity[] quantityArray2 = new Quantity[quantityArray.length];
            int n = 0;
            for (Quantity<?> quantity : quantityArray) {
                if (quantity == null) continue;
                quantityArray2[n++] = quantity;
            }
            if (n != 0) {
                this.positionalAccuracyHints = ArraysExt.resize(quantityArray2, n);
                return;
            }
        }
        this.positionalAccuracyHints = null;
    }

    public synchronized Mode getExecutionMode() {
        return this.executionMode;
    }

    public synchronized void setExecutionMode(Mode mode) {
        ArgumentChecks.ensureNonNull("mode", (Object)mode);
        this.executionMode = mode;
    }

    private boolean parallel(RenderedImage renderedImage) {
        assert (Thread.holdsLock(this));
        switch (this.executionMode) {
            case PARALLEL: {
                return true;
            }
            case SEQUENTIAL: {
                return false;
            }
        }
        if (renderedImage instanceof BufferedImage) {
            return true;
        }
        return renderedImage.getClass().getName().startsWith("org.apache.sis.");
    }

    public synchronized ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public synchronized void setErrorHandler(ErrorHandler errorHandler) {
        ArgumentChecks.ensureNonNull("handler", errorHandler);
        this.errorHandler = errorHandler;
    }

    private boolean failOnException() {
        assert (Thread.holdsLock(this));
        return this.errorHandler == ErrorHandler.THROW;
    }

    public DoubleUnaryOperator filterNodataValues(Number ... numberArray) {
        return numberArray != null ? StatisticsCalculator.filterNodataValues(numberArray) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statistics[] valueOfStatistics(RenderedImage renderedImage, Shape shape, DoubleUnaryOperator ... doubleUnaryOperatorArray) {
        ErrorHandler errorHandler;
        boolean bl;
        boolean bl2;
        Object object;
        ArgumentChecks.ensureNonNull("source", renderedImage);
        if (shape == null && (doubleUnaryOperatorArray == null || ArraysExt.allEquals(doubleUnaryOperatorArray, null)) && (object = renderedImage.getProperty("org.apache.sis.Statistics")) instanceof Statistics[]) {
            return (Statistics[])object;
        }
        Object object2 = this;
        synchronized (object2) {
            bl2 = this.parallel(renderedImage);
            bl = this.failOnException();
            errorHandler = this.errorHandler;
        }
        object2 = new StatisticsCalculator(renderedImage, shape, doubleUnaryOperatorArray, bl2, bl);
        Object object3 = ((AnnotatedImage)object2).getProperty("org.apache.sis.Statistics");
        ((AnnotatedImage)object2).logAndClearError(ImageProcessor.class, "valueOfStatistics", errorHandler);
        return (Statistics[])object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage statistics(RenderedImage renderedImage, Shape shape, DoubleUnaryOperator ... doubleUnaryOperatorArray) {
        boolean bl;
        boolean bl2;
        ArgumentChecks.ensureNonNull("source", renderedImage);
        if (shape == null && (doubleUnaryOperatorArray == null || ArraysExt.allEquals(doubleUnaryOperatorArray, null)) && ArraysExt.contains(renderedImage.getPropertyNames(), "org.apache.sis.Statistics")) {
            return renderedImage;
        }
        ImageProcessor imageProcessor = this;
        synchronized (imageProcessor) {
            bl2 = this.parallel(renderedImage);
            bl = this.failOnException();
        }
        return new StatisticsCalculator(renderedImage, shape, doubleUnaryOperatorArray, bl2, bl).unique();
    }

    public RenderedImage stretchColorRamp(RenderedImage renderedImage, Map<String, ?> map) {
        ArgumentChecks.ensureNonNull("source", renderedImage);
        return RecoloredImage.stretchColorRamp(this, renderedImage, map);
    }

    public RenderedImage selectBands(RenderedImage renderedImage, int ... nArray) {
        ArgumentChecks.ensureNonNull("source", renderedImage);
        return BandSelectImage.create(renderedImage, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage mask(RenderedImage renderedImage, Shape shape, boolean bl) {
        Number[] numberArray;
        ArgumentChecks.ensureNonNull("source", renderedImage);
        ArgumentChecks.ensureNonNull("mask", shape);
        ImageProcessor imageProcessor = this;
        synchronized (imageProcessor) {
            numberArray = this.fillValues;
        }
        return ImageProcessor.unique(new MaskedImage(renderedImage, shape, bl, numberArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage convert(RenderedImage renderedImage, NumberRange<?>[] numberRangeArray, MathTransform1D[] mathTransform1DArray, DataType dataType, ColorModel colorModel) {
        ImageLayout imageLayout;
        ArgumentChecks.ensureNonNull("source", renderedImage);
        ArgumentChecks.ensureNonNull("converters", mathTransform1DArray);
        ArgumentChecks.ensureNonNull("targetType", (Object)dataType);
        ArgumentChecks.ensureSizeBetween("converters", 1, ImageUtilities.getNumBands(renderedImage), mathTransform1DArray.length);
        mathTransform1DArray = (MathTransform1D[])mathTransform1DArray.clone();
        for (int i = 0; i < mathTransform1DArray.length; ++i) {
            ArgumentChecks.ensureNonNullElement("converters", i, mathTransform1DArray[i]);
        }
        ImageProcessor imageProcessor = this;
        synchronized (imageProcessor) {
            imageLayout = this.layout;
        }
        return ImageProcessor.unique(BandedSampleConverter.create(renderedImage, imageLayout, numberRangeArray, mathTransform1DArray, dataType.toDataBufferType(), colorModel));
    }

    private static void ensureNonEmpty(Rectangle rectangle) {
        if (rectangle != null && rectangle.isEmpty()) {
            throw new IllegalArgumentException(Errors.format((short)29, "bounds"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage resample(RenderedImage renderedImage, Rectangle rectangle, MathTransform mathTransform) {
        RenderedImage renderedImage2;
        RenderedImage renderedImage3;
        block6: {
            Quantity<?>[] quantityArray;
            Number[] numberArray;
            Interpolation interpolation;
            Object object;
            ArgumentChecks.ensureNonNull("source", renderedImage);
            ArgumentChecks.ensureNonNull("bounds", rectangle);
            ArgumentChecks.ensureNonNull("toSource", mathTransform);
            ImageProcessor.ensureNonEmpty(rectangle);
            renderedImage3 = renderedImage;
            SampleModel sampleModel = renderedImage.getSampleModel();
            boolean bl = mathTransform.isIdentity();
            renderedImage2 = null;
            while (true) {
                if (bl && rectangle.x == renderedImage.getMinX() && rectangle.y == renderedImage.getMinY() && rectangle.width == renderedImage.getWidth() && rectangle.height == renderedImage.getHeight()) {
                    renderedImage2 = renderedImage;
                    break block6;
                }
                if (!Objects.equals(sampleModel, renderedImage.getSampleModel())) break;
                if (renderedImage instanceof ImageAdapter) {
                    renderedImage = ((ImageAdapter)renderedImage).source;
                    continue;
                }
                if (!(renderedImage instanceof ResampledImage) || (object = renderedImage.getSources()) == null || object.size() != 1) break;
                mathTransform = MathTransforms.concatenate(mathTransform, ((ResampledImage)renderedImage).toSource);
                bl = mathTransform.isIdentity();
                renderedImage = (RenderedImage)object.get(0);
            }
            ImageProcessor imageProcessor = this;
            synchronized (imageProcessor) {
                object = this.layout;
                interpolation = this.interpolation;
                numberArray = this.fillValues;
                quantityArray = this.positionalAccuracyHints;
            }
            renderedImage2 = ImageProcessor.unique(new ResampledImage(renderedImage, ((ImageLayout)object).createCompatibleSampleModel(renderedImage, rectangle), ((ImageLayout)object).getMinTile(), rectangle, mathTransform, interpolation, numberArray, quantityArray));
        }
        return RecoloredImage.applySameColors(renderedImage2, renderedImage3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage prefetch(RenderedImage renderedImage, Rectangle rectangle) {
        ErrorHandler errorHandler;
        boolean bl;
        if (renderedImage == null || renderedImage instanceof BufferedImage || renderedImage instanceof TiledImage) {
            return renderedImage;
        }
        while (renderedImage instanceof PrefetchedImage) {
            renderedImage = ((PrefetchedImage)renderedImage).source;
        }
        Object object = this;
        synchronized (object) {
            bl = this.parallel(renderedImage);
            errorHandler = this.errorHandler;
        }
        object = new PrefetchedImage(renderedImage, rectangle, errorHandler, bl);
        return ((PrefetchedImage)object).isEmpty() ? renderedImage : object;
    }

    public RenderedImage visualize(RenderedImage renderedImage, Map<NumberRange<?>, Color[]> map) {
        ArgumentChecks.ensureNonNull("source", renderedImage);
        ArgumentChecks.ensureNonNull("colors", map);
        return this.visualize(new Visualization.Builder(renderedImage, map.entrySet()));
    }

    public RenderedImage visualize(RenderedImage renderedImage, List<SampleDimension> list) {
        ArgumentChecks.ensureNonNull("source", renderedImage);
        return this.visualize(new Visualization.Builder(null, renderedImage, null, list));
    }

    public RenderedImage visualize(RenderedImage renderedImage, Rectangle rectangle, MathTransform mathTransform, List<SampleDimension> list) {
        ArgumentChecks.ensureNonNull("source", renderedImage);
        ArgumentChecks.ensureNonNull("bounds", rectangle);
        ArgumentChecks.ensureNonNull("toSource", mathTransform);
        ImageProcessor.ensureNonEmpty(rectangle);
        return this.visualize(new Visualization.Builder(rectangle, renderedImage, mathTransform, list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RenderedImage visualize(Visualization.Builder builder) {
        ImageProcessor imageProcessor = this;
        synchronized (imageProcessor) {
            builder.layout = this.layout;
            builder.interpolation = this.interpolation;
            builder.categoryColors = this.colors;
            builder.fillValues = this.fillValues;
            builder.positionalAccuracyHints = this.positionalAccuracyHints;
        }
        try {
            return builder.create(this);
        }
        catch (IllegalStateException | NoninvertibleTransformException exception) {
            throw new IllegalArgumentException(Resources.format((short)66), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NavigableMap<Double, Shape>> isolines(RenderedImage renderedImage, double[][] dArray, MathTransform mathTransform) {
        boolean bl;
        ImageProcessor imageProcessor = this;
        synchronized (imageProcessor) {
            bl = this.parallel(renderedImage);
        }
        if (bl) {
            return Isolines.toList(Isolines.parallelGenerate(renderedImage, dArray, mathTransform));
        }
        try {
            return Isolines.toList(Isolines.generate(renderedImage, dArray, mathTransform));
        }
        catch (TransformException transformException) {
            throw (ImagingOpException)new ImagingOpException(null).initCause(transformException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            Object[] objectArray;
            Function<Category, Color[]> function;
            Object[] objectArray2;
            Interpolation interpolation;
            ErrorHandler errorHandler;
            Mode mode;
            ImageProcessor imageProcessor = (ImageProcessor)object;
            ImageProcessor imageProcessor2 = this;
            synchronized (imageProcessor2) {
                mode = this.executionMode;
                errorHandler = this.errorHandler;
                interpolation = this.interpolation;
                objectArray2 = this.fillValues;
                function = this.colors;
                objectArray = this.positionalAccuracyHints;
            }
            imageProcessor2 = imageProcessor;
            synchronized (imageProcessor2) {
                return errorHandler.equals(imageProcessor.errorHandler) && mode.equals((Object)imageProcessor.executionMode) && interpolation.equals(imageProcessor.interpolation) && Objects.equals(function, imageProcessor.colors) && Arrays.equals(objectArray2, imageProcessor.fillValues) && Arrays.equals(objectArray, imageProcessor.positionalAccuracyHints);
            }
        }
        return false;
    }

    public synchronized int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.errorHandler, this.executionMode, this.interpolation}) + 37 * Arrays.hashCode(this.fillValues) + 31 * Objects.hashCode(this.colors) + 39 * Arrays.hashCode(this.positionalAccuracyHints);
    }

    public synchronized ImageProcessor clone() {
        try {
            return (ImageProcessor)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public static enum Mode {
        PARALLEL,
        SEQUENTIAL,
        DEFAULT;

    }

    public static enum Resizing {
        NONE,
        EXPAND;

    }
}

