/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public final class PixelTranslation
extends Static
implements Serializable {
    private static final long serialVersionUID = -5671620211497720808L;
    private static final MathTransform[] translations = new MathTransform[10];
    public final PixelOrientation orientation;
    public final double dx;
    public final double dy;
    private static final Map<PixelOrientation, PixelTranslation> ORIENTATIONS = new HashMap<PixelOrientation, PixelTranslation>(12);

    private static void add(PixelOrientation pixelOrientation, double d, double d2) {
        if (ORIENTATIONS.put(pixelOrientation, new PixelTranslation(pixelOrientation, d, d2)) != null) {
            throw new AssertionError();
        }
    }

    private PixelTranslation(PixelOrientation pixelOrientation, double d, double d2) {
        this.orientation = pixelOrientation;
        this.dx = d;
        this.dy = d2;
    }

    public static PixelOrientation getPixelOrientation(PixelInCell pixelInCell) {
        if (pixelInCell == null) {
            return null;
        }
        if (pixelInCell.equals(PixelInCell.CELL_CENTER)) {
            return PixelOrientation.CENTER;
        }
        if (pixelInCell.equals(PixelInCell.CELL_CORNER)) {
            return PixelOrientation.UPPER_LEFT;
        }
        throw new IllegalArgumentException(Errors.format((short)45, "anchor", pixelInCell));
    }

    public static double getPixelTranslation(PixelInCell pixelInCell) {
        if (PixelInCell.CELL_CENTER.equals(pixelInCell)) {
            return 0.0;
        }
        if (PixelInCell.CELL_CORNER.equals(pixelInCell)) {
            return -0.5;
        }
        throw new IllegalArgumentException(Errors.format((short)45, "anchor", pixelInCell));
    }

    public static PixelTranslation getPixelTranslation(PixelOrientation pixelOrientation) {
        PixelTranslation pixelTranslation = ORIENTATIONS.get(pixelOrientation);
        if (pixelTranslation == null) {
            throw new IllegalArgumentException(Errors.format((short)45, "anchor", pixelOrientation));
        }
        return pixelTranslation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MathTransform translate(MathTransform mathTransform, PixelInCell pixelInCell, PixelInCell pixelInCell2) {
        MathTransform mathTransform2;
        if (mathTransform == null || pixelInCell2.equals(pixelInCell)) {
            return mathTransform;
        }
        int n = mathTransform.getSourceDimensions();
        double d = PixelTranslation.getPixelTranslation(pixelInCell2) - PixelTranslation.getPixelTranslation(pixelInCell);
        int n2 = d == -0.5 ? 2 * n - 2 : (d == 0.5 ? 2 * n - 1 : -1);
        if (n2 < 0 || n2 >= translations.length) {
            mathTransform2 = MathTransforms.uniformTranslation(n, d);
            return MathTransforms.concatenate(mathTransform2, mathTransform);
        }
        MathTransform[] mathTransformArray = translations;
        synchronized (translations) {
            mathTransform2 = translations[n2];
            if (mathTransform2 != null) return MathTransforms.concatenate(mathTransform2, mathTransform);
            mathTransform2 = MathTransforms.uniformTranslation(n, d);
            PixelTranslation.translations[n2] = mathTransform2;
            // ** MonitorExit[var8_7] (shouldn't be in output)
            return MathTransforms.concatenate(mathTransform2, mathTransform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MathTransform translate(MathTransform mathTransform, PixelOrientation pixelOrientation, PixelOrientation pixelOrientation2, int n, int n2) {
        MathTransform mathTransform2;
        if (mathTransform == null || pixelOrientation2.equals(pixelOrientation)) {
            return mathTransform;
        }
        int n3 = mathTransform.getSourceDimensions();
        if (n < 0 || n >= n3) {
            throw PixelTranslation.illegalDimension("xDimension", n);
        }
        if (n2 < 0 || n2 >= n3) {
            throw PixelTranslation.illegalDimension("yDimension", n2);
        }
        if (n == n2) {
            throw PixelTranslation.illegalDimension("xDimension", "yDimension");
        }
        PixelTranslation pixelTranslation = PixelTranslation.getPixelTranslation(pixelOrientation);
        PixelTranslation pixelTranslation2 = PixelTranslation.getPixelTranslation(pixelOrientation2);
        double d = pixelTranslation2.dx - pixelTranslation.dx;
        double d2 = pixelTranslation2.dy - pixelTranslation.dy;
        if (n3 == 2 && (n | n2) == 1 && d == d2 && Math.abs(d) == 0.5) {
            int n4 = d >= 0.0 ? 3 : 2;
            MathTransform[] mathTransformArray = translations;
            synchronized (translations) {
                mathTransform2 = translations[n4];
                if (mathTransform2 == null) {
                    mathTransform2 = MathTransforms.uniformTranslation(n3, d);
                    PixelTranslation.translations[n4] = mathTransform2;
                }
                // ** MonitorExit[var14_12] (shouldn't be in output)
            }
        } else {
            MatrixSIS matrixSIS = Matrices.createIdentity(n3 + 1);
            matrixSIS.setElement(n, n3, d);
            matrixSIS.setElement(n2, n3, d2);
            mathTransform2 = MathTransforms.linear(matrixSIS);
        }
        return MathTransforms.concatenate(mathTransform2, mathTransform);
    }

    private static IllegalArgumentException illegalDimension(String string, Object object) {
        return new IllegalArgumentException(Errors.format((short)45, string, object));
    }

    public String toString() {
        return String.valueOf(this.orientation) + '[' + this.dx + ", " + this.dy + ']';
    }

    static {
        PixelTranslation.add(PixelOrientation.CENTER, 0.0, 0.0);
        PixelTranslation.add(PixelOrientation.UPPER_LEFT, -0.5, -0.5);
        PixelTranslation.add(PixelOrientation.UPPER_RIGHT, 0.5, -0.5);
        PixelTranslation.add(PixelOrientation.LOWER_LEFT, -0.5, 0.5);
        PixelTranslation.add(PixelOrientation.LOWER_RIGHT, 0.5, 0.5);
    }
}

