/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage;

import java.awt.Shape;
import java.io.Serializable;
import java.util.Objects;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Utilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class RegionOfInterest
implements LenientComparable,
Serializable {
    private static final long serialVersionUID = -8408578541189424074L;
    private final Shape geometry;
    private final CoordinateReferenceSystem crs;

    public RegionOfInterest(Shape shape, CoordinateReferenceSystem coordinateReferenceSystem) {
        ArgumentChecks.ensureNonNull("geometry", shape);
        ArgumentChecks.ensureDimensionMatches("crs", 2, coordinateReferenceSystem);
        this.geometry = shape;
        this.crs = coordinateReferenceSystem;
    }

    public Shape toShape2D(GridGeometry gridGeometry) throws TransformException {
        MathTransform2D mathTransform2D;
        try {
            MathTransform mathTransform = gridGeometry.getGridToCRS(PixelInCell.CELL_CENTER).inverse();
            if (this.crs != null && gridGeometry.isDefined(1)) {
                CoordinateOperation coordinateOperation = CRS.findOperation(this.crs, gridGeometry.getCoordinateReferenceSystem(), gridGeometry.getGeographicExtent().orElse(null));
                mathTransform = MathTransforms.concatenate(coordinateOperation.getMathTransform(), mathTransform);
            }
            mathTransform2D = MathTransforms.bidimensional(mathTransform);
        }
        catch (IllegalArgumentException | FactoryException exception) {
            throw new TransformException(null, exception);
        }
        return mathTransform2D.createTransformedShape(this.geometry);
    }

    @Override
    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object instanceof ComparisonMode) {
            RegionOfInterest regionOfInterest = (RegionOfInterest)object;
            if (comparisonMode != ComparisonMode.STRICT || object.getClass() == this.getClass()) {
                return this.geometry.equals(regionOfInterest.geometry) && Utilities.deepEquals(this.crs, regionOfInterest.crs, comparisonMode);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.geometry.hashCode() + Objects.hashCode(this.crs);
    }
}

