/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import jj2000.j2k.JJ2KExceptionHandler;
import jj2000.j2k.NoNextElementException;
import jj2000.j2k.NotImplementedError;
import jj2000.j2k.codestream.CorruptedCodestreamException;
import jj2000.j2k.codestream.HeaderInfo;
import jj2000.j2k.codestream.Markers;
import jj2000.j2k.codestream.PrecInfo;
import jj2000.j2k.codestream.ProgressionType;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.codestream.reader.CBlkInfo;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.codestream.reader.PktDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.entropy.decoder.DecLyrdCBlk;
import jj2000.j2k.image.Coord;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.quantization.dequantizer.StdDequantizerParams;
import jj2000.j2k.util.ArrayUtil;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public class FileBitstreamReaderAgent
extends BitstreamReaderAgent
implements Markers,
ProgressionType,
StdEntropyCoderOptions {
    private boolean isPsotEqualsZero = true;
    public PktDecoder pktDec;
    private ParameterList pl;
    private RandomAccessIO in;
    private int[][] firstPackOff;
    private int[] nBytes;
    private boolean printInfo = false;
    private int[] baknBytes;
    private int[][] tilePartLen;
    private int[] totTileLen;
    private int[] totTileHeadLen;
    private int firstTilePartHeadLen;
    private double totAllTileLen;
    private int mainHeadLen;
    private int headLen = 0;
    private int[][] tilePartHeadLen;
    private Vector pktHL;
    private boolean isTruncMode;
    private int remainingTileParts;
    private int[] tilePartsRead;
    private int totTilePartsRead = 0;
    private int[] tileParts;
    private int curTilePart;
    private int[][] tilePartNum;
    private boolean isEOCFound = false;
    private HeaderInfo hi;
    private CBlkInfo[][][][][] cbI;
    private int lQuit;
    private boolean usePOCQuit = false;

    public int getNumTileParts(int t2) {
        if (this.firstPackOff == null || this.firstPackOff[t2] == null) {
            throw new Error("Tile " + t2 + " not found in input codestream.");
        }
        return this.firstPackOff[t2].length;
    }

    public CBlkInfo[][][][][] getCBlkInfo() {
        return this.cbI;
    }

    public FileBitstreamReaderAgent(HeaderDecoder hd, RandomAccessIO ehs, DecoderSpecs decSpec, ParameterList pl, boolean cdstrInfo, HeaderInfo hi) throws IOException {
        super(hd, decSpec);
        int ncbQuit;
        this.pl = pl;
        this.printInfo = cdstrInfo;
        this.hi = hi;
        String strInfo = "Codestream elements information in bytes (offset, total length, header length):\n\n";
        this.usePOCQuit = pl.getBooleanParameter("poc_quit");
        boolean parsing = pl.getBooleanParameter("parsing");
        try {
            this.trate = pl.getFloatParameter("rate");
            if (this.trate == -1.0f) {
                this.trate = Float.MAX_VALUE;
            }
        }
        catch (NumberFormatException e) {
            throw new Error("Invalid value in 'rate' option: " + pl.getParameter("rate"));
        }
        catch (IllegalArgumentException e) {
            throw new Error("'rate' option is missing");
        }
        try {
            this.tnbytes = pl.getIntParameter("nbytes");
        }
        catch (NumberFormatException e) {
            throw new Error("Invalid value in 'nbytes' option: " + pl.getParameter("nbytes"));
        }
        catch (IllegalArgumentException e) {
            throw new Error("'nbytes' option is missing");
        }
        ParameterList defaults = pl.getDefaultParameterList();
        boolean rateInBytes = (float)this.tnbytes != defaults.getFloatParameter("nbytes");
        if (rateInBytes) {
            this.trate = (float)this.tnbytes * 8.0f / (float)hd.getMaxCompImgWidth() / (float)hd.getMaxCompImgHeight();
        } else {
            this.tnbytes = (int)(this.trate * (float)hd.getMaxCompImgWidth() * (float)hd.getMaxCompImgHeight()) / 8;
        }
        this.isTruncMode = !pl.getBooleanParameter("parsing");
        try {
            ncbQuit = pl.getIntParameter("ncb_quit");
        }
        catch (NumberFormatException e) {
            throw new Error("Invalid value in 'ncb_quit' option: " + pl.getParameter("ncb_quit"));
        }
        catch (IllegalArgumentException e) {
            throw new Error("'ncb_quit' option is missing");
        }
        if (ncbQuit != -1 && !this.isTruncMode) {
            throw new Error("Cannot use -parsing and -ncb_quit condition at the same time.");
        }
        try {
            this.lQuit = pl.getIntParameter("l_quit");
        }
        catch (NumberFormatException e) {
            throw new Error("Invalid value in 'l_quit' option: " + pl.getParameter("l_quit"));
        }
        catch (IllegalArgumentException e) {
            throw new Error("'l_quit' option is missing");
        }
        this.in = ehs;
        this.pktDec = new PktDecoder(decSpec, hd, ehs, this, this.isTruncMode, ncbQuit);
        this.tileParts = new int[this.nt];
        this.totTileLen = new int[this.nt];
        this.tilePartLen = new int[this.nt][];
        this.tilePartNum = new int[this.nt][];
        this.firstPackOff = new int[this.nt][];
        this.tilePartsRead = new int[this.nt];
        this.totTileHeadLen = new int[this.nt];
        this.tilePartHeadLen = new int[this.nt][];
        this.nBytes = new int[this.nt];
        this.baknBytes = new int[this.nt];
        hd.nTileParts = new int[this.nt];
        this.isTruncMode = this.isTruncMode;
        int t2 = 0;
        int tp = 0;
        int tptot = 0;
        int cdstreamStart = hd.mainHeadOff;
        this.headLen = this.mainHeadLen = this.in.getPos() - cdstreamStart;
        this.anbytes = ncbQuit == -1 ? this.mainHeadLen : 0;
        strInfo = strInfo + "Main header length    : " + cdstreamStart + ", " + this.mainHeadLen + ", " + this.mainHeadLen + "\n";
        if (this.anbytes > this.tnbytes) {
            throw new Error("Requested bitrate is too small.");
        }
        boolean rateReached = false;
        boolean numtp = false;
        this.totAllTileLen = 0.0;
        this.remainingTileParts = this.nt;
        int maxTP = this.nt;
        try {
            while (this.remainingTileParts != 0) {
                int tilePartStart = this.in.getPos();
                try {
                    t2 = this.readTilePartHeader();
                    if (this.isEOCFound) break;
                    tp = this.tilePartsRead[t2];
                    if (this.isPsotEqualsZero) {
                        this.tilePartLen[t2][tp] = this.in.length() - 2 - tilePartStart;
                    }
                }
                catch (EOFException e) {
                    this.firstPackOff[t2][tp] = this.in.length();
                    throw e;
                }
                int pos = this.in.getPos();
                if (this.isTruncMode && ncbQuit == -1 && pos - cdstreamStart > this.tnbytes) {
                    this.firstPackOff[t2][tp] = this.in.length();
                    rateReached = true;
                    break;
                }
                this.firstPackOff[t2][tp] = pos;
                this.tilePartHeadLen[t2][tp] = pos - tilePartStart;
                strInfo = strInfo + "Tile-part " + tp + " of tile " + t2 + " : " + tilePartStart + ", " + this.tilePartLen[t2][tp] + ", " + this.tilePartHeadLen[t2][tp] + "\n";
                int n = t2;
                this.totTileLen[n] = this.totTileLen[n] + this.tilePartLen[t2][tp];
                int n2 = t2;
                this.totTileHeadLen[n2] = this.totTileHeadLen[n2] + this.tilePartHeadLen[t2][tp];
                this.totAllTileLen += (double)this.tilePartLen[t2][tp];
                if (this.isTruncMode) {
                    if (this.anbytes + this.tilePartLen[t2][tp] > this.tnbytes) {
                        this.anbytes += this.tilePartHeadLen[t2][tp];
                        this.headLen += this.tilePartHeadLen[t2][tp];
                        rateReached = true;
                        int n3 = t2;
                        this.nBytes[n3] = this.nBytes[n3] + (this.tnbytes - this.anbytes);
                        break;
                    }
                    this.anbytes += this.tilePartHeadLen[t2][tp];
                    this.headLen += this.tilePartHeadLen[t2][tp];
                    int n4 = t2;
                    this.nBytes[n4] = this.nBytes[n4] + (this.tilePartLen[t2][tp] - this.tilePartHeadLen[t2][tp]);
                } else {
                    if (this.anbytes + this.tilePartHeadLen[t2][tp] > this.tnbytes) break;
                    this.anbytes += this.tilePartHeadLen[t2][tp];
                    this.headLen += this.tilePartHeadLen[t2][tp];
                }
                if (tptot == 0) {
                    this.firstTilePartHeadLen = this.tilePartHeadLen[t2][tp];
                }
                int n5 = t2;
                this.tilePartsRead[n5] = this.tilePartsRead[n5] + 1;
                this.in.seek(tilePartStart + this.tilePartLen[t2][tp]);
                --this.remainingTileParts;
                --maxTP;
                ++tptot;
                if (!this.isPsotEqualsZero) continue;
                if (this.remainingTileParts != 0) {
                    FacilityManager.getMsgLogger().printmsg(2, "Some tile-parts have not been found. The codestream may be corrupted.");
                }
                break;
            }
        }
        catch (EOFException e) {
            if (this.printInfo) {
                FacilityManager.getMsgLogger().printmsg(1, strInfo);
            }
            FacilityManager.getMsgLogger().printmsg(2, "Codestream truncated in tile " + t2);
            int fileLen = this.in.length();
            if (fileLen < this.tnbytes) {
                this.tnbytes = fileLen;
                this.trate = (float)this.tnbytes * 8.0f / (float)hd.getMaxCompImgWidth() / (float)hd.getMaxCompImgHeight();
            }
            if (!this.isTruncMode) {
                this.allocateRate();
            }
            if (pl.getParameter("res") == null) {
                this.targetRes = decSpec.dls.getMin();
            } else {
                try {
                    this.targetRes = pl.getIntParameter("res");
                    if (this.targetRes < 0) {
                        throw new IllegalArgumentException("Specified negative resolution level index: " + this.targetRes);
                    }
                }
                catch (NumberFormatException f) {
                    throw new IllegalArgumentException("Invalid resolution level index ('-res' option) " + pl.getParameter("res"));
                }
            }
            int mdl = decSpec.dls.getMin();
            if (this.targetRes > mdl) {
                FacilityManager.getMsgLogger().printmsg(2, "Specified resolution level (" + this.targetRes + ") is larger" + " than the maximum value. Setting it to " + mdl + " (maximum value)");
                this.targetRes = mdl;
            }
            for (int tIdx = 0; tIdx < this.nt; ++tIdx) {
                this.baknBytes[tIdx] = this.nBytes[tIdx];
            }
            return;
        }
        this.remainingTileParts = 0;
        if (pl.getParameter("res") == null) {
            this.targetRes = decSpec.dls.getMin();
        } else {
            try {
                this.targetRes = pl.getIntParameter("res");
                if (this.targetRes < 0) {
                    throw new IllegalArgumentException("Specified negative resolution level index: " + this.targetRes);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid resolution level index ('-res' option) " + pl.getParameter("res"));
            }
        }
        int mdl = decSpec.dls.getMin();
        if (this.targetRes > mdl) {
            FacilityManager.getMsgLogger().printmsg(2, "Specified resolution level (" + this.targetRes + ") is larger" + " than the maximum possible. Setting it to " + mdl + " (maximum possible)");
            this.targetRes = mdl;
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, strInfo);
        }
        if (!this.isEOCFound && !this.isPsotEqualsZero) {
            try {
                if (!rateReached && !this.isPsotEqualsZero && this.in.readShort() != -39) {
                    FacilityManager.getMsgLogger().printmsg(2, "EOC marker not found. Codestream is corrupted.");
                }
            }
            catch (EOFException e) {
                FacilityManager.getMsgLogger().printmsg(2, "EOC marker is missing");
            }
        }
        if (!this.isTruncMode) {
            this.allocateRate();
        } else if (this.in.getPos() >= this.tnbytes) {
            this.anbytes += 2;
        }
        for (int tIdx = 0; tIdx < this.nt; ++tIdx) {
            this.baknBytes[tIdx] = this.nBytes[tIdx];
            if (!this.printInfo) continue;
            FacilityManager.getMsgLogger().println("" + hi.toStringTileHeader(tIdx, this.tilePartLen[tIdx].length), 2, 2);
        }
    }

    private void allocateRate() {
        int rem;
        int stopOff = this.tnbytes;
        this.anbytes += 2;
        if (this.anbytes > stopOff) {
            throw new Error("Requested bitrate is too small for parsing");
        }
        int totnByte = rem = stopOff - this.anbytes;
        for (int t2 = this.nt - 1; t2 > 0; --t2) {
            this.nBytes[t2] = (int)((double)totnByte * ((double)this.totTileLen[t2] / this.totAllTileLen));
            rem -= this.nBytes[t2];
        }
        this.nBytes[0] = rem;
    }

    private int readTilePartHeader() throws IOException {
        int nrOfTileParts;
        int tilePart;
        int psot;
        int tile;
        int lsot;
        HeaderInfo.SOT ms = this.hi.getNewSOT();
        short marker = this.in.readShort();
        if (marker != -112) {
            if (marker == -39) {
                this.isEOCFound = true;
                return -1;
            }
            throw new CorruptedCodestreamException("SOT tag not found in tile-part start");
        }
        this.isEOCFound = false;
        ms.lsot = lsot = this.in.readUnsignedShort();
        if (lsot != 10) {
            throw new CorruptedCodestreamException("Wrong length for SOT marker segment: " + lsot);
        }
        ms.isot = tile = this.in.readUnsignedShort();
        if (tile > 65534) {
            throw new CorruptedCodestreamException("Tile index too high in tile-part.");
        }
        ms.psot = psot = this.in.readInt();
        boolean bl = this.isPsotEqualsZero = psot == 0;
        if (psot < 0) {
            throw new NotImplementedError("Tile length larger than maximum supported");
        }
        ms.tpsot = tilePart = this.in.read();
        if (tilePart != this.tilePartsRead[tile] || tilePart < 0 || tilePart > 254) {
            throw new CorruptedCodestreamException("Out of order tile-part");
        }
        ms.tnsot = nrOfTileParts = this.in.read();
        this.hi.sot.put("t" + tile + "_tp" + tilePart, ms);
        if (nrOfTileParts == 0) {
            int i;
            int nExtraTp;
            if (this.tileParts[tile] == 0 || this.tileParts[tile] == this.tilePartLen.length) {
                nExtraTp = 2;
                ++this.remainingTileParts;
            } else {
                nExtraTp = 1;
            }
            int n = tile;
            this.tileParts[n] = this.tileParts[n] + nExtraTp;
            nrOfTileParts = this.tileParts[tile];
            FacilityManager.getMsgLogger().printmsg(2, "Header of tile-part " + tilePart + " of tile " + tile + ", does not indicate the total" + " number of tile-parts. Assuming that there are " + nrOfTileParts + " tile-parts for this tile.");
            int[] tmpA = this.tilePartLen[tile];
            this.tilePartLen[tile] = new int[nrOfTileParts];
            for (i = 0; i < nrOfTileParts - nExtraTp; ++i) {
                this.tilePartLen[tile][i] = tmpA[i];
            }
            tmpA = this.tilePartNum[tile];
            this.tilePartNum[tile] = new int[nrOfTileParts];
            for (i = 0; i < nrOfTileParts - nExtraTp; ++i) {
                this.tilePartNum[tile][i] = tmpA[i];
            }
            tmpA = this.firstPackOff[tile];
            this.firstPackOff[tile] = new int[nrOfTileParts];
            for (i = 0; i < nrOfTileParts - nExtraTp; ++i) {
                this.firstPackOff[tile][i] = tmpA[i];
            }
            tmpA = this.tilePartHeadLen[tile];
            this.tilePartHeadLen[tile] = new int[nrOfTileParts];
            for (i = 0; i < nrOfTileParts - nExtraTp; ++i) {
                this.tilePartHeadLen[tile][i] = tmpA[i];
            }
        } else if (this.tileParts[tile] == 0) {
            this.remainingTileParts += nrOfTileParts - 1;
            this.tileParts[tile] = nrOfTileParts;
            this.tilePartLen[tile] = new int[nrOfTileParts];
            this.tilePartNum[tile] = new int[nrOfTileParts];
            this.firstPackOff[tile] = new int[nrOfTileParts];
            this.tilePartHeadLen[tile] = new int[nrOfTileParts];
        } else {
            if (this.tileParts[tile] > nrOfTileParts) {
                throw new CorruptedCodestreamException("Invalid number of tile-parts in tile " + tile + ": " + nrOfTileParts);
            }
            this.remainingTileParts += nrOfTileParts - this.tileParts[tile];
            if (this.tileParts[tile] != nrOfTileParts) {
                int i;
                int[] tmpA = this.tilePartLen[tile];
                this.tilePartLen[tile] = new int[nrOfTileParts];
                for (i = 0; i < this.tileParts[tile] - 1; ++i) {
                    this.tilePartLen[tile][i] = tmpA[i];
                }
                tmpA = this.tilePartNum[tile];
                this.tilePartNum[tile] = new int[nrOfTileParts];
                for (i = 0; i < this.tileParts[tile] - 1; ++i) {
                    this.tilePartNum[tile][i] = tmpA[i];
                }
                tmpA = this.firstPackOff[tile];
                this.firstPackOff[tile] = new int[nrOfTileParts];
                for (i = 0; i < this.tileParts[tile] - 1; ++i) {
                    this.firstPackOff[tile][i] = tmpA[i];
                }
                tmpA = this.tilePartHeadLen[tile];
                this.tilePartHeadLen[tile] = new int[nrOfTileParts];
                for (i = 0; i < this.tileParts[tile] - 1; ++i) {
                    this.tilePartHeadLen[tile][i] = tmpA[i];
                }
            }
        }
        this.hd.resetHeaderMarkers();
        this.hd.nTileParts[tile] = nrOfTileParts;
        do {
            this.hd.extractTilePartMarkSeg(this.in.readShort(), this.in, tile, tilePart);
        } while ((this.hd.getNumFoundMarkSeg() & 0x2000) == 0);
        this.hd.readFoundTilePartMarkSeg(tile, tilePart);
        this.tilePartLen[tile][tilePart] = psot;
        this.tilePartNum[tile][tilePart] = this.totTilePartsRead++;
        this.hd.setTileOfTileParts(tile);
        return tile;
    }

    private boolean readLyResCompPos(int[][] lys, int lye, int ress, int rese, int comps, int compe) throws IOException {
        int minlys = 10000;
        for (int c = comps; c < compe; ++c) {
            if (c >= this.mdl.length) continue;
            for (int r = ress; r < rese; ++r) {
                if (lys[c] == null || r >= lys[c].length || lys[c][r] >= minlys) continue;
                minlys = lys[c][r];
            }
        }
        int t2 = this.getTileIdx();
        boolean status = false;
        int lastByte = this.firstPackOff[t2][this.curTilePart] + this.tilePartLen[t2][this.curTilePart] - 1 - this.tilePartHeadLen[t2][this.curTilePart];
        int numLayers = (Integer)this.decSpec.nls.getTileDef(t2);
        int nPrec = 1;
        String strInfo = "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n";
        boolean pph = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(t2)).booleanValue()) {
            pph = true;
        }
        for (int l = minlys; l < lye; ++l) {
            for (int r = ress; r < rese; ++r) {
                for (int c = comps; c < compe; ++c) {
                    if (c >= this.mdl.length || r >= lys[c].length || r > this.mdl[c] || l < lys[c][r] || l >= numLayers) continue;
                    nPrec = this.pktDec.getNumPrecinct(c, r);
                    for (int p = 0; p < nPrec; ++p) {
                        int start = this.in.getPos();
                        if (pph) {
                            this.pktDec.readPktHead(l, r, c, p, this.cbI[c][r], this.nBytes);
                        }
                        if (start > lastByte && this.curTilePart < this.firstPackOff[t2].length - 1) {
                            ++this.curTilePart;
                            this.in.seek(this.firstPackOff[t2][this.curTilePart]);
                            lastByte = this.in.getPos() + this.tilePartLen[t2][this.curTilePart] - 1 - this.tilePartHeadLen[t2][this.curTilePart];
                        }
                        if (status = this.pktDec.readSOPMarker(this.nBytes, p, c, r)) {
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, strInfo);
                            }
                            return true;
                        }
                        if (!pph) {
                            status = this.pktDec.readPktHead(l, r, c, p, this.cbI[c][r], this.nBytes);
                        }
                        if (status) {
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, strInfo);
                            }
                            return true;
                        }
                        int hlen = this.in.getPos() - start;
                        this.pktHL.addElement(new Integer(hlen));
                        status = this.pktDec.readPktBody(l, r, c, p, this.cbI[c][r], this.nBytes);
                        int plen = this.in.getPos() - start;
                        strInfo = strInfo + " Pkt l=" + l + ",r=" + r + ",c=" + c + ",p=" + p + ": " + start + ", " + plen + ", " + hlen + "\n";
                        if (!status) continue;
                        if (this.printInfo) {
                            FacilityManager.getMsgLogger().printmsg(1, strInfo);
                        }
                        return true;
                    }
                }
            }
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, strInfo);
        }
        return false;
    }

    private boolean readResLyCompPos(int[][] lys, int lye, int ress, int rese, int comps, int compe) throws IOException {
        int t2 = this.getTileIdx();
        boolean status = false;
        int lastByte = this.firstPackOff[t2][this.curTilePart] + this.tilePartLen[t2][this.curTilePart] - 1 - this.tilePartHeadLen[t2][this.curTilePart];
        int minlys = 10000;
        for (int c = comps; c < compe; ++c) {
            if (c >= this.mdl.length) continue;
            for (int r = ress; r < rese; ++r) {
                if (r > this.mdl[c] || lys[c] == null || r >= lys[c].length || lys[c][r] >= minlys) continue;
                minlys = lys[c][r];
            }
        }
        String strInfo = "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n";
        int numLayers = (Integer)this.decSpec.nls.getTileDef(t2);
        boolean pph = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(t2)).booleanValue()) {
            pph = true;
        }
        int nPrec = 1;
        for (int r = ress; r < rese; ++r) {
            for (int l = minlys; l < lye; ++l) {
                for (int c = comps; c < compe; ++c) {
                    if (c >= this.mdl.length || r > this.mdl[c] || r >= lys[c].length || l < lys[c][r] || l >= numLayers) continue;
                    nPrec = this.pktDec.getNumPrecinct(c, r);
                    for (int p = 0; p < nPrec; ++p) {
                        int start = this.in.getPos();
                        if (pph) {
                            this.pktDec.readPktHead(l, r, c, p, this.cbI[c][r], this.nBytes);
                        }
                        if (start > lastByte && this.curTilePart < this.firstPackOff[t2].length - 1) {
                            ++this.curTilePart;
                            this.in.seek(this.firstPackOff[t2][this.curTilePart]);
                            lastByte = this.in.getPos() + this.tilePartLen[t2][this.curTilePart] - 1 - this.tilePartHeadLen[t2][this.curTilePart];
                        }
                        if (status = this.pktDec.readSOPMarker(this.nBytes, p, c, r)) {
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, strInfo);
                            }
                            return true;
                        }
                        if (!pph) {
                            status = this.pktDec.readPktHead(l, r, c, p, this.cbI[c][r], this.nBytes);
                        }
                        if (status) {
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, strInfo);
                            }
                            return true;
                        }
                        int hlen = this.in.getPos() - start;
                        this.pktHL.addElement(new Integer(hlen));
                        status = this.pktDec.readPktBody(l, r, c, p, this.cbI[c][r], this.nBytes);
                        int plen = this.in.getPos() - start;
                        strInfo = strInfo + " Pkt l=" + l + ",r=" + r + ",c=" + c + ",p=" + p + ": " + start + ", " + plen + ", " + hlen + "\n";
                        if (!status) continue;
                        if (this.printInfo) {
                            FacilityManager.getMsgLogger().printmsg(1, strInfo);
                        }
                        return true;
                    }
                }
            }
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, strInfo);
        }
        return false;
    }

    private boolean readResPosCompLy(int[][] lys, int lye, int ress, int rese, int comps, int compe) throws IOException {
        PrecInfo prec;
        Coord nTiles = this.getNumTiles(null);
        Coord tileI = this.getTile(null);
        int x0siz = this.hd.getImgULX();
        int y0siz = this.hd.getImgULY();
        int xsiz = x0siz + this.hd.getImgWidth();
        int ysiz = y0siz + this.hd.getImgHeight();
        int xt0siz = this.getTilePartULX();
        int yt0siz = this.getTilePartULY();
        int xtsiz = this.getNomTileWidth();
        int ytsiz = this.getNomTileHeight();
        int tx0 = tileI.x == 0 ? x0siz : xt0siz + tileI.x * xtsiz;
        int ty0 = tileI.y == 0 ? y0siz : yt0siz + tileI.y * ytsiz;
        int tx1 = tileI.x != nTiles.x - 1 ? xt0siz + (tileI.x + 1) * xtsiz : xsiz;
        int ty1 = tileI.y != nTiles.y - 1 ? yt0siz + (tileI.y + 1) * ytsiz : ysiz;
        int t2 = this.getTileIdx();
        int gcd_x = 0;
        int gcd_y = 0;
        int nPrec = 0;
        int[][] nextPrec = new int[compe][];
        int minlys = 100000;
        int minx = tx1;
        int miny = ty1;
        int maxx = tx0;
        int maxy = ty0;
        for (int c = comps; c < compe; ++c) {
            for (int r = ress; r < rese; ++r) {
                if (c >= this.mdl.length || r > this.mdl[c]) continue;
                nextPrec[c] = new int[this.mdl[c] + 1];
                if (lys[c] != null && r < lys[c].length && lys[c][r] < minlys) {
                    minlys = lys[c][r];
                }
                for (int p = this.pktDec.getNumPrecinct(c, r) - 1; p >= 0; --p) {
                    prec = this.pktDec.getPrecInfo(c, r, p);
                    if (prec.rgulx != tx0) {
                        if (prec.rgulx < minx) {
                            minx = prec.rgulx;
                        }
                        if (prec.rgulx > maxx) {
                            maxx = prec.rgulx;
                        }
                    }
                    if (prec.rguly != ty0) {
                        if (prec.rguly < miny) {
                            miny = prec.rguly;
                        }
                        if (prec.rguly > maxy) {
                            maxy = prec.rguly;
                        }
                    }
                    if (nPrec == 0) {
                        gcd_x = prec.rgw;
                        gcd_y = prec.rgh;
                    } else {
                        gcd_x = MathUtil.gcd(gcd_x, prec.rgw);
                        gcd_y = MathUtil.gcd(gcd_y, prec.rgh);
                    }
                    ++nPrec;
                }
            }
        }
        if (nPrec == 0) {
            throw new Error("Image cannot have no precinct");
        }
        int pyend = (maxy - miny) / gcd_y + 1;
        int pxend = (maxx - minx) / gcd_x + 1;
        boolean status = false;
        int lastByte = this.firstPackOff[t2][this.curTilePart] + this.tilePartLen[t2][this.curTilePart] - 1 - this.tilePartHeadLen[t2][this.curTilePart];
        int numLayers = (Integer)this.decSpec.nls.getTileDef(t2);
        String strInfo = "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n";
        boolean pph = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(t2)).booleanValue()) {
            pph = true;
        }
        for (int r = ress; r < rese; ++r) {
            int y = ty0;
            int x = tx0;
            for (int py = 0; py <= pyend; ++py) {
                for (int px = 0; px <= pxend; ++px) {
                    for (int c = comps; c < compe; ++c) {
                        if (c >= this.mdl.length || r > this.mdl[c] || nextPrec[c][r] >= this.pktDec.getNumPrecinct(c, r)) continue;
                        prec = this.pktDec.getPrecInfo(c, r, nextPrec[c][r]);
                        if (prec.rgulx != x || prec.rguly != y) continue;
                        for (int l = minlys; l < lye; ++l) {
                            if (r >= lys[c].length || l < lys[c][r] || l >= numLayers) continue;
                            int start = this.in.getPos();
                            if (pph) {
                                this.pktDec.readPktHead(l, r, c, nextPrec[c][r], this.cbI[c][r], this.nBytes);
                            }
                            if (start > lastByte && this.curTilePart < this.firstPackOff[t2].length - 1) {
                                ++this.curTilePart;
                                this.in.seek(this.firstPackOff[t2][this.curTilePart]);
                                lastByte = this.in.getPos() + this.tilePartLen[t2][this.curTilePart] - 1 - this.tilePartHeadLen[t2][this.curTilePart];
                            }
                            if (status = this.pktDec.readSOPMarker(this.nBytes, nextPrec[c][r], c, r)) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, strInfo);
                                }
                                return true;
                            }
                            if (!pph) {
                                status = this.pktDec.readPktHead(l, r, c, nextPrec[c][r], this.cbI[c][r], this.nBytes);
                            }
                            if (status) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, strInfo);
                                }
                                return true;
                            }
                            int hlen = this.in.getPos() - start;
                            this.pktHL.addElement(new Integer(hlen));
                            status = this.pktDec.readPktBody(l, r, c, nextPrec[c][r], this.cbI[c][r], this.nBytes);
                            int plen = this.in.getPos() - start;
                            strInfo = strInfo + " Pkt l=" + l + ",r=" + r + ",c=" + c + ",p=" + nextPrec[c][r] + ": " + start + ", " + plen + ", " + hlen + "\n";
                            if (!status) continue;
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, strInfo);
                            }
                            return true;
                        }
                        int[] nArray = nextPrec[c];
                        int n = r;
                        nArray[n] = nArray[n] + 1;
                    }
                    x = px != pxend ? minx + px * gcd_x : tx0;
                }
                y = py != pyend ? miny + py * gcd_y : ty0;
            }
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, strInfo);
        }
        return false;
    }

    private boolean readPosCompResLy(int[][] lys, int lye, int ress, int rese, int comps, int compe) throws IOException {
        PrecInfo prec;
        Coord nTiles = this.getNumTiles(null);
        Coord tileI = this.getTile(null);
        int x0siz = this.hd.getImgULX();
        int y0siz = this.hd.getImgULY();
        int xsiz = x0siz + this.hd.getImgWidth();
        int ysiz = y0siz + this.hd.getImgHeight();
        int xt0siz = this.getTilePartULX();
        int yt0siz = this.getTilePartULY();
        int xtsiz = this.getNomTileWidth();
        int ytsiz = this.getNomTileHeight();
        int tx0 = tileI.x == 0 ? x0siz : xt0siz + tileI.x * xtsiz;
        int ty0 = tileI.y == 0 ? y0siz : yt0siz + tileI.y * ytsiz;
        int tx1 = tileI.x != nTiles.x - 1 ? xt0siz + (tileI.x + 1) * xtsiz : xsiz;
        int ty1 = tileI.y != nTiles.y - 1 ? yt0siz + (tileI.y + 1) * ytsiz : ysiz;
        int t2 = this.getTileIdx();
        int gcd_x = 0;
        int gcd_y = 0;
        int nPrec = 0;
        int[][] nextPrec = new int[compe][];
        int minlys = 100000;
        int minx = tx1;
        int miny = ty1;
        int maxx = tx0;
        int maxy = ty0;
        for (int c = comps; c < compe; ++c) {
            for (int r = ress; r < rese; ++r) {
                if (c >= this.mdl.length || r > this.mdl[c]) continue;
                nextPrec[c] = new int[this.mdl[c] + 1];
                if (lys[c] != null && r < lys[c].length && lys[c][r] < minlys) {
                    minlys = lys[c][r];
                }
                for (int p = this.pktDec.getNumPrecinct(c, r) - 1; p >= 0; --p) {
                    prec = this.pktDec.getPrecInfo(c, r, p);
                    if (prec.rgulx != tx0) {
                        if (prec.rgulx < minx) {
                            minx = prec.rgulx;
                        }
                        if (prec.rgulx > maxx) {
                            maxx = prec.rgulx;
                        }
                    }
                    if (prec.rguly != ty0) {
                        if (prec.rguly < miny) {
                            miny = prec.rguly;
                        }
                        if (prec.rguly > maxy) {
                            maxy = prec.rguly;
                        }
                    }
                    if (nPrec == 0) {
                        gcd_x = prec.rgw;
                        gcd_y = prec.rgh;
                    } else {
                        gcd_x = MathUtil.gcd(gcd_x, prec.rgw);
                        gcd_y = MathUtil.gcd(gcd_y, prec.rgh);
                    }
                    ++nPrec;
                }
            }
        }
        if (nPrec == 0) {
            throw new Error("Image cannot have no precinct");
        }
        int pyend = (maxy - miny) / gcd_y + 1;
        int pxend = (maxx - minx) / gcd_x + 1;
        boolean status = false;
        int lastByte = this.firstPackOff[t2][this.curTilePart] + this.tilePartLen[t2][this.curTilePart] - 1 - this.tilePartHeadLen[t2][this.curTilePart];
        int numLayers = (Integer)this.decSpec.nls.getTileDef(t2);
        String strInfo = "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n";
        boolean pph = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(t2)).booleanValue()) {
            pph = true;
        }
        int y = ty0;
        int x = tx0;
        for (int py = 0; py <= pyend; ++py) {
            for (int px = 0; px <= pxend; ++px) {
                for (int c = comps; c < compe; ++c) {
                    if (c >= this.mdl.length) continue;
                    for (int r = ress; r < rese; ++r) {
                        if (r > this.mdl[c] || nextPrec[c][r] >= this.pktDec.getNumPrecinct(c, r)) continue;
                        prec = this.pktDec.getPrecInfo(c, r, nextPrec[c][r]);
                        if (prec.rgulx != x || prec.rguly != y) continue;
                        for (int l = minlys; l < lye; ++l) {
                            if (r >= lys[c].length || l < lys[c][r] || l >= numLayers) continue;
                            int start = this.in.getPos();
                            if (pph) {
                                this.pktDec.readPktHead(l, r, c, nextPrec[c][r], this.cbI[c][r], this.nBytes);
                            }
                            if (start > lastByte && this.curTilePart < this.firstPackOff[t2].length - 1) {
                                ++this.curTilePart;
                                this.in.seek(this.firstPackOff[t2][this.curTilePart]);
                                lastByte = this.in.getPos() + this.tilePartLen[t2][this.curTilePart] - 1 - this.tilePartHeadLen[t2][this.curTilePart];
                            }
                            if (status = this.pktDec.readSOPMarker(this.nBytes, nextPrec[c][r], c, r)) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, strInfo);
                                }
                                return true;
                            }
                            if (!pph) {
                                status = this.pktDec.readPktHead(l, r, c, nextPrec[c][r], this.cbI[c][r], this.nBytes);
                            }
                            if (status) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, strInfo);
                                }
                                return true;
                            }
                            int hlen = this.in.getPos() - start;
                            this.pktHL.addElement(new Integer(hlen));
                            status = this.pktDec.readPktBody(l, r, c, nextPrec[c][r], this.cbI[c][r], this.nBytes);
                            int plen = this.in.getPos() - start;
                            strInfo = strInfo + " Pkt l=" + l + ",r=" + r + ",c=" + c + ",p=" + nextPrec[c][r] + ": " + start + ", " + plen + ", " + hlen + "\n";
                            if (!status) continue;
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, strInfo);
                            }
                            return true;
                        }
                        int[] nArray = nextPrec[c];
                        int n = r;
                        nArray[n] = nArray[n] + 1;
                    }
                }
                x = px != pxend ? minx + px * gcd_x : tx0;
            }
            y = py != pyend ? miny + py * gcd_y : ty0;
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, strInfo);
        }
        return false;
    }

    private boolean readCompPosResLy(int[][] lys, int lye, int ress, int rese, int comps, int compe) throws IOException {
        PrecInfo prec;
        Coord nTiles = this.getNumTiles(null);
        Coord tileI = this.getTile(null);
        int x0siz = this.hd.getImgULX();
        int y0siz = this.hd.getImgULY();
        int xsiz = x0siz + this.hd.getImgWidth();
        int ysiz = y0siz + this.hd.getImgHeight();
        int xt0siz = this.getTilePartULX();
        int yt0siz = this.getTilePartULY();
        int xtsiz = this.getNomTileWidth();
        int ytsiz = this.getNomTileHeight();
        int tx0 = tileI.x == 0 ? x0siz : xt0siz + tileI.x * xtsiz;
        int ty0 = tileI.y == 0 ? y0siz : yt0siz + tileI.y * ytsiz;
        int tx1 = tileI.x != nTiles.x - 1 ? xt0siz + (tileI.x + 1) * xtsiz : xsiz;
        int ty1 = tileI.y != nTiles.y - 1 ? yt0siz + (tileI.y + 1) * ytsiz : ysiz;
        int t2 = this.getTileIdx();
        int gcd_x = 0;
        int gcd_y = 0;
        int nPrec = 0;
        int[][] nextPrec = new int[compe][];
        int minlys = 100000;
        int minx = tx1;
        int miny = ty1;
        int maxx = tx0;
        int maxy = ty0;
        for (int c = comps; c < compe; ++c) {
            for (int r = ress; r < rese; ++r) {
                if (c >= this.mdl.length || r > this.mdl[c]) continue;
                nextPrec[c] = new int[this.mdl[c] + 1];
                if (lys[c] != null && r < lys[c].length && lys[c][r] < minlys) {
                    minlys = lys[c][r];
                }
                for (int p = this.pktDec.getNumPrecinct(c, r) - 1; p >= 0; --p) {
                    prec = this.pktDec.getPrecInfo(c, r, p);
                    if (prec.rgulx != tx0) {
                        if (prec.rgulx < minx) {
                            minx = prec.rgulx;
                        }
                        if (prec.rgulx > maxx) {
                            maxx = prec.rgulx;
                        }
                    }
                    if (prec.rguly != ty0) {
                        if (prec.rguly < miny) {
                            miny = prec.rguly;
                        }
                        if (prec.rguly > maxy) {
                            maxy = prec.rguly;
                        }
                    }
                    if (nPrec == 0) {
                        gcd_x = prec.rgw;
                        gcd_y = prec.rgh;
                    } else {
                        gcd_x = MathUtil.gcd(gcd_x, prec.rgw);
                        gcd_y = MathUtil.gcd(gcd_y, prec.rgh);
                    }
                    ++nPrec;
                }
            }
        }
        if (nPrec == 0) {
            throw new Error("Image cannot have no precinct");
        }
        int pyend = (maxy - miny) / gcd_y + 1;
        int pxend = (maxx - minx) / gcd_x + 1;
        boolean status = false;
        int lastByte = this.firstPackOff[t2][this.curTilePart] + this.tilePartLen[t2][this.curTilePart] - 1 - this.tilePartHeadLen[t2][this.curTilePart];
        int numLayers = (Integer)this.decSpec.nls.getTileDef(t2);
        String strInfo = "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n";
        boolean pph = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(t2)).booleanValue()) {
            pph = true;
        }
        for (int c = comps; c < compe; ++c) {
            if (c >= this.mdl.length) continue;
            int y = ty0;
            int x = tx0;
            for (int py = 0; py <= pyend; ++py) {
                for (int px = 0; px <= pxend; ++px) {
                    for (int r = ress; r < rese; ++r) {
                        if (r > this.mdl[c] || nextPrec[c][r] >= this.pktDec.getNumPrecinct(c, r)) continue;
                        prec = this.pktDec.getPrecInfo(c, r, nextPrec[c][r]);
                        if (prec.rgulx != x || prec.rguly != y) continue;
                        for (int l = minlys; l < lye; ++l) {
                            if (r >= lys[c].length || l < lys[c][r]) continue;
                            int start = this.in.getPos();
                            if (pph) {
                                this.pktDec.readPktHead(l, r, c, nextPrec[c][r], this.cbI[c][r], this.nBytes);
                            }
                            if (start > lastByte && this.curTilePart < this.firstPackOff[t2].length - 1) {
                                ++this.curTilePart;
                                this.in.seek(this.firstPackOff[t2][this.curTilePart]);
                                lastByte = this.in.getPos() + this.tilePartLen[t2][this.curTilePart] - 1 - this.tilePartHeadLen[t2][this.curTilePart];
                            }
                            if (status = this.pktDec.readSOPMarker(this.nBytes, nextPrec[c][r], c, r)) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, strInfo);
                                }
                                return true;
                            }
                            if (!pph) {
                                status = this.pktDec.readPktHead(l, r, c, nextPrec[c][r], this.cbI[c][r], this.nBytes);
                            }
                            if (status) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, strInfo);
                                }
                                return true;
                            }
                            int hlen = this.in.getPos() - start;
                            this.pktHL.addElement(new Integer(hlen));
                            status = this.pktDec.readPktBody(l, r, c, nextPrec[c][r], this.cbI[c][r], this.nBytes);
                            int plen = this.in.getPos() - start;
                            strInfo = strInfo + " Pkt l=" + l + ",r=" + r + ",c=" + c + ",p=" + nextPrec[c][r] + ": " + start + ", " + plen + ", " + hlen + "\n";
                            if (!status) continue;
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, strInfo);
                            }
                            return true;
                        }
                        int[] nArray = nextPrec[c];
                        int n = r;
                        nArray[n] = nArray[n] + 1;
                    }
                    x = px != pxend ? minx + px * gcd_x : tx0;
                }
                y = py != pyend ? miny + py * gcd_y : ty0;
            }
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, strInfo);
        }
        return false;
    }

    private void readTilePkts(int t2) throws IOException {
        this.pktHL = new Vector();
        int nl = (Integer)this.decSpec.nls.getTileDef(t2);
        if (((Boolean)this.decSpec.pphs.getTileDef(t2)).booleanValue()) {
            ByteArrayInputStream pphbais = this.hd.getPackedPktHead(t2);
            this.cbI = this.pktDec.restart(this.nc, this.mdl, nl, this.cbI, true, pphbais);
        } else {
            this.cbI = this.pktDec.restart(this.nc, this.mdl, nl, this.cbI, false, null);
        }
        int[][] pocSpec = (int[][])this.decSpec.pcs.getTileDef(t2);
        int nChg = pocSpec == null ? 1 : pocSpec.length;
        int[][] change = new int[nChg][6];
        int idx = 0;
        change[0][1] = 0;
        if (pocSpec == null) {
            change[idx][0] = (Integer)this.decSpec.pos.getTileDef(t2);
            change[idx][1] = nl;
            change[idx][2] = 0;
            change[idx][3] = this.decSpec.dls.getMaxInTile(t2) + 1;
            change[idx][4] = 0;
            change[idx][5] = this.nc;
        } else {
            for (idx = 0; idx < nChg; ++idx) {
                change[idx][0] = pocSpec[idx][5];
                change[idx][1] = pocSpec[idx][2];
                change[idx][2] = pocSpec[idx][0];
                change[idx][3] = pocSpec[idx][3];
                change[idx][4] = pocSpec[idx][1];
                change[idx][5] = pocSpec[idx][4];
            }
        }
        try {
            if (this.isTruncMode && this.firstPackOff == null || this.firstPackOff[t2] == null) {
                return;
            }
            this.in.seek(this.firstPackOff[t2][0]);
        }
        catch (EOFException e) {
            FacilityManager.getMsgLogger().printmsg(2, "Codestream truncated in tile " + t2);
            return;
        }
        this.curTilePart = 0;
        boolean status = false;
        int nb = this.nBytes[t2];
        int[][] lys = new int[this.nc][];
        for (int c = 0; c < this.nc; ++c) {
            lys[c] = new int[(Integer)this.decSpec.dls.getTileCompVal(t2, c) + 1];
        }
        for (int chg = 0; chg < nChg; ++chg) {
            int lye = change[chg][1];
            int ress = change[chg][2];
            int rese = change[chg][3];
            int comps = change[chg][4];
            int compe = change[chg][5];
            switch (change[chg][0]) {
                case 0: {
                    status = this.readLyResCompPos(lys, lye, ress, rese, comps, compe);
                    break;
                }
                case 1: {
                    status = this.readResLyCompPos(lys, lye, ress, rese, comps, compe);
                    break;
                }
                case 2: {
                    status = this.readResPosCompLy(lys, lye, ress, rese, comps, compe);
                    break;
                }
                case 3: {
                    status = this.readPosCompResLy(lys, lye, ress, rese, comps, compe);
                    break;
                }
                case 4: {
                    status = this.readCompPosResLy(lys, lye, ress, rese, comps, compe);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not recognized progression type");
                }
            }
            for (int c = comps; c < compe; ++c) {
                if (c >= lys.length) continue;
                for (int r = ress; r < rese; ++r) {
                    if (r >= lys[c].length) continue;
                    lys[c][r] = lye;
                }
            }
            if (!status && !this.usePOCQuit) {
                continue;
            }
            break;
        }
        if (this.isTruncMode) {
            this.anbytes += nb - this.nBytes[t2];
            if (status) {
                this.nBytes[t2] = 0;
            }
        } else if (this.nBytes[t2] < this.totTileLen[t2] - this.totTileHeadLen[t2]) {
            boolean stopCount = false;
            int[] pktHeadLen = new int[this.pktHL.size()];
            for (int i = this.pktHL.size() - 1; i >= 0; --i) {
                pktHeadLen[i] = (Integer)this.pktHL.elementAt(i);
            }
            boolean reject = false;
            for (int l = 0; l < nl; ++l) {
                if (this.cbI == null) continue;
                int nc = this.cbI.length;
                int mres = 0;
                for (int c = 0; c < nc; ++c) {
                    if (this.cbI[c] == null || this.cbI[c].length <= mres) continue;
                    mres = this.cbI[c].length;
                }
                for (int r = 0; r < mres; ++r) {
                    int msub = 0;
                    for (int c = 0; c < nc; ++c) {
                        if (this.cbI[c] == null || this.cbI[c][r] == null || this.cbI[c][r].length <= msub) continue;
                        msub = this.cbI[c][r].length;
                    }
                    for (int s2 = 0; s2 < msub; ++s2) {
                        if (r == 0 && s2 != 0 || r != 0 && s2 == 0) continue;
                        int mnby = 0;
                        for (int c = 0; c < nc; ++c) {
                            if (this.cbI[c] == null || this.cbI[c][r] == null || this.cbI[c][r][s2] == null || this.cbI[c][r][s2].length <= mnby) continue;
                            mnby = this.cbI[c][r][s2].length;
                        }
                        for (int m4 = 0; m4 < mnby; ++m4) {
                            int mnbx = 0;
                            for (int c = 0; c < nc; ++c) {
                                if (this.cbI[c] == null || this.cbI[c][r] == null || this.cbI[c][r][s2] == null || this.cbI[c][r][s2][m4] == null || this.cbI[c][r][s2][m4].length <= mnbx) continue;
                                mnbx = this.cbI[c][r][s2][m4].length;
                            }
                            for (int n = 0; n < mnbx; ++n) {
                                for (int c = 0; c < nc; ++c) {
                                    if (this.cbI[c] == null || this.cbI[c][r] == null || this.cbI[c][r][s2] == null || this.cbI[c][r][s2][m4] == null || this.cbI[c][r][s2][m4][n] == null) continue;
                                    CBlkInfo cb = this.cbI[c][r][s2][m4][n];
                                    if (!reject) {
                                        if (this.nBytes[t2] < pktHeadLen[cb.pktIdx[l]]) {
                                            stopCount = true;
                                            reject = true;
                                        } else if (!stopCount) {
                                            int n2 = t2;
                                            this.nBytes[n2] = this.nBytes[n2] - pktHeadLen[cb.pktIdx[l]];
                                            this.anbytes += pktHeadLen[cb.pktIdx[l]];
                                            pktHeadLen[cb.pktIdx[l]] = 0;
                                        }
                                    }
                                    if (cb.len[l] == 0) continue;
                                    if (cb.len[l] < this.nBytes[t2] && !reject) {
                                        int n3 = t2;
                                        this.nBytes[n3] = this.nBytes[n3] - cb.len[l];
                                        this.anbytes += cb.len[l];
                                        continue;
                                    }
                                    cb.ntp[l] = 0;
                                    cb.off[l] = 0;
                                    cb.len[l] = 0;
                                    reject = true;
                                }
                            }
                        }
                    }
                }
            }
        } else {
            this.anbytes += this.totTileLen[t2] - this.totTileHeadLen[t2];
            if (t2 < this.getNumTiles() - 1) {
                int n = t2 + 1;
                this.nBytes[n] = this.nBytes[n] + (this.nBytes[t2] - (this.totTileLen[t2] - this.totTileHeadLen[t2]));
            }
        }
    }

    @Override
    public void setTile(int x, int y) {
        if (x < 0 || y < 0 || x >= this.ntX || y >= this.ntY) {
            throw new IllegalArgumentException();
        }
        int t2 = y * this.ntX + x;
        if (t2 == 0) {
            this.anbytes = this.headLen;
            if (!this.isTruncMode) {
                this.anbytes += 2;
            }
            for (int tIdx = 0; tIdx < this.nt; ++tIdx) {
                this.nBytes[tIdx] = this.baknBytes[tIdx];
            }
        }
        this.ctX = x;
        this.ctY = y;
        int ctox = x == 0 ? this.ax : this.px + x * this.ntW;
        int ctoy = y == 0 ? this.ay : this.py + y * this.ntH;
        for (int i = this.nc - 1; i >= 0; --i) {
            this.culx[i] = (ctox + this.hd.getCompSubsX(i) - 1) / this.hd.getCompSubsX(i);
            this.culy[i] = (ctoy + this.hd.getCompSubsY(i) - 1) / this.hd.getCompSubsY(i);
            this.offX[i] = (this.px + x * this.ntW + this.hd.getCompSubsX(i) - 1) / this.hd.getCompSubsX(i);
            this.offY[i] = (this.py + y * this.ntH + this.hd.getCompSubsY(i) - 1) / this.hd.getCompSubsY(i);
        }
        this.subbTrees = new SubbandSyn[this.nc];
        this.mdl = new int[this.nc];
        this.derived = new boolean[this.nc];
        this.params = new StdDequantizerParams[this.nc];
        this.gb = new int[this.nc];
        for (int c = 0; c < this.nc; ++c) {
            this.derived[c] = this.decSpec.qts.isDerived(t2, c);
            this.params[c] = (StdDequantizerParams)this.decSpec.qsss.getTileCompVal(t2, c);
            this.gb[c] = (Integer)this.decSpec.gbs.getTileCompVal(t2, c);
            this.mdl[c] = (Integer)this.decSpec.dls.getTileCompVal(t2, c);
            this.subbTrees[c] = new SubbandSyn(this.getTileCompWidth(t2, c, this.mdl[c]), this.getTileCompHeight(t2, c, this.mdl[c]), this.getResULX(c, this.mdl[c]), this.getResULY(c, this.mdl[c]), this.mdl[c], this.decSpec.wfs.getHFilters(t2, c), this.decSpec.wfs.getVFilters(t2, c));
            this.initSubbandsFields(c, this.subbTrees[c]);
        }
        try {
            this.readTilePkts(t2);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("IO Error when reading tile " + x + " x " + y);
        }
    }

    @Override
    public void nextTile() {
        if (this.ctX == this.ntX - 1 && this.ctY == this.ntY - 1) {
            throw new NoNextElementException();
        }
        if (this.ctX < this.ntX - 1) {
            this.setTile(this.ctX + 1, this.ctY);
        } else {
            this.setTile(0, this.ctY + 1);
        }
    }

    @Override
    public DecLyrdCBlk getCodeBlock(int c, int m4, int n, SubbandSyn sb, int fl, int nl, DecLyrdCBlk ccb) {
        int lastlayer;
        int passtype;
        int tpidx;
        int nts;
        int l;
        CBlkInfo rcb;
        int maxdl;
        int t2 = this.getTileIdx();
        int r = sb.resLvl;
        int s2 = sb.sbandIdx;
        int numLayers = (Integer)this.decSpec.nls.getTileDef(t2);
        int options = (Integer)this.decSpec.ecopts.getTileCompVal(t2, c);
        if (nl < 0) {
            nl = numLayers - fl + 1;
        }
        if (this.lQuit != -1 && fl + nl > this.lQuit) {
            nl = this.lQuit - fl;
        }
        if (r > this.targetRes + (maxdl = this.getSynSubbandTree((int)t2, (int)c).resLvl) - this.decSpec.dls.getMin()) {
            throw new Error("JJ2000 error: requesting a code-block disallowed by the '-res' option.");
        }
        try {
            rcb = this.cbI[c][r][s2][m4][n];
            if (fl < 1 || fl > numLayers || fl + nl - 1 > numLayers) {
                throw new IllegalArgumentException();
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Code-block (t:" + t2 + ", c:" + c + ", r:" + r + ", s:" + s2 + ", " + m4 + "x" + n + ") not found in codestream");
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Code-block (t:" + t2 + ", c:" + c + ", r:" + r + ", s:" + s2 + ", " + m4 + "x" + n + ") not found in bit stream");
        }
        if (ccb == null) {
            ccb = new DecLyrdCBlk();
        }
        ccb.m = m4;
        ccb.n = n;
        ccb.nl = 0;
        ccb.dl = 0;
        ccb.nTrunc = 0;
        if (rcb == null) {
            ccb.skipMSBP = 0;
            ccb.prog = false;
            ccb.uly = 0;
            ccb.ulx = 0;
            ccb.h = 0;
            ccb.w = 0;
            return ccb;
        }
        ccb.skipMSBP = rcb.msbSkipped;
        ccb.ulx = rcb.ulx;
        ccb.uly = rcb.uly;
        ccb.w = rcb.w;
        ccb.h = rcb.h;
        ccb.ftpIdx = 0;
        for (l = 0; l < rcb.len.length && rcb.len[l] == 0; ++l) {
            ccb.ftpIdx += rcb.ntp[l];
        }
        for (l = fl - 1; l < fl + nl - 1; ++l) {
            ++ccb.nl;
            ccb.dl += rcb.len[l];
            ccb.nTrunc += rcb.ntp[l];
        }
        if ((options & 4) != 0) {
            nts = ccb.nTrunc - ccb.ftpIdx;
        } else if ((options & 1) != 0) {
            if (ccb.nTrunc <= 10) {
                nts = 1;
            } else {
                nts = 1;
                for (tpidx = ccb.ftpIdx; tpidx < ccb.nTrunc; ++tpidx) {
                    if (tpidx < 9 || (passtype = (tpidx + 2) % 3) != 1 && passtype != 2) continue;
                    ++nts;
                }
            }
        } else {
            nts = 1;
        }
        if (ccb.data == null || ccb.data.length < ccb.dl) {
            ccb.data = new byte[ccb.dl];
        }
        if (nts > 1 && (ccb.tsLengths == null || ccb.tsLengths.length < nts)) {
            ccb.tsLengths = new int[nts];
        } else if (nts > 1 && (options & 5) == 1) {
            ArrayUtil.intArraySet(ccb.tsLengths, 0);
        }
        int dataIdx = -1;
        tpidx = ccb.ftpIdx;
        int ctp = ccb.ftpIdx;
        int tsidx = 0;
        for (l = fl - 1; l < fl + nl - 1; ++l) {
            int j;
            ctp += rcb.ntp[l];
            if (rcb.len[l] == 0) continue;
            try {
                this.in.seek(rcb.off[l]);
                this.in.readFully(ccb.data, dataIdx + 1, rcb.len[l]);
                dataIdx += rcb.len[l];
            }
            catch (IOException e) {
                JJ2KExceptionHandler.handleException(e);
            }
            if (nts == 1) continue;
            if ((options & 4) != 0) {
                j = 0;
                while (tpidx < ctp) {
                    ccb.tsLengths[tsidx++] = rcb.segLen[l] != null ? rcb.segLen[l][j] : rcb.len[l];
                    ++j;
                    ++tpidx;
                }
                continue;
            }
            j = 0;
            while (tpidx < ctp) {
                if (tpidx >= 9 && (passtype = (tpidx + 2) % 3) != 0) {
                    if (rcb.segLen[l] != null) {
                        int n2 = tsidx++;
                        ccb.tsLengths[n2] = ccb.tsLengths[n2] + rcb.segLen[l][j++];
                        int n3 = l;
                        rcb.len[n3] = rcb.len[n3] - rcb.segLen[l][j - 1];
                    } else {
                        int n4 = tsidx++;
                        ccb.tsLengths[n4] = ccb.tsLengths[n4] + rcb.len[l];
                        rcb.len[l] = 0;
                    }
                }
                ++tpidx;
            }
            if (rcb.segLen[l] != null && j < rcb.segLen[l].length) {
                int n5 = tsidx;
                ccb.tsLengths[n5] = ccb.tsLengths[n5] + rcb.segLen[l][j];
                int n6 = l;
                rcb.len[n6] = rcb.len[n6] - rcb.segLen[l][j];
                continue;
            }
            if (tsidx >= nts) continue;
            int n7 = tsidx;
            ccb.tsLengths[n7] = ccb.tsLengths[n7] + rcb.len[l];
            rcb.len[l] = 0;
        }
        if (nts == 1 && ccb.tsLengths != null) {
            ccb.tsLengths[0] = ccb.dl;
        }
        if ((lastlayer = fl + nl - 1) < numLayers - 1) {
            for (l = lastlayer + 1; l < numLayers; ++l) {
                if (rcb.len[l] == 0) continue;
                ccb.prog = true;
            }
        }
        return ccb;
    }
}

