/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.util;

import com.mchange.v2.c3p0.C3P0ProxyConnection;
import com.mchange.v2.sql.SqlUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Random;
import javax.sql.DataSource;

public final class TestUtils {
    private static final Method OBJECT_EQUALS;
    private static final Method IDENTITY_HASHCODE;
    private static final Method IPCFP;

    public static boolean samePhysicalConnection(C3P0ProxyConnection c3P0ProxyConnection, C3P0ProxyConnection c3P0ProxyConnection2) throws SQLException {
        try {
            Object object = c3P0ProxyConnection.rawConnectionOperation(IPCFP, null, new Object[]{C3P0ProxyConnection.RAW_CONNECTION, c3P0ProxyConnection2});
            return (Boolean)object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw SqlUtils.toSQLException(exception);
        }
    }

    public static boolean isPhysicalConnectionForProxy(Connection connection, C3P0ProxyConnection c3P0ProxyConnection) throws SQLException {
        try {
            Object object = c3P0ProxyConnection.rawConnectionOperation(OBJECT_EQUALS, connection, new Object[]{C3P0ProxyConnection.RAW_CONNECTION});
            return (Boolean)object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw SqlUtils.toSQLException(exception);
        }
    }

    public static int physicalConnectionIdentityHashCode(C3P0ProxyConnection c3P0ProxyConnection) throws SQLException {
        try {
            Object object = c3P0ProxyConnection.rawConnectionOperation(IDENTITY_HASHCODE, null, new Object[]{C3P0ProxyConnection.RAW_CONNECTION});
            return (Integer)object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw SqlUtils.toSQLException(exception);
        }
    }

    public static DataSource unreliableCommitDataSource(DataSource dataSource) throws Exception {
        return (DataSource)Proxy.newProxyInstance(TestUtils.class.getClassLoader(), new Class[]{DataSource.class}, (InvocationHandler)new StupidDataSourceInvocationHandler(dataSource));
    }

    private TestUtils() {
    }

    static {
        try {
            OBJECT_EQUALS = Object.class.getMethod("equals", Object.class);
            IDENTITY_HASHCODE = System.class.getMethod("identityHashCode", Object.class);
            IPCFP = TestUtils.class.getMethod("isPhysicalConnectionForProxy", Connection.class, C3P0ProxyConnection.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Huh? Can't reflectively get ahold of expected methods?");
        }
    }

    static class StupidConnectionInvocationHandler
    implements InvocationHandler {
        Connection conn;
        Random r = new Random();
        boolean invalid = false;

        StupidConnectionInvocationHandler(Connection connection) {
            this.conn = connection;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if ("close".equals(method.getName())) {
                if (this.invalid) {
                    new Exception("Duplicate close() called on Connection!!!").printStackTrace();
                } else {
                    this.invalid = true;
                }
                return null;
            }
            if (this.invalid) {
                throw new SQLException("Connection closed -- cannot " + method.getName());
            }
            if ("commit".equals(method.getName()) && this.r.nextInt(100) == 0) {
                this.conn.rollback();
                throw new SQLException("Random commit exception!!!");
            }
            if (this.r.nextInt(200) == 0) {
                this.conn.rollback();
                this.conn.close();
                throw new SQLException("Random Fatal Exception Occurred!!!");
            }
            return method.invoke((Object)this.conn, objectArray);
        }
    }

    static class StupidDataSourceInvocationHandler
    implements InvocationHandler {
        DataSource ds;
        Random r = new Random();

        StupidDataSourceInvocationHandler(DataSource dataSource) {
            this.ds = dataSource;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if ("getConnection".equals(method.getName())) {
                Connection connection = (Connection)method.invoke((Object)this.ds, objectArray);
                return Proxy.newProxyInstance(TestUtils.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new StupidConnectionInvocationHandler(connection));
            }
            return method.invoke((Object)this.ds, objectArray);
        }
    }
}

