/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.time.Duration;
import java.time.Instant;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.referencing.ExtentSelector;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.AggregatedResource;

public final class MergeStrategy {
    private static final MergeStrategy SELECT_BY_TIME = new MergeStrategy(null);
    private final Duration timeGranularity;

    private MergeStrategy(Duration duration) {
        this.timeGranularity = duration;
    }

    public static MergeStrategy selectByTimeThenArea(Duration duration) {
        return duration != null ? new MergeStrategy(duration) : SELECT_BY_TIME;
    }

    final Integer apply(GridGeometry gridGeometry, GridGeometry[] gridGeometryArray) {
        ExtentSelector<Integer> extentSelector = new ExtentSelector<Integer>(gridGeometry.getGeographicExtent().orElse(null), gridGeometry.getTemporalExtent());
        if (this.timeGranularity != null) {
            extentSelector.setTimeGranularity(this.timeGranularity);
            extentSelector.alternateOrdering = true;
        }
        for (int i = 0; i < gridGeometryArray.length; ++i) {
            GridGeometry gridGeometry2 = gridGeometryArray[i];
            if (gridGeometry2 == null) continue;
            Instant[] instantArray = gridGeometry2.getTemporalExtent();
            int n = instantArray.length;
            extentSelector.evaluate(gridGeometry2.getGeographicExtent().orElse(null), n == 0 ? null : instantArray[0], n == 0 ? null : instantArray[n - 1], i);
        }
        return (Integer)extentSelector.best();
    }

    public Resource apply(Resource resource) {
        if (resource instanceof AggregatedResource) {
            return ((AggregatedResource)((Object)resource)).apply(this);
        }
        return resource;
    }

    public String toString() {
        return Strings.toString(this.getClass(), "algo", "selectByTimeThenArea", "timeGranularity", this.timeGranularity);
    }
}

