/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import org.apache.sis.internal.metadata.Resources;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.MetadataVisitor;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.collection.CodeListSet;
import org.apache.sis.util.resources.Errors;

public class MetadataCopier
extends MetadataVisitor<Object> {
    private final MetadataStandard standard;
    private Object target;

    public MetadataCopier(MetadataStandard metadataStandard) {
        this.standard = metadataStandard;
    }

    private MetadataStandard getStandard(Object object) {
        MetadataStandard metadataStandard;
        if (object instanceof AbstractMetadata && (metadataStandard = ((AbstractMetadata)object).getStandard()) != null) {
            return metadataStandard;
        }
        return this.standard;
    }

    public static MetadataCopier forModifiable(MetadataStandard metadataStandard) {
        return new MetadataCopier(metadataStandard){

            @Override
            protected Object copyRecursively(Class<?> clazz, Object object) {
                ModifiableMetadata.State state;
                if (object instanceof ModifiableMetadata && (state = ((ModifiableMetadata)object).state()) != null && state.isUnmodifiable()) {
                    return object;
                }
                return super.copyRecursively(clazz, object);
            }
        };
    }

    public Object copy(Object object) {
        return this.copyRecursively(null, object);
    }

    public <T> T copy(Class<T> clazz, T t2) {
        Class<?> clazz2;
        ArgumentChecks.ensureNonNull("type", clazz);
        if (t2 instanceof AbstractMetadata && !clazz.isAssignableFrom(clazz2 = ((AbstractMetadata)t2).getInterface())) {
            throw new IllegalArgumentException(Resources.format((short)5, clazz2, clazz));
        }
        return clazz.cast(this.copyRecursively(clazz, t2));
    }

    protected Object copyRecursively(Class<?> clazz, Object object) {
        Object r;
        MetadataStandard metadataStandard;
        if (object != null && (metadataStandard = this.getStandard(object)) != null && (r = this.walk(metadataStandard, clazz, object, false)) != null) {
            return r;
        }
        return object;
    }

    @Override
    final MetadataVisitor.Filter preVisit(PropertyAccessor propertyAccessor) {
        if (propertyAccessor.isWritable()) {
            try {
                this.target = propertyAccessor.implementation.getConstructor(new Class[0]).newInstance(new Object[0]);
                return MetadataVisitor.Filter.WRITABLE_RESULT;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new UnsupportedOperationException(Errors.format((short)169, propertyAccessor.type), Exceptions.unwrap(reflectiveOperationException));
            }
        }
        this.target = null;
        return MetadataVisitor.Filter.NONE;
    }

    @Override
    final Object result() {
        return this.target;
    }

    @Override
    final Object visit(Class<?> clazz, Object object) {
        if (!clazz.isInstance(object)) {
            if (object instanceof Collection) {
                SequencedCollection<Object> sequencedCollection = (List<Object>)object;
                if (sequencedCollection.isEmpty()) {
                    return null;
                }
                if (!(sequencedCollection instanceof EnumSet) && !(sequencedCollection instanceof CodeListSet)) {
                    Object[] objectArray = sequencedCollection.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray[i] = this.copyRecursively(clazz, objectArray[i]);
                    }
                    sequencedCollection = Arrays.asList(objectArray);
                    if (object instanceof Set) {
                        sequencedCollection = new LinkedHashSet<Object>(sequencedCollection);
                    }
                }
                return sequencedCollection;
            }
            if (object instanceof Map) {
                return object;
            }
        }
        return this.copyRecursively(clazz, object);
    }

    @Override
    protected List<String> getCurrentPropertyPath() {
        return super.getCurrentPropertyPath();
    }
}

