/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.ParserException;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Length;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.AbstractUnit;
import org.apache.sis.measure.AngularVelocity;
import org.apache.sis.measure.ConventionalUnit;
import org.apache.sis.measure.LinearConverter;
import org.apache.sis.measure.PowerOf10;
import org.apache.sis.measure.Prefixes;
import org.apache.sis.measure.Salinity;
import org.apache.sis.measure.Scalar;
import org.apache.sis.measure.ScalarFactory;
import org.apache.sis.measure.ScaleRateOfChange;
import org.apache.sis.measure.SexagesimalConverter;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.UnitDimension;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.UnitRegistry;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class Units
extends Static {
    public static final Unit<Length> NANOMETRE;
    public static final Unit<Length> MILLIMETRE;
    public static final Unit<Length> CENTIMETRE;
    public static final Unit<Length> METRE;
    public static final Unit<Length> KILOMETRE;
    public static final Unit<Length> NAUTICAL_MILE;
    public static final Unit<Length> STATUTE_MILE;
    public static final Unit<Length> US_SURVEY_FOOT;
    public static final Unit<Length> CLARKE_FOOT;
    public static final Unit<Length> FOOT;
    public static final Unit<Length> INCH;
    public static final Unit<Length> POINT;
    public static final Unit<Area> SQUARE_METRE;
    public static final Unit<Area> HECTARE;
    public static final Unit<Volume> CUBIC_METRE;
    public static final Unit<Volume> LITRE;
    public static final Unit<SolidAngle> STERADIAN;
    public static final Unit<Angle> MICRORADIAN;
    public static final Unit<Angle> RADIAN;
    public static final Unit<Angle> DEGREE;
    public static final Unit<Angle> ARC_MINUTE;
    public static final Unit<Angle> ARC_SECOND;
    public static final Unit<Angle> GRAD;
    public static final Unit<Time> MILLISECOND;
    public static final Unit<Time> SECOND;
    public static final Unit<Time> MINUTE;
    public static final Unit<Time> HOUR;
    public static final Unit<Time> DAY;
    public static final Unit<Time> WEEK;
    public static final Unit<Time> TROPICAL_YEAR;
    public static final Unit<Frequency> HERTZ;
    public static final Unit<AngularVelocity> RADIANS_PER_SECOND;
    public static final Unit<Speed> METRES_PER_SECOND;
    public static final Unit<Speed> KILOMETRES_PER_HOUR;
    public static final Unit<Acceleration> METRES_PER_SECOND_SQUARED;
    public static final Unit<Acceleration> GAL;
    public static final Unit<Pressure> PASCAL;
    public static final Unit<Pressure> HECTOPASCAL;
    public static final Unit<Pressure> DECIBAR;
    public static final Unit<Pressure> BAR;
    public static final Unit<Pressure> ATMOSPHERE;
    public static final Unit<Force> NEWTON;
    public static final Unit<Energy> JOULE;
    public static final Unit<Power> WATT;
    public static final Unit<ElectricPotential> VOLT;
    public static final Unit<ElectricCurrent> AMPERE;
    public static final Unit<ElectricCharge> COULOMB;
    public static final Unit<ElectricCapacitance> FARAD;
    public static final Unit<ElectricResistance> OHM;
    public static final Unit<ElectricConductance> SIEMENS;
    public static final Unit<MagneticFlux> WEBER;
    public static final Unit<MagneticFluxDensity> TESLA;
    public static final Unit<ElectricInductance> HENRY;
    public static final Unit<Temperature> KELVIN;
    public static final Unit<Temperature> CELSIUS;
    public static final Unit<Temperature> FAHRENHEIT;
    public static final Unit<LuminousIntensity> CANDELA;
    public static final Unit<LuminousFlux> LUMEN;
    public static final Unit<Illuminance> LUX;
    public static final Unit<Mass> GRAM;
    public static final Unit<Mass> KILOGRAM;
    public static final Unit<AmountOfSubstance> MOLE;
    public static final Unit<Dimensionless> UNITY;
    public static final Unit<Dimensionless> PERCENT;
    public static final Unit<Dimensionless> PPM;
    public static final Unit<Dimensionless> DECIBEL;
    public static final Unit<Salinity> PSU;
    static final Unit<Dimensionless> SIGMA;
    public static final Unit<Dimensionless> PIXEL;
    static final boolean initialized;

    private static <Q extends Quantity<Q>> SystemUnit<Q> add(Class<Q> clazz, ScalarFactory<Q> scalarFactory, UnitDimension unitDimension, String string, byte by, short s2) {
        return UnitRegistry.init(new SystemUnit<Q>(clazz, unitDimension, string, by, s2, scalarFactory));
    }

    private static <Q extends Quantity<Q>> ConventionalUnit<Q> add(AbstractUnit<Q> abstractUnit, UnitConverter unitConverter, String string, byte by, short s2) {
        ConventionalUnit<Q> conventionalUnit = UnitRegistry.init(new ConventionalUnit<Q>(abstractUnit, unitConverter, string, by, s2));
        ConventionalUnit<Q>[] conventionalUnitArray = abstractUnit.related();
        if (!(conventionalUnitArray == null || conventionalUnit.scope == 2 && unitConverter.isLinear())) {
            int n = 0;
            while (conventionalUnitArray[n] != null) {
                ++n;
            }
            conventionalUnitArray[n] = conventionalUnit;
        }
        return conventionalUnit;
    }

    static SystemUnit<?> get(Dimension dimension) {
        return (SystemUnit)UnitRegistry.get(dimension);
    }

    static <Q extends Quantity<Q>> SystemUnit<Q> get(Class<Q> clazz) {
        return (SystemUnit)UnitRegistry.get(clazz);
    }

    static Unit<?> get(String string) {
        return (Unit)UnitRegistry.get(string);
    }

    private Units() {
    }

    public static boolean isAngular(Unit<?> unit) {
        return unit != null && unit.getSystemUnit().equals(RADIAN);
    }

    public static boolean isLinear(Unit<?> unit) {
        return unit != null && unit.getSystemUnit().equals(METRE);
    }

    public static boolean isPressure(Unit<?> unit) {
        return unit != null && unit.getSystemUnit().equals(PASCAL);
    }

    public static boolean isTemporal(Unit<?> unit) {
        return unit != null && unit.getSystemUnit().equals(SECOND);
    }

    public static boolean isScale(Unit<?> unit) {
        return unit != null && unit.getSystemUnit().equals(UNITY);
    }

    public static Unit<Angle> ensureAngular(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isAngular(unit)) {
            throw new IllegalArgumentException(Errors.format((short)100, unit));
        }
        return unit;
    }

    public static Unit<Length> ensureLinear(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isLinear(unit)) {
            throw new IllegalArgumentException(Errors.format((short)103, unit));
        }
        return unit;
    }

    public static Unit<Time> ensureTemporal(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isTemporal(unit)) {
            throw new IllegalArgumentException(Errors.format((short)107, unit));
        }
        return unit;
    }

    public static Unit<Dimensionless> ensureScale(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isScale(unit)) {
            throw new IllegalArgumentException(Errors.format((short)105, unit));
        }
        return unit;
    }

    public static <Q extends Quantity<Q>> Unit<Q> multiply(Unit<Q> unit, double d, double d2) {
        return unit.transform(LinearConverter.scale(d, d2));
    }

    public static <Q extends Quantity<Q>> double toStandardUnit(Unit<Q> unit) {
        return AbstractConverter.scale(unit == null ? null : unit.getConverterTo(unit.getSystemUnit()));
    }

    public static UnitConverter converter(Number number, Number number2) {
        return LinearConverter.create(number, number2);
    }

    public static Number[] coefficients(UnitConverter unitConverter) {
        if (unitConverter != null) {
            if (unitConverter instanceof AbstractConverter) {
                return ((AbstractConverter)unitConverter).coefficients();
            }
            if (unitConverter.isIdentity()) {
                return new Number[0];
            }
            if (unitConverter.isLinear()) {
                double d = unitConverter.convert(0.0);
                double d2 = unitConverter.convert(1.0) - d;
                Number[] numberArray = new Number[d2 != 1.0 ? 2 : (d != 0.0 ? 1 : 0)];
                switch (numberArray.length) {
                    case 2: {
                        numberArray[1] = d2;
                    }
                    case 1: {
                        numberArray[0] = d;
                    }
                }
                return numberArray;
            }
        }
        return null;
    }

    public static double derivative(UnitConverter unitConverter, double d) {
        return AbstractConverter.derivative(unitConverter, d);
    }

    public static Unit<?> valueOf(String string) throws ParserException {
        return string != null ? UnitFormat.INSTANCE.parse(string) : null;
    }

    public static Unit<?> valueOfEPSG(int n) {
        switch (n) {
            case 9102: 
            case 9122: {
                return DEGREE;
            }
            case 9001: {
                return METRE;
            }
            case 9107: 
            case 9108: {
                return SexagesimalConverter.DMS_SCALED;
            }
            case 9110: {
                return SexagesimalConverter.DMS;
            }
            case 9111: {
                return SexagesimalConverter.DM;
            }
            case 9201: 
            case 9203: {
                return UNITY;
            }
        }
        return n > 0 && n <= Short.MAX_VALUE ? (Unit)UnitRegistry.get((short)n) : null;
    }

    public static Integer getEpsgCode(Unit<?> unit, boolean bl) {
        if (unit != null) {
            if (!(unit instanceof AbstractUnit) && !((unit = Units.get(unit.getSymbol())) instanceof AbstractUnit)) {
                return null;
            }
            int n = ((AbstractUnit)unit).epsg;
            if (n != 0) {
                if (bl && n == 9102) {
                    n = 9122;
                }
                return n;
            }
        }
        return null;
    }

    static {
        UnitDimension unitDimension = new UnitDimension('L');
        UnitDimension unitDimension2 = new UnitDimension('M');
        UnitDimension unitDimension3 = new UnitDimension('T');
        UnitDimension unitDimension4 = new UnitDimension('I');
        UnitDimension unitDimension5 = new UnitDimension('\u0398');
        UnitDimension unitDimension6 = new UnitDimension('N');
        UnitDimension unitDimension7 = new UnitDimension('J');
        UnitDimension unitDimension8 = unitDimension3.pow(-1);
        UnitDimension unitDimension9 = unitDimension.pow(2);
        UnitDimension unitDimension10 = unitDimension.divide(unitDimension3);
        UnitDimension unitDimension11 = unitDimension10.divide(unitDimension3);
        UnitDimension unitDimension12 = unitDimension2.multiply(unitDimension10).divide(unitDimension3);
        UnitDimension unitDimension13 = unitDimension12.multiply(unitDimension);
        UnitDimension unitDimension14 = unitDimension13.divide(unitDimension3);
        UnitDimension unitDimension15 = unitDimension4.multiply(unitDimension3);
        UnitDimension unitDimension16 = unitDimension14.divide(unitDimension4);
        UnitDimension unitDimension17 = unitDimension16.multiply(unitDimension3);
        UnitDimension unitDimension18 = unitDimension12.divide(unitDimension9);
        UnitDimension unitDimension19 = UnitDimension.NONE;
        SystemUnit<Length> systemUnit = Units.add(Length.class, Scalar.Length::new, unitDimension, "m", (byte)3, (short)9001);
        SystemUnit<Area> systemUnit2 = Units.add(Area.class, Scalar.Area::new, unitDimension9, "m\u00b2", (byte)3, (short)0);
        SystemUnit<Volume> systemUnit3 = Units.add(Volume.class, Scalar.Volume::new, unitDimension.pow(3), "m\u00b3", (byte)3, (short)0);
        SystemUnit<Time> systemUnit4 = Units.add(Time.class, Scalar.Time::new, unitDimension3, "s", (byte)3, (short)1040);
        SystemUnit<Temperature> systemUnit5 = Units.add(Temperature.class, Scalar.Temperature.FACTORY, unitDimension5, "\u212a", (byte)3, (short)0);
        SystemUnit<Speed> systemUnit6 = Units.add(Speed.class, Scalar.Speed::new, unitDimension10, "m\u2215s", (byte)3, (short)1026);
        SystemUnit<Acceleration> systemUnit7 = Units.add(Acceleration.class, Scalar.Acceleration::new, unitDimension11, "m\u2215s\u00b2", (byte)3, (short)0);
        SystemUnit<Pressure> systemUnit8 = Units.add(Pressure.class, Scalar.Pressure::new, unitDimension18, "Pa", (byte)3, (short)0);
        SystemUnit<Angle> systemUnit9 = Units.add(Angle.class, Scalar.Angle::new, unitDimension19, "rad", (byte)3, (short)9101);
        SystemUnit<Dimensionless> systemUnit10 = Units.add(Dimensionless.class, Scalar.Dimensionless::new, unitDimension19, "", (byte)2, (short)9201);
        SystemUnit<Mass> systemUnit11 = Units.add(Mass.class, Scalar.Mass::new, unitDimension2, "kg", (byte)2, (short)0);
        LinearConverter linearConverter = Prefixes.converter('n');
        LinearConverter linearConverter2 = Prefixes.converter('\u00b5');
        LinearConverter linearConverter3 = Prefixes.converter('m');
        LinearConverter linearConverter4 = Prefixes.converter('c');
        LinearConverter linearConverter5 = Prefixes.converter('h');
        LinearConverter linearConverter6 = Prefixes.converter('k');
        LinearConverter linearConverter7 = LinearConverter.scale(10000.0, 1.0);
        systemUnit9.related(4);
        RADIAN = systemUnit9;
        GRAD = Units.add(systemUnit9, LinearConverter.scale(0.15707963267948966, 10.0), "grad", (byte)32, (short)9105);
        DEGREE = Units.add(systemUnit9, LinearConverter.scale(0.15707963267948966, 9.0), "\u00b0", (byte)4, (short)9102);
        ARC_MINUTE = Units.add(systemUnit9, LinearConverter.scale(0.15707963267948966, 540.0), "\u2032", (byte)4, (short)9103);
        ARC_SECOND = Units.add(systemUnit9, LinearConverter.scale(0.15707963267948966, 32400.0), "\u2033", (byte)4, (short)9104);
        MICRORADIAN = Units.add(systemUnit9, linearConverter2, "\u00b5rad", (byte)2, (short)9109);
        systemUnit.related(7);
        METRE = systemUnit;
        NANOMETRE = Units.add(systemUnit, linearConverter, "nm", (byte)2, (short)0);
        MILLIMETRE = Units.add(systemUnit, linearConverter3, "mm", (byte)2, (short)1025);
        CENTIMETRE = Units.add(systemUnit, linearConverter4, "cm", (byte)2, (short)1033);
        KILOMETRE = Units.add(systemUnit, linearConverter6, "km", (byte)2, (short)9036);
        NAUTICAL_MILE = Units.add(systemUnit, LinearConverter.scale(1852.0, 1.0), "M", (byte)32, (short)9030);
        STATUTE_MILE = Units.add(systemUnit, LinearConverter.scale(1609344.0, 1000.0), "mi", (byte)16, (short)9093);
        US_SURVEY_FOOT = Units.add(systemUnit, LinearConverter.scale(1200.0, 3937.0), "ftUS", (byte)32, (short)9003);
        CLARKE_FOOT = Units.add(systemUnit, LinearConverter.scale(3.047972654E9, 1.0E10), "ftCla", (byte)32, (short)9005);
        FOOT = Units.add(systemUnit, LinearConverter.scale(3048.0, 10000.0), "ft", (byte)16, (short)9002);
        INCH = Units.add(systemUnit, LinearConverter.scale(254.0, 10000.0), "in", (byte)16, (short)0);
        POINT = Units.add(systemUnit, LinearConverter.scale(996264.0, 7.2E7), "pt", (byte)32, (short)0);
        systemUnit4.related(5);
        SECOND = systemUnit4;
        MILLISECOND = Units.add(systemUnit4, linearConverter3, "ms", (byte)2, (short)0);
        MINUTE = Units.add(systemUnit4, LinearConverter.scale(60.0, 1.0), "min", (byte)4, (short)0);
        HOUR = Units.add(systemUnit4, LinearConverter.scale(3600.0, 1.0), "h", (byte)4, (short)0);
        DAY = Units.add(systemUnit4, LinearConverter.scale(86400.0, 1.0), "d", (byte)4, (short)0);
        WEEK = Units.add(systemUnit4, LinearConverter.scale(604800.0, 1.0), "wk", (byte)32, (short)0);
        TROPICAL_YEAR = Units.add(systemUnit4, LinearConverter.scale(3.1556925445E10, 1000.0), "a", (byte)32, (short)1029);
        SystemUnit<ScaleRateOfChange> systemUnit12 = new SystemUnit<ScaleRateOfChange>(ScaleRateOfChange.class, unitDimension8, null, 32, 1036, null);
        systemUnit12.related(1);
        systemUnit6.related(1);
        systemUnit7.related(1);
        METRES_PER_SECOND = systemUnit6;
        METRES_PER_SECOND_SQUARED = systemUnit7;
        KILOMETRES_PER_HOUR = Units.add(systemUnit6, LinearConverter.scale(10.0, 36.0), "km\u2215h", (byte)4, (short)0);
        RADIANS_PER_SECOND = Units.add(AngularVelocity.class, null, unitDimension8, "rad\u2215s", (byte)2, (short)1035);
        GAL = Units.add(systemUnit7, linearConverter4, "Gal", (byte)13, (short)0);
        Units.add(systemUnit12, LinearConverter.scale(1.0, 3.1556925445E16), "ppm\u2215a", (byte)32, (short)1030);
        systemUnit8.related(3);
        PASCAL = systemUnit8;
        HECTOPASCAL = Units.add(systemUnit8, linearConverter5, "hPa", (byte)2, (short)0);
        DECIBAR = Units.add(systemUnit8, linearConverter7, "dbar", (byte)32, (short)0);
        BAR = Units.add(systemUnit8, LinearConverter.scale(100000.0, 1.0), "bar", (byte)32, (short)0);
        ATMOSPHERE = Units.add(systemUnit8, LinearConverter.scale(101325.0, 1.0), "atm", (byte)32, (short)0);
        systemUnit5.related(2);
        KELVIN = systemUnit5;
        CELSIUS = Units.add(systemUnit5, LinearConverter.offset(27315.0, 100.0), "\u00b0C", (byte)2, (short)0);
        FAHRENHEIT = Units.add(systemUnit5, new LinearConverter(100.0, 45967.0, 180.0), "\u00b0F", (byte)32, (short)0);
        SQUARE_METRE = systemUnit2;
        CUBIC_METRE = systemUnit3;
        KILOGRAM = systemUnit11;
        HECTARE = Units.add(systemUnit2, linearConverter7, "ha", (byte)4, (short)0);
        LITRE = Units.add(systemUnit3, linearConverter3, "L", (byte)5, (short)0);
        GRAM = Units.add(systemUnit11, linearConverter3, "g", (byte)5, (short)0);
        HERTZ = Units.add(Frequency.class, Scalar.Frequency::new, unitDimension8, "Hz", (byte)3, (short)0);
        NEWTON = Units.add(Force.class, Scalar.Force::new, unitDimension12, "N", (byte)3, (short)0);
        JOULE = Units.add(Energy.class, Scalar.Energy::new, unitDimension13, "J", (byte)3, (short)0);
        WATT = Units.add(Power.class, Scalar.Power::new, unitDimension14, "W", (byte)3, (short)0);
        AMPERE = Units.add(ElectricCurrent.class, null, unitDimension4, "A", (byte)3, (short)0);
        COULOMB = Units.add(ElectricCharge.class, null, unitDimension15, "C", (byte)3, (short)0);
        VOLT = Units.add(ElectricPotential.class, null, unitDimension16, "V", (byte)3, (short)0);
        FARAD = Units.add(ElectricCapacitance.class, null, unitDimension15.divide(unitDimension16), "F", (byte)3, (short)0);
        SIEMENS = Units.add(ElectricConductance.class, null, unitDimension4.divide(unitDimension16), "S", (byte)3, (short)0);
        OHM = Units.add(ElectricResistance.class, null, unitDimension16.divide(unitDimension4), "\u03a9", (byte)3, (short)0);
        WEBER = Units.add(MagneticFlux.class, null, unitDimension17, "Wb", (byte)3, (short)0);
        TESLA = Units.add(MagneticFluxDensity.class, null, unitDimension17.divide(unitDimension9), "T", (byte)3, (short)0);
        HENRY = Units.add(ElectricInductance.class, null, unitDimension17.divide(unitDimension4), "H", (byte)3, (short)0);
        LUX = Units.add(Illuminance.class, null, unitDimension7.divide(unitDimension9), "lx", (byte)3, (short)0);
        LUMEN = Units.add(LuminousFlux.class, null, unitDimension7, "lm", (byte)3, (short)0);
        CANDELA = Units.add(LuminousIntensity.class, null, unitDimension7, "cd", (byte)3, (short)0);
        MOLE = Units.add(AmountOfSubstance.class, null, unitDimension6, "mol", (byte)3, (short)0);
        STERADIAN = Units.add(SolidAngle.class, null, unitDimension19, "sr", (byte)3, (short)0);
        SIGMA = Units.add(Dimensionless.class, Scalar.Dimensionless::new, unitDimension19, "sigma", (byte)32, (short)0);
        PIXEL = Units.add(Dimensionless.class, Scalar.Dimensionless::new, unitDimension19, "px", (byte)32, (short)0);
        SystemUnit<Salinity> systemUnit13 = Units.add(Salinity.class, null, unitDimension19, null, (byte)32, (short)0);
        PSU = Units.add(systemUnit13, linearConverter3, "psu", (byte)32, (short)0);
        PERCENT = Units.add(systemUnit10, linearConverter4, "%", (byte)32, (short)0);
        PPM = Units.add(systemUnit10, linearConverter2, "ppm", (byte)32, (short)9202);
        ConventionalUnit<Dimensionless> conventionalUnit = Units.add(systemUnit10, PowerOf10.belToOne(), "B", (byte)5, (short)0);
        DECIBEL = Units.add(conventionalUnit, Prefixes.converter('d'), "dB", (byte)4, (short)0);
        UNITY = UnitRegistry.init(systemUnit10);
        UnitRegistry.alias(UNITY, Short.valueOf((short)9203));
        UnitRegistry.alias(DEGREE, Short.valueOf((short)9122));
        UnitRegistry.alias(ARC_MINUTE, "'");
        UnitRegistry.alias(ARC_SECOND, "\"");
        UnitRegistry.alias(KELVIN, "K");
        UnitRegistry.alias(CELSIUS, "\u2103");
        UnitRegistry.alias(CELSIUS, "Cel");
        UnitRegistry.alias(FAHRENHEIT, "\u2109");
        UnitRegistry.alias(GRAD, "gon");
        UnitRegistry.alias(GAL, "cm\u2215s\u00b2");
        UnitRegistry.alias(HECTARE, "hm\u00b2");
        UnitRegistry.alias(LITRE, "l");
        UnitRegistry.alias(LITRE, "\u2113");
        UnitRegistry.alias(PSU, "PSU");
        UnitRegistry.alias(UNITY, "1");
        initialized = true;
    }
}

