/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.GridCacheValue;
import org.apache.sis.internal.netcdf.Linearizer;
import org.apache.sis.internal.storage.io.ByteWriter;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.Vector;
import org.apache.sis.util.collection.Cache;

class GridCacheKey {
    private final int width;
    private final int height;
    private final Object xAxis;
    private final Object yAxis;

    GridCacheKey(int n, int n2, Axis axis, Axis axis2) {
        this.width = n;
        this.height = n2;
        this.xAxis = axis;
        this.yAxis = axis2;
    }

    private GridCacheKey(GridCacheKey gridCacheKey) {
        this.width = gridCacheKey.width;
        this.height = gridCacheKey.height;
        this.xAxis = GridCacheKey.id(gridCacheKey.xAxis);
        this.yAxis = GridCacheKey.id(gridCacheKey.yAxis);
    }

    private static Object id(Object object) {
        return ((Axis)object).getName();
    }

    final GridCacheValue cached(Decoder decoder) {
        return decoder.localizationGrids.get(this);
    }

    final GridCacheValue cache(Decoder decoder, GridCacheValue gridCacheValue) {
        GridCacheValue gridCacheValue2 = decoder.localizationGrids.putIfAbsent(this, gridCacheValue);
        return gridCacheValue2 != null ? gridCacheValue2 : gridCacheValue;
    }

    public int hashCode() {
        return 31 * this.width + 37 * this.height + 7 * this.xAxis.hashCode() + this.yAxis.hashCode();
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            GridCacheKey gridCacheKey = (GridCacheKey)object;
            return gridCacheKey.width == this.width && gridCacheKey.height == this.height && this.xAxis.equals(gridCacheKey.xAxis) && this.yAxis.equals(gridCacheKey.yAxis);
        }
        return false;
    }

    public String toString() {
        return Strings.toString(this.getClass(), "width", this.width, "height", this.height);
    }

    static final class Global
    extends GridCacheKey {
        private static final Cache<GridCacheKey, GridCacheValue> CACHE = new Cache(12, 0L, false);
        private final Set<Linearizer.Type> linearizerTypes = EnumSet.noneOf(Linearizer.Type.class);
        private final byte[] digest;

        Global(GridCacheKey gridCacheKey, Vector vector, Vector vector2, Set<Linearizer> set) {
            super(gridCacheKey);
            MessageDigest messageDigest;
            for (Linearizer object2 : set) {
                this.linearizerTypes.add(object2.type);
            }
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new UnsupportedOperationException(noSuchAlgorithmException);
            }
            byte[] byArray = new byte[8192];
            byte[] byArray2 = Global.checksum(messageDigest, vector, byArray);
            byte[] byArray3 = Global.checksum(messageDigest, vector2, byArray);
            this.digest = new byte[byArray2.length + byArray3.length];
            System.arraycopy(byArray2, 0, this.digest, 0, byArray2.length);
            System.arraycopy(byArray3, 0, this.digest, byArray2.length, byArray3.length);
        }

        private static byte[] checksum(MessageDigest messageDigest, Vector vector, byte[] byArray) {
            int n;
            ByteWriter byteWriter = ByteWriter.create(vector, byArray);
            while ((n = byteWriter.write()) > 0) {
                messageDigest.update(byArray, 0, n);
            }
            return messageDigest.digest();
        }

        final Cache.Handler<GridCacheValue> lock() {
            return CACHE.lock(this);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.linearizerTypes.hashCode() + Arrays.hashCode(this.digest);
        }

        @Override
        public boolean equals(Object object) {
            if (super.equals(object)) {
                Global global = (Global)object;
                if (this.linearizerTypes.equals(global.linearizerTypes)) {
                    return Arrays.equals(this.digest, global.digest);
                }
            }
            return false;
        }
    }
}

