/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Date;
import org.apache.sis.filter.BinaryFunction;
import org.apache.sis.filter.ComparisonFilter;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.geoapi.filter.TemporalOperatorName;
import org.apache.sis.internal.geoapi.temporal.Instant;
import org.apache.sis.internal.geoapi.temporal.Period;

abstract class TemporalFilter<T>
extends BinaryFunction<T, Object, Object>
implements Filter<T>,
Optimization.OnFilter<T> {
    private static final long serialVersionUID = 5392780837658687513L;

    TemporalFilter(Expression<? super T, ?> expression, Expression<? super T, ?> expression2) {
        super(expression, expression2);
    }

    private static java.time.Instant toInstant(Instant instant) {
        Date date;
        if (instant != null && (date = instant.getDate()) != null) {
            return date.toInstant();
        }
        return null;
    }

    private static boolean isBefore(Instant instant, java.time.Instant instant2) {
        java.time.Instant instant3 = TemporalFilter.toInstant(instant);
        return instant3 != null && instant3.isBefore(instant2);
    }

    private static boolean isAfter(Instant instant, java.time.Instant instant2) {
        java.time.Instant instant3 = TemporalFilter.toInstant(instant);
        return instant3 != null && instant3.isAfter(instant2);
    }

    private static boolean isEqual(Instant instant, java.time.Instant instant2) {
        java.time.Instant instant3 = TemporalFilter.toInstant(instant);
        return instant3 != null && instant3.equals(instant2);
    }

    private static boolean isBefore(Instant instant, Instant instant2) {
        java.time.Instant instant3;
        java.time.Instant instant4 = TemporalFilter.toInstant(instant);
        return instant4 != null && (instant3 = TemporalFilter.toInstant(instant2)) != null && instant4.isBefore(instant3);
    }

    private static boolean isAfter(Instant instant, Instant instant2) {
        java.time.Instant instant3;
        java.time.Instant instant4 = TemporalFilter.toInstant(instant);
        return instant4 != null && (instant3 = TemporalFilter.toInstant(instant2)) != null && instant4.isAfter(instant3);
    }

    private static boolean isEqual(Instant instant, Instant instant2) {
        java.time.Instant instant3 = TemporalFilter.toInstant(instant);
        return instant3 != null && instant3.equals(TemporalFilter.toInstant(instant2));
    }

    @Override
    public final boolean test(T t2) {
        Object v = this.expression1.apply(t2);
        if (v instanceof Period) {
            Object v2 = this.expression2.apply(t2);
            if (v2 instanceof Period) {
                return this.evaluate((Period)v, (Period)v2);
            }
            java.time.Instant instant = ComparisonFilter.toInstant(v2);
            if (instant != null) {
                return this.evaluate((Period)v, instant);
            }
        } else {
            java.time.Instant instant;
            java.time.Instant instant2 = ComparisonFilter.toInstant(v);
            if (instant2 != null && (instant = ComparisonFilter.toInstant(this.expression2.apply(t2))) != null) {
                return this.evaluate(instant2, instant);
            }
        }
        return false;
    }

    protected boolean evaluate(java.time.Instant instant, java.time.Instant instant2) {
        return false;
    }

    protected boolean evaluate(Period period, java.time.Instant instant) {
        return false;
    }

    protected boolean evaluate(Period period, Period period2) {
        return false;
    }

    static final class AnyInteracts<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = 5972351564286442392L;

        AnyInteracts(Expression<? super T, ?> expression, Expression<? super T, ?> expression2) {
            super(expression, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<? super T, ?>[] expressionArray) {
            return new AnyInteracts<T>(expressionArray[0], expressionArray[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.ANY_INTERACTS;
        }

        @Override
        public boolean evaluate(Period period, Period period2) {
            java.time.Instant instant;
            java.time.Instant instant2;
            java.time.Instant instant3;
            java.time.Instant instant4 = TemporalFilter.toInstant(period.getBeginning());
            return instant4 != null && (instant3 = TemporalFilter.toInstant(period2.getEnding())) != null && instant4.isBefore(instant3) && (instant2 = TemporalFilter.toInstant(period.getEnding())) != null && (instant = TemporalFilter.toInstant(period2.getBeginning())) != null && instant2.isAfter(instant);
        }
    }

    static final class OverlappedBy<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = 2228673820507226463L;

        OverlappedBy(Expression<? super T, ?> expression, Expression<? super T, ?> expression2) {
            super(expression, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<? super T, ?>[] expressionArray) {
            return new OverlappedBy<T>(expressionArray[0], expressionArray[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.OVERLAPPED_BY;
        }

        @Override
        public boolean evaluate(Period period, Period period2) {
            java.time.Instant instant;
            java.time.Instant instant2 = TemporalFilter.toInstant(period.getBeginning());
            return instant2 != null && (instant = TemporalFilter.toInstant(period2.getEnding())) != null && instant2.isBefore(instant) && TemporalFilter.isBefore(period2.getBeginning(), instant2) && TemporalFilter.isAfter(period.getEnding(), instant);
        }
    }

    static final class Overlaps<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = 1517443045593389773L;

        Overlaps(Expression<? super T, ?> expression, Expression<? super T, ?> expression2) {
            super(expression, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<? super T, ?>[] expressionArray) {
            return new Overlaps<T>(expressionArray[0], expressionArray[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.OVERLAPS;
        }

        @Override
        public boolean evaluate(Period period, Period period2) {
            java.time.Instant instant;
            java.time.Instant instant2 = TemporalFilter.toInstant(period.getEnding());
            return instant2 != null && (instant = TemporalFilter.toInstant(period2.getBeginning())) != null && instant2.isAfter(instant) && TemporalFilter.isBefore(period.getBeginning(), instant) && TemporalFilter.isAfter(period2.getEnding(), instant2);
        }
    }

    static final class Contains<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = 9107531246948034411L;

        Contains(Expression<? super T, ?> expression, Expression<? super T, ?> expression2) {
            super(expression, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<? super T, ?>[] expressionArray) {
            return new Contains<T>(expressionArray[0], expressionArray[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.CONTAINS;
        }

        @Override
        protected char symbol() {
            return '\u228b';
        }

        @Override
        public boolean evaluate(Period period, java.time.Instant instant) {
            return TemporalFilter.isBefore(period.getBeginning(), instant) && TemporalFilter.isAfter(period.getEnding(), instant);
        }

        @Override
        public boolean evaluate(Period period, Period period2) {
            return TemporalFilter.isBefore(period.getBeginning(), period2.getBeginning()) && TemporalFilter.isAfter(period.getEnding(), period2.getEnding());
        }
    }

    static final class During<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = -4674319635076886196L;

        During(Expression<? super T, ?> expression, Expression<? super T, ?> expression2) {
            super(expression, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<? super T, ?>[] expressionArray) {
            return new During<T>(expressionArray[0], expressionArray[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.DURING;
        }

        @Override
        protected char symbol() {
            return '\u228a';
        }

        @Override
        public boolean evaluate(Period period, Period period2) {
            return TemporalFilter.isAfter(period.getBeginning(), period2.getBeginning()) && TemporalFilter.isBefore(period.getEnding(), period2.getEnding());
        }
    }

    static final class MetBy<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = 5358059498707330482L;

        MetBy(Expression<? super T, ?> expression, Expression<? super T, ?> expression2) {
            super(expression, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<? super T, ?>[] expressionArray) {
            return new MetBy<T>(expressionArray[0], expressionArray[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.MET_BY;
        }

        @Override
        public boolean evaluate(java.time.Instant instant, java.time.Instant instant2) {
            return instant.equals(instant2);
        }

        @Override
        public boolean evaluate(Period period, java.time.Instant instant) {
            return TemporalFilter.isEqual(period.getBeginning(), instant);
        }

        @Override
        public boolean evaluate(Period period, Period period2) {
            return TemporalFilter.isEqual(period.getBeginning(), period2.getEnding());
        }
    }

    static final class Meets<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = -3534843269384858443L;

        Meets(Expression<? super T, ?> expression, Expression<? super T, ?> expression2) {
            super(expression, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<? super T, ?>[] expressionArray) {
            return new Meets<T>(expressionArray[0], expressionArray[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.MEETS;
        }

        @Override
        public boolean evaluate(java.time.Instant instant, java.time.Instant instant2) {
            return instant.equals(instant2);
        }

        @Override
        public boolean evaluate(Period period, java.time.Instant instant) {
            return TemporalFilter.isEqual(period.getEnding(), instant);
        }

        @Override
        public boolean evaluate(Period period, Period period2) {
            return TemporalFilter.isEqual(period.getEnding(), period2.getBeginning());
        }
    }

    static final class EndedBy<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = 8586566103462153666L;

        EndedBy(Expression<? super T, ?> expression, Expression<? super T, ?> expression2) {
            super(expression, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<? super T, ?>[] expressionArray) {
            return new EndedBy<T>(expressionArray[0], expressionArray[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.ENDED_BY;
        }

        @Override
        public boolean evaluate(Period period, java.time.Instant instant) {
            return TemporalFilter.isEqual(period.getEnding(), instant);
        }

        @Override
        public boolean evaluate(Period period, Period period2) {
            return TemporalFilter.isEqual(period.getEnding(), period2.getEnding()) && TemporalFilter.isBefore(period.getBeginning(), period2.getBeginning());
        }
    }

    static final class BegunBy<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = -7212413827394364384L;

        BegunBy(Expression<? super T, ?> expression, Expression<? super T, ?> expression2) {
            super(expression, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<? super T, ?>[] expressionArray) {
            return new BegunBy<T>(expressionArray[0], expressionArray[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.BEGUN_BY;
        }

        @Override
        public boolean evaluate(Period period, java.time.Instant instant) {
            return TemporalFilter.isEqual(period.getBeginning(), instant);
        }

        @Override
        public boolean evaluate(Period period, Period period2) {
            return TemporalFilter.isEqual(period.getBeginning(), period2.getBeginning()) && TemporalFilter.isAfter(period.getEnding(), period2.getEnding());
        }
    }

    static final class Ends<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = -5508229966320563437L;

        Ends(Expression<? super T, ?> expression, Expression<? super T, ?> expression2) {
            super(expression, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<? super T, ?>[] expressionArray) {
            return new Ends<T>(expressionArray[0], expressionArray[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.ENDS;
        }

        @Override
        public boolean evaluate(Period period, Period period2) {
            return TemporalFilter.isEqual(period.getEnding(), period2.getEnding()) && TemporalFilter.isAfter(period.getBeginning(), period2.getBeginning());
        }
    }

    static final class Begins<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = -7880699329127762233L;

        Begins(Expression<? super T, ?> expression, Expression<? super T, ?> expression2) {
            super(expression, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<? super T, ?>[] expressionArray) {
            return new Begins<T>(expressionArray[0], expressionArray[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.BEGINS;
        }

        @Override
        public boolean evaluate(Period period, Period period2) {
            return TemporalFilter.isEqual(period.getBeginning(), period2.getBeginning()) && TemporalFilter.isBefore(period.getEnding(), period2.getEnding());
        }
    }

    static final class After<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = 5410476260417497682L;

        After(Expression<? super T, ?> expression, Expression<? super T, ?> expression2) {
            super(expression, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<? super T, ?>[] expressionArray) {
            return new After<T>(expressionArray[0], expressionArray[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.AFTER;
        }

        @Override
        protected char symbol() {
            return '>';
        }

        @Override
        protected boolean evaluate(java.time.Instant instant, java.time.Instant instant2) {
            return instant.isAfter(instant2);
        }

        @Override
        public boolean evaluate(Period period, java.time.Instant instant) {
            return TemporalFilter.isAfter(period.getBeginning(), instant);
        }

        @Override
        public boolean evaluate(Period period, Period period2) {
            return TemporalFilter.isAfter(period.getBeginning(), period2.getEnding());
        }
    }

    static final class Before<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = -3422629447456003982L;

        Before(Expression<? super T, ?> expression, Expression<? super T, ?> expression2) {
            super(expression, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<? super T, ?>[] expressionArray) {
            return new Before<T>(expressionArray[0], expressionArray[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.BEFORE;
        }

        @Override
        protected char symbol() {
            return '<';
        }

        @Override
        protected boolean evaluate(java.time.Instant instant, java.time.Instant instant2) {
            return instant.isBefore(instant2);
        }

        @Override
        public boolean evaluate(Period period, java.time.Instant instant) {
            return TemporalFilter.isBefore(period.getEnding(), instant);
        }

        @Override
        public boolean evaluate(Period period, Period period2) {
            return TemporalFilter.isBefore(period.getEnding(), period2.getBeginning());
        }
    }

    static final class Equals<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = -6060822291802339424L;

        Equals(Expression<? super T, ?> expression, Expression<? super T, ?> expression2) {
            super(expression, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<? super T, ?>[] expressionArray) {
            return new Equals<T>(expressionArray[0], expressionArray[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.EQUALS;
        }

        @Override
        protected char symbol() {
            return '=';
        }

        @Override
        protected boolean evaluate(java.time.Instant instant, java.time.Instant instant2) {
            return instant.equals(instant2);
        }

        @Override
        public boolean evaluate(Period period, java.time.Instant instant) {
            return TemporalFilter.isEqual(period.getBeginning(), instant) && TemporalFilter.isEqual(period.getEnding(), instant);
        }

        @Override
        public boolean evaluate(Period period, Period period2) {
            return TemporalFilter.isEqual(period.getBeginning(), period2.getBeginning()) && TemporalFilter.isEqual(period.getEnding(), period2.getEnding());
        }
    }
}

