/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Range;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;

public final class ExtentSelector<T> {
    private GeographicBoundingBox areaOfInterest;
    private Instant minTOI;
    private Instant maxTOI;
    private long granularity;
    public boolean alternateOrdering;
    private T best;
    private double largestArea;
    private Duration longestTime;
    private double outsideArea;
    private Duration overtime;
    private double pseudoDistance;
    private double temporalDistance;
    private static final int OVERTIME = 0;
    private static final int TEMPORAL_DISTANCE = 1;
    private static final int OUTSIDE_AREA = 2;
    private static final int PSEUDO_DISTANCE = 3;
    private static final int NONE = 4;

    public ExtentSelector(GeographicBoundingBox geographicBoundingBox, Instant[] instantArray) {
        int n;
        this.areaOfInterest = geographicBoundingBox;
        if (instantArray != null && (n = instantArray.length) != 0) {
            this.minTOI = instantArray[0];
            this.maxTOI = instantArray[n - 1];
        }
    }

    public ExtentSelector(Extent extent) {
        if (!this.setExtentOfInterest(extent, null, null)) {
            throw new IllegalArgumentException();
        }
    }

    public final boolean setExtentOfInterest(Extent extent, GeographicBoundingBox geographicBoundingBox, Instant[] instantArray) {
        Comparable<Date> comparable;
        this.areaOfInterest = Extents.intersection(geographicBoundingBox, Extents.getGeographicBoundingBox(extent));
        this.maxTOI = null;
        this.minTOI = null;
        Range<Date> range = Extents.getTimeRange(extent);
        if (range != null) {
            comparable = range.getMinValue();
            if (comparable != null) {
                this.minTOI = ((Date)comparable).toInstant();
            }
            if ((comparable = range.getMaxValue()) != null) {
                this.maxTOI = ((Date)comparable).toInstant();
            }
        }
        if (instantArray != null && instantArray.length != 0) {
            comparable = instantArray[0];
            if (this.minTOI == null || comparable != null && ((Instant)comparable).isAfter(this.minTOI)) {
                this.minTOI = comparable;
            }
            if (instantArray.length >= 2) {
                comparable = instantArray[1];
            }
            if (this.maxTOI == null || comparable != null && ((Instant)comparable).isBefore(this.maxTOI)) {
                this.maxTOI = comparable;
            }
        }
        return (this.minTOI == null || this.maxTOI == null || !this.minTOI.isAfter(this.maxTOI)) && (this.areaOfInterest == null || this.areaOfInterest.getNorthBoundLatitude() >= this.areaOfInterest.getSouthBoundLatitude() && Double.isFinite(this.areaOfInterest.getWestBoundLongitude()) && Double.isFinite(this.areaOfInterest.getEastBoundLongitude()) && !Boolean.FALSE.equals(this.areaOfInterest.getInclusion()));
    }

    public final GeographicBoundingBox getAreaOfInterest() {
        return this.areaOfInterest;
    }

    public final Instant[] getTimeOfInterest() {
        Instant[] instantArray;
        if (this.minTOI == null && this.maxTOI == null) {
            instantArray = null;
        } else {
            Instant[] instantArray2 = new Instant[2];
            instantArray2[0] = this.minTOI;
            instantArray = instantArray2;
            instantArray2[1] = this.maxTOI;
        }
        return instantArray;
    }

    public final void setTimeGranularity(Duration duration) {
        if (duration == null) {
            this.granularity = 0L;
        } else {
            if (duration.isZero() || duration.isNegative()) {
                throw new IllegalArgumentException(Errors.format((short)45, "resolution", duration));
            }
            this.granularity = duration.getSeconds();
        }
    }

    private Duration round(Duration duration) {
        if (duration != null && !duration.isZero() && this.granularity != 0L) {
            long l = duration.getSeconds();
            long l2 = l / this.granularity;
            long l3 = l % this.granularity;
            if (l3 != 0L) {
                if ((l -= l3) == 0L || l3 >= this.granularity >> 1) {
                    l += this.granularity;
                }
                duration = Duration.ofSeconds(l);
            }
        }
        return duration;
    }

    private double pseudoDistance(GeographicBoundingBox geographicBoundingBox) {
        if (this.areaOfInterest == null || geographicBoundingBox == null) {
            return Double.NaN;
        }
        double d = this.areaOfInterest.getNorthBoundLatitude() + this.areaOfInterest.getSouthBoundLatitude();
        double d2 = geographicBoundingBox.getNorthBoundLatitude() + geographicBoundingBox.getSouthBoundLatitude() - d;
        double d3 = (geographicBoundingBox.getEastBoundLongitude() - this.areaOfInterest.getEastBoundLongitude() + (geographicBoundingBox.getWestBoundLongitude() - this.areaOfInterest.getWestBoundLongitude())) * Math.cos(d * (Math.PI / 360));
        return d2 * d2 + d3 * d3;
    }

    private double temporalDistance(Instant instant, Instant instant2) {
        return Math.abs(ExtentSelector.median(instant, instant2) - ExtentSelector.median(this.minTOI, this.maxTOI));
    }

    private static double median(Instant instant, Instant instant2) {
        if (instant != null) {
            long l = instant.toEpochMilli();
            return instant2 != null ? MathFunctions.average(l, instant2.toEpochMilli()) : (double)l;
        }
        return instant2 != null ? (double)instant2.toEpochMilli() : Double.NaN;
    }

    private Duration overtime(Instant instant, Instant instant2, Duration duration) {
        return instant != null && instant2 != null && duration != null ? this.round(Duration.between(instant, instant2).minus(duration)) : null;
    }

    public void evaluate(Extent extent, T t2) {
        Date date;
        Range<Date> range = Extents.getTimeRange(extent);
        this.evaluate(Extents.getGeographicBoundingBox(extent), range != null && (date = range.getMinValue()) != null ? date.toInstant() : null, range != null && (date = range.getMaxValue()) != null ? date.toInstant() : null, t2);
    }

    public void evaluate(GeographicBoundingBox geographicBoundingBox, Instant instant, Instant instant2, T t2) {
        int n;
        double d;
        Duration duration;
        Instant instant3 = instant;
        Instant instant4 = instant2;
        if (instant3 != null && this.minTOI != null && instant3.isBefore(this.minTOI)) {
            instant3 = this.minTOI;
        }
        if (instant4 != null && this.maxTOI != null && instant4.isAfter(this.maxTOI)) {
            instant4 = this.maxTOI;
        }
        if (instant3 != null && instant4 != null) {
            duration = Duration.between(instant3, instant4);
            if (duration.isNegative()) {
                return;
            }
        } else {
            duration = null;
        }
        if (Double.isNaN(d = Extents.area(Extents.intersection(geographicBoundingBox, this.areaOfInterest))) && geographicBoundingBox != null) {
            return;
        }
        Duration duration2 = this.round(duration);
        int n2 = 0;
        if (this.best != null && (n = ExtentSelector.compare(duration2, this.longestTime, -1)) <= 0) {
            if (n != 0) {
                return;
            }
            n2 = 1;
            Duration duration3 = this.overtime(instant, instant2, duration);
            n = ExtentSelector.compare(duration3, this.overtime, 1);
            if (n >= 0) {
                if (n != 0) {
                    return;
                }
                n2 = 2;
                double d2 = this.temporalDistance(instant, instant2);
                if (this.alternateOrdering || (n = ExtentSelector.compare(d2, this.temporalDistance, 1)) >= 0) {
                    if (n != 0) {
                        return;
                    }
                    n = ExtentSelector.compare(d, this.largestArea, -1);
                    if (n <= 0) {
                        if (n != 0) {
                            return;
                        }
                        n2 = 3;
                        double d3 = Extents.area(geographicBoundingBox) - d;
                        n = ExtentSelector.compare(d3, this.outsideArea, 1);
                        if (n >= 0) {
                            if (n != 0) {
                                return;
                            }
                            n2 = 4;
                            double d4 = this.pseudoDistance(geographicBoundingBox);
                            if (!(ExtentSelector.compare(d4, this.pseudoDistance, 1) < 0 || n == 0 && this.alternateOrdering)) {
                                return;
                            }
                            if (this.alternateOrdering && ExtentSelector.compare(d2, this.temporalDistance, 1) >= 0) {
                                return;
                            }
                            this.pseudoDistance = d4;
                        }
                        this.outsideArea = d3;
                    }
                }
                this.temporalDistance = d2;
            }
            this.overtime = duration3;
        }
        this.longestTime = duration2;
        this.largestArea = d;
        switch (n2) {
            case 0: {
                this.overtime = this.overtime(instant, instant2, duration);
            }
            case 1: {
                this.temporalDistance = this.temporalDistance(instant, instant2);
            }
            case 2: {
                this.outsideArea = Extents.area(geographicBoundingBox) - d;
            }
            case 3: {
                this.pseudoDistance = this.pseudoDistance(geographicBoundingBox);
            }
        }
        this.best = t2;
    }

    private static int compare(Duration duration, Duration duration2, int n) {
        if (duration != null) {
            return duration2 != null ? duration.compareTo(duration2) : -n;
        }
        return duration2 != null ? n : 0;
    }

    private static int compare(double d, double d2, int n) {
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        boolean bl = Double.isNaN(d2);
        if (Double.isNaN(d) == bl) {
            return 0;
        }
        if (bl) {
            n = -n;
        }
        return n;
    }

    public T best() {
        return this.best;
    }
}

