/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import org.apache.sis.coverage.Category;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.opengis.util.InternationalString;

final class ColorsForRange
implements Comparable<ColorsForRange> {
    final CharSequence name;
    NumberRange<?> sampleRange;
    private final Color[] colors;
    final boolean isData;

    ColorsForRange(Category category, Function<Category, Color[]> function) {
        InternationalString internationalString = category.getName();
        this.name = internationalString != null ? internationalString : this.sampleRange.toString();
        this.sampleRange = category.getSampleRange();
        this.colors = function.apply(category);
        this.isData = category.isQuantitative();
    }

    ColorsForRange(CharSequence charSequence, NumberRange<?> numberRange, Color[] colorArray, boolean bl) {
        ArgumentChecks.ensureNonNull("sampleRange", numberRange);
        this.name = charSequence != null ? charSequence : numberRange.toString();
        this.sampleRange = numberRange;
        this.colors = colorArray;
        this.isData = bl;
    }

    static ColorsForRange[] list(Collection<Map.Entry<NumberRange<?>, Color[]>> collection) {
        ColorsForRange[] colorsForRangeArray = new ColorsForRange[collection.size()];
        int n = 0;
        for (Map.Entry<NumberRange<?>, Color[]> entry : collection) {
            colorsForRangeArray[n++] = new ColorsForRange(null, entry.getKey(), entry.getValue(), true);
        }
        return ArraysExt.resize(colorsForRangeArray, n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.name).append(": ").append(this.sampleRange);
        if (this.colors != null) {
            ColorsForRange.appendColorRange(stringBuilder, this.colors.length, n -> this.colors[n].getRGB());
        }
        return stringBuilder.toString();
    }

    static void appendColorRange(StringBuilder stringBuilder, int n, IntUnaryOperator intUnaryOperator) {
        if (n != 0) {
            String string = " \u2192 ARGB[";
            int n2 = 0;
            do {
                stringBuilder.append(string).append(Integer.toHexString(intUnaryOperator.applyAsInt(n2)).toUpperCase());
                string = " \u2026 ";
            } while (n2 < (n2 = n - 1));
            stringBuilder.append(']');
        }
    }

    @Override
    public int compareTo(ColorsForRange colorsForRange) {
        return this.getAlpha() - colorsForRange.getAlpha();
    }

    private int getAlpha() {
        int n = 0;
        if (this.colors != null) {
            for (int i = 0; i < this.colors.length; ++i) {
                int n2 = this.colors[i].getAlpha();
                if (n2 <= n) continue;
                if (n2 >= 255) {
                    return 255;
                }
                n = n2;
            }
        }
        return n;
    }

    final int[] toARGB() {
        if (this.colors != null) {
            int n = 0;
            int[] nArray = new int[this.colors.length];
            for (int i = 0; i < nArray.length; ++i) {
                Color color = this.colors[i];
                if (color == null) continue;
                int n2 = color.getRGB();
                n |= n2;
                nArray[i] = n2;
            }
            if ((n & 0xFF000000) != 0) {
                return nArray;
            }
        }
        return ArraysExt.EMPTY_INT;
    }
}

