/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.apache.sis.filter.BinaryFunction;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.FilterNode;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.geoapi.filter.BetweenComparisonOperator;
import org.apache.sis.internal.geoapi.filter.BinaryComparisonOperator;
import org.apache.sis.internal.geoapi.filter.ComparisonOperatorName;
import org.apache.sis.internal.geoapi.filter.MatchAction;
import org.apache.sis.math.Fraction;
import org.apache.sis.util.ArgumentChecks;

abstract class ComparisonFilter<R>
extends BinaryFunction<R, Object, Object>
implements BinaryComparisonOperator<R>,
Optimization.OnFilter<R> {
    private static final long serialVersionUID = 1228683039737814926L;
    protected final boolean isMatchingCase;
    protected final MatchAction matchAction;

    ComparisonFilter(Expression<? super R, ?> expression, Expression<? super R, ?> expression2, boolean bl, MatchAction matchAction) {
        super(expression, expression2);
        this.isMatchingCase = bl;
        this.matchAction = matchAction;
        ArgumentChecks.ensureNonNull("matchAction", (Object)matchAction);
    }

    @Override
    public final Expression<? super R, ?> getOperand1() {
        return this.expression1;
    }

    @Override
    public final Expression<? super R, ?> getOperand2() {
        return this.expression2;
    }

    @Override
    public final boolean isMatchingCase() {
        return this.isMatchingCase;
    }

    @Override
    public final MatchAction getMatchAction() {
        return this.matchAction;
    }

    @Override
    public final int hashCode() {
        return super.hashCode() + Boolean.hashCode(this.isMatchingCase) + 61 * this.matchAction.hashCode();
    }

    @Override
    public final boolean equals(Object object) {
        if (super.equals(object)) {
            ComparisonFilter comparisonFilter = (ComparisonFilter)object;
            return comparisonFilter.isMatchingCase == this.isMatchingCase && this.matchAction.equals((Object)comparisonFilter.matchAction);
        }
        return false;
    }

    @Override
    public final boolean test(R r) {
        Object v;
        Object v2 = this.expression1.apply(r);
        if (v2 != null && (v = this.expression2.apply(r)) != null) {
            Iterable iterable;
            boolean bl = v2 instanceof Iterable;
            if (bl) {
                if (v instanceof Iterable) {
                    return false;
                }
                iterable = (Iterable)v2;
            } else if (v instanceof Iterable) {
                iterable = (Iterable)v;
            } else {
                return this.evaluate(v2, v);
            }
            boolean bl2 = false;
            block5: for (Object t2 : iterable) {
                if (t2 == null) continue;
                boolean bl3 = bl ? this.evaluate(t2, v) : this.evaluate(v2, t2);
                switch (this.matchAction) {
                    default: {
                        return false;
                    }
                    case ALL: {
                        if (!bl3) {
                            return false;
                        }
                        bl2 = true;
                        continue block5;
                    }
                    case ANY: {
                        if (!bl3) continue block5;
                        return true;
                    }
                    case ONE: 
                }
                if (!bl3) continue;
                if (bl2) {
                    return false;
                }
                bl2 = true;
            }
            return bl2;
        }
        return false;
    }

    private boolean evaluate(Object object, Object object2) {
        Comparable<ChronoLocalDateTime<?>> comparable;
        if (object instanceof Number && object2 instanceof Number && (comparable = this.apply((Number)object, (Number)object2)) != null) {
            return ((Number)((Object)comparable)).intValue() != 0;
        }
        if (object instanceof java.util.Date && object2 instanceof java.util.Date) {
            if (object.getClass() == object2.getClass()) {
                return this.fromCompareTo(((java.util.Date)object).compareTo((java.util.Date)object2));
            }
            object = ComparisonFilter.fromLegacy((java.util.Date)object);
            object2 = ComparisonFilter.fromLegacy((java.util.Date)object2);
        }
        if (object instanceof Temporal || object2 instanceof Temporal) {
            if (object instanceof Instant) {
                comparable = ComparisonFilter.toInstant(object2);
                if (comparable != null) {
                    return this.fromCompareTo(((Instant)object).compareTo((Instant)comparable));
                }
            } else if (object2 instanceof Instant) {
                comparable = ComparisonFilter.toInstant(object);
                if (comparable != null) {
                    return this.fromCompareTo(((Instant)comparable).compareTo((Instant)object2));
                }
            } else if (object instanceof OffsetDateTime) {
                comparable = ComparisonFilter.toOffsetDateTime(object2);
                if (comparable != null) {
                    return this.compare((OffsetDateTime)object, (OffsetDateTime)comparable);
                }
            } else if (object2 instanceof OffsetDateTime) {
                comparable = ComparisonFilter.toOffsetDateTime(object);
                if (comparable != null) {
                    return this.compare((OffsetDateTime)comparable, (OffsetDateTime)object2);
                }
            } else if (object instanceof OffsetTime && object2 instanceof OffsetTime) {
                return this.compare((OffsetTime)object, (OffsetTime)object2);
            }
            if (object instanceof ChronoLocalDateTime) {
                comparable = ComparisonFilter.toLocalDateTime(object2);
                if (comparable != null) {
                    return this.compare((ChronoLocalDateTime)object, (ChronoLocalDateTime<?>)comparable);
                }
            } else if (object2 instanceof ChronoLocalDateTime && (comparable = ComparisonFilter.toLocalDateTime(object)) != null) {
                return this.compare((ChronoLocalDateTime<?>)comparable, (ChronoLocalDateTime)object2);
            }
            if (object instanceof ChronoLocalDate) {
                comparable = ComparisonFilter.toLocalDate(object2);
                if (comparable != null) {
                    return this.compare((ChronoLocalDate)object, (ChronoLocalDate)comparable);
                }
            } else if (object2 instanceof ChronoLocalDate && (comparable = ComparisonFilter.toLocalDate(object)) != null) {
                return this.compare((ChronoLocalDate)comparable, (ChronoLocalDate)object2);
            }
            if (object instanceof LocalTime) {
                comparable = ComparisonFilter.toLocalTime(object2);
                if (comparable != null) {
                    return this.fromCompareTo(((LocalTime)object).compareTo((LocalTime)comparable));
                }
            } else if (object2 instanceof LocalTime && (comparable = ComparisonFilter.toLocalTime(object)) != null) {
                return this.fromCompareTo(((LocalTime)comparable).compareTo((LocalTime)object2));
            }
        }
        if (object instanceof CharSequence || object2 instanceof CharSequence) {
            comparable = object.toString();
            String string = object2.toString();
            int n = this.isMatchingCase ? ((String)((Object)comparable)).compareTo(string) : ((String)((Object)comparable)).compareToIgnoreCase(string);
            return this.fromCompareTo(n);
        }
        if (object.getClass() == object2.getClass() && object instanceof Comparable) {
            int n = ((Comparable)object).compareTo(object2);
            return this.fromCompareTo(n);
        }
        return false;
    }

    private static Temporal fromLegacy(java.util.Date date) {
        if (date instanceof Timestamp) {
            return ((Timestamp)date).toLocalDateTime();
        }
        if (date instanceof Date) {
            return ((Date)date).toLocalDate();
        }
        if (date instanceof Time) {
            return ((Time)date).toLocalTime();
        }
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    static Instant toInstant(Object object) {
        if (object instanceof Instant) {
            return (Instant)object;
        }
        if (object instanceof OffsetDateTime) {
            return ((OffsetDateTime)object).toInstant();
        }
        if (object instanceof ChronoZonedDateTime) {
            return ((ChronoZonedDateTime)object).toInstant();
        }
        if (object instanceof java.util.Date) {
            try {
                return ((java.util.Date)object).toInstant();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        } else if (object instanceof Calendar) {
            return ((Calendar)object).toInstant();
        }
        return null;
    }

    private static OffsetDateTime toOffsetDateTime(Object object) {
        if (object instanceof OffsetDateTime) {
            return (OffsetDateTime)object;
        }
        if (object instanceof ZonedDateTime) {
            return ((ZonedDateTime)object).toOffsetDateTime();
        }
        return null;
    }

    private static ChronoLocalDateTime<?> toLocalDateTime(Object object) {
        if (object instanceof ChronoLocalDateTime) {
            return (ChronoLocalDateTime)object;
        }
        if (object instanceof ChronoZonedDateTime) {
            ComparisonFilter.ignoringField(ChronoField.OFFSET_SECONDS);
            return ((ChronoZonedDateTime)object).toLocalDateTime();
        }
        if (object instanceof OffsetDateTime) {
            ComparisonFilter.ignoringField(ChronoField.OFFSET_SECONDS);
            return ((OffsetDateTime)object).toLocalDateTime();
        }
        if (object instanceof Timestamp) {
            return ((Timestamp)object).toLocalDateTime();
        }
        return null;
    }

    private static ChronoLocalDate toLocalDate(Object object) {
        if (object instanceof ChronoLocalDate) {
            return (ChronoLocalDate)object;
        }
        if (object instanceof ChronoLocalDateTime) {
            ComparisonFilter.ignoringField(ChronoField.SECOND_OF_DAY);
            return ((ChronoLocalDateTime)object).toLocalDate();
        }
        if (object instanceof ChronoZonedDateTime) {
            ComparisonFilter.ignoringField(ChronoField.SECOND_OF_DAY);
            return ((ChronoZonedDateTime)object).toLocalDate();
        }
        if (object instanceof OffsetDateTime) {
            ComparisonFilter.ignoringField(ChronoField.SECOND_OF_DAY);
            return ((OffsetDateTime)object).toLocalDate();
        }
        if (object instanceof Date) {
            return ((Date)object).toLocalDate();
        }
        return null;
    }

    private static LocalTime toLocalTime(Object object) {
        if (object instanceof LocalTime) {
            return (LocalTime)object;
        }
        if (object instanceof OffsetTime) {
            ComparisonFilter.ignoringField(ChronoField.OFFSET_SECONDS);
            return ((OffsetTime)object).toLocalTime();
        }
        if (object instanceof Time) {
            return ((Time)object).toLocalTime();
        }
        return null;
    }

    private static void ignoringField(ChronoField chronoField) {
    }

    private static Number number(boolean bl) {
        return bl ? 1 : 0;
    }

    protected abstract boolean fromCompareTo(int var1);

    protected abstract boolean compare(OffsetTime var1, OffsetTime var2);

    protected abstract boolean compare(OffsetDateTime var1, OffsetDateTime var2);

    protected abstract boolean compare(ChronoLocalDate var1, ChronoLocalDate var2);

    protected abstract boolean compare(ChronoLocalDateTime<?> var1, ChronoLocalDateTime<?> var2);

    protected abstract boolean compare(ChronoZonedDateTime<?> var1, ChronoZonedDateTime<?> var2);

    @Override
    protected final Number applyAsDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return ComparisonFilter.number(this.fromCompareTo(bigDecimal.compareTo(bigDecimal2)));
    }

    @Override
    protected final Number applyAsInteger(BigInteger bigInteger, BigInteger bigInteger2) {
        return ComparisonFilter.number(this.fromCompareTo(bigInteger.compareTo(bigInteger2)));
    }

    @Override
    protected final Number applyAsFraction(Fraction fraction, Fraction fraction2) {
        return ComparisonFilter.number(this.fromCompareTo(fraction.compareTo(fraction2)));
    }

    static final class Between<R>
    extends FilterNode<R>
    implements BetweenComparisonOperator<R> {
        private static final long serialVersionUID = -2434954008425799595L;
        private final GreaterThanOrEqualTo<? super R> lower;
        private final LessThanOrEqualTo<? super R> upper;

        Between(Expression<? super R, ?> expression, Expression<? super R, ?> expression2, Expression<? super R, ?> expression3) {
            this.lower = new GreaterThanOrEqualTo<R>(expression, expression2, true, MatchAction.ANY);
            this.upper = new LessThanOrEqualTo<R>(expression, expression3, true, MatchAction.ANY);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_BETWEEN;
        }

        @Override
        protected Collection<?> getChildren() {
            return this.getExpressions();
        }

        @Override
        public List<Expression<? super R, ?>> getExpressions() {
            return Arrays.asList(this.lower.expression1, this.lower.expression2, this.upper.expression2);
        }

        @Override
        public Expression<? super R, ?> getExpression() {
            return this.lower.expression1;
        }

        @Override
        public Expression<? super R, ?> getLowerBoundary() {
            return this.lower.expression2;
        }

        @Override
        public Expression<? super R, ?> getUpperBoundary() {
            return this.upper.expression2;
        }

        @Override
        public boolean test(R r) {
            return this.lower.test(r) && this.upper.test(r);
        }
    }

    static final class NotEqualTo<R>
    extends ComparisonFilter<R> {
        private static final long serialVersionUID = -3295957142249035362L;

        NotEqualTo(Expression<? super R, ?> expression, Expression<? super R, ?> expression2, boolean bl, MatchAction matchAction) {
            super(expression, expression2, bl, matchAction);
        }

        @Override
        public Filter<R> recreate(Expression<? super R, ?>[] expressionArray) {
            return new NotEqualTo<R>(expressionArray[0], expressionArray[1], this.isMatchingCase, this.matchAction);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_NOT_EQUAL_TO;
        }

        @Override
        protected char symbol() {
            return '\u2260';
        }

        @Override
        protected boolean fromCompareTo(int n) {
            return n != 0;
        }

        @Override
        protected Number applyAsDouble(double d, double d2) {
            return ComparisonFilter.number(d != d2);
        }

        @Override
        protected Number applyAsLong(long l, long l2) {
            return ComparisonFilter.number(l != l2);
        }

        @Override
        protected boolean compare(OffsetTime offsetTime, OffsetTime offsetTime2) {
            return !offsetTime.isEqual(offsetTime2);
        }

        @Override
        protected boolean compare(OffsetDateTime offsetDateTime, OffsetDateTime offsetDateTime2) {
            return !offsetDateTime.isEqual(offsetDateTime2);
        }

        @Override
        protected boolean compare(ChronoLocalDate chronoLocalDate, ChronoLocalDate chronoLocalDate2) {
            return !chronoLocalDate.isEqual(chronoLocalDate2);
        }

        @Override
        protected boolean compare(ChronoLocalDateTime<?> chronoLocalDateTime, ChronoLocalDateTime<?> chronoLocalDateTime2) {
            return !chronoLocalDateTime.isEqual(chronoLocalDateTime2);
        }

        @Override
        protected boolean compare(ChronoZonedDateTime<?> chronoZonedDateTime, ChronoZonedDateTime<?> chronoZonedDateTime2) {
            return !chronoZonedDateTime.isEqual(chronoZonedDateTime2);
        }
    }

    static final class EqualTo<R>
    extends ComparisonFilter<R> {
        private static final long serialVersionUID = 8502612221498749667L;

        EqualTo(Expression<? super R, ?> expression, Expression<? super R, ?> expression2, boolean bl, MatchAction matchAction) {
            super(expression, expression2, bl, matchAction);
        }

        @Override
        public Filter<R> recreate(Expression<? super R, ?>[] expressionArray) {
            return new EqualTo<R>(expressionArray[0], expressionArray[1], this.isMatchingCase, this.matchAction);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_EQUAL_TO;
        }

        @Override
        protected char symbol() {
            return '=';
        }

        @Override
        protected boolean fromCompareTo(int n) {
            return n == 0;
        }

        @Override
        protected Number applyAsDouble(double d, double d2) {
            return ComparisonFilter.number(d == d2);
        }

        @Override
        protected Number applyAsLong(long l, long l2) {
            return ComparisonFilter.number(l == l2);
        }

        @Override
        protected boolean compare(OffsetTime offsetTime, OffsetTime offsetTime2) {
            return offsetTime.isEqual(offsetTime2);
        }

        @Override
        protected boolean compare(OffsetDateTime offsetDateTime, OffsetDateTime offsetDateTime2) {
            return offsetDateTime.isEqual(offsetDateTime2);
        }

        @Override
        protected boolean compare(ChronoLocalDate chronoLocalDate, ChronoLocalDate chronoLocalDate2) {
            return chronoLocalDate.isEqual(chronoLocalDate2);
        }

        @Override
        protected boolean compare(ChronoLocalDateTime<?> chronoLocalDateTime, ChronoLocalDateTime<?> chronoLocalDateTime2) {
            return chronoLocalDateTime.isEqual(chronoLocalDateTime2);
        }

        @Override
        protected boolean compare(ChronoZonedDateTime<?> chronoZonedDateTime, ChronoZonedDateTime<?> chronoZonedDateTime2) {
            return chronoZonedDateTime.isEqual(chronoZonedDateTime2);
        }
    }

    static final class GreaterThanOrEqualTo<R>
    extends ComparisonFilter<R> {
        private static final long serialVersionUID = 1514185657159141882L;

        GreaterThanOrEqualTo(Expression<? super R, ?> expression, Expression<? super R, ?> expression2, boolean bl, MatchAction matchAction) {
            super(expression, expression2, bl, matchAction);
        }

        @Override
        public Filter<R> recreate(Expression<? super R, ?>[] expressionArray) {
            return new GreaterThanOrEqualTo<R>(expressionArray[0], expressionArray[1], this.isMatchingCase, this.matchAction);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_GREATER_THAN_OR_EQUAL_TO;
        }

        @Override
        protected char symbol() {
            return '\u2265';
        }

        @Override
        protected boolean fromCompareTo(int n) {
            return n >= 0;
        }

        @Override
        protected Number applyAsDouble(double d, double d2) {
            return ComparisonFilter.number(d >= d2);
        }

        @Override
        protected Number applyAsLong(long l, long l2) {
            return ComparisonFilter.number(l >= l2);
        }

        @Override
        protected boolean compare(OffsetTime offsetTime, OffsetTime offsetTime2) {
            return !offsetTime.isBefore(offsetTime2);
        }

        @Override
        protected boolean compare(OffsetDateTime offsetDateTime, OffsetDateTime offsetDateTime2) {
            return !offsetDateTime.isBefore(offsetDateTime2);
        }

        @Override
        protected boolean compare(ChronoLocalDate chronoLocalDate, ChronoLocalDate chronoLocalDate2) {
            return !chronoLocalDate.isBefore(chronoLocalDate2);
        }

        @Override
        protected boolean compare(ChronoLocalDateTime<?> chronoLocalDateTime, ChronoLocalDateTime<?> chronoLocalDateTime2) {
            return !chronoLocalDateTime.isBefore(chronoLocalDateTime2);
        }

        @Override
        protected boolean compare(ChronoZonedDateTime<?> chronoZonedDateTime, ChronoZonedDateTime<?> chronoZonedDateTime2) {
            return !chronoZonedDateTime.isBefore(chronoZonedDateTime2);
        }
    }

    static final class GreaterThan<R>
    extends ComparisonFilter<R> {
        private static final long serialVersionUID = 8605517892232632586L;

        GreaterThan(Expression<? super R, ?> expression, Expression<? super R, ?> expression2, boolean bl, MatchAction matchAction) {
            super(expression, expression2, bl, matchAction);
        }

        @Override
        public Filter<R> recreate(Expression<? super R, ?>[] expressionArray) {
            return new GreaterThan<R>(expressionArray[0], expressionArray[1], this.isMatchingCase, this.matchAction);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_GREATER_THAN;
        }

        @Override
        protected char symbol() {
            return '>';
        }

        @Override
        protected boolean fromCompareTo(int n) {
            return n > 0;
        }

        @Override
        protected Number applyAsDouble(double d, double d2) {
            return ComparisonFilter.number(d > d2);
        }

        @Override
        protected Number applyAsLong(long l, long l2) {
            return ComparisonFilter.number(l > l2);
        }

        @Override
        protected boolean compare(OffsetTime offsetTime, OffsetTime offsetTime2) {
            return offsetTime.isAfter(offsetTime2);
        }

        @Override
        protected boolean compare(OffsetDateTime offsetDateTime, OffsetDateTime offsetDateTime2) {
            return offsetDateTime.isAfter(offsetDateTime2);
        }

        @Override
        protected boolean compare(ChronoLocalDate chronoLocalDate, ChronoLocalDate chronoLocalDate2) {
            return chronoLocalDate.isAfter(chronoLocalDate2);
        }

        @Override
        protected boolean compare(ChronoLocalDateTime<?> chronoLocalDateTime, ChronoLocalDateTime<?> chronoLocalDateTime2) {
            return chronoLocalDateTime.isAfter(chronoLocalDateTime2);
        }

        @Override
        protected boolean compare(ChronoZonedDateTime<?> chronoZonedDateTime, ChronoZonedDateTime<?> chronoZonedDateTime2) {
            return chronoZonedDateTime.isAfter(chronoZonedDateTime2);
        }
    }

    static final class LessThanOrEqualTo<R>
    extends ComparisonFilter<R> {
        private static final long serialVersionUID = 6357459227911760871L;

        LessThanOrEqualTo(Expression<? super R, ?> expression, Expression<? super R, ?> expression2, boolean bl, MatchAction matchAction) {
            super(expression, expression2, bl, matchAction);
        }

        @Override
        public Filter<R> recreate(Expression<? super R, ?>[] expressionArray) {
            return new LessThanOrEqualTo<R>(expressionArray[0], expressionArray[1], this.isMatchingCase, this.matchAction);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_LESS_THAN_OR_EQUAL_TO;
        }

        @Override
        protected char symbol() {
            return '\u2264';
        }

        @Override
        protected boolean fromCompareTo(int n) {
            return n <= 0;
        }

        @Override
        protected Number applyAsDouble(double d, double d2) {
            return ComparisonFilter.number(d <= d2);
        }

        @Override
        protected Number applyAsLong(long l, long l2) {
            return ComparisonFilter.number(l <= l2);
        }

        @Override
        protected boolean compare(OffsetTime offsetTime, OffsetTime offsetTime2) {
            return !offsetTime.isAfter(offsetTime2);
        }

        @Override
        protected boolean compare(OffsetDateTime offsetDateTime, OffsetDateTime offsetDateTime2) {
            return !offsetDateTime.isAfter(offsetDateTime2);
        }

        @Override
        protected boolean compare(ChronoLocalDate chronoLocalDate, ChronoLocalDate chronoLocalDate2) {
            return !chronoLocalDate.isAfter(chronoLocalDate2);
        }

        @Override
        protected boolean compare(ChronoLocalDateTime<?> chronoLocalDateTime, ChronoLocalDateTime<?> chronoLocalDateTime2) {
            return !chronoLocalDateTime.isAfter(chronoLocalDateTime2);
        }

        @Override
        protected boolean compare(ChronoZonedDateTime<?> chronoZonedDateTime, ChronoZonedDateTime<?> chronoZonedDateTime2) {
            return !chronoZonedDateTime.isAfter(chronoZonedDateTime2);
        }
    }

    static final class LessThan<R>
    extends ComparisonFilter<R> {
        private static final long serialVersionUID = 6126039112844823196L;

        LessThan(Expression<? super R, ?> expression, Expression<? super R, ?> expression2, boolean bl, MatchAction matchAction) {
            super(expression, expression2, bl, matchAction);
        }

        @Override
        public Filter<R> recreate(Expression<? super R, ?>[] expressionArray) {
            return new LessThan<R>(expressionArray[0], expressionArray[1], this.isMatchingCase, this.matchAction);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_LESS_THAN;
        }

        @Override
        protected char symbol() {
            return '<';
        }

        @Override
        protected boolean fromCompareTo(int n) {
            return n < 0;
        }

        @Override
        protected Number applyAsDouble(double d, double d2) {
            return ComparisonFilter.number(d < d2);
        }

        @Override
        protected Number applyAsLong(long l, long l2) {
            return ComparisonFilter.number(l < l2);
        }

        @Override
        protected boolean compare(OffsetTime offsetTime, OffsetTime offsetTime2) {
            return offsetTime.isBefore(offsetTime2);
        }

        @Override
        protected boolean compare(OffsetDateTime offsetDateTime, OffsetDateTime offsetDateTime2) {
            return offsetDateTime.isBefore(offsetDateTime2);
        }

        @Override
        protected boolean compare(ChronoLocalDate chronoLocalDate, ChronoLocalDate chronoLocalDate2) {
            return chronoLocalDate.isBefore(chronoLocalDate2);
        }

        @Override
        protected boolean compare(ChronoLocalDateTime<?> chronoLocalDateTime, ChronoLocalDateTime<?> chronoLocalDateTime2) {
            return chronoLocalDateTime.isBefore(chronoLocalDateTime2);
        }

        @Override
        protected boolean compare(ChronoZonedDateTime<?> chronoZonedDateTime, ChronoZonedDateTime<?> chronoZonedDateTime2) {
            return chronoZonedDateTime.isBefore(chronoZonedDateTime2);
        }
    }
}

