/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.NoSuchAuthorityCodeException;

final class CommonAuthorityCode {
    static final char SEPARATOR = ',';
    final String localCode;
    private String complement;
    private double[] parameters;
    private int versionOfAuto;
    final boolean isNumeric;
    boolean isOGC;

    CommonAuthorityCode(String string) throws NoSuchAuthorityCodeException {
        int n;
        int n2;
        int n3 = string.indexOf(58);
        if (n3 >= 0) {
            n2 = CharSequences.skipTrailingWhitespaces(string, 0, n3);
            n = CharSequences.skipLeadingWhitespaces(string, 0, n2);
            this.isOGC = GeodeticAuthorityFactory.regionMatches("OGC", string, n, n2);
            if (!this.isOGC && !GeodeticAuthorityFactory.regionMatches("CRS", string, n, n2)) {
                if (string.regionMatches(true, n, "AUTO", 0, 4)) {
                    switch (n2 - n) {
                        case 4: {
                            this.versionOfAuto = 1;
                            break;
                        }
                        case 5: {
                            this.versionOfAuto = string.charAt(n2 - 1) - 48;
                        }
                    }
                }
                if (!this.isAuto(false)) {
                    throw new NoSuchAuthorityCodeException(Resources.format((short)66, CharSequences.trimWhitespaces(string, 0, n3)), "OGC", string);
                }
            }
        }
        if (string.regionMatches(true, n3 = CharSequences.skipLeadingWhitespaces(string, n3 + 1, n2 = string.length()), "CRS", 0, "CRS".length())) {
            n3 = CharSequences.skipLeadingWhitespaces(string, n3 + "CRS".length(), n2);
        }
        if (n3 >= n2) {
            throw new NoSuchAuthorityCodeException(Errors.format((short)29, "code"), "OGC", string);
        }
        n = CharSequences.skipTrailingWhitespaces(string, n3, n2);
        int n4 = string.indexOf(44, n3);
        if (n4 >= 0) {
            this.complement = string.substring(CharSequences.skipLeadingWhitespaces(string, n4 + 1, n), n);
            n = CharSequences.skipTrailingWhitespaces(string, n3, n4);
        }
        this.localCode = string.substring(n3, n);
        char c = this.localCode.charAt(0);
        this.isNumeric = c >= '0' && c <= '9' || c == '-' || c == '+';
    }

    final boolean isAuto(boolean bl) {
        return bl ? this.versionOfAuto == 1 : this.versionOfAuto >= 1 && this.versionOfAuto <= 2;
    }

    final boolean isParameterless() {
        return this.complement == null || this.complement.isEmpty();
    }

    final double[] parameters() {
        if (this.parameters == null) {
            this.parameters = CharSequences.parseDoubles(this.complement, ',');
        }
        return this.parameters;
    }

    final String unexpectedParameters() {
        return Errors.format((short)135, this.localCode, this.complement);
    }
}

