/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.awt.geom.AffineTransform;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.j2d.ParameterizedAffine;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.MapProjection;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

@XmlTransient
public final class Equirectangular
extends AbstractProvider {
    private static final long serialVersionUID = -278288251842178001L;
    public static final String NAME = "Equidistant Cylindrical (Spherical)";
    public static final ParameterDescriptor<Double> STANDARD_PARALLEL;
    static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> LONGITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> FALSE_EASTING;
    public static final ParameterDescriptor<Double> FALSE_NORTHING;
    static final ParameterDescriptorGroup PARAMETERS;

    public Equirectangular() {
        super(CylindricalProjection.class, PARAMETERS, EllipsoidalCS.class, 2, true, CartesianCS.class, 2, false);
    }

    private static double getAndStore(Parameters parameters, ParameterValueGroup parameterValueGroup, ParameterDescriptor<Double> parameterDescriptor) throws IllegalArgumentException {
        double d = parameters.doubleValue(parameterDescriptor);
        MapProjection.validate(parameterDescriptor, d);
        if (d != 0.0) {
            parameterValueGroup.parameter(parameterDescriptor.getName().getCode()).setValue(d);
        }
        return d;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws FactoryException {
        Parameters parameters = Parameters.castOrWrap(parameterValueGroup);
        ContextualParameters contextualParameters = new ContextualParameters(PARAMETERS, 2, 2);
        double d = Equirectangular.getAndStore(parameters, contextualParameters, MapProjection.SEMI_MAJOR);
        double d2 = Equirectangular.getAndStore(parameters, contextualParameters, MapProjection.SEMI_MINOR);
        double d3 = Equirectangular.getAndStore(parameters, contextualParameters, LONGITUDE_OF_ORIGIN);
        double d4 = Equirectangular.getAndStore(parameters, contextualParameters, LATITUDE_OF_ORIGIN);
        double d5 = Equirectangular.getAndStore(parameters, contextualParameters, STANDARD_PARALLEL);
        double d6 = Equirectangular.getAndStore(parameters, contextualParameters, FALSE_EASTING);
        double d7 = Equirectangular.getAndStore(parameters, contextualParameters, FALSE_NORTHING);
        d5 = Math.toRadians(d5);
        MatrixSIS matrixSIS = contextualParameters.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        matrixSIS.convertBefore(0, Math.cos(d5), null);
        contextualParameters.normalizeGeographicInputs(d3).convertBefore(1, null, -d4);
        if (d != d2) {
            double d8 = d2 / d;
            double d9 = Math.sin(d5);
            d = d2 / (1.0 - (1.0 - d8 * d8) * (d9 * d9));
        }
        DoubleDouble doubleDouble = DoubleDouble.createAndGuessError(d);
        MatrixSIS matrixSIS2 = contextualParameters.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        matrixSIS2.convertAfter(0, doubleDouble, DoubleDouble.createAndGuessError(d6));
        matrixSIS2.convertAfter(1, doubleDouble, DoubleDouble.createAndGuessError(d7));
        MathTransform mathTransform = contextualParameters.completeTransform(mathTransformFactory, MathTransforms.identity(2));
        if (mathTransform instanceof AffineTransform) {
            mathTransform = new ParameterizedAffine((AffineTransform)((Object)mathTransform), contextualParameters, true);
        }
        return mathTransform;
    }

    static {
        ParameterBuilder parameterBuilder = Equirectangular.builder();
        STANDARD_PARALLEL = Equirectangular.createLatitude((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8823")).addIdentifier(Citations.GEOTIFF, "3078")).addName("Latitude of 1st standard parallel")).addName(Citations.OGC, "standard_parallel_1")).addName(Citations.ESRI, "Standard_Parallel_1")).addName(Citations.NETCDF, "standard_parallel")).addName(Citations.GEOTIFF, "StdParallel1")).addName(Citations.PROJ4, "lat_ts"), false);
        LONGITUDE_OF_ORIGIN = Equirectangular.createLongitude((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8802")).addIdentifier(Citations.GEOTIFF, "3088")).addName("Longitude of natural origin")).addName(Citations.OGC, "central_meridian")).addName(Citations.ESRI, "Central_Meridian")).addName(Citations.NETCDF, "longitude_of_projection_origin")).addName(Citations.GEOTIFF, "CenterLong")).addName(Citations.PROJ4, "lon_0"));
        FALSE_EASTING = Equirectangular.createShift((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8806")).addIdentifier(Citations.GEOTIFF, "3082")).addName("False easting")).addName(Citations.OGC, "false_easting")).addName(Citations.ESRI, "False_Easting")).addName(Citations.NETCDF, "false_easting")).addName(Citations.GEOTIFF, "FalseEasting")).addName(Citations.PROJ4, "x_0"));
        FALSE_NORTHING = Equirectangular.createShift((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8807")).addIdentifier(Citations.GEOTIFF, "3083")).addName("False northing")).addName(Citations.OGC, "false_northing")).addName(Citations.ESRI, "False_Northing")).addName(Citations.NETCDF, "false_northing")).addName(Citations.GEOTIFF, "FalseNorthing")).addName(Citations.PROJ4, "y_0"));
        LATITUDE_OF_ORIGIN = Equirectangular.createZeroConstant(((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8801")).addIdentifier(Citations.GEOTIFF, "3089")).addName("Latitude of natural origin")).addName(Citations.OGC, "latitude_of_origin")).addName(Citations.ESRI, "Latitude_Of_Origin")).addName(Citations.NETCDF, "latitude_of_projection_origin")).addName(Citations.GEOTIFF, "CenterLat")).addName(Citations.PROJ4, "lat_0")).setRemarks(Resources.formatInternational((short)12, (Object)0))).setRequired(false));
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)Equirectangular.addIdentifierAndLegacy(parameterBuilder, "1029", "9823").addName(NAME)).addName("Plate Carr\u00e9e")).addName(Citations.OGC, "Equirectangular")).addName(Citations.ESRI, "Plate_Carree")).addName(Citations.GEOTIFF, "CT_Equirectangular")).addName(Citations.PROJ4, "eqc")).addIdentifier(Citations.GEOTIFF, "17")).createGroupForMapProjection(STANDARD_PARALLEL, LATITUDE_OF_ORIGIN, LONGITUDE_OF_ORIGIN, FALSE_EASTING, FALSE_NORTHING);
    }
}

