/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.jts;

import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryType;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.jts.JTS;
import org.apache.sis.internal.feature.jts.PackedCoordinateSequence;
import org.apache.sis.internal.feature.jts.PackedCoordinateSequenceFactory;
import org.apache.sis.internal.feature.jts.Wrapper;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.Vector;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTReader;

public final class Factory
extends Geometries<Geometry> {
    private static final long serialVersionUID = 3457343016410620076L;
    public static final Factory INSTANCE = new Factory();
    private final transient GeometryFactory factory = new GeometryFactory((CoordinateSequenceFactory)new PackedCoordinateSequenceFactory(true));
    private final transient GeometryFactory fctry32 = new GeometryFactory((CoordinateSequenceFactory)new PackedCoordinateSequenceFactory(false));

    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private Factory() {
        super(GeometryLibrary.JTS, Geometry.class, Point.class, LineString.class, Polygon.class);
    }

    @Override
    public Class<?> getGeometryClass(GeometryType geometryType) {
        switch (geometryType) {
            default: {
                return this.rootClass;
            }
            case POINT: {
                return this.pointClass;
            }
            case LINESTRING: {
                return this.polylineClass;
            }
            case POLYGON: {
                return this.polygonClass;
            }
            case MULTI_POINT: {
                return MultiPoint.class;
            }
            case MULTI_LINESTRING: {
                return MultiLineString.class;
            }
            case MULTI_POLYGON: 
        }
        return MultiPolygon.class;
    }

    @Override
    public GeometryWrapper<Geometry> castOrWrap(Object object) {
        return object == null || object instanceof Wrapper ? (Wrapper)object : new Wrapper((Geometry)object);
    }

    @Override
    protected GeometryWrapper<Geometry> createWrapper(Geometry geometry) {
        return new Wrapper(geometry);
    }

    static boolean isFloat(CoordinateSequence coordinateSequence) {
        return coordinateSequence instanceof PackedCoordinateSequence.Float || coordinateSequence instanceof PackedCoordinateSequence.Float;
    }

    static boolean isFloat(boolean bl, Point point) {
        return bl && Factory.isFloat(point.getCoordinateSequence());
    }

    public final GeometryFactory factory(boolean bl) {
        return bl ? this.fctry32 : this.factory;
    }

    @Override
    public Object createPoint(float f, float f2) {
        return this.fctry32.createPoint((Coordinate)new CoordinateXY((double)f, (double)f2));
    }

    @Override
    public Object createPoint(double d, double d2) {
        return this.factory.createPoint((Coordinate)new CoordinateXY(d, d2));
    }

    @Override
    public Object createPoint(double d, double d2, double d3) {
        return this.factory.createPoint(new Coordinate(d, d2, d3));
    }

    @Override
    public Geometry createPolyline(boolean bl, int n, Vector ... vectorArray) {
        boolean bl2;
        boolean bl3 = bl2 = n == 3;
        if (!bl2 && n != 2) {
            throw new UnsupportedOperationException(Factory.unsupported(n));
        }
        boolean bl4 = true;
        for (Vector vector : vectorArray) {
            if (vector == null || vector.isSinglePrecision()) continue;
            bl4 = false;
            break;
        }
        ArrayList arrayList = new ArrayList(32);
        ArrayList<Geometry> arrayList2 = new ArrayList<Geometry>();
        for (Vector vector : vectorArray) {
            if (vector == null) continue;
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                double d = vector.doubleValue(n3++);
                double d2 = vector.doubleValue(n3++);
                if (!Double.isNaN(d) && !Double.isNaN(d2)) {
                    Object object = bl2 ? new Coordinate(d, d2, vector.doubleValue(n3++)) : new CoordinateXY(d, d2);
                    arrayList.add(object);
                    continue;
                }
                if (bl2) {
                    ++n3;
                }
                this.toLineString(arrayList, arrayList2, bl, bl4);
                arrayList.clear();
            }
        }
        this.toLineString(arrayList, arrayList2, bl, bl4);
        return this.toGeometry(arrayList2, bl, bl4);
    }

    @Override
    public GeometryWrapper<Geometry> createMultiPolygon(Object[] objectArray) {
        Polygon[] polygonArray = new Polygon[objectArray.length];
        boolean bl = true;
        for (int i = 0; i < objectArray.length; ++i) {
            Polygon polygon;
            Object object = Factory.unwrap(objectArray[i]);
            if (object instanceof Polygon) {
                polygon = (Polygon)object;
            } else {
                boolean bl2;
                CoordinateSequence coordinateSequence;
                if (object instanceof LinearRing) {
                    LinearRing linearRing = (LinearRing)object;
                    coordinateSequence = linearRing.getCoordinateSequence();
                    bl2 = Factory.isFloat(coordinateSequence);
                    polygon = this.factory(bl2).createPolygon(linearRing);
                } else if (object instanceof LineString) {
                    coordinateSequence = ((LineString)object).getCoordinateSequence();
                    bl2 = Factory.isFloat(coordinateSequence);
                    polygon = this.factory(bl2).createPolygon(coordinateSequence);
                } else {
                    throw new ClassCastException(Errors.format((short)43, Strings.bracket("geometries", (Object)i), Polygon.class, Classes.getClass(object)));
                }
                JTS.copyMetadata((Geometry)object, (Geometry)polygon);
                bl &= bl2;
            }
            polygonArray[i] = polygon;
        }
        return new Wrapper((Geometry)this.factory(bl).createMultiPolygon(polygonArray));
    }

    final void toLineString(List<Coordinate> list, List<Geometry> list2, boolean bl, boolean bl2) {
        int n = list.size();
        if (n >= 2) {
            Coordinate[] coordinateArray = list.toArray(new Coordinate[n]);
            GeometryFactory geometryFactory = this.factory(bl2);
            Object object = bl ? geometryFactory.createPolygon(coordinateArray) : (coordinateArray.length > 3 && coordinateArray[0].equals2D(coordinateArray[n - 1]) ? geometryFactory.createLinearRing(coordinateArray) : geometryFactory.createLineString(coordinateArray));
            list2.add((Geometry)object);
        }
    }

    final Geometry toGeometry(List<Geometry> list, boolean bl, boolean bl2) {
        int n = list.size();
        switch (n) {
            case 0: {
                GeometryFactory geometryFactory = this.factory(bl2);
                return bl ? geometryFactory.createPolygon((Coordinate[])null) : geometryFactory.createLinearRing((Coordinate[])null);
            }
            case 1: {
                return list.get(0);
            }
        }
        GeometryFactory geometryFactory = this.factory(bl2);
        return bl ? geometryFactory.createMultiPolygon(list.toArray(new Polygon[n])) : geometryFactory.createMultiLineString(list.toArray(new LineString[n]));
    }

    private <G extends Geometry> Geometry createFromComponents(G[] GArray, Function<G, CoordinateSequence> function, BiFunction<GeometryFactory, G[], Geometry> biFunction) {
        boolean bl = true;
        for (G g2 : GArray) {
            if (Factory.isFloat(function.apply(g2))) continue;
            bl = false;
            break;
        }
        return biFunction.apply(this.factory(bl), GArray);
    }

    @Override
    public GeometryWrapper<Geometry> createFromComponents(GeometryType geometryType, Object object) {
        GeometryCollection geometryCollection;
        block0 : switch (geometryType) {
            case GEOMETRY_COLLECTION: {
                geometryCollection = this.factory.createGeometryCollection((Geometry[])object);
                break;
            }
            case MULTI_LINESTRING: {
                geometryCollection = this.createFromComponents((Geometry[])((LineString[])object), LineString::getCoordinateSequence, GeometryFactory::createMultiLineString);
                break;
            }
            case MULTI_POLYGON: {
                geometryCollection = this.createFromComponents((Geometry[])((Polygon[])object), polygon -> polygon.getExteriorRing().getCoordinateSequence(), GeometryFactory::createMultiPolygon);
                break;
            }
            case MULTI_POINT: {
                if (object instanceof Point[]) {
                    geometryCollection = this.createFromComponents((Geometry[])((Point[])object), Point::getCoordinateSequence, GeometryFactory::createMultiPoint);
                    break;
                }
            }
            default: {
                GeometryFactory geometryFactory;
                CoordinateSequence coordinateSequence;
                if (object instanceof CoordinateSequence) {
                    coordinateSequence = (CoordinateSequence)object;
                    geometryFactory = this.factory(Factory.isFloat(coordinateSequence));
                } else {
                    Coordinate[] coordinateArray;
                    if (object instanceof Coordinate[]) {
                        coordinateArray = (Coordinate[])object;
                        geometryFactory = this.factory;
                    } else {
                        List<Object> list = object instanceof Collection ? (List<Object>)object : Arrays.asList((Object[])object);
                        coordinateArray = new Coordinate[list.size()];
                        boolean bl = true;
                        int n = 0;
                        for (Object e : list) {
                            Coordinate coordinate;
                            if (e instanceof Point) {
                                Point point = (Point)e;
                                bl = Factory.isFloat(bl, point);
                                coordinate = point.getCoordinate();
                            } else {
                                coordinate = (Coordinate)e;
                                bl = false;
                            }
                            coordinateArray[n++] = coordinate;
                        }
                        geometryFactory = this.factory(bl);
                    }
                    coordinateSequence = geometryFactory.getCoordinateSequenceFactory().create(coordinateArray);
                }
                switch (geometryType) {
                    case MULTI_POINT: 
                    case GEOMETRY: {
                        geometryCollection = geometryFactory.createMultiPoint(coordinateSequence);
                        break block0;
                    }
                    case LINESTRING: {
                        geometryCollection = geometryFactory.createLineString(coordinateSequence);
                        break block0;
                    }
                    case POLYGON: {
                        geometryCollection = geometryFactory.createPolygon(coordinateSequence);
                        break block0;
                    }
                    case POINT: {
                        geometryCollection = geometryFactory.createMultiPoint(coordinateSequence).getCentroid();
                        break block0;
                    }
                }
                throw new AssertionError((Object)geometryType);
            }
        }
        return new Wrapper((Geometry)geometryCollection);
    }

    @Override
    public GeometryWrapper<Geometry> parseWKT(String string) throws ParseException {
        WKTReader wKTReader = new WKTReader(this.factory);
        wKTReader.setIsOldJtsCoordinateSyntaxAllowed(false);
        return new Wrapper(wKTReader.read(string));
    }

    @Override
    public GeometryWrapper<Geometry> parseWKB(ByteBuffer byteBuffer) throws ParseException {
        byte[] byArray;
        if (byteBuffer.hasArray()) {
            byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset();
            int n2 = byteBuffer.limit() + n;
            if ((n += byteBuffer.position()) != 0 || n2 != byArray.length) {
                byArray = Arrays.copyOfRange(byArray, n, n2);
            }
        } else {
            byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
        }
        return new Wrapper(new WKBReader(this.factory).read(byArray));
    }
}

