/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.Molodensky;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.Matrix;

public abstract class DatumShiftTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -4492222496475405226L;
    final ContextualParameters context;
    final DatumShiftGrid<?, ?> grid;
    private transient double scaleX;
    private transient double scaleY;
    private transient double x0;
    private transient double y0;

    DatumShiftTransform(ParameterDescriptorGroup parameterDescriptorGroup, DatumShiftGrid<?, ?> datumShiftGrid) {
        int n = datumShiftGrid.getTranslationDimensions();
        this.context = new ContextualParameters(parameterDescriptorGroup, n, n);
        this.grid = datumShiftGrid;
        this.computeConversionFactors();
    }

    DatumShiftTransform(ParameterDescriptorGroup parameterDescriptorGroup, boolean bl, boolean bl2, DatumShiftGrid<?, ?> datumShiftGrid) {
        this.context = new ContextualParameters(parameterDescriptorGroup, bl ? 3 : 2, bl2 ? 3 : 2);
        this.grid = datumShiftGrid;
        this.computeConversionFactors();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.computeConversionFactors();
    }

    private void computeConversionFactors() {
        this.scaleX = Double.NaN;
        this.scaleY = Double.NaN;
        this.x0 = Double.NaN;
        this.y0 = Double.NaN;
        if (this.grid != null) {
            Matrix matrix;
            LinearTransform linearTransform = this.grid.getCoordinateToGrid();
            double d = Units.toStandardUnit(this.grid.getCoordinateUnit());
            if (!Double.isNaN(d) && Matrices.isAffine(matrix = linearTransform.getMatrix())) {
                int n = matrix.getNumCol() - 1;
                switch (matrix.getNumRow()) {
                    default: {
                        this.y0 = matrix.getElement(1, n);
                        this.scaleY = DatumShiftTransform.diagonal(matrix, 1, n) / d;
                    }
                    case 1: {
                        this.x0 = matrix.getElement(0, n);
                        this.scaleX = DatumShiftTransform.diagonal(matrix, 0, n) / d;
                    }
                    case 0: 
                }
            }
        }
    }

    private static double diagonal(Matrix matrix, int n, int n2) {
        while (--n2 >= 0) {
            if (n == n2 || matrix.getElement(n, n2) == 0.0) continue;
            return Double.NaN;
        }
        return matrix.getElement(n, n);
    }

    static void ensureGeocentricTranslation(DatumShiftGrid<?, ?> datumShiftGrid, Unit<Length> unit) throws IllegalArgumentException {
        int n = datumShiftGrid.getTranslationDimensions();
        if (n != 3) {
            throw new MismatchedDimensionException(Errors.format((short)81, "grid", 3, n));
        }
        Object object = "ratio";
        if (datumShiftGrid.isCellValueRatio() || (object = datumShiftGrid.getTranslationUnit()) != unit) {
            throw new IllegalArgumentException(Resources.format((short)26, "translation", object));
        }
    }

    final void setContextParameters(double d, double d2, Unit<Length> unit, Ellipsoid ellipsoid) {
        UnitConverter unitConverter = ellipsoid.getAxisUnit().getConverterTo(unit);
        this.context.getOrCreate(Molodensky.SRC_SEMI_MAJOR).setValue(d, unit);
        this.context.getOrCreate(Molodensky.SRC_SEMI_MINOR).setValue(d2, unit);
        this.context.getOrCreate(Molodensky.TGT_SEMI_MAJOR).setValue(unitConverter.convert(ellipsoid.getSemiMajorAxis()), unit);
        this.context.getOrCreate(Molodensky.TGT_SEMI_MINOR).setValue(unitConverter.convert(ellipsoid.getSemiMinorAxis()), unit);
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.context;
    }

    @Override
    protected ContextualParameters getContextualParameters() {
        return this.context;
    }

    final double normalizedToGridX(double d) {
        return d * this.scaleX + this.x0;
    }

    final double normalizedToGridY(double d) {
        return d * this.scaleY + this.y0;
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() + Objects.hashCode(this.grid);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        return super.equals(object, comparisonMode) && Objects.equals(this.grid, ((DatumShiftTransform)object).grid);
    }
}

