/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.GeodeticException;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.UnsupportedImplementationException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.PassThroughOperation;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;

@XmlType(name="PassThroughOperationType", propOrder={"indices", "operation"})
@XmlRootElement(name="PassThroughOperation")
public class DefaultPassThroughOperation
extends AbstractCoordinateOperation
implements PassThroughOperation {
    private static final long serialVersionUID = 4308173919747248695L;
    private SingleOperation operation;

    public DefaultPassThroughOperation(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, SingleOperation singleOperation, int n, int n2) {
        super(map, coordinateReferenceSystem, coordinateReferenceSystem2, null, MathTransforms.passThrough(n, singleOperation.getMathTransform(), n2));
        this.operation = singleOperation;
    }

    protected DefaultPassThroughOperation(PassThroughOperation passThroughOperation) {
        super(passThroughOperation);
        this.operation = passThroughOperation.getOperation();
    }

    public static DefaultPassThroughOperation castOrCopy(PassThroughOperation passThroughOperation) {
        return passThroughOperation == null || passThroughOperation instanceof DefaultPassThroughOperation ? (DefaultPassThroughOperation)passThroughOperation : new DefaultPassThroughOperation(passThroughOperation);
    }

    public Class<? extends PassThroughOperation> getInterface() {
        return PassThroughOperation.class;
    }

    @Override
    @Deprecated
    public OperationMethod getMethod() {
        return null;
    }

    @Override
    @Deprecated
    public ParameterValueGroup getParameterValues() {
        return null;
    }

    @Override
    @XmlElement(name="coordOperation", required=true)
    public SingleOperation getOperation() {
        return this.operation;
    }

    @Override
    public int[] getModifiedCoordinates() {
        CoordinateReferenceSystem coordinateReferenceSystem;
        MathTransform mathTransform = super.getMathTransform();
        if (mathTransform instanceof PassThroughTransform) {
            return ((PassThroughTransform)mathTransform).getModifiedCoordinates();
        }
        if (this.operation != null && (coordinateReferenceSystem = super.getSourceCRS()) instanceof CompoundCRS) {
            int n = 0;
            CoordinateReferenceSystem coordinateReferenceSystem2 = this.operation.getSourceCRS();
            for (CoordinateReferenceSystem coordinateReferenceSystem3 : ((CompoundCRS)coordinateReferenceSystem).getComponents()) {
                int n2 = ReferencingUtilities.getDimension(coordinateReferenceSystem3);
                if (coordinateReferenceSystem3 == coordinateReferenceSystem2) {
                    int[] nArray = new int[n2];
                    for (int i = 0; i < n2; ++i) {
                        nArray[i] = n + i;
                    }
                    return nArray;
                }
                n += n2;
            }
        }
        throw new UnsupportedImplementationException(mathTransform.getClass());
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            if (comparisonMode == ComparisonMode.STRICT) {
                return Objects.equals(this.operation, ((DefaultPassThroughOperation)object).operation);
            }
            return Utilities.deepEquals(this.getOperation(), ((PassThroughOperation)object).getOperation(), comparisonMode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)(31 * this.operation.hashCode());
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        formatter.append(new FormattableObject(){

            @Override
            protected String formatTo(Formatter formatter) {
                for (int n : DefaultPassThroughOperation.this.getModifiedCoordinates()) {
                    formatter.append(n);
                }
                return "ModifiedCoordinates";
            }
        });
        formatter.newLine();
        formatter.append(DefaultPassThroughOperation.castOrCopy(this.getOperation()));
        formatter.setInvalidWKT(this, null);
        return "PassThroughOperation";
    }

    private DefaultPassThroughOperation() {
    }

    private void setOperation(SingleOperation singleOperation) {
        if (this.operation == null) {
            this.operation = singleOperation;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultPassThroughOperation.class, "setOperation", "coordOperation");
        }
    }

    @XmlElement(name="modifiedCoordinate", required=true)
    private int[] getIndices() {
        int[] nArray = this.getModifiedCoordinates();
        int n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] + 1;
        }
        return nArray;
    }

    private void setIndices(int[] nArray) {
        String string = "modifiedCoordinate";
        FactoryException factoryException = null;
        int n = nArray.length;
        if (n != 0) {
            if (!ArraysExt.isRange(nArray[0], nArray)) {
                throw new GeodeticException(Errors.format((short)4, string, Arrays.toString(nArray)));
            }
            string = "sourceCRS";
            CoordinateReferenceSystem coordinateReferenceSystem = super.getSourceCRS();
            if (coordinateReferenceSystem != null) {
                string = "targetCRS";
                CoordinateReferenceSystem coordinateReferenceSystem2 = super.getTargetCRS();
                if (coordinateReferenceSystem2 != null) {
                    string = "coordOperation";
                    if (this.operation != null) {
                        MathTransform mathTransform = this.operation.getMathTransform();
                        if (this.operation instanceof Conversion) {
                            CoordinateReferenceSystem coordinateReferenceSystem3 = this.operation.getSourceCRS();
                            CoordinateReferenceSystem coordinateReferenceSystem4 = this.operation.getTargetCRS();
                            if (mathTransform == null || coordinateReferenceSystem3 == null || coordinateReferenceSystem4 == null) {
                                try {
                                    int[] nArray2 = (int[])nArray.clone();
                                    int n2 = 0;
                                    while (n2 < n) {
                                        int n3 = n2++;
                                        nArray2[n3] = nArray2[n3] - 1;
                                    }
                                    if (coordinateReferenceSystem3 == null) {
                                        coordinateReferenceSystem3 = CRS.selectDimensions(coordinateReferenceSystem, nArray2);
                                    }
                                    if (coordinateReferenceSystem4 == null) {
                                        coordinateReferenceSystem4 = CRS.selectDimensions(coordinateReferenceSystem2, nArray2);
                                    }
                                    this.operation = DefaultConversion.castOrCopy((Conversion)this.operation).specialize(Conversion.class, coordinateReferenceSystem3, coordinateReferenceSystem4, null);
                                    mathTransform = this.operation.getMathTransform();
                                }
                                catch (FactoryException factoryException2) {
                                    factoryException = factoryException2;
                                }
                            }
                        }
                        if (mathTransform != null) {
                            this.transform = MathTransforms.passThrough(nArray[0] - 1, mathTransform, ReferencingUtilities.getDimension(coordinateReferenceSystem) - nArray[n - 1]);
                            return;
                        }
                    }
                }
            }
        }
        throw new GeodeticException(Errors.format((short)85, "PassThroughOperation", string), factoryException);
    }

    @Override
    void afterUnmarshal(Unmarshaller unmarshaller, Object object) {
        super.afterUnmarshal(unmarshaller, object);
        if (this.transform == null) {
            this.setIndices(ArraysExt.EMPTY_INT);
        }
    }
}

