/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;

@XmlType(name="ImageDatumType")
@XmlRootElement(name="ImageDatum")
public class DefaultImageDatum
extends AbstractDatum
implements ImageDatum {
    private static final long serialVersionUID = -4304193511244150936L;
    private PixelInCell pixelInCell;

    public DefaultImageDatum(Map<String, ?> map, PixelInCell pixelInCell) {
        super(map);
        this.pixelInCell = pixelInCell;
        ArgumentChecks.ensureNonNull("pixelInCell", pixelInCell);
    }

    protected DefaultImageDatum(ImageDatum imageDatum) {
        super(imageDatum);
        this.pixelInCell = imageDatum.getPixelInCell();
    }

    public static DefaultImageDatum castOrCopy(ImageDatum imageDatum) {
        return imageDatum == null || imageDatum instanceof DefaultImageDatum ? (DefaultImageDatum)imageDatum : new DefaultImageDatum(imageDatum);
    }

    public Class<? extends ImageDatum> getInterface() {
        return ImageDatum.class;
    }

    @Override
    @XmlElement(required=true)
    public PixelInCell getPixelInCell() {
        return this.pixelInCell;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                return Objects.equals(this.pixelInCell, ((DefaultImageDatum)object).pixelInCell);
            }
        }
        return Objects.equals(this.getPixelInCell(), ((ImageDatum)object).getPixelInCell());
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hashCode(this.pixelInCell);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        Convention convention = formatter.getConvention();
        if (convention == Convention.INTERNAL) {
            formatter.append(this.getPixelInCell());
        } else if (convention.majorVersion() == 1) {
            formatter.setInvalidWKT(this, null);
        }
        return formatter.shortOrLong("IDatum", "ImageDatum");
    }

    private DefaultImageDatum() {
    }

    private void setPixelInCell(PixelInCell pixelInCell) {
        if (this.pixelInCell == null) {
            this.pixelInCell = pixelInCell;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultImageDatum.class, "setPixelInCell", "pixelInCell");
        }
    }
}

