/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gco.InternationalStringAdapter;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.legacy.DateToTemporal;
import org.apache.sis.internal.metadata.legacy.TemporalToDate;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.quality.AbstractCompleteness;
import org.apache.sis.metadata.iso.quality.AbstractLogicalConsistency;
import org.apache.sis.metadata.iso.quality.AbstractMetaquality;
import org.apache.sis.metadata.iso.quality.AbstractPositionalAccuracy;
import org.apache.sis.metadata.iso.quality.AbstractTemporalQuality;
import org.apache.sis.metadata.iso.quality.AbstractThematicAccuracy;
import org.apache.sis.metadata.iso.quality.DefaultEvaluationMethod;
import org.apache.sis.metadata.iso.quality.DefaultMeasureReference;
import org.apache.sis.metadata.iso.quality.DefaultQualityMeasure;
import org.apache.sis.metadata.iso.quality.DefaultUsability;
import org.apache.sis.metadata.iso.quality.ISOMetadata;
import org.apache.sis.util.collection.Containers;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.Completeness;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.LogicalConsistency;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.metadata.quality.Result;
import org.opengis.metadata.quality.TemporalAccuracy;
import org.opengis.metadata.quality.ThematicAccuracy;
import org.opengis.metadata.quality.Usability;
import org.opengis.util.InternationalString;

@XmlType(name="AbstractDQ_Element_Type", propOrder={"standaloneQualityReportDetails", "measureReference", "evaluationMethod", "namesOfMeasure", "measureIdentification", "measureDescription", "evaluationMethodType", "evaluationMethodDescription", "evaluationProcedure", "dates", "results", "derivedElement"})
@XmlRootElement(name="AbstractDQ_Element")
@XmlSeeAlso(value={AbstractCompleteness.class, AbstractLogicalConsistency.class, AbstractPositionalAccuracy.class, AbstractThematicAccuracy.class, AbstractTemporalQuality.class, DefaultUsability.class, AbstractMetaquality.class, DefaultQualityMeasure.class})
public class AbstractElement
extends ISOMetadata
implements Element {
    private static final long serialVersionUID = -406229448295586970L;
    private InternationalString standaloneQualityReportDetails;
    private DefaultMeasureReference measureReference;
    private DefaultEvaluationMethod evaluationMethod;
    private Collection<Result> results;
    private Collection<Element> derivedElements;

    public AbstractElement() {
    }

    public AbstractElement(Result result) {
        this.results = this.singleton(result, Result.class);
    }

    public AbstractElement(Element element) {
        super(element);
        if (element != null) {
            if (element instanceof AbstractElement) {
                DefaultMeasureReference defaultMeasureReference;
                AbstractElement abstractElement = (AbstractElement)element;
                this.standaloneQualityReportDetails = abstractElement.getStandaloneQualityReportDetails();
                this.evaluationMethod = abstractElement.getEvaluationMethod();
                this.derivedElements = this.copyCollection(abstractElement.getDerivedElements(), Element.class);
                this.measureReference = abstractElement.getMeasureReference();
                if (this.measureReference == null && (defaultMeasureReference = new DefaultMeasureReference()).setLegacy(element)) {
                    this.measureReference = defaultMeasureReference;
                }
            }
            this.results = this.copyCollection(element.getResults(), Result.class);
        }
    }

    public static AbstractElement castOrCopy(Element element) {
        if (element instanceof PositionalAccuracy) {
            return AbstractPositionalAccuracy.castOrCopy((PositionalAccuracy)element);
        }
        if (element instanceof TemporalAccuracy) {
            return AbstractTemporalQuality.castOrCopy((TemporalAccuracy)element);
        }
        if (element instanceof ThematicAccuracy) {
            return AbstractThematicAccuracy.castOrCopy((ThematicAccuracy)element);
        }
        if (element instanceof LogicalConsistency) {
            return AbstractLogicalConsistency.castOrCopy((LogicalConsistency)element);
        }
        if (element instanceof Completeness) {
            return AbstractCompleteness.castOrCopy((Completeness)element);
        }
        if (element instanceof Usability) {
            return DefaultUsability.castOrCopy((Usability)element);
        }
        if (element == null || element instanceof AbstractElement) {
            return (AbstractElement)element;
        }
        return new AbstractElement(element);
    }

    @XmlElement(name="standaloneQualityReportDetails")
    @XmlJavaTypeAdapter(value=InternationalStringAdapter.Since2014.class)
    @UML(identifier="standaloneQualityReportDetails", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public InternationalString getStandaloneQualityReportDetails() {
        return this.standaloneQualityReportDetails;
    }

    public void setStandaloneQualityReportDetails(InternationalString internationalString) {
        this.checkWritePermission(this.standaloneQualityReportDetails);
        this.standaloneQualityReportDetails = internationalString;
    }

    @XmlElement(name="measure", required=false)
    @UML(identifier="measure", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public DefaultMeasureReference getMeasureReference() {
        return this.measureReference;
    }

    public void setMeasureReference(DefaultMeasureReference defaultMeasureReference) {
        this.checkWritePermission(this.measureReference);
        this.measureReference = defaultMeasureReference;
    }

    private <V> V getMeasureReferenceProperty(Function<DefaultMeasureReference, V> function) {
        DefaultMeasureReference defaultMeasureReference = this.getMeasureReference();
        return defaultMeasureReference != null && FilterByVersion.LEGACY_METADATA.accept() ? (V)function.apply(defaultMeasureReference) : null;
    }

    private <V> void setMeasureReferenceProperty(BiConsumer<DefaultMeasureReference, V> biConsumer, V v) {
        if (v != null) {
            if (this.measureReference == null) {
                this.measureReference = new DefaultMeasureReference();
            }
            biConsumer.accept(this.measureReference, v);
        }
    }

    @Deprecated
    @Dependencies(value={"getMeasureReference"})
    @XmlElement(name="nameOfMeasure", namespace="http://www.isotc211.org/2005/gmd")
    public Collection<InternationalString> getNamesOfMeasure() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        DefaultMeasureReference defaultMeasureReference = this.getMeasureReference();
        if (defaultMeasureReference == null) {
            if (this.state() == ModifiableMetadata.State.FINAL) {
                return Collections.emptyList();
            }
            defaultMeasureReference = new DefaultMeasureReference();
            this.setMeasureReference(defaultMeasureReference);
        }
        return defaultMeasureReference.getNamesOfMeasure();
    }

    @Deprecated
    public void setNamesOfMeasure(Collection<? extends InternationalString> collection) {
        if (!Containers.isNullOrEmpty(collection)) {
            this.setMeasureReferenceProperty(DefaultMeasureReference::setNamesOfMeasure, collection);
        }
    }

    @Override
    @Deprecated
    @Dependencies(value={"getMeasureReference"})
    @XmlElement(name="measureIdentification", namespace="http://www.isotc211.org/2005/gmd")
    public Identifier getMeasureIdentification() {
        return this.getMeasureReferenceProperty(DefaultMeasureReference::getMeasureIdentification);
    }

    @Deprecated
    public void setMeasureIdentification(Identifier identifier) {
        this.setMeasureReferenceProperty(DefaultMeasureReference::setMeasureIdentification, identifier);
    }

    @Override
    @Deprecated
    @Dependencies(value={"getMeasureReference"})
    @XmlElement(name="measureDescription", namespace="http://www.isotc211.org/2005/gmd")
    public InternationalString getMeasureDescription() {
        return this.getMeasureReferenceProperty(DefaultMeasureReference::getMeasureDescription);
    }

    @Deprecated
    public void setMeasureDescription(InternationalString internationalString) {
        this.setMeasureReferenceProperty(DefaultMeasureReference::setMeasureDescription, internationalString);
    }

    @XmlElement(name="evaluationMethod", required=false)
    @UML(identifier="evaluationMethod", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public DefaultEvaluationMethod getEvaluationMethod() {
        return this.evaluationMethod;
    }

    public void setEvaluationMethod(DefaultEvaluationMethod defaultEvaluationMethod) {
        this.checkWritePermission(this.evaluationMethod);
        this.evaluationMethod = defaultEvaluationMethod;
    }

    private <V> V getEvaluationMethodProperty(Function<DefaultEvaluationMethod, V> function) {
        DefaultEvaluationMethod defaultEvaluationMethod = this.getEvaluationMethod();
        return defaultEvaluationMethod != null && FilterByVersion.LEGACY_METADATA.accept() ? (V)function.apply(defaultEvaluationMethod) : null;
    }

    private <V> void setEvaluationMethodProperty(BiConsumer<DefaultEvaluationMethod, V> biConsumer, V v) {
        if (v != null) {
            if (this.evaluationMethod == null) {
                this.evaluationMethod = new DefaultEvaluationMethod();
            }
            biConsumer.accept(this.evaluationMethod, v);
        }
    }

    @Override
    @Deprecated
    @Dependencies(value={"getEvaluationMethod"})
    @XmlElement(name="evaluationMethodType", namespace="http://www.isotc211.org/2005/gmd")
    public EvaluationMethodType getEvaluationMethodType() {
        return this.getEvaluationMethodProperty(DefaultEvaluationMethod::getEvaluationMethodType);
    }

    @Deprecated
    public void setEvaluationMethodType(EvaluationMethodType evaluationMethodType) {
        this.setEvaluationMethodProperty(DefaultEvaluationMethod::setEvaluationMethodType, evaluationMethodType);
    }

    @Override
    @Deprecated
    @Dependencies(value={"getEvaluationMethod"})
    @XmlElement(name="evaluationMethodDescription", namespace="http://www.isotc211.org/2005/gmd")
    public InternationalString getEvaluationMethodDescription() {
        return this.getEvaluationMethodProperty(DefaultEvaluationMethod::getEvaluationMethodDescription);
    }

    @Deprecated
    public void setEvaluationMethodDescription(InternationalString internationalString) {
        this.setEvaluationMethodProperty(DefaultEvaluationMethod::setEvaluationMethodDescription, internationalString);
    }

    @Override
    @Deprecated
    @Dependencies(value={"getEvaluationMethod"})
    @XmlElement(name="evaluationProcedure", namespace="http://www.isotc211.org/2005/gmd")
    public Citation getEvaluationProcedure() {
        return this.getEvaluationMethodProperty(DefaultEvaluationMethod::getEvaluationProcedure);
    }

    @Deprecated
    public void setEvaluationProcedure(Citation citation) {
        this.setEvaluationMethodProperty(DefaultEvaluationMethod::setEvaluationProcedure, citation);
    }

    @Deprecated
    @Dependencies(value={"getEvaluationMethod"})
    @XmlElement(name="dateTime", namespace="http://www.isotc211.org/2005/gmd")
    public Collection<Date> getDates() {
        if (FilterByVersion.LEGACY_METADATA.accept()) {
            Collection<Temporal> collection;
            DefaultEvaluationMethod defaultEvaluationMethod = this.getEvaluationMethod();
            if (defaultEvaluationMethod == null) {
                if (this.state() == ModifiableMetadata.State.FINAL) {
                    return Collections.emptyList();
                }
                defaultEvaluationMethod = new DefaultEvaluationMethod();
                this.setEvaluationMethod(defaultEvaluationMethod);
            }
            if ((collection = defaultEvaluationMethod.getDates()) != null) {
                return new TemporalToDate(collection);
            }
        }
        return null;
    }

    @Deprecated
    public void setDates(Collection<? extends Date> collection) {
        if (!Containers.isNullOrEmpty(collection)) {
            this.setEvaluationMethodProperty(DefaultEvaluationMethod::setDates, new DateToTemporal(collection));
        }
    }

    @XmlElement(name="result", required=true)
    public Collection<Result> getResults() {
        this.results = this.nonNullCollection(this.results, Result.class);
        return this.results;
    }

    public void setResults(Collection<? extends Result> collection) {
        this.results = this.writeCollection(collection, this.results, Result.class);
    }

    @UML(identifier="derivedElement", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public Collection<Element> getDerivedElements() {
        this.derivedElements = this.nonNullCollection(this.derivedElements, Element.class);
        return this.derivedElements;
    }

    public void setDerivedElements(Collection<? extends Element> collection) {
        this.derivedElements = this.writeCollection(collection, this.derivedElements, Element.class);
    }

    @XmlElement(name="derivedElement")
    private Collection<Element> getDerivedElement() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getDerivedElements() : null;
    }
}

