/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sis.internal.util.MetadataServices;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Classes;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.resources.Errors;

public final class CheckedArrayList<E>
extends ArrayList<E>
implements CheckedContainer<E> {
    private static final long serialVersionUID = -8265578982723471814L;
    private final Class<E> type;

    public CheckedArrayList(Class<E> clazz) {
        this.type = clazz;
        ArgumentChecks.ensureNonNull("type", clazz);
    }

    public CheckedArrayList(Class<E> clazz, int n) {
        super(n);
        this.type = clazz;
        ArgumentChecks.ensureNonNull("type", clazz);
    }

    public static <E> CheckedArrayList<E> castOrCopy(Collection<?> collection, Class<E> clazz) {
        if (collection == null) {
            return null;
        }
        if (collection instanceof CheckedArrayList && ((CheckedArrayList)collection).type == clazz) {
            return (CheckedArrayList)collection;
        }
        CheckedArrayList checkedArrayList = new CheckedArrayList(clazz, collection.size());
        checkedArrayList.addAll(collection);
        return checkedArrayList;
    }

    @Override
    public Class<E> getElementType() {
        return this.type;
    }

    public static String illegalElement(Collection<?> collection, Object object, Class<?> clazz) {
        Object[] objectArray;
        short s2;
        if (MetadataServices.getInstance().isUnmarshalling()) {
            return null;
        }
        if (object == null) {
            s2 = 114;
            objectArray = new Object[]{Classes.getShortClassName(collection) + '<' + Classes.getShortName(clazz) + '>'};
        } else {
            s2 = 43;
            objectArray = new Object[]{"element", clazz, object.getClass()};
        }
        return Errors.format(s2, objectArray);
    }

    private boolean ensureValid(E e) {
        if (this.type.isInstance(e)) {
            return true;
        }
        String string = CheckedArrayList.illegalElement(this, e, this.type);
        if (string == null) {
            return false;
        }
        if (e == null) {
            throw new NullArgumentException(string);
        }
        throw new ClassCastException(string);
    }

    private List<E> ensureValidCollection(Collection<? extends E> collection) {
        Object[] objectArray;
        int n = 0;
        for (Object object : objectArray = collection.toArray()) {
            if (!this.ensureValid(object)) continue;
            objectArray[n++] = object;
        }
        return new Mediator<Object>(ArraysExt.resize(objectArray, n));
    }

    @Override
    public E set(int n, E e) {
        if (this.ensureValid(e)) {
            return super.set(n, e);
        }
        return this.get(n);
    }

    @Override
    public boolean add(E e) {
        if (this.ensureValid(e)) {
            return super.add(e);
        }
        return false;
    }

    @Override
    public void add(int n, E e) {
        if (this.ensureValid(e)) {
            super.add(n, e);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return super.addAll(this.ensureValidCollection(collection));
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        return super.addAll(n, this.ensureValidCollection(collection));
    }

    @Override
    public List<E> subList(int n, int n2) {
        return Collections.checkedList(super.subList(n, n2), this.type);
    }

    private static final class Mediator<E>
    extends AbstractList<E> {
        private final E[] array;

        Mediator(E[] EArray) {
            this.array = EArray;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public E get(int n) {
            return this.array[n];
        }

        @Override
        public E[] toArray() {
            return this.array;
        }
    }
}

