/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;
import org.apache.sis.internal.coverage.j2d.SampleModelFactory;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Localized;
import org.opengis.metadata.spatial.DimensionNameType;

public final class RangeArgument {
    private final long[] packed;
    public final boolean hasAllBands;
    private int first;
    private int last;
    private int interval;
    private SampleDimension.Builder builder;

    private RangeArgument(long[] lArray, boolean bl) {
        this.packed = lArray;
        this.hasAllBands = bl;
        this.interval = 1;
    }

    public static RangeArgument validate(int n, int[] nArray, Localized localized) {
        long[] lArray;
        ArgumentChecks.ensureStrictlyPositive("numSampleDimensions", n);
        if (nArray == null || nArray.length == 0) {
            lArray = new long[n];
            for (int i = 1; i < n; ++i) {
                lArray[i] = (long)i << 32 | (long)i;
            }
        } else {
            int n2;
            int n3;
            lArray = new long[nArray.length];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = nArray[n3];
                if (n2 < 0 || n2 >= n) {
                    throw new IllegalArgumentException(Resources.forLocale(localized.getLocale()).getString((short)52, n - 1, n2));
                }
                lArray[n3] = (long)n2 << 32 | (long)n3;
            }
            Arrays.sort(lArray);
            n3 = -1;
            for (n2 = 0; n2 < lArray.length; ++n2) {
                int n4 = (int)(lArray[n2] >>> 32);
                if (n4 == n3) {
                    throw new IllegalArgumentException(Resources.forLocale(localized.getLocale()).getString((short)53, n4));
                }
                n3 = n4;
            }
        }
        return new RangeArgument(lArray, lArray.length == n);
    }

    public boolean isIdentity() {
        if (!this.hasAllBands || this.interval != 1) {
            return false;
        }
        for (int i = 0; i < this.packed.length; ++i) {
            if (this.packed[i] == ((long)i << 32 | (long)i)) continue;
            return false;
        }
        return true;
    }

    public int getNumBands() {
        return this.packed.length;
    }

    public int[] getSelectedBands() {
        int[] nArray = new int[this.getNumBands()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[this.getTargetIndex((int)i)] = this.getSourceIndex(i);
        }
        return nArray;
    }

    public int getFirstSpecified() {
        for (long l : this.packed) {
            if ((int)l != 0) continue;
            return (int)(l >>> 32);
        }
        throw new IllegalStateException();
    }

    public int getSourceIndex(int n) {
        return (int)(this.packed[n] >>> 32);
    }

    public int getTargetIndex(int n) {
        return (int)this.packed[n];
    }

    public int getSubsampledIndex(int n) {
        return (this.getSourceIndex(n) - this.first) / this.interval;
    }

    public int getPixelStride() {
        return (this.last - this.first) / this.interval + 1;
    }

    public GridExtent insertBandDimension(GridExtent gridExtent, int n) {
        this.first = this.getSourceIndex(0);
        this.last = this.getSourceIndex(this.packed.length - 1);
        return gridExtent.insertDimension(n, DimensionNameType.valueOf("BAND"), this.first, this.last, true);
    }

    public int[] insertSubsampling(int[] nArray, int n) {
        int[] nArray2 = new int[this.packed.length - 1];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = this.getSourceIndex(i + 1) - this.getSourceIndex(i);
        }
        int[] nArray3 = MathFunctions.commonDivisors(nArray2);
        this.interval = nArray3.length != 0 ? nArray3[nArray3.length - 1] : 1;
        nArray = ArraysExt.insert(nArray, n, 1);
        nArray[n] = this.interval;
        return nArray;
    }

    public SampleDimension[] select(List<? extends SampleDimension> list) {
        SampleDimension[] sampleDimensionArray = new SampleDimension[this.getNumBands()];
        for (int i = 0; i < sampleDimensionArray.length; ++i) {
            sampleDimensionArray[this.getTargetIndex((int)i)] = list.get(this.getSourceIndex(i));
        }
        return sampleDimensionArray;
    }

    public SampleModel select(SampleModel sampleModel, boolean bl) {
        if (sampleModel == null || this.isIdentity()) {
            return sampleModel;
        }
        int[] nArray = this.getSelectedBands();
        if (bl) {
            return sampleModel.createSubsetSampleModel(nArray);
        }
        SampleModelFactory sampleModelFactory = new SampleModelFactory(sampleModel);
        sampleModelFactory.subsetAndCompress(nArray);
        return sampleModelFactory.build();
    }

    public Optional<ColorModel> select(ColorModel colorModel) {
        if (colorModel == null || this.isIdentity()) {
            return Optional.ofNullable(colorModel);
        }
        return ColorModelFactory.createSubset(colorModel, this.getSelectedBands());
    }

    public SampleDimension.Builder builder() {
        if (this.builder == null) {
            this.builder = new SampleDimension.Builder();
        } else {
            this.builder.clear();
        }
        return this.builder;
    }
}

