/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.referencing;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.sis.internal.metadata.Identifiers;
import org.apache.sis.internal.metadata.NameMeaning;
import org.apache.sis.internal.util.DefinitionURI;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.NamedIdentifier;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;

@XmlType(name="CodeType")
public final class Code {
    @XmlValue
    String code;
    @XmlAttribute
    String codeSpace;

    Code() {
    }

    Code(ReferenceIdentifier referenceIdentifier) {
        this.code = referenceIdentifier.getCode();
        this.codeSpace = referenceIdentifier.getCodeSpace();
        String string = referenceIdentifier.getVersion();
        if (string != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.codeSpace != null) {
                stringBuilder.append(this.codeSpace);
            }
            this.codeSpace = stringBuilder.append(':').append(string).toString();
        }
    }

    public ReferenceIdentifier getIdentifier() {
        String string = this.code;
        if (string == null) {
            return null;
        }
        Citation citation = null;
        String string2 = null;
        String string3 = this.codeSpace;
        DefinitionURI definitionURI = DefinitionURI.parse(string);
        if (definitionURI != null && definitionURI.code != null) {
            citation = Identifiers.isEPSG(string3, definitionURI.authority) ? Citations.EPSG : Citations.fromName(string3);
            string3 = definitionURI.authority;
            string2 = definitionURI.version;
            string = definitionURI.code;
        } else if (string3 != null) {
            int n = string3.lastIndexOf(58);
            if (n >= 0) {
                string2 = string3.substring(n + 1);
                string3 = string3.substring(0, n);
            }
            citation = Citations.fromName(string3);
        }
        return new NamedIdentifier(citation, string3, (CharSequence)string, string2, null);
    }

    public static Code forIdentifiedObject(Class<?> clazz, Iterable<? extends ReferenceIdentifier> iterable) {
        if (iterable != null) {
            Object object;
            Object object2;
            boolean bl = false;
            boolean bl2 = false;
            Object object3 = null;
            Object object4 = iterable.iterator();
            while (object4.hasNext()) {
                object2 = object4.next();
                object = object2.getCode();
                if (object == null) continue;
                if (((String)object).regionMatches(true, 0, "urn:", 0, 4)) {
                    return new Code((ReferenceIdentifier)object2);
                }
                if (bl) continue;
                bl = ((String)object).regionMatches(true, 0, "http:", 0, 5);
                if (bl) {
                    object3 = object2;
                    continue;
                }
                if (bl2 || !(bl2 = "EPSG".equalsIgnoreCase(object2.getCodeSpace())) && object3 != null) continue;
                object3 = object2;
            }
            if (object3 != null) {
                if (!bl && (object4 = NameMeaning.toURN(clazz, object3.getCodeSpace(), object3.getVersion(), object3.getCode())) != null) {
                    object2 = new Code();
                    object = object3.getAuthority();
                    if (bl2) {
                        ((Code)object2).codeSpace = "IOGP";
                        if (object != null) {
                            for (Identifier identifier : object.getIdentifiers()) {
                                String string;
                                if (!"EPSG".equalsIgnoreCase(identifier.getCode()) || !(identifier instanceof ReferenceIdentifier) || (string = ((ReferenceIdentifier)identifier).getCodeSpace()) == null) continue;
                                ((Code)object2).codeSpace = string;
                                break;
                            }
                        }
                    } else {
                        ((Code)object2).codeSpace = Citations.toCodeSpace((Citation)object);
                    }
                    ((Code)object2).code = object4;
                    return object2;
                }
                return new Code((ReferenceIdentifier)object3);
            }
        }
        return null;
    }
}

